//
//  PPClipBusinessCardSelectRectangleImageScrollView
//
//
//  Created by Andrewlia on 14/1/3.
//  Copyright (c) 2014年 Andrewlia. All rights reserved.
//

#import "PPImageScrollView.h"
#import "UIImage+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize             12.0f
#define PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance 14.0f
#define PPClipBusinessCardSelectRectangleImageScrollViewRectClipSelectedDistance         18.0f

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPClipBusinessCardSelectRectangleImageScrollViewTouch)
{
    PPClipBusinessCardSelectRectangleImageScrollViewTouch_None = 0,
    PPClipBusinessCardSelectRectangleImageScrollViewTouch_ImageViewMove,
    PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectMove,
    PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectResize
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPClipBusinessCardSelectRectangleImageScrollView;
@protocol PPClipBusinessCardSelectRectangleImageScrollViewDelegate<UIScrollViewDelegate>
@required
- (void)ppClipBusinessCardSelectRectangleImageScrollViewDidRectMove:(PPClipBusinessCardSelectRectangleImageScrollView *)ppClipBusinessCardSelectRectangleImageScrollView;
- (void)ppClipBusinessCardSelectRectangleImageScrollViewDidRectResize:(PPClipBusinessCardSelectRectangleImageScrollView *)ppClipBusinessCardSelectRectangleImageScrollView;
- (void)ppClipBusinessCardSelectRectangleImageScrollViewDidTouchUp:(PPClipBusinessCardSelectRectangleImageScrollView *)ppClipBusinessCardSelectRectangleImageScrollView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPClipBusinessCardSelectRectangleImageScrollView : PPImageScrollView
{
    id<PPClipBusinessCardSelectRectangleImageScrollViewDelegate> selectRectDelegate_;
    BOOL                                                         boundaryOut_;
    CGPoint                                                      distanceToOriginalPoint_;
    CGPoint                                                      scrollDirection_;
    CGRect                                                       rectSelected_;
    CGSize                                                       minimumImageViewSize_;
    NSTimer                                                      *timer_;
    PPClipBusinessCardSelectRectangleImageScrollViewTouch        ppClipBusinessCardSelectRectangleImageScrollViewTouch_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign) id<PPClipBusinessCardSelectRectangleImageScrollViewDelegate> selectRectDelegate;
@property (nonatomic, assign) CGRect                                                       rectSelected;
@property (nonatomic, assign) CGSize                                                       minimumImageViewSize;

@end
