//
//  PPClipBusinessCardDrawSelectRectangleView.m
//
//
//  Created by Andrewlia on 14/1/3.
//  Copyright (c) 2014年 Andrewlia. All rights reserved.
//

#import "PPClipBusinessCardDrawSelectRectangleView.h"
#import "PPClipBusinessCardViewControllerPrivateParameterDefine.h"
#import "UIColor+HexString.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPClipBusinessCardDrawSelectRectangleView()

@interface PPClipBusinessCardDrawSelectRectangleView ()
- (void)drawDefaultControlRectangleInContext:(CGContextRef)context;
- (void)drawSelectColorEdgeInContext:(CGContextRef)context;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPClipBusinessCardDrawSelectRectangleView

@implementation PPClipBusinessCardDrawSelectRectangleView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - synthesize

@synthesize
rectDrawn                                         = rectDrawn_,
ppClipBusinessCardDrawSelectRectangleViewColor    = ppClipBusinessCardDrawSelectRectangleViewColor_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Drawing and Updating the View

//================================================================================
// Only override drawRect: if you perform custom drawing.
// 當使用 setNeedsDisplay, 則此事件函式即被呼叫
//================================================================================
- (void)drawRect:(CGRect)rect
{
    if (CGRectIsEmpty(self.frame)==NO)
    {
        CGContextRef foregroundShowContext = UIGraphicsGetCurrentContext();
        CGContextSaveGState(foregroundShowContext);
        
        //////////////////////////////////////////////////
        
        if (foregroundShowContext!=NULL)
        {
            [self drawDefaultControlRectangleInContext:foregroundShowContext];
            [self drawSelectColorEdgeInContext:foregroundShowContext];
        }
        
        //////////////////////////////////////////////////
        
        CGContextRestoreGState(foregroundShowContext);
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
// 改變點擊事件觸發的View
//================================================================================
- (UIView *)hitTest:(CGPoint)point withEvent:(UIEvent *)event
{
    [super hitTest:point withEvent:event];
    
    //////////////////////////////////////////////////
    
    return nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Methods

//================================================================================
// 設定Frame大小時,即被呼叫來重設顯示畫面
//================================================================================
- (void)setFrame:(CGRect)frame
{
    [super setFrame:frame];
    
    //////////////////////////////////////////////////
    
    [self setNeedsDisplay];
}


//================================================================================
// 設定選擇方框大小時,即被呼叫來重設顯示畫面
//================================================================================
- (void)setRectDrawn:(CGRect)rectDrawn
{
    rectDrawn_ = rectDrawn;
    
    [self setNeedsDisplay];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

//================================================================================
// 定義繪畫矩形圖案的函式
//================================================================================
- (void)drawDefaultControlRectangleInContext:(CGContextRef)context
{
    if (context!=NULL)
    {
        CGContextSetFillColorWithColor(context, [UIColor yellowColor].CGColor);
        CGContextSetLineWidth(context, PPClipBusinessCardDrawSelectRectangleViewLineWidth);
        CGContextSetStrokeColorWithColor(context, [UIColor yellowColor].CGColor);
        
        //////////////////////////////////////////////////
        
        // 定義並繪畫四個控制點
        
        CGRect standardRectDrawn     = CGRectStandardize(self.rectDrawn);
        
        CGPoint pointLeftUp          = standardRectDrawn.origin;
        CGRect controlPointLeftUp    = CGRectMake(pointLeftUp.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  pointLeftUp.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
        
        CGPoint pointLeftDown        = CGPointMake(pointLeftUp.x, pointLeftUp.y+standardRectDrawn.size.height);
        CGRect controlPointLeftDown  = CGRectMake(pointLeftDown.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  pointLeftDown.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
        
        CGPoint pointRightUp         = CGPointMake(pointLeftUp.x+standardRectDrawn.size.width, pointLeftUp.y);
        CGRect controlPointRightUp   = CGRectMake(pointRightUp.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  pointRightUp.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
        
        CGPoint pointRightDown       = CGPointMake(pointLeftUp.x+standardRectDrawn.size.width, pointLeftUp.y+standardRectDrawn.size.height);
        CGRect controlPointRightDown = CGRectMake(pointRightDown.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  pointRightDown.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
        
        
//        CGPoint pointLeftMindle        = CGPointMake((pointLeftUp.x+pointLeftDown.x)/2, (pointLeftUp.y+pointLeftDown.y)/2);
//        CGRect  controlPointLeftMindle = CGRectMake(pointLeftMindle.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    pointLeftMindle.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
//        
//        CGPoint pointRightMindle        = CGPointMake((pointRightUp.x+pointRightDown.x)/2, (pointRightUp.y+pointRightDown.y)/2);
//        CGRect  controlPointRightMindle = CGRectMake(pointRightMindle.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    pointRightMindle.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
//        
//        CGPoint pointUpMindle        = CGPointMake((pointLeftUp.x+pointRightUp.x)/2, (pointLeftUp.y+pointRightUp.y)/2);
//        CGRect  controlPointUpMindle = CGRectMake(pointUpMindle.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    pointUpMindle.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
//        
//        CGPoint pointDownMindle        = CGPointMake((pointLeftDown.x+pointRightDown.x)/2, (pointLeftDown.y+pointRightDown.y)/2);
//        CGRect  controlPointDownMindle = CGRectMake(pointDownMindle.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    pointDownMindle.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
    
        //////////////////////////////////////////////////
        
        CGContextAddEllipseInRect(context, controlPointLeftUp);
        CGContextFillEllipseInRect(context, controlPointLeftUp);
        
        CGContextAddEllipseInRect(context, controlPointLeftDown);
        CGContextFillEllipseInRect(context, controlPointLeftDown);
    
        CGContextAddEllipseInRect(context, controlPointRightUp);
        CGContextFillEllipseInRect(context, controlPointRightUp);
        
        CGContextAddEllipseInRect(context, controlPointRightDown);
        CGContextFillEllipseInRect(context, controlPointRightDown);
        
        //////////////////////////////////////////////////

//        CGContextAddEllipseInRect(context, controlPointLeftMindle);
//        CGContextFillEllipseInRect(context, controlPointLeftMindle);
//        
//        CGContextAddEllipseInRect(context, controlPointRightMindle);
//        CGContextFillEllipseInRect(context, controlPointRightMindle);
//        
//        CGContextAddEllipseInRect(context, controlPointUpMindle);
//        CGContextFillEllipseInRect(context, controlPointUpMindle);
//        
//        CGContextAddEllipseInRect(context, controlPointDownMindle);
//        CGContextFillEllipseInRect(context, controlPointDownMindle);
//        //////////////////////////////////////////////////
        // 繪畫控制矩形
        
        CGContextAddRect(context, self.rectDrawn);
        CGContextStrokePath(context);
    }
    
}


//================================================================================
// 定義繪畫選擇邊的函式
//================================================================================
- (void)drawSelectColorEdgeInContext:(CGContextRef)context
{
    if (context!=NULL)
    {
        CGContextSetFillColorWithColor(context, [UIColor colorWithHexString:PPClipBusinessCardViewControllerSelectRectLineColor].CGColor);
        CGContextSetStrokeColorWithColor(context, [UIColor colorWithHexString:PPClipBusinessCardViewControllerSelectRectLineColor].CGColor);
        
        //////////////////////////////////////////////////
        // 定義四個控制點
        
        CGRect standardRectDrawn     = CGRectStandardize(self.rectDrawn);
        
        CGPoint pointLeftUp          = standardRectDrawn.origin;
        CGRect controlPointLeftUp    = CGRectMake(pointLeftUp.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  pointLeftUp.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
        
        CGPoint pointLeftDown        = CGPointMake(pointLeftUp.x, pointLeftUp.y+standardRectDrawn.size.height);
        CGRect controlPointLeftDown  = CGRectMake(pointLeftDown.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  pointLeftDown.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
        
        CGPoint pointRightUp         = CGPointMake(pointLeftUp.x+standardRectDrawn.size.width, pointLeftUp.y);
        CGRect controlPointRightUp   = CGRectMake(pointRightUp.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  pointRightUp.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
        
        CGPoint pointRightDown       = CGPointMake(pointLeftUp.x+standardRectDrawn.size.width, pointLeftUp.y+standardRectDrawn.size.height);
        CGRect controlPointRightDown = CGRectMake(pointRightDown.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  pointRightDown.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
                                                  2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
//        
//        CGPoint pointLeftMindle        = CGPointMake((pointLeftUp.x+pointLeftDown.x)/2, (pointLeftUp.y+pointLeftDown.y)/2);
//        CGRect  controlPointLeftMindle = CGRectMake(pointLeftMindle.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    pointLeftMindle.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
//                                                    2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
//        
//        CGPoint pointRightMindle        = CGPointMake((pointRightUp.x+pointRightDown.x)/2, (pointRightUp.y+pointRightDown.y)/2);
//        CGRect  controlPointRightMindle = CGRectMake(pointRightMindle.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                     pointRightMindle.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                     2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
//                                                     2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
//        
//        CGPoint pointUpMindle           = CGPointMake((pointLeftUp.x+pointRightUp.x)/2, (pointLeftUp.y+pointRightUp.y)/2);
//        CGRect  controlPointUpMindle    = CGRectMake(pointUpMindle.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                     pointUpMindle.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                     2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
//                                                     2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
//        
//        CGPoint pointDownMindle         = CGPointMake((pointLeftDown.x+pointRightDown.x)/2, (pointLeftDown.y+pointRightDown.y)/2);
//        CGRect  controlPointDownMindle  = CGRectMake(pointDownMindle.x-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                     pointDownMindle.y-PPClipBusinessCardDrawSelectRectangleViewControlSize,
//                                                     2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1,
//                                                     2*PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
        
        //////////////////////////////////////////////////
        // 繪畫選擇的模式
        
        switch (self.ppClipBusinessCardDrawSelectRectangleViewColor)
        {
            case PPClipBusinessCardDrawSelectRectangleViewColor_None:
            {
                CGContextAddEllipseInRect(context, controlPointLeftUp);
                CGContextFillEllipseInRect(context, controlPointLeftUp);
                
                CGContextAddEllipseInRect(context, controlPointLeftDown);
                CGContextFillEllipseInRect(context, controlPointLeftDown);
                
                CGContextAddEllipseInRect(context, controlPointRightUp);
                CGContextFillEllipseInRect(context, controlPointRightUp);
                
                CGContextAddEllipseInRect(context, controlPointRightDown);
                CGContextFillEllipseInRect(context, controlPointRightDown);
                
//                CGContextAddEllipseInRect(context, controlPointLeftMindle);
//                CGContextFillEllipseInRect(context, controlPointLeftMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointRightMindle);
//                CGContextFillEllipseInRect(context, controlPointRightMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointUpMindle);
//                CGContextFillEllipseInRect(context, controlPointUpMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointDownMindle);
//                CGContextFillEllipseInRect(context, controlPointDownMindle);
                
                CGContextAddRect(context, standardRectDrawn);
                
                break;
            }
            case PPClipBusinessCardDrawSelectRectangleViewColor_LeftUp:
            {
                CGContextAddEllipseInRect(context, controlPointLeftDown);
                CGContextFillEllipseInRect(context, controlPointLeftDown);
                
                CGContextAddEllipseInRect(context, controlPointRightUp);
                CGContextFillEllipseInRect(context, controlPointRightUp);
                
                CGContextAddEllipseInRect(context, controlPointRightDown);
                CGContextFillEllipseInRect(context, controlPointRightDown);
                
//                CGContextAddEllipseInRect(context, controlPointDownMindle);
//                CGContextFillEllipseInRect(context, controlPointDownMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointRightMindle);
//                CGContextFillEllipseInRect(context, controlPointRightMindle);
                
                CGContextMoveToPoint(context, pointRightUp.x, pointRightUp.y);
                CGContextAddLineToPoint(context, pointRightDown.x, pointRightDown.y);
                CGContextAddLineToPoint(context, pointLeftDown.x, pointLeftDown.y);
                
                break;
            }
            case PPClipBusinessCardDrawSelectRectangleViewColor_LeftDown:
            {
                CGContextAddEllipseInRect(context, controlPointLeftUp);
                CGContextFillEllipseInRect(context, controlPointLeftUp);
                
                CGContextAddEllipseInRect(context, controlPointRightUp);
                CGContextFillEllipseInRect(context, controlPointRightUp);
                
                CGContextAddEllipseInRect(context, controlPointRightDown);
                CGContextFillEllipseInRect(context, controlPointRightDown);
                
//                CGContextAddEllipseInRect(context, controlPointUpMindle);
//                CGContextFillEllipseInRect(context, controlPointUpMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointRightMindle);
//                CGContextFillEllipseInRect(context, controlPointRightMindle);
                
                CGContextMoveToPoint(context, pointLeftUp.x, pointLeftUp.y);
                CGContextAddLineToPoint(context, pointRightUp.x, pointRightUp.y);
                CGContextAddLineToPoint(context, pointRightDown.x, pointRightDown.y);
                
                break;
            }
            case PPClipBusinessCardDrawSelectRectangleViewColor_RightUp:
            {
                CGContextAddEllipseInRect(context, controlPointLeftUp);
                CGContextFillEllipseInRect(context, controlPointLeftUp);
                
                CGContextAddEllipseInRect(context, controlPointLeftDown);
                CGContextFillEllipseInRect(context, controlPointLeftDown);
                
                CGContextAddEllipseInRect(context, controlPointRightDown);
                CGContextFillEllipseInRect(context, controlPointRightDown);
                
//                CGContextAddEllipseInRect(context, controlPointDownMindle);
//                CGContextFillEllipseInRect(context, controlPointDownMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointLeftMindle);
//                CGContextFillEllipseInRect(context, controlPointLeftMindle);
                
                CGContextMoveToPoint(context, pointRightDown.x, pointRightDown.y);
                CGContextAddLineToPoint(context, pointLeftDown.x, pointLeftDown.y);
                CGContextAddLineToPoint(context, pointLeftUp.x, pointLeftUp.y);
                
                break;
            }
            case PPClipBusinessCardDrawSelectRectangleViewColor_RightDown:
            {
                CGContextAddEllipseInRect(context, controlPointLeftUp);
                CGContextFillEllipseInRect(context, controlPointLeftUp);
                
                CGContextAddEllipseInRect(context, controlPointLeftDown);
                CGContextFillEllipseInRect(context, controlPointLeftDown);
                
                CGContextAddEllipseInRect(context, controlPointRightUp);
                CGContextFillEllipseInRect(context, controlPointRightUp);
                
//                CGContextAddEllipseInRect(context, controlPointUpMindle);
//                CGContextFillEllipseInRect(context, controlPointUpMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointLeftMindle);
//                CGContextFillEllipseInRect(context, controlPointLeftMindle);
                
                CGContextMoveToPoint(context, pointLeftDown.x, pointLeftDown.y);
                CGContextAddLineToPoint(context, pointLeftUp.x, pointLeftUp.y);
                CGContextAddLineToPoint(context, pointRightUp.x, pointRightUp.y);
                
                break;
            }
            case PPClipBusinessCardDrawSelectRectangleViewColor_UpMindle:
            {
                CGContextAddEllipseInRect(context, controlPointLeftDown);
                CGContextFillEllipseInRect(context, controlPointLeftDown);
                
                CGContextAddEllipseInRect(context, controlPointRightDown);
                CGContextFillEllipseInRect(context, controlPointRightDown);
                
//                CGContextAddEllipseInRect(context, controlPointRightMindle);
//                CGContextFillEllipseInRect(context, controlPointRightMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointLeftMindle);
//                CGContextFillEllipseInRect(context, controlPointLeftMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointDownMindle);
//                CGContextFillEllipseInRect(context, controlPointDownMindle);
                
                CGContextMoveToPoint(context, pointLeftUp.x, pointLeftUp.y+PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
                CGContextAddLineToPoint(context, pointLeftDown.x, pointLeftDown.y);
                CGContextAddLineToPoint(context, pointRightDown.x, pointRightDown.y);
                CGContextAddLineToPoint(context, pointRightUp.x, pointRightUp.y+PPClipBusinessCardDrawSelectRectangleViewControlSize+1);
                break;
            }
            case PPClipBusinessCardDrawSelectRectangleViewColor_DownMindle:
            {
                CGContextAddEllipseInRect(context, controlPointLeftUp);
                CGContextFillEllipseInRect(context, controlPointLeftUp);
                
                CGContextAddEllipseInRect(context, controlPointRightUp);
                CGContextFillEllipseInRect(context, controlPointRightUp);
                
//                CGContextAddEllipseInRect(context, controlPointRightMindle);
//                CGContextFillEllipseInRect(context, controlPointRightMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointLeftMindle);
//                CGContextFillEllipseInRect(context, controlPointLeftMindle);
//                
//                CGContextAddEllipseInRect(context, controlPointUpMindle);
//                CGContextFillEllipseInRect(context, controlPointUpMindle);
                
                CGContextMoveToPoint(context, pointLeftDown.x, pointLeftDown.y-(PPClipBusinessCardDrawSelectRectangleViewControlSize+1));
                CGContextAddLineToPoint(context, pointLeftUp.x, pointLeftUp.y);
                CGContextAddLineToPoint(context, pointRightUp.x, pointRightUp.y);
                CGContextAddLineToPoint(context, pointRightDown.x, pointRightDown.y-(PPClipBusinessCardDrawSelectRectangleViewControlSize+1));
                break;
            }
            case PPClipBusinessCardDrawSelectRectangleViewColor_LeftMindle:
            {
                break;
            }
            case PPClipBusinessCardDrawSelectRectangleViewColor_RightMindle:
            {
                break;
            }
            default:
            {
                break;
            }
        }
        
        CGContextStrokePath(context);
    }
    
}

@end
