//
//  CardImageTopBarView.m
//  
//
//  Created by Howard.Lin on 13/12/25.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "CardImageTopBarView.h"

// Define
#import "PPCardImageViewController+ResourceDefine.h"

// Category
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation CardImageTopBarView


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        // Initialization code
        self.style = PPBarViewStyle_CenteredAbsolute;

        //////////////////////////////////////////////////
        
        _backButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(_backButton!=nil)
        {
            _backButton.delegate = self;
            _backButton.tag      = CardImageTopBarViewButtonTag_Back;
            
            [_backButton addControlEvents:UIControlEventTouchUpInside];
            [_backButton setImageWithName:ImageNameForCardImageTopBarViewBackButton];

            //////////////////////////////////////////////////

            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_backButton];
            
            if(itemModel!=nil)
            {
                itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        //////////////////////////////////////////////////

        _addOrChageSideButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(self.addOrChageSideButton!=nil)
        {
            self.addOrChageSideButton.delegate = self;
            self.addOrChageSideButton.tag      = CardImageTopBarViewButtonTag_ChageSide;
            
            [self.addOrChageSideButton addControlEvents:UIControlEventTouchUpInside];
            [self.addOrChageSideButton setImageWithName:ImageNameForCardImageTopBarViewChnageSideButton];
        }

        //////////////////////////////////////////////////

        if(_addOrChageSideButton!=nil)
        {
            PPBarViewItemModel *addOrChageSideItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_addOrChageSideButton];
            
            if(addOrChageSideItemModel!=nil)
            {
                addOrChageSideItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////

            if(addOrChageSideItemModel!=nil)
            {
                [self setItemModels:@[addOrChageSideItemModel]
                       forBlockType:PPBarViewBlockType_Right];
            }
            
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_backButton removeFromSuperview];
    [_backButton release];
    _backButton = nil;
    
    [_addOrChageSideButton removeFromSuperview];
    [_addOrChageSideButton release];
    _addOrChageSideButton = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)setLayout:(CardImageTopBarViewLayout)layout
{
    _layout = layout;
    
    //////////////////////////////////////////////////

    switch (self.layout)
    {
        case CardImageTopBarViewLayout_AddFrontCard:
        {
            self.addOrChageSideButton.tag = CardImageTopBarViewButtonTag_AddFrontCard;
            [self.addOrChageSideButton setImageWithName:ImageNameForCardImageTopBarViewAddButton];
            
            break;
        }
        case CardImageTopBarViewLayout_AddRearCard:
        {
            self.addOrChageSideButton.tag = CardImageTopBarViewButtonTag_AddRearCard;
            [self.addOrChageSideButton setImageWithName:ImageNameForCardImageTopBarViewAddRearCardButton];
            
            break;
        }
        case CardImageTopBarViewLayout_Edit:
        {
            self.addOrChageSideButton.tag = CardImageTopBarViewButtonTag_ChageSide;
            [self.addOrChageSideButton setImageWithName:ImageNameForCardImageTopBarViewChnageSideButton];
            
            break;
        }
        default:
        {
            break;
        }
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(cardImageTopBarView:ppButton:controlEvent:)]==YES)
    {
        [self.delegate cardImageTopBarView:self ppButton:ppButton controlEvent:controlEvent];;
    }
}


@end
