//
//  PPCardImageViewController.m
//  
//
//  Created by Howard.Lin on 13/12/25.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCardImageViewController.h"

// Define
#import "PPCardImageViewController+PrivateParameterDefine.h"
#import "PPCardImageViewController+ResourceDefine.h"
#import "UIViewController+ShareApplication.h"

// controller
#import "PPLogController.h"

// view
#import "PPAlertView.h"
#import "PPBusyView.h"

// extension
#import "AVCaptureDevice+RequestAuthorization.h"
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCardImageViewController () <UIAlertViewDelegate,CardImageBottomBarViewDelegate,CardImageTopBarViewDelegate>

@property (nonatomic,readwrite,retain) CardImageBottomBarView  *cardImageBottomBarView;
@property (nonatomic,readwrite,retain) CardImageTopBarView     *cardImageTopBarView;
@property (nonatomic,retain)           PPBusyView              *busyView;
@property (nonatomic,retain)           UIImage                 *defaultImage;
@property (nonatomic,readwrite,retain) UIImage                 *rearCardImage;
@property (nonatomic,readwrite,retain) UIImage                 *frontCardImage;
@property (nonatomic,assign)           BOOL                    firstFetchImage;
//@property (nonatomic, retain)          UIAlertController       *alertController;

@property (nonatomic,retain) NSArray *layoutConstraints;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCardImageViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _cardImageViewControllerDisplayMode  = PPCardImageViewControllerDisplayMode_EditFrontSide;
        
        //////////////////////////////////////////////////

        _bottomBarBackgroundColor = [[UIColor clearColor] retain];
        
        //////////////////////////////////////////////////

        // MARK: 顯示範圍設定
        self.browseAreaInset = UIEdgeInsetsMake(0, 0, PPCardImageViewControllerBottomViewHeight, 0);
        
        //////////////////////////////////////////////////

        _firstFetchImage = YES;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_cardImageBottomBarView removeFromSuperview];
    [_cardImageBottomBarView release];
    _cardImageBottomBarView = nil;
    
    [_cardImageTopBarView removeFromSuperview];
    [_cardImageTopBarView release];
    _cardImageTopBarView = nil;
    
    [_defaultImage release];
    _defaultImage = nil;
    
    [_rearCardImage release];
    _rearCardImage = nil;
    
    [_frontCardImage release];
    _frontCardImage = nil;
    
    [_controllerTitle release];
    _controllerTitle = nil;
    
    [_bottomBarBackgroundColor release];
    _bottomBarBackgroundColor = nil;
    
    [_imageScrollViewBackgroundColor release];
    _imageScrollViewBackgroundColor = nil;
    
    [_navigationBarButtonHighlightedBackgroundColor release];
    _navigationBarButtonHighlightedBackgroundColor = nil;
    
    [_bottomBarBacButtonHighlightedkgroundColor release];
    _bottomBarBacButtonHighlightedkgroundColor = nil;
    
    [_layoutConstraints release];
    _layoutConstraints = nil;
    
    [_busyView removeFromSuperview];
    [_busyView release];
    _busyView = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    PPLogFunctionIn();
    
    //////////////////////////////////////////////////
    
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    if(self.cardImageBottomBarView==nil)
    {
        _cardImageBottomBarView = [[CardImageBottomBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if(self.cardImageBottomBarView!=nil)
    {
        [self.cardImageBottomBarView setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.cardImageBottomBarView.delegate = self;
        self.cardImageBottomBarView.backgroundColor = self.bottomBarBackgroundColor;
        
        //////////////////////////////////////////////////

        [self.cardImageBottomBarView.moreButton setImageEdgeInsets:self.buttonImageEdgeInsets];
        [self.cardImageBottomBarView.replaceImageButton setImageEdgeInsets:self.buttonImageEdgeInsets];
        [self.cardImageBottomBarView.rotateLeftButton setImageEdgeInsets:self.buttonImageEdgeInsets];
        [self.cardImageBottomBarView.rotateRightButton setImageEdgeInsets:self.buttonImageEdgeInsets];
        
        //////////////////////////////////////////////////

        if(self.bottomBarBacButtonHighlightedkgroundColor)
        {
            [self.cardImageBottomBarView.moreButton setBackgroundImage:[UIImage imageWithColor:self.bottomBarBacButtonHighlightedkgroundColor] forState:UIControlStateHighlighted];
            [self.cardImageBottomBarView.replaceImageButton setBackgroundImage:[UIImage imageWithColor:self.bottomBarBacButtonHighlightedkgroundColor] forState:UIControlStateHighlighted];
            [self.cardImageBottomBarView.rotateLeftButton setBackgroundImage:[UIImage imageWithColor:self.bottomBarBacButtonHighlightedkgroundColor] forState:UIControlStateHighlighted];
            [self.cardImageBottomBarView.rotateRightButton setBackgroundImage:[UIImage imageWithColor:self.bottomBarBacButtonHighlightedkgroundColor] forState:UIControlStateHighlighted];
        }
        //////////////////////////////////////////////////

        [self.view addSubview:self.cardImageBottomBarView];
    }
    
    //////////////////////////////////////////////////
    
    if(self.navigationController!=nil)
    {
        if(self.cardImageTopBarView==nil)
        {
            _cardImageTopBarView = [[CardImageTopBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
        }
        
        if(self.cardImageTopBarView!=nil)
        {
            self.cardImageTopBarView.delegate  = self;
            self.cardImageTopBarView.titleLabel.text = self.controllerTitle;
            
            if(self.navigationBarButtonHighlightedBackgroundColor!=nil)
            {
                [self.cardImageTopBarView.addOrChageSideButton setBackgroundImage:[UIImage imageWithColor:self.navigationBarButtonHighlightedBackgroundColor]
                                                                         forState:UIControlStateHighlighted];
                
                [self.cardImageTopBarView.backButton setBackgroundImage:[UIImage imageWithColor:self.navigationBarButtonHighlightedBackgroundColor]
                                                               forState:UIControlStateHighlighted];
            }
            
            //////////////////////////////////////////////////

            [self.cardImageTopBarView.addOrChageSideButton setImageEdgeInsets:self.buttonImageEdgeInsets];
            [self.cardImageTopBarView.backButton setImageEdgeInsets:self.buttonImageEdgeInsets];
        }
        
        //////////////////////////////////////////////////
        
        UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.cardImageTopBarView];

        self.navigationItem.leftBarButtonItem = leftBarButtonItem;

        [leftBarButtonItem release];
    }
    
    //////////////////////////////////////////////////
    
    //!!更新目前排版
    self.cardImageViewControllerDisplayMode = self.cardImageViewControllerDisplayMode;
    
    //////////////////////////////////////////////////
   
    [self fetchImage];
    
    //////////////////////////////////////////////////

    [self.view setNeedsUpdateConstraints];
    
    PPLogFunctionOut();
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    PPLogFunctionIn();

    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////
    
    self.navigationItem.leftBarButtonItem = nil;
    
    [self.cardImageBottomBarView removeFromSuperview];
    self.cardImageBottomBarView = nil;
    
    [self.cardImageTopBarView removeFromSuperview];
    self.cardImageTopBarView = nil;

    //////////////////////////////////////////////////
    
    PPLogFunctionOut();
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    //////////////////////////////////////////////////
    
    [self resetLayoutConstraints];
    
    [self updateDisplayImage];

}


//==============================================================================
//
//==============================================================================
- (void)updateViewConstraints
{
    [super updateViewConstraints];
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
    
    [self updateDisplayImage];

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.cardImageTopBarView==nil)
    {
        return ;
    }
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSInteger bottomBarHeight = PPCardImageViewControllerBottomViewHeight;
    
    if(@available(iOS 11, *))
    {
        bottomBarHeight += self.view.safeAreaInsets.bottom;
        self.cardImageBottomBarView.addtionBlockEdgeInsets = UIEdgeInsetsMake(0, 0, self.view.safeAreaInsets.bottom, 0);
    }
    self.browseAreaInset = UIEdgeInsetsMake(0, 0, bottomBarHeight, 0);
    [self assignBrowseViewLayuotConstraints];

    //////////////////////////////////////////////////
    NSDictionary *views = @{@"cardImageBottomBarView":self.cardImageBottomBarView};
    NSDictionary *metrics = @{@"BottomBarHeight":@(bottomBarHeight)};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[cardImageBottomBarView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:[cardImageBottomBarView(BottomBarHeight)]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View rotation Event

//================================================================================
//
//================================================================================
- (void)willRotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration
{
    [super willRotateToInterfaceOrientation:toInterfaceOrientation duration:duration];
    
    //////////////////////////////////////////////////
//
//    CGRect layoutFrame      = [self layoutFrame];
//
//    //////////////////////////////////////////////////
//
//    self.browseAreaInset = UIEdgeInsetsMake(layoutFrame.origin.y, 0, PPCardImageViewControllerBottomViewHeight, 0);
//
//    //////////////////////////////////////////////////
//
//    [self updateImageFromDisplayImage];
//    [self assignBrowseViewLayuotConstraints];
//
    //////////////////////////////////////////////////

    if([self.delegate respondsToSelector:@selector(cardImageViewController:willAnimateRotationToInterfaceOrientation:)]==YES)
    {
        [self.delegate cardImageViewController:self
     willAnimateRotationToInterfaceOrientation:toInterfaceOrientation];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setCardImageViewControllerDisplayMode:(PPCardImageViewControllerDisplayMode)cardImageViewControllerDisplayMode
{
    _cardImageViewControllerDisplayMode = cardImageViewControllerDisplayMode;
    
    //////////////////////////////////////////////////
    
    [self updateCardImageTopBarViewLayout];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)updateDisplayImage
{
    switch (self.cardImageViewControllerDisplayMode)
    {
        case PPCardImageViewControllerDisplayMode_EditBackSide:
        {
            if(self.image!=self.rearCardImage)
            {
                self.image = self.rearCardImage;
                
                [super viewDidLayoutSubviews];
            }
            
            break;
        }
        case PPCardImageViewControllerDisplayMode_EditFrontSide:
        default:
        {
            if(self.frontCardImage!=nil)
            {
                if(self.image!=self.frontCardImage)
                {
                    self.image = self.frontCardImage;
                    
                    [super viewDidLayoutSubviews];
                }
            }
            else
            {
                if(self.image!=self.defaultImage)
                {
                    self.image = self.defaultImage;
                    
                    [super viewDidLayoutSubviews];
                }
            }
            
            break;
        }
    }
}


//================================================================================
//
//================================================================================
- (void)updateImageFromDisplayImage
{
    if(self.image!=self.defaultImage)
    {
        if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditBackSide)
        {
            self.rearCardImage = [self imageWithApplyRotation];
            
        }
        else if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditFrontSide)
        {
            self.frontCardImage = [self imageWithApplyRotation];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)updateCardImageTopBarViewLayout
{
    if(self.cardImageTopBarView!=nil)
    {
        switch (self.cardImageViewControllerDisplayMode)
        {
            case PPCardImageViewControllerDisplayMode_EditBackSide:
            {
                self.cardImageTopBarView.layout = CardImageTopBarViewLayout_Edit;
                
                break;
            }
            case PPCardImageViewControllerDisplayMode_EditFrontSide:
            default:
            {
                if(self.frontCardImage==nil)
                {
                    self.cardImageTopBarView.layout = CardImageTopBarViewLayout_AddFrontCard;
                }
                else if(self.rearCardImage==nil)
                {
                    self.cardImageTopBarView.layout = CardImageTopBarViewLayout_AddRearCard;
                }
                else
                {
                    self.cardImageTopBarView.layout = CardImageTopBarViewLayout_Edit;
                }
                
                break;
            }
        }
    }
}



//===============================================================================
//
//===============================================================================
- (void)showBusyView:(BOOL)show
{
    if(show==YES)
    {
        if(self.busyView==nil)
        {
            _busyView = [[PPBusyView alloc] initWithSuperView:[UIApplication sharedApplication].keyWindow];
            _busyView.style = PPBusyViewStyle_Border;
        }
    }
    else
    {
        [self.busyView removeFromSuperview];
        self.busyView = nil;
    }
}


//================================================================================
//
//================================================================================
- (BOOL)hasImage
{
    BOOL result = YES;
    
    if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditFrontSide &&
       self.frontCardImage==nil)
    {
        result = NO;
    }
    else if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditBackSide &&
            self.rearCardImage==nil)
    {
        result = NO;
    }
    
    return result;
}


//==============================================================================
//
//==============================================================================
- (void)showAddImageActionSheetWithTag:(PPCardImageViewControllerActionSheetTag)tag fromButton:(UIButton*)button
{

    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:nil
                                                                             message:nil
                                                                      preferredStyle:UIAlertControllerStyleActionSheet];
    [alertController addAction:[UIAlertAction actionWithTitle:@"Cancel"
                                                        style:UIAlertActionStyleCancel
                                                      handler:^(UIAlertAction * _Nonnull action) {
                                                          
                                                      }]];
    [alertController addAction:[UIAlertAction actionWithTitle:PCIV_MLS_SelectPhoto
                                                        style:UIAlertActionStyleDefault
                                                      handler:^(UIAlertAction * _Nonnull action) {
                                                          
                                                          PPCardImageViewControllerAction controllerAction = PPCardImageViewControllerAction_SelectPhotoForFrontCard;
                                                          if(tag==PPCardImageViewControllerActionSheetTag_NewCardImageForBackCard)
                                                          {
                                                              controllerAction = PPCardImageViewControllerAction_SelectPhotoForRearCard;
                                                          }
                                                          
                                                          _cardImageViewControllerAction = controllerAction;
                                                          
                                                          //////////////////////////////////////////////////
                                                          
                                                          [self.delegate cardImageViewController:self
                                                                                          action:controllerAction];
                                                          
                                                      }]];
    [alertController addAction:[UIAlertAction actionWithTitle:PCIV_MLS_TakePhoto
                                                        style:UIAlertActionStyleDefault
                                                      handler:^(UIAlertAction * _Nonnull action) {
                                                          
                                                          __block PPCardImageViewController *blockSelf = self;
                                                          
                                                          [AVCaptureDevice requestAccessCameraWithSuccessHandler:^{
                                                              
                                                              PPCardImageViewControllerAction controllerAction = PPCardImageViewControllerAction_TakePhotoForFrontCard;
                                                              if(tag==PPCardImageViewControllerActionSheetTag_NewCardImageForBackCard)
                                                              {
                                                                  controllerAction = PPCardImageViewControllerAction_TakePhotoForRearCard;
                                                              }
                                                              
                                                              _cardImageViewControllerAction = controllerAction;
                                                              
                                                              //////////////////////////////////////////////////
                                                              
                                                              [blockSelf.delegate cardImageViewController:self
                                                                                                   action:controllerAction];
                                                          } failedHandler:^{
                                                              
                                                              [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                                                                   title:@""
                                                                                 message:PCIV_MLS_CameraPolicyFailed
                                                                       cancelButtonTitle:PCIV_MLS_OK
                                                                       otherButtonTitles:nil];
                                                          }];
                                                      }]];
    
    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        [alertController setModalPresentationStyle:UIModalPresentationPopover];
        
        UIPopoverPresentationController *popPresenter = [alertController
                                                         popoverPresentationController];
        popPresenter.sourceView = button;
        popPresenter.sourceRect = button.bounds;
        
    }
    
    [self presentViewController:alertController animated:YES completion:nil];
}



//==============================================================================
//
//==============================================================================
- (void)showMoreActionSheetWithTag:(PPCardImageViewControllerActionSheetTag)tag fromButton:(UIButton*)button
{
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:nil
                                                                             message:nil
                                                                      preferredStyle:UIAlertControllerStyleActionSheet];
    [alertController addAction:[UIAlertAction actionWithTitle:@"Cancel"
                                                        style:UIAlertActionStyleCancel
                                                      handler:^(UIAlertAction * _Nonnull action) {
                                                          
                                                      }]];
    
    [alertController addAction:[UIAlertAction actionWithTitle:PCIV_MLS_ImageEnhance
                                                        style:UIAlertActionStyleDefault
                                                      handler:^(UIAlertAction * _Nonnull action) {
                                                          
                                                          PPCardImageViewControllerAction controllerAction = PPCardImageViewControllerAction_ImageEnhanceForFrontCard;

                                                          if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditBackSide)
                                                          {
                                                              controllerAction = PPCardImageViewControllerAction_ImageEnhanceForRearCard;
                                                          }
                                                          
                                                          _cardImageViewControllerAction = controllerAction;
                                                          
                                                          //////////////////////////////////////////////////
                                                          
                                                          [self.delegate cardImageViewController:self
                                                                                          action:controllerAction];
                                                          
                                                      }]];
    [alertController addAction:[UIAlertAction actionWithTitle:PCIV_MLS_DeleteImage
                                                        style:UIAlertActionStyleDefault
                                                      handler:^(UIAlertAction * _Nonnull action) {
                                                          
                                                          [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                                                               title:@""
                                                                             message:PCIV_MLS_CheckIfDeleteImage
                                                                            delegate:self
                                                                                 tag:PPCardImageViewControllerAlertViewTag_AskDeleteImage
                                                                   cancelButtonTitle:PCIV_MLS_Cancel
                                                                   otherButtonTitles:PCIV_MLS_Delete, nil];
                                                      }]];
    
    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        [alertController setModalPresentationStyle:UIModalPresentationPopover];
        
        UIPopoverPresentationController *popPresenter = [alertController
                                                         popoverPresentationController];
        popPresenter.sourceView = button;
        popPresenter.sourceRect = button.bounds;
    }
    
    [self presentViewController:alertController animated:YES completion:nil];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private fetch Image Method

//================================================================================
//
//================================================================================
- (void)fetchImage
{
    do
    {
        if(self.datasource==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([self.datasource respondsToSelector:@selector(defaultImageWithCardImageViewController:)]==NO ||
           [self.datasource respondsToSelector:@selector(frontImageWithCardImageViewController:)]==NO ||
           [self.datasource respondsToSelector:@selector(rearImageWithCardImageViewController:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self showBusyView:YES];
        
        //////////////////////////////////////////////////

        self.defaultImage = [self.datasource defaultImageWithCardImageViewController:self];
        
        //////////////////////////////////////////////////

        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            __block UIImage *frontCardImage = [[blockself.datasource frontImageWithCardImageViewController:self] retain];
            __block UIImage *rearCardImage  = [[blockself.datasource rearImageWithCardImageViewController:self] retain];
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if(blockself.frontCardImage!=frontCardImage)
                {
                    if(self.firstFetchImage==NO)
                    {
                        blockself.frontCardImageFixed = YES;
                    }
                
                    //////////////////////////////////////////////////

                    blockself.frontCardImage      = frontCardImage;
                }
                
                //////////////////////////////////////////////////

                if(blockself.rearCardImage!=rearCardImage)
                {
                    if(blockself.firstFetchImage==NO)
                    {
                        blockself.rearCardImageFixed = YES;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    blockself.rearCardImage      = rearCardImage;
                }
       
                //////////////////////////////////////////////////

                // 視圖進來後，做過一次 fetchImage之後，此flag要開始，讓下次進來的時候，如果是新增反面圖時才能判斷有修改過
                
                blockself.firstFetchImage = NO;
                
                //////////////////////////////////////////////////

                [blockself updateDisplayImage];
                
                //////////////////////////////////////////////////

                [frontCardImage release];
                [rearCardImage release];
                
                //////////////////////////////////////////////////

                [blockself updateCardImageTopBarViewLayout];
                
                //////////////////////////////////////////////////

                [blockself showBusyView:NO];
            });
        });
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIActionSheetDelegate Method

//================================================================================
//
//================================================================================
- (void)actionSheet:(UIActionSheet *)actionSheet didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    do
    {
        if([self.delegate respondsToSelector:@selector(cardImageViewController:action:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *clickedButtonTitle = [actionSheet buttonTitleAtIndex:buttonIndex];
        
        //////////////////////////////////////////////////
        
        if(actionSheet.tag==PPCardImageViewControllerActionSheetTag_More)
        {
            [self updateImageFromDisplayImage];
            
            //////////////////////////////////////////////////
            
            if([clickedButtonTitle compare:PCIV_MLS_ImageEnhance]==NSOrderedSame)
            {
                // TODO: 名片影像加強

                _cardImageViewControllerAction = PPCardImageViewControllerAction_ImageEnhanceForFrontCard;
                
                if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditBackSide)
                {
                    _cardImageViewControllerAction = PPCardImageViewControllerAction_ImageEnhanceForRearCard;
                }
        
                //////////////////////////////////////////////////
                
                [self.delegate cardImageViewController:self
                                                action:_cardImageViewControllerAction];
                
            }
            else if([clickedButtonTitle compare:PCIV_MLS_DeleteImage]==NSOrderedSame)
            {
                [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                     title:@""
                                   message:PCIV_MLS_CheckIfDeleteImage
                                  delegate:self
                                       tag:PPCardImageViewControllerAlertViewTag_AskDeleteImage
                         cancelButtonTitle:PCIV_MLS_Cancel
                         otherButtonTitles:PCIV_MLS_Delete, nil];
            }
        }
        else if(actionSheet.tag==PPCardImageViewControllerActionSheetTag_NewCardImageForBackCard)
        {
            [self updateImageFromDisplayImage];
            
            //////////////////////////////////////////////////

            switch (buttonIndex)
            {
                case PPCardImageViewControllerActionSheet_NewCardImageButtonIndex_SelectPhoto:
                {
                    _cardImageViewControllerAction = PPCardImageViewControllerAction_SelectPhotoForRearCard;
                    
                    //////////////////////////////////////////////////
                    
                    [self.delegate cardImageViewController:self
                                                    action:PPCardImageViewControllerAction_SelectPhotoForRearCard];
                    
                    break;
                }
                case PPCardImageViewControllerActionSheet_NewCardImageButtonIndex_TakePhoto:
                {
                    __block PPCardImageViewController *blockSelf = self;
                    
                    [AVCaptureDevice requestAccessCameraWithSuccessHandler:^{
                        
                        _cardImageViewControllerAction = PPCardImageViewControllerAction_TakePhotoForRearCard;
                        
                        //////////////////////////////////////////////////
                        
                        [blockSelf.delegate cardImageViewController:self
                                                             action:PPCardImageViewControllerAction_TakePhotoForRearCard];
                    }
                                                             failedHandler:^{
                                                                 
                                                                 [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                                                                      title:@""
                                                                                    message:PCIV_MLS_CameraPolicyFailed
                                                                          cancelButtonTitle:PCIV_MLS_OK
                                                                          otherButtonTitles:nil];
                                                             }];
                    
                    break;
                }
            }
        }
        else if(actionSheet.tag==PPCardImageViewControllerActionSheetTag_NewCardImageForFrontCard)
        {
            [self updateImageFromDisplayImage];
            
            //////////////////////////////////////////////////
            
            switch (buttonIndex)
            {
                case PPCardImageViewControllerActionSheet_NewCardImageButtonIndex_SelectPhoto:
                {
                    _cardImageViewControllerAction = PPCardImageViewControllerAction_SelectPhotoForFrontCard;
                    
                    //////////////////////////////////////////////////
                    
                    [self.delegate cardImageViewController:self
                                                    action:PPCardImageViewControllerAction_SelectPhotoForFrontCard];
                    
                    break;
                }
                case PPCardImageViewControllerActionSheet_NewCardImageButtonIndex_TakePhoto:
                {
                    
                    __block PPCardImageViewController *blockSelf = self;
                    
                    [AVCaptureDevice requestAccessCameraWithSuccessHandler:^{
                        
                        _cardImageViewControllerAction = PPCardImageViewControllerAction_TakePhotoForFrontCard;
                        
                        //////////////////////////////////////////////////
                        
                        [blockSelf.delegate cardImageViewController:self
                                                             action:PPCardImageViewControllerAction_TakePhotoForFrontCard];
                    }
                                                             failedHandler:^{
                                                                 
                                                                 [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                                                                      title:@""
                                                                                    message:PCIV_MLS_CameraPolicyFailed
                                                                          cancelButtonTitle:PCIV_MLS_OK
                                                                          otherButtonTitles:nil];
                                                             }];
                    
                    break;
                }
            }
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIAlertViewDelegate Method

//================================================================================
//
//================================================================================
- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if(alertView.tag==PPCardImageViewControllerAlertViewTag_AskDeleteImage)
    {
        // MARK:刪除圖片
        if([[alertView buttonTitleAtIndex:buttonIndex] compare:PCIV_MLS_Delete]==NSOrderedSame)
        {
            switch (self.cardImageViewControllerDisplayMode)
            {
                case PPCardImageViewControllerDisplayMode_EditBackSide:
                {
                    self.rearCardImage = nil;
                    
                    //////////////////////////////////////////////////
                    
                    self.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditFrontSide;
                    
                    //////////////////////////////////////////////////
                    
                    [self updateDisplayImage];
                    
                    //////////////////////////////////////////////////
                    
                    self.rearCardImageFixed = YES;
                    
                    //////////////////////////////////////////////////
                    
                    _cardImageViewControllerAction = PPCardImageViewControllerAction_DeleteRearCard;
                    
                    //////////////////////////////////////////////////
                    
                    if([self.delegate respondsToSelector:@selector(cardImageViewController:action:)]==YES)
                    {
                        [self.delegate cardImageViewController:self
                                                        action:PPCardImageViewControllerAction_DeleteRearCard];
                    }
                    
                    break;
                }
                case PPCardImageViewControllerDisplayMode_EditFrontSide:
                {
                    if(self.rearCardImage!=nil)
                    {
                        self.frontCardImage = self.rearCardImage;
                        self.rearCardImage  = nil;
                    }
                    else
                    {
                        self.frontCardImage = nil;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    self.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditFrontSide;
                    
                    //////////////////////////////////////////////////
                    
                    [self updateDisplayImage];
                    
                    //////////////////////////////////////////////////
                    
                    self.rearCardImageFixed = YES;
                    self.frontCardImageFixed = YES;
                    
                    //////////////////////////////////////////////////
                    
                    _cardImageViewControllerAction = PPCardImageViewControllerAction_DeleteFrontCard;
                    
                    //////////////////////////////////////////////////
                    if([self.delegate respondsToSelector:@selector(cardImageViewController:action:)]==YES)
                    {
                        [self.delegate cardImageViewController:self
                                                        action:_cardImageViewControllerAction];
                    }
                    break;
                }
                default:
                {
                    break;
                }
            }
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CardImageBottomBarViewDelegate Method

//================================================================================
//
//================================================================================
- (void)cardImageBottomBarView:(CardImageBottomBarView *)cardImageBottomBarView
                      ppButton:(PPButton *)button
                  controlEvent:(UIControlEvents)controlEvent
{
    BOOL shouldAction = YES;
    if ([self.delegate respondsToSelector:@selector(shouldActionWithCardImageViewController:)])
    {
        shouldAction = [self.delegate shouldActionWithCardImageViewController:self];
    }
    
    if(shouldAction)
    {
        switch (button.tag)
        {
            case CardImageBottomBarViewButtonTag_More:
            {
                [self showMoreActionSheetWithTag:PPCardImageViewControllerActionSheetTag_More fromButton:self.cardImageBottomBarView.moreButton];
                break;
            }
            case CardImageBottomBarViewButtonTag_Replace:
            {
                [self updateImageFromDisplayImage];
                
                //////////////////////////////////////////////////
                PPCardImageViewControllerActionSheetTag tag = PPCardImageViewControllerActionSheetTag_NewCardImageForFrontCard;

                if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditBackSide)
                {
                    tag = PPCardImageViewControllerActionSheetTag_NewCardImageForBackCard;
                }
                
                [self showAddImageActionSheetWithTag:tag fromButton:self.cardImageBottomBarView.replaceImageButton];

                break;
            }
            case CardImageBottomBarViewButtonTag_RotateLeft:
            {
                [self animateRotateImageViewWithOrientation:PPImageBrowseViewController_Orientation_Left];
                
                //////////////////////////////////////////////////
                
                PPCardImageViewControllerAction action = PPCardImageViewControllerAction_None;
                
                //////////////////////////////////////////////////
                
                if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditBackSide)
                {
                    self.rearCardImageFixed=YES;
             
                    //////////////////////////////////////////////////

                    action = PPCardImageViewControllerAction_RotateForFrontCard;
                }
                else if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditFrontSide)
                {
                    self.frontCardImageFixed=YES;
         
                    //////////////////////////////////////////////////

                    action = PPCardImageViewControllerAction_RotateForRearCard;
                }
                
                //////////////////////////////////////////////////
                
                if(self.delegate!=nil &&
                   [self.delegate respondsToSelector:@selector(cardImageViewController:action:)]==YES)
                {
                    [self.delegate cardImageViewController:self
                                                    action:action];
                }
                
                break;
            }
            case CardImageBottomBarViewButtonTag_RotateRight:
            {
                [self animateRotateImageViewWithOrientation:PPImageBrowseViewController_Orientation_Right];
                
                //////////////////////////////////////////////////
                
                PPCardImageViewControllerAction action = PPCardImageViewControllerAction_None;
                
                //////////////////////////////////////////////////
                
                if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditBackSide)
                {
                    self.rearCardImageFixed=YES;

                    //////////////////////////////////////////////////

                    action = PPCardImageViewControllerAction_RotateForFrontCard;
                }
                else if(self.cardImageViewControllerDisplayMode==PPCardImageViewControllerDisplayMode_EditFrontSide)
                {
                    self.frontCardImageFixed=YES;
       
                    //////////////////////////////////////////////////

                    action = PPCardImageViewControllerAction_RotateForRearCard;
                }
                
                //////////////////////////////////////////////////
                
                if(self.delegate!=nil &&
                   [self.delegate respondsToSelector:@selector(cardImageViewController:action:)]==YES)
                {
                    [self.delegate cardImageViewController:self
                                                    action:action];
                }
                
                break;
            }
            default:
            {
                break;
            }
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CardImageTopBarDelegate Method

//================================================================================
//
//================================================================================
- (void)cardImageTopBarView:(CardImageTopBarView *)cardImageTopBarView
                   ppButton:(PPButton *)button
               controlEvent:(UIControlEvents)controlEvent
{
    switch (button.tag)
    {
        case CardImageTopBarViewButtonTag_AddFrontCard:
        case CardImageTopBarViewButtonTag_AddRearCard:
        {
            PPCardImageViewControllerActionSheetTag tag = PPCardImageViewControllerActionSheetTag_NewCardImageForFrontCard;
            
            if(self.frontCardImage!=nil)
            {
                tag = PPCardImageViewControllerActionSheetTag_NewCardImageForBackCard;
            }
            
            [self showAddImageActionSheetWithTag:tag fromButton:self.cardImageTopBarView.addOrChageSideButton];
            
            break;
        }
        case CardImageTopBarViewButtonTag_Back:
        {
            if(self.frontCardImageFixed==YES ||
               self.rearCardImageFixed==YES)
            {
                [self updateImageFromDisplayImage];
                
                //////////////////////////////////////////////////
                
                if([self.delegate respondsToSelector:@selector(cardImageViewController:didPickingFrontCardImage:rearCardImage:)]==YES)
                {
                    [self.delegate cardImageViewController:self
                                  didPickingFrontCardImage:self.frontCardImage
                                             rearCardImage:self.rearCardImage];
                }
            }
            else
            {
                if([self.delegate respondsToSelector:@selector(cardImageViewController:action:)]==YES)
                {
                    _cardImageViewControllerAction = PPCardImageViewControllerAction_Exit;
                    
                    //////////////////////////////////////////////////

                    [self.delegate cardImageViewController:self action:PPCardImageViewControllerAction_Exit];
                }
            }

            break;
        }
        case CardImageTopBarViewButtonTag_ChageSide:
        {
            switch (self.cardImageViewControllerDisplayMode)
            {
                case PPCardImageViewControllerDisplayMode_EditBackSide:
                {
                    self.rearCardImage = [self imageWithApplyRotation];
                    
                    //////////////////////////////////////////////////

                    self.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditFrontSide;
                    
                    [self updateDisplayImage];
                    
                    break;
                }
                case PPCardImageViewControllerDisplayMode_EditFrontSide:
                {
                    self.frontCardImage = [self imageWithApplyRotation];
                    
                    //////////////////////////////////////////////////

                    self.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditBackSide;
                    
                    [self updateDisplayImage];
                    
                    
                    break;
                }
                default:
                {
                    break;
                }
            }
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
- (UIImage *)displayImage
{
    return self.image;
}


//===============================================================================
//
//===============================================================================
- (void)clearMember
{
    [self.cardImageBottomBarView removeFromSuperview];
    self.cardImageBottomBarView = nil;
    
    [self.cardImageTopBarView removeFromSuperview];
    self.cardImageTopBarView = nil;
    
    self.rearCardImage = nil;
    
    self.frontCardImage = nil;
    
    self.rearCardImageFixed = NO;
    self.frontCardImageFixed = NO;
}

@end
