//
//  PPAlertController.m
//
//  Created by Howard.Lin on 2014/8/14.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#ifdef __IPHONE_8_0
#import "PPAlertController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static BOOL         allowMultiAlert = YES;
static NSInteger    instanceCount   = 0;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPAlertController ()

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPAlertController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if((self = [super init]))
    {
        instanceCount++;
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    instanceCount--;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Rotation Events


//================================================================================
//
//================================================================================
- (UIInterfaceOrientationMask)supportedInterfaceOrientations
{
    UIViewController *parentViewContoller = self.presentingViewController;
    if ([self.presentingViewController isKindOfClass:[UINavigationController class]])
    {
        parentViewContoller = [(UINavigationController *)self.presentingViewController topViewController];
    }
    
    return [parentViewContoller supportedInterfaceOrientations];
}


//================================================================================
//
//================================================================================
- (BOOL)shouldAutorotate
{
    UIViewController *parentViewContoller = self.presentingViewController;
    if ([self.presentingViewController isKindOfClass:[UINavigationController class]])
    {
        parentViewContoller = [(UINavigationController *)self.presentingViewController topViewController];
    }
    
    return [parentViewContoller shouldAutorotate];
}


//================================================================================
//
//================================================================================
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation
{
    UIViewController *parentViewContoller = self.presentingViewController;
    if ([self.presentingViewController isKindOfClass:[UINavigationController class]])
    {
        parentViewContoller = [(UINavigationController *)self.presentingViewController topViewController];
    }
    
    return [parentViewContoller shouldAutorotateToInterfaceOrientation:toInterfaceOrientation];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Class Method

//================================================================================
//
//================================================================================
+ (PPAlertController *)alertControllerWithAlertControllerStyle:(UIAlertControllerStyle)alertControllerStyle
                                                         title:(NSString *)title
                                                       message:(NSString *)message
                                                   alertAction:(UIAlertAction *)alertAction
                                                     arguments:(va_list)arguments
{
    PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:title
                                                                                   message:message
                                                                            preferredStyle:alertControllerStyle];
    
    do
    {
        if(ppAlertViewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        
        if(ppAlertViewController!=nil)
        {
            for(UIAlertAction *subAction=alertAction; subAction!=nil; subAction=va_arg(arguments, UIAlertAction *))
            {
                [ppAlertViewController addAction:subAction];
            }
        }
    }while(0);
    
    return ppAlertViewController;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (void)setAllowMultiAlert:(BOOL)allow
{
    allowMultiAlert = allow;
}

//================================================================================
//
//================================================================================
+ (BOOL)isAllowMultiAlert
{
    return allowMultiAlert;
}

//================================================================================
//
//================================================================================
+ (BOOL)canAlert
{
    BOOL result = [PPAlertController isAllowMultiAlert];
    
    if(result==NO)
    {
        result = YES;
        
        NSArray *windows = [UIApplication sharedApplication].windows;
        
        for(UIWindow *window in windows)
        {
            NSArray *subviews = window.subviews;
            
            for(UIView *subview in subviews)
            {
                if([subview isKindOfClass:[UIAlertView class]]==YES)
                {
                    if(((UIAlertView *)subview).isVisible==YES)
                    {
                        result = NO;
                        break;
                    }
                }
            }
            
            if(result==NO)
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(instanceCount>0)
        {
            result = NO;
        }
    }
    
    return result;
}


//================================================================================
//
//================================================================================
+ (BOOL)alertController:(PPAlertController *)alertController addTextFieldHandle:(void (^)(UITextField *textField))configurationHandler ,...
{
    BOOL result = NO;
    
    do
    {
        if(alertController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        va_list arguments;
        
        va_start(arguments, configurationHandler);
      
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        for( void *subTextfield=configurationHandler; subTextfield!=nil; subTextfield=va_arg(arguments,void *))
        {
            [alertController addTextFieldWithConfigurationHandler:subTextfield];
        }
        
        va_end(arguments);
        
        
        result = YES;
        
    }while(0);
    
    
    return result;
}


//================================================================================
//
//================================================================================
+ (PPAlertController *)alertControllerWithAlertControllerStyle:(UIAlertControllerStyle)alertControllerStyle
                                                         title:(NSString *)title
                                                       message:(NSString *)message
                                              alertActionStyle:(UIAlertActionStyle)alertActionStyle
{
    PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:title
                                                                                   message:message
                                                                            preferredStyle:alertControllerStyle];
    
    do
    {
        if(ppAlertViewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        
        if(ppAlertViewController!=nil)
        {
            NSString *actionTitle = NSLocalizedString(@"MLS_OK", nil);
            
            if(alertActionStyle==UIAlertActionStyleCancel)
            {
                actionTitle = NSLocalizedString(@"MLS_Cancel", nil);
            }
            
            UIAlertAction *defaultAction = [UIAlertAction actionWithTitle:actionTitle
                                                                    style:alertActionStyle
                                                                  handler:nil];
            
            [ppAlertViewController addAction:defaultAction];
            
        }
    }while(0);
    
    
    return ppAlertViewController;
}


//================================================================================
//
//================================================================================
+ (PPAlertController *)alertControllerWithAlertControllerStyle:(UIAlertControllerStyle)alertControllerStyle
                                                         title:(NSString *)title
                                                       message:(NSString *)message
                                                   alertAction:(UIAlertAction *)alertAction, ...
{
    PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithTitle:title
                                                                                   message:message
                                                                            preferredStyle:alertControllerStyle];
    
    do
    {
        if(ppAlertViewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        
        if(ppAlertViewController!=nil)
        {
            va_list arguments;
            
            va_start(arguments, alertAction);
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            for(UIAlertAction *subAction=alertAction; subAction!=nil; subAction=va_arg(arguments, UIAlertAction *))
            {
                [ppAlertViewController addAction:subAction];
            }
            
            va_end(arguments);
        }
    }while(0);
    
    return ppAlertViewController;
}


//================================================================================
//
//================================================================================
+ (BOOL)showWithAlertControllerStyle:(UIAlertControllerStyle)alertControllerStyle
                               title:(NSString *)title
                             message:(NSString *)message
                    alertActionStyle:(UIAlertActionStyle)alertActionStyle
              showFromViewController:(UIViewController *)viewController
                            animated:(BOOL)animated;
{
    BOOL result = NO;
    
    do
    {
        if(viewController==nil ||
           [viewController respondsToSelector:@selector(presentViewController:animated:completion:)]==NO ||
           [PPAlertController canAlert]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithAlertControllerStyle:alertControllerStyle
                                                                                                        title:title
                                                                                                      message:message
                                                                                             alertActionStyle:alertActionStyle];
        
        if(ppAlertViewController!=nil)
        {
            [viewController presentViewController:ppAlertViewController animated:animated completion:nil];
            
            result = YES;
        }
 
    }while(0);
    
    return result;
}


//================================================================================
//
//================================================================================
+ (BOOL)showWithAlertControllerStyle:(UIAlertControllerStyle)alertControllerStyle
                               title:(NSString *)title
                             message:(NSString *)message
              showFromViewController:(UIViewController *)viewController
                            animated:(BOOL)animated
                         alertAction:(UIAlertAction *)alertAction, ...
{
    BOOL result = NO;
    
    do
    {
        if(viewController==nil ||
           [viewController respondsToSelector:@selector(presentViewController:animated:completion:)]==NO ||
           [PPAlertController canAlert]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        va_list arguments;
        
        va_start(arguments, alertAction);
        
        PPAlertController *ppAlertViewController = [PPAlertController alertControllerWithAlertControllerStyle:alertControllerStyle
                                                                                                        title:title
                                                                                                      message:message
                                                                                                  alertAction:alertAction
                                                                                                    arguments:arguments];
        
        va_end(arguments);
        
        if(ppAlertViewController!=nil)
        {
            [viewController presentViewController:ppAlertViewController animated:animated completion:nil];
            
            result = YES;
        }
        
    }while(0);
    
    return result;
}

@end
#endif
