//
//  AlbumCollectionViewCell.m
//
//  Created by howard.lin on 13/3/11.
//  Copyright (c) 2013年 penpower. All rights reserved.
//



#import "AlbumCollectionViewCell.h"

// Define
#import "PPAlbumContentViewController+ResourceDefine.h"
#import "PPAlbumContentViewController+ParameterDefine.h"

// View
#import "AlbumCollectionViewCell.h"

// Category
#import "UIImage+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface AlbumCollectionViewCell()

@property (nonatomic,retain) UIImageView *imageView;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AlbumCollectionViewCell

@implementation AlbumCollectionViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
  
    if (self)
    {
        _imageView = [[UIImageView alloc] init];
        
        if(_imageView!=nil)
        {
            [_imageView setContentMode:UIViewContentModeScaleAspectFit];
            [self addSubview:_imageView];
        }
    
        //////////////////////////////////////////////////

        _selectImageView = [[PPSelectImageView alloc] init];
        
        if(_selectImageView!=nil)
        {
            [self addSubview:_selectImageView];
        }
        
        //////////////////////////////////////////////////

        self.clipsToBounds = YES;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_imageView removeFromSuperview];
    [_imageView release];
    
    [_selectImageView removeFromSuperview];
    [_selectImageView release];
    
    [_cellImage release];
    _cellImage = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Touch Event;

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [super touchesBegan:touches withEvent:event];
    
    //////////////////////////////////////////////////

    if([self.delegate respondsToSelector:@selector(albumViewCollectionCellShouldTouch:)]==YES)
    {
        self.shouldSendTouchEnd = [self.delegate albumViewCollectionCellShouldTouch:self];
    }
    
    //////////////////////////////////////////////////

    if(self.shouldSendTouchEnd==YES &&
       [self.delegate respondsToSelector:@selector(albumViewCollectionCellTouchBegin:)]==YES)
    {
        [self.delegate albumViewCollectionCellTouchBegin:self];
    }
}


//================================================================================
//
//================================================================================
- (void)touchesEnded:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [super touchesEnded:touches withEvent:event];
    
    //////////////////////////////////////////////////
    
    if(self.shouldSendTouchEnd==YES &&
       [self.delegate respondsToSelector:@selector(albumViewCollectionCellTouchEnd:)]==YES)
    {
        [self.delegate albumViewCollectionCellTouchEnd:self];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - layout of subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    self.imageView.frame = self.bounds;
    
    //////////////////////////////////////////////////

    self.selectImageView.frame = CGRectMake(0, self.bounds.origin.y, self.bounds.size.width*0.2, self.bounds.size.height*0.2);
}


//================================================================================
//
//================================================================================
- (void)enable
{
    self.userInteractionEnabled = YES;
    
    self.imageView.alpha = 1;
}


//================================================================================
//
//================================================================================
- (void)disable
{
    self.userInteractionEnabled = NO;
    
    self.imageView.alpha = AlbumCollectionViewCellDisalbeAlpha;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)prepareForReuse
{
    [self.selectImageView setStatus:PPSelectStatus_Unselect];
    [self enable];
}


//================================================================================
//
//================================================================================
- (void)refresh
{
    self.imageView.image = self.cellImage;
}
@end
