//
//  PPAlbumSectionController.h
//
//  Created by Howard on 2015/2/17.
//
//

#import "PPSectionController.h"

#import <Photos/Photos.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPAlbumSectionControllerSectionTag)
{
    PPAlbumSectionControllerSectionTag_SandBox = 0,
    
    //////////////////////////////////////////////////

    PPAlbumSectionControllerSectionTag_TimeStapAlbum = 0,
    PPAlbumSectionControllerSectionTag_SystemAlbum,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPAlbumSectionController;

@protocol PPAlbumSectionControllerDelegate <NSObject>

@optional
- (void)ppAlbumSectionControllerDidFinishAlbumExtract:(PPAlbumSectionController *)ppAlbumSectionController;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPAlbumSectionController : PPSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

@property (nonatomic,assign) id<PPAlbumSectionControllerDelegate> delegate;

@property (nonatomic,copy)   NSString                             *mountSanboxDirectory;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)albumExtract;
- (void)sandBoxAlbumExtracWithDirectory:(NSString *)directory;

@end
