//
//  PPAboutViewController.m
//
//  Created by Mike Shih on 12/6/7.
//  Extracted by Andrew Lai on 14/2/5.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPAboutViewController.h"
#import "UIViewController+ShareApplication.h"
#import "PPAlertController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPAboutViewControllerGap            20
#define PPAboutViewControllerMargin         10

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPCommonFontSize                    (16)                      //顯示字形大小
#define PPLabelHeight                       (PPCommonFontSize+4)

////////////////////////////////////////////////////////////////////////////////////////////////////

static PPButton *PPAboutViewController_DefaultBackButton = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSString *PPAboutViewControllerVersionNumber     = @"Version: ";
static NSString *PPAboutViewControllerCopyright         = @"Copyright © ";
static NSString *PPAboutViewControllerCompanyName       = @"PenPower Technology Ltd.";
static NSString *PPAboutViewControllerAllRightsReserved = @"All rights reserved.";
static NSString *PPAboutViewControllerHyperLink         = @"http://www.penpowerinc.com";

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPAboutViewControllerButtonTag)
{
    PPAboutViewControllerButtonTag_None = 0,
	PPAboutViewControllerButtonTag_Back,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAboutViewController()

@interface PPAboutViewController()
@property(nonatomic,retain) PPButton            *ppButtonBack;
@property(nonatomic,retain) PPHyperLinkLabel    *ppHyperLinkLabel;
@property(nonatomic,retain) PPNavigationBarView *ppNavigationBarView;
@property(nonatomic,retain) UIImageView         *applicationIconImageView;
@property(nonatomic,retain) UILabel             *allRightsReservedLabel;
@property(nonatomic,retain) UILabel             *applicationNameLabel;
@property(nonatomic,retain) UILabel             *companyNameLabel;
@property(nonatomic,retain) UILabel             *copyrightLabel;
@property(nonatomic,retain) UILabel             *versionNumberLabel;
@property(nonatomic,retain) UILabel             *kernelNumberLabel;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPAboutViewController

@implementation PPAboutViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - synthesize

@synthesize
applicationNameLabelString  = applicationNameLabelString_,
copyrightDateString         = copyrightDateString_,
HyperLinkLabelURL           = HyperLinkLabelURL_,
HyperLinkLabelDisplayString = HyperLinkLabelDisplayString_,
ppButtonBack                = ppButtonBack_,
ppHyperLinkLabel            = ppHyperLinkLabel_,
ppNavigationBarView         = ppNavigationBarView_,
applicationIconImageView    = applicationIconImageView_,
allRightsReservedLabel      = allRightsReservedLabel_,
applicationNameLabel        = applicationNameLabel_,
companyNameLabel            = companyNameLabel_,
copyrightLabel              = copyrightLabel_,
versionNumberLabel          = versionNumberLabel_,
kernelNumberLabel           = kernelNumberLabel_;






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
// 初始化參數
//================================================================================
- (id)init
{
	if((self = [super init]))
	{
        // 定義property list 顏色參數
        NSDictionary *colorDefineDictionary = [[NSDictionary alloc] initWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"PPAboutViewControllerColor" ofType:@"plist"]];
        if(colorDefineDictionary!=nil)
        {
            [UIColor addColorPropertyFromDictionary:colorDefineDictionary];
            
            [colorDefineDictionary release];
        }
        
        applicationNameLabelString_  = nil;
        HyperLinkLabelURL_           = nil;
        HyperLinkLabelDisplayString_ = nil;
        
        _customNavigationBar = YES;
        
        _controllTitle = @"About";
	}
	
	return self;
}


//================================================================================
// 釋放物件的處理(釋放.h檔裡所宣告的物件)
//================================================================================
- (void)dealloc
{
    [self removeMainUI];
    
    [_applicationNameAttributedString release];
    _applicationNameAttributedString = nil;
    
    [applicationNameLabelString_ release];
    applicationNameLabelString_ = nil;
    
    [copyrightDateString_ release];
    copyrightDateString_ = nil;
    
    [HyperLinkLabelURL_ release];
    HyperLinkLabelURL_ = nil;
    
    [HyperLinkLabelDisplayString_ release];
    HyperLinkLabelDisplayString_ = nil;
    
    [_aboutViewControllerAllRightsReserved release];
    _aboutViewControllerAllRightsReserved = nil;
    
    [_aboutViewControllerCompanyName release];
    _aboutViewControllerCompanyName = nil;
    
    [_versionCustom release];
    _versionCustom = nil;
    
    [_kernelCustom release];
    _kernelCustom = nil;
    
    [_controllTitle release];
    _controllTitle = nil;
    
    [_navigationTitleColor release];
    _navigationTitleColor = nil;
    
    self.logoImageName = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
// View要呈現前即被呼叫
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
	
    //////////////////////////////////////////////////
    
    UIColor *backgroundColor = [UIColor colorForKey:@"PPAboutViewController_Background"];
    if(backgroundColor==nil)
    {
        backgroundColor = [UIColor whiteColor];
    }
    
    self.view.backgroundColor = backgroundColor;
    

    //////////////////////////////////////////////////
    [self prepareMainUI];
}


//================================================================================
// View要關閉前即被呼叫
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
	[super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    //////////////////////////////////////////////////
    //使用客製化導航列覆蓋原始整列
    
    if(self.customNavigationBar==YES &&
       self.navigationController!=nil)
    {
        PPNavigationBarView *ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
        if(ppNavigationBarView!=nil)
        {
            ppNavigationBarView.style           = PPBarViewStyle_CenteredAbsolute;
            ppNavigationBarView.tintColor       = self.navigationController.navigationBar.tintColor;
            ppNavigationBarView.titleLabel.text = self.controllTitle;
            
            if (self.navigationTitleColor)
            {
                [ppNavigationBarView.titleLabel setTextColor:self.navigationTitleColor];
            }
            
            //////////////////////////////////////////////////
            
            if (self.splitViewController==nil)
            {
                //////////////////////////////////////////////////
                // Get buttonClose by delegate or default, if not respond to delegate.
                
                if (PPAboutViewController_DefaultBackButton!=nil)
                {
                    self.ppButtonBack = PPAboutViewController_DefaultBackButton;
                }
                else
                {
                    PPButton *ppButtonBack = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
                    if( ppButtonBack != nil)
                    {
                        self.ppButtonBack = ppButtonBack;
                        [self.ppButtonBack setBackgroundImageWithName:ImageNamePPButtonBackgroundForBack];
                        [self.ppButtonBack setTitle:NSLocalizedStringFromTable(@"MLS_Back", NSStringFromClass(self.ppButtonBack.class), nil) maxWidth:0];
                        [ppButtonBack release];
                    }
                }
                
                if(self.ppButtonBack != nil)
                {
                    [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
                    self.ppButtonBack.delegate    = self;
                    self.ppButtonBack.tag         = PPAboutViewControllerButtonTag_Back;
                    [ppNavigationBarView setViews:@[self.ppButtonBack]
                                     forBlockType:PPBarViewBlockType_Left];
                }
            }
            
            [ppNavigationBarView layoutSubviews];
            
            //////////////////////////////////////////////////
            
            UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:ppNavigationBarView];
            if(leftBarButtonItem!=nil)
            {
                self.navigationItem.leftBarButtonItem = leftBarButtonItem;
                [leftBarButtonItem release];
            }
            
            self.ppNavigationBarView = ppNavigationBarView;
            [ppNavigationBarView release];
        }
    }
    else
    {
        self.title = self.controllTitle;
    }
    
    //////////////////////////////////////////////////
    UIImageView *applicationIconImageView = [[UIImageView alloc] init];
    
    if(applicationIconImageView!=nil)
    {
        if(self.logoImageName.length>0)
        {
            UIImage *logoImage = [UIImage imageWithName:self.logoImageName];
            
            //////////////////////////////////////////////////

            if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
            {
                applicationIconImageView.image = [logoImage imageScalingMaxLength:76];
            }
            else
            {
                applicationIconImageView.image = [logoImage imageScalingMaxLength:60];
            }
        }
        else
        {
            if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
            {
                if ([[[UIDevice currentDevice] systemVersion] floatValue]<=7.0)
                {
                    applicationIconImageView.image = [UIImage imageWithName:PPFileNameAboutViewControllerForIOS6iPad];
                }
                else
                {
                    applicationIconImageView.image = [UIImage imageWithName:PPFileNameAboutViewControllerForIOS7iPad];
                }
            }
            else
            {
                if ([[[UIDevice currentDevice] systemVersion] floatValue]<=7.0)
                {
                    applicationIconImageView.image = [UIImage imageWithName:PPFileNameAboutViewControllerForIOS6iPhone];
                }
                else
                {
                    applicationIconImageView.image = [UIImage imageWithName:PPFileNameAboutViewControllerForIOS7iPhone];
                }
            }
        }
        
        
        applicationIconImageView.bounds = CGRectMake(0, 0, applicationIconImageView.image.size.width, applicationIconImageView.image.size.height);
        
        [applicationIconImageView setCornerRadius:5];
        
        self.applicationIconImageView = applicationIconImageView;
        [applicationIconImageView release];
        
        [self.view addSubview:self.applicationIconImageView];
    }
    
    //////////////////////////////////////////////////
    
    UIColor *labelTextColor = [UIColor colorForKey:@"PPAboutViewController_LabelText"];
    if(labelTextColor==nil)
    {
        labelTextColor = [UIColor blackColor];
    }
    
    UILabel *applicationNameLabel = [[UILabel alloc] init];
    if(applicationNameLabel!=nil)
    {
        if(self.applicationNameAttributedString==nil)
        {
            if (self.applicationNameLabelString==nil)
            {
                applicationNameLabel.text = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleDisplayName"];
            }
            else
            {
                applicationNameLabel.text = self.applicationNameLabelString;
            }
        }
        else
        {
            applicationNameLabel.attributedText = self.applicationNameAttributedString;            
        }
        
        
        applicationNameLabel.backgroundColor   = [UIColor clearColor];
        applicationNameLabel.textAlignment     = NSTextAlignmentCenter;
        applicationNameLabel.textColor         = labelTextColor;
        
        self.applicationNameLabel = applicationNameLabel;
        [applicationNameLabel release];
        
        [self.view addSubview:self.applicationNameLabel];
    }
    
    //////////////////////////////////////////////////
    
    UILabel *versionNumberLabel = [[UILabel alloc] init];
    if(versionNumberLabel!=nil)
    {
        versionNumberLabel.backgroundColor = [UIColor clearColor];
        
        NSString *version = nil;
        if (self.versionCustom==nil)
        {
            version = [PPAboutViewControllerVersionNumber stringByAppendingString:[[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleShortVersionString"]];
            version = [version stringByAppendingString:[NSString stringWithFormat:@" (%@)", [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleVersion"]]];
        }
        else
        {
            version = self.versionCustom;
        }
        
        versionNumberLabel.text			   = version;
        
        versionNumberLabel.textAlignment   = NSTextAlignmentCenter;
        versionNumberLabel.textColor       = labelTextColor;
        
        self.versionNumberLabel = versionNumberLabel;
        [versionNumberLabel release];
        
        [self.view addSubview:self.versionNumberLabel];
    }
    
    //////////////////////////////////////////////////
    
    if (self.kernelCustom!=nil)
    {
        UILabel *kernelNumberLabel = [[UILabel alloc] init];
        if(kernelNumberLabel!=nil)
        {
            kernelNumberLabel.backgroundColor = [UIColor clearColor];
            kernelNumberLabel.text			  = self.kernelCustom;
            
            kernelNumberLabel.textAlignment   = NSTextAlignmentCenter;
            kernelNumberLabel.textColor       = labelTextColor;
            
            self.kernelNumberLabel = kernelNumberLabel;
            [kernelNumberLabel release];
            
            [self.view addSubview:self.kernelNumberLabel];
        }
    }
    
    //////////////////////////////////////////////////
    
    UILabel *copyrightLabel = [[UILabel alloc] init];
    if(copyrightLabel!=nil)
    {
        copyrightLabel.backgroundColor = [UIColor clearColor];
        copyrightLabel.text            = [PPAboutViewControllerCopyright stringByAppendingString:(self.copyrightDateString==nil?@"":self.copyrightDateString)];
        copyrightLabel.textAlignment   = NSTextAlignmentCenter;
        copyrightLabel.textColor       = labelTextColor;
        
        self.copyrightLabel = copyrightLabel;
        [copyrightLabel release];
        
        [self.view addSubview:self.copyrightLabel];
    }
    
    //////////////////////////////////////////////////
    
    UILabel *companyNameLabel = [[UILabel alloc] init];
    if(companyNameLabel!=nil)
    {
        companyNameLabel.backgroundColor = [UIColor clearColor];
        
        if(self.aboutViewControllerCompanyName!=nil)
        {
            companyNameLabel.text = self.aboutViewControllerCompanyName;
        }
        else
        {
            companyNameLabel.text = PPAboutViewControllerCompanyName;
        }
        
        companyNameLabel.textAlignment   = NSTextAlignmentCenter;
        companyNameLabel.textColor       = labelTextColor;
        
        self.companyNameLabel = companyNameLabel;
        [companyNameLabel release];
        
        [self.view addSubview:self.companyNameLabel];
    }
    
    //////////////////////////////////////////////////
    
    UILabel *allRightsReservedLabel = [[UILabel alloc] init];
    if(allRightsReservedLabel!=nil)
    {
        allRightsReservedLabel.backgroundColor = [UIColor clearColor];
        
        if(self.aboutViewControllerAllRightsReserved!=nil)
        {
            allRightsReservedLabel.text = self.aboutViewControllerAllRightsReserved;
        }
        else
        {
            allRightsReservedLabel.text = PPAboutViewControllerAllRightsReserved;
        }
        
        allRightsReservedLabel.textAlignment   = NSTextAlignmentCenter;
        allRightsReservedLabel.textColor       = labelTextColor;
        
        self.allRightsReservedLabel = allRightsReservedLabel;
        [allRightsReservedLabel release];
        
        [self.view addSubview:self.allRightsReservedLabel];
    }
    
    //////////////////////////////////////////////////
    
    PPHyperLinkLabel *ppHyperLinkLabel = [[PPHyperLinkLabel alloc] init];
    if(ppHyperLinkLabel!=nil)
    {
        ppHyperLinkLabel.backgroundColor = [UIColor clearColor];
        ppHyperLinkLabel.delegate        = self;
        
        if (self.HyperLinkLabelURL==nil)
        {
            ppHyperLinkLabel.link = PPAboutViewControllerHyperLink;
        }
        else
        {
            ppHyperLinkLabel.link = self.HyperLinkLabelURL;
        }
        
        if (self.HyperLinkLabelDisplayString==nil)
        {
            NSURL *url = [NSURL URLWithString:ppHyperLinkLabel.link];
            NSString *subString = [NSString stringWithString:[ppHyperLinkLabel.link substringFromIndex:[url scheme].length+3]];//+3除去://
            ppHyperLinkLabel.text = subString;
        }
        else
        {
            ppHyperLinkLabel.text = self.HyperLinkLabelDisplayString;
        }
        
        ppHyperLinkLabel.textAlignment   = NSTextAlignmentCenter;
        ppHyperLinkLabel.textColor		 = [UIColor colorForKey:DefaultColor_HyperLink];
        
        self.ppHyperLinkLabel = ppHyperLinkLabel;
        [ppHyperLinkLabel release];
        
        [self.view addSubview:self.ppHyperLinkLabel];
    }
    //////////////////////////////////////////////////
    [self addTripleTapGestureRecognierToView:self.applicationIconImageView];
    [self addTripleTapGestureRecognierToView:self.versionNumberLabel];

}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeTripleTapTapGestureRecognierFromView:self.applicationIconImageView];
    [self removeTripleTapTapGestureRecognierFromView:self.versionNumberLabel];
    
    [self.applicationIconImageView removeFromSuperview];
    self.applicationIconImageView = nil;
    
    [self.applicationNameLabel removeFromSuperview];
    self.applicationNameLabel = nil;
    
    [self.versionNumberLabel removeFromSuperview];
    self.versionNumberLabel = nil;
    
    [self.kernelNumberLabel removeFromSuperview];
    self.kernelNumberLabel = nil;
    
    [self.copyrightLabel removeFromSuperview];
    self.copyrightLabel = nil;
    
    [self.companyNameLabel removeFromSuperview];
    self.companyNameLabel = nil;
    
    [self.allRightsReservedLabel removeFromSuperview];
    self.allRightsReservedLabel = nil;
    
    [self.ppHyperLinkLabel removeFromSuperview];
    self.ppHyperLinkLabel = nil;
    
    //////////////////////////////////////////////////
    
    if(self.navigationItem!=nil)
    {
        self.navigationItem.leftBarButtonItem = nil;
    }
    
    //////////////////////////////////////////////////
    
    self.ppNavigationBarView    = nil;
    self.ppButtonBack           = nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method Override

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect layoutFrame = [self layoutFrame];
    
    //////////////////////////////////////////////////
    
	CGFloat viewOffsetTopY = (layoutFrame.size.height-(self.applicationIconImageView.bounds.size.height+PPAboutViewControllerMargin)-(PPLabelHeight*6+PPAboutViewControllerMargin*5))/2+layoutFrame.origin.y;
    
	self.applicationIconImageView.frame = CGRectMake((self.view.frame.size.width-self.applicationIconImageView.bounds.size.width)/2, viewOffsetTopY, self.applicationIconImageView.bounds.size.width, self.applicationIconImageView.bounds.size.height);
	viewOffsetTopY += self.applicationIconImageView.bounds.size.height+PPAboutViewControllerMargin;
	
	self.applicationNameLabel.frame = CGRectMake(0, viewOffsetTopY, self.view.frame.size.width, PPLabelHeight);
	viewOffsetTopY += PPLabelHeight+PPAboutViewControllerMargin;
	
	self.versionNumberLabel.frame = CGRectMake(0, viewOffsetTopY, self.view.frame.size.width, PPLabelHeight);
	viewOffsetTopY += PPLabelHeight+PPAboutViewControllerMargin;
    
    if (self.kernelNumberLabel!=nil)
    {
        self.kernelNumberLabel.frame = CGRectMake(0, viewOffsetTopY, self.view.frame.size.width, PPLabelHeight);
        viewOffsetTopY += PPLabelHeight+PPAboutViewControllerMargin;
    }
	
	self.copyrightLabel.frame = CGRectMake(0, viewOffsetTopY, self.view.frame.size.width, PPLabelHeight);
	viewOffsetTopY += PPLabelHeight+PPAboutViewControllerMargin;
	
	self.companyNameLabel.frame = CGRectMake(0, viewOffsetTopY, self.view.frame.size.width, PPLabelHeight);
	viewOffsetTopY += PPLabelHeight+PPAboutViewControllerMargin;
	
	self.allRightsReservedLabel.frame = CGRectMake(0, viewOffsetTopY, self.view.frame.size.width, PPLabelHeight);
	viewOffsetTopY += PPLabelHeight+PPAboutViewControllerMargin;
    
    self.ppHyperLinkLabel.frame = CGRectMake(0, viewOffsetTopY, self.view.frame.size.width, PPLabelHeight);
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - gesture


//==============================================================================
//
//==============================================================================
- (void)addTripleTapGestureRecognierToView:(UIView*)view
{
    UITapGestureRecognizer *tapGestureRecognier = [[UITapGestureRecognizer alloc] init];
    if (tapGestureRecognier)
    {
        [tapGestureRecognier setNumberOfTapsRequired:3];
        [tapGestureRecognier addTarget:self action:@selector(onTripleTapRecognier:)];
        [view setUserInteractionEnabled:YES];
        [view addGestureRecognizer:tapGestureRecognier];
        [tapGestureRecognier release];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeTripleTapTapGestureRecognierFromView:(UIView*)view
{
    NSArray *gestureRecognizers = view.gestureRecognizers;
    for (UIGestureRecognizer *gestureRecognizer in gestureRecognizers)
    {
        [view removeGestureRecognizer:gestureRecognizer];
    }
}


//==============================================================================
//
//==============================================================================
- (void)onTripleTapRecognier:(UITapGestureRecognizer *)tapGestureRecognier
{
    if (tapGestureRecognier.view==self.applicationIconImageView)
    {
        if ([self.delegate respondsToSelector:@selector(didTripleTapApplicationIconWithAboutViewController:)])
        {
            [self.delegate didTripleTapApplicationIconWithAboutViewController:self];
        }

    }
    else if(tapGestureRecognier.view==self.versionNumberLabel)
    {
        if ([self.delegate respondsToSelector:@selector(didTripleTapVersionLabelWithAboutViewController:)])
        {
            [self.delegate didTripleTapVersionLabelWithAboutViewController:self];
        }
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Methods

//================================================================================
// PPButton Events
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
	switch(ppButton.tag)
	{
        case PPAboutViewControllerButtonTag_Back:
		default:
        {
            [self goBackAnimated:YES];
			
			break;
		}
	}
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPHyperLinkLabelDelegate

//================================================================================
//
//================================================================================
- (void)ppHyperLinkLabel:(PPHyperLinkLabel *)ppHyperLinkLabel action:(PPHyperLinkLabelAction)action
{
    switch(action)
    {
        case PPHyperLinkLabelAction_TouchUpInside:
        default:
        {
            if([[UIApplication sharedApplication] openURL:[NSURL URLWithString:ppHyperLinkLabel.link]]==NO)
            {
                [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                          title:@""
                                                        message:NSLocalizedString(@"MLS_FailedToOpenWebsite", nil)
                                               alertActionStyle:UIAlertActionStyleDefault
                                         showFromViewController:self
                                                       animated:YES];
            }
            
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (void)setDefaultBackButton:(PPButton *)backButton
{
    [PPAboutViewController_DefaultBackButton release];
    PPAboutViewController_DefaultBackButton = [backButton retain];
}

@end
