//
//  PPMicrosoftLoginViewController.m
//
//
//  Created by Howard on 2019/6/25.
//

#import "PPMicrosoftLoginViewController.h"

#import "NSError+Custom.h"

// View
#import "PPMicrosoftLoginView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface

@interface PPMicrosoftLoginViewController()


@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation

@implementation PPMicrosoftLoginViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.clientID = nil;
    self.redirectURL = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - view controller life cycle

//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    // 建立 Login View
    self.loginView = [[[PPMicrosoftLoginView alloc] init] autorelease];

    self.loginView.enableShouldReloadPage = self.isLaunchPage;
    //////////////////////////////////////////////////

    // 呼叫父類別 
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    if([self.loginView isKindOfClass:[PPMicrosoftLoginView class]]==YES)
    {
        PPMicrosoftLoginView *microsoftLoginView = (PPMicrosoftLoginView *)self.loginView;
        
        //////////////////////////////////////////////////

        [microsoftLoginView showAuthFlowFromClientID:self.clientID secretID:self.secretID redirectURL:self.redirectURL completion:^(id object, NSError *returnError) {
            
            NSMutableDictionary *infos = [NSMutableDictionary dictionary];
            
            if(object!=nil)
            {
                [infos  setObject:object forKey:NSStringFromClass([NSDictionary class])];
            }
            
            if(returnError!=nil)
            {
                [infos  setObject:returnError forKey:NSStringFromClass([returnError class])];
            }
            
            [self performSelectorOnMainThread:@selector(sendMainthreadCompletionWithInfos:)
                                   withObject:infos
                                waitUntilDone:NO];
        }];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)sendMainthreadCompletionWithInfos:(NSDictionary *)infos
{
    NSError *returnError = [infos objectForKey:NSStringFromClass([NSError class])];
    id object = [infos objectForKey:NSStringFromClass([NSDictionary class])];
    
    if (self.isLaunchPage==YES)
    {
        // !! 如果是App進入頁，有錯誤不能關閉view controller
        // error要顯示
        if(returnError==nil)
        {
            if(self.loginCompletion!=nil)
            {
                self.loginCompletion(object,returnError);
            }
        }
        else
        {
            [self showRetryAlertWithError:returnError];
        }
    }
    else
    {
        if(self.loginCompletion!=nil)
        {
            self.loginCompletion(object,returnError);
        }
        
        // 關閉view controller
        [self goBackAnimated:YES];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)showRetryAlertWithError:(NSError *)error
{
    // !!cancel不用顯示，只要reload
    if (error.code==NSErrorCustom_Code_OperationCancel)
    {
        [self reloadWebView];
    }
    else
    {
        [super showRetryAlertWithError:error];
    }
}


@end
