//
//  PPWeChatLoginView.m
//
//
//  Created by Howard on 2019/6/10.
//

#import "PPWeChatLoginView.h"

static NSString *  const PPWeChatLoginViewAPI_OAuth = @"https://open.weixin.qq.com/connect/qrconnect";

static NSString *  const PPWeChatLoginViewAPI_RedirectURL = @"https://open.weixin.qq.com/connect/qrconnect";

static NSString *  const PPWeChatLoginViewAPI_AccessToken = @"https://api.weixin.qq.com/sns/oauth2/access_token";

static NSString *  const PPWeChatLoginViewAPI_LoginUser = @"https://api.weixin.qq.com/sns/userinfo";



@implementation PPWeChatLoginView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Override Method

//================================================================================
//
//================================================================================
- (BOOL)isRedirectURL:(NSString *)requestUrlString
{
    return [[requestUrlString lowercaseString] hasPrefix:[PPWeChatLoginViewAPI_RedirectURL lowercaseString]];
}


//================================================================================
//
//================================================================================
- (void)handleUserAgentResponse:(NSURL *)url
{
    id object = nil;
    NSError *returnError = nil;
    
    do
    {
        // 取得 accessToken
        NSRange range = [[url absoluteString] rangeOfString:@"code="];
        NSString *code = [[url absoluteString] substringFromIndex:range.location+range.length];
        
        NSString *requestTokenString = [NSString stringWithFormat:@"%@?appid=%@&secret=%@&code=%@&grant_type=authorization_code",PPWeChatLoginViewAPI_AccessToken,self.clientID,self.secretID,code];
        
        //////////////////////////////////////////////////
        
//   GET     https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code
        
        NSURLResponse *response = nil;
        
        NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:requestTokenString]];
        
        [urlRequest setHTTPMethod:@"GET"];
        
        NSData *downloadedData = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
        
        object = [NSJSONSerialization JSONObjectWithData:downloadedData options:NSJSONReadingMutableLeaves error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
        
        NSString *accessToken = [object objectForKey:@"access_token"];
        NSString *refreshToken = [object objectForKey:@"refresh_token"];
        NSString *openID = [object objectForKey:@"openid"];
        
        //////////////////////////////////////////////////
        
      //   GET     https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID
        
        NSString *requestAccountString = [NSString stringWithFormat:@"%@&access_token=%@&openid=%@",PPWeChatLoginViewAPI_LoginUser,accessToken,openID];
        
        urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:requestAccountString]];
        
        [urlRequest setHTTPMethod:@"GET"];
        
        downloadedData = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
        
        object = [NSJSONSerialization JSONObjectWithData:downloadedData options:NSJSONReadingMutableLeaves error:&returnError];
        
        //////////////////////////////////////////////////
        
        // add accessToken
        if([object isKindOfClass:[NSDictionary class]]==YES)
        {
            object = [NSMutableDictionary dictionaryWithDictionary:object];
            
            [object setObject:([accessToken length]>0)?accessToken:[NSNull null]
                       forKey:@"accessToken"];
            
            [object setObject:([refreshToken length]>0)?accessToken:[NSNull null]
                       forKey:@"refreshToken"];
            
            [object setObject:([openID length]>0)?accessToken:[NSNull null]
                       forKey:@"openID"];
        }
    }
    while (0);
    
    if(self.authCompletion!=nil)
    {
        self.authCompletion(object,returnError);
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showAuthFlowFromClientID:(NSString *)clientID
                        secretID:(NSString *)secretID
                      completion:(AuthCompletion)completion;
{
    NSURLRequest *request = [NSURLRequest requestWithURL:[NSURL URLWithString:[NSString stringWithFormat:@"%@?appid=%@&redirect_uri=%@&response_type=code&scope=snsapi_login&state=STATE#wechat_redirect",PPWeChatLoginViewAPI_OAuth,clientID,PPWeChatLoginViewAPI_RedirectURL]]];
    
    //////////////////////////////////////////////////

    [super showAuthFlowFromRequest:request
                          clientID:clientID
                          secretID:secretID
                        completion:completion];
    
}
@end
