//
//  PPFBLoginView.m
//
//
//  Created by Howard on 2019/6/5.
//

#import "PPFBLoginView.h"

#import "NSError+Custom.h"

static NSString *  const PPFBLoginViewAPI_RedirectURL = @"https://www.facebook.com/connect/login_success.html";
static NSString *  const PPFBLoginViewAPI_OAuth = @"https://www.facebook.com/v3.3/dialog/oauth";
static NSString *  const PPFBLoginViewAPI_AccessToken = @"https://graph.facebook.com/v3.3/oauth/access_token";
static NSString *  const PPFBLoginViewAPI_LoginUser = @"https://graph.facebook.com/v3.3/me?fields=email,id,name";





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation

@implementation PPFBLoginView


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Override Method

//================================================================================
//
//================================================================================
- (BOOL)isRedirectURL:(NSString *)requestUrlString
{
    return [[requestUrlString lowercaseString] hasPrefix:[PPFBLoginViewAPI_RedirectURL lowercaseString]];
}


//================================================================================
//
//================================================================================
- (void)handleUserAgentResponse:(NSURL *)url
{
    id object = nil;
    NSError *returnError = nil;
    
    do
    {
        // 取得 accessToken
        NSRange range = [[url absoluteString] rangeOfString:@"code="];
        NSString *code = [[url absoluteString] substringFromIndex:range.location+range.length];
        
        NSString *requestTokenString = [NSString stringWithFormat:@"%@?client_id=%@&redirect_uri=%@&client_secret=%@&code=%@",PPFBLoginViewAPI_AccessToken,self.clientID,PPFBLoginViewAPI_RedirectURL,self.secretID,code];
        
        //////////////////////////////////////////////////
        
        //    GET https://graph.facebook.com/v3.3/oauth/access_token?
        //    client_id={app-id}
        //    &redirect_uri={redirect-uri}
        //    &client_secret={app-secret}
        //    &code={code-parameter}
        
        NSURLResponse *response = nil;
      
        NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:requestTokenString]];
        
        [urlRequest setHTTPMethod:@"GET"];
        
        NSData *downloadedData = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
        
        object = [NSJSONSerialization JSONObjectWithData:downloadedData options:NSJSONReadingMutableLeaves error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
    
        NSString *accessToken = [object objectForKey:@"access_token"];
        
        //////////////////////////////////////////////////
        
        //    GET graph.facebook.com/debug_token?
        //    input_token={token-to-inspect}
        //    &access_token={app-token-or-admin-token}
        
        NSString *requestAccountString = [NSString stringWithFormat:@"%@&access_token=%@",PPFBLoginViewAPI_LoginUser,accessToken];
        
        urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:requestAccountString]];
        
        [urlRequest setHTTPMethod:@"GET"];
        
        downloadedData = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
        
        object = [NSJSONSerialization JSONObjectWithData:downloadedData options:NSJSONReadingMutableLeaves error:&returnError];
        
        //////////////////////////////////////////////////

        // add accessToken
        if([object isKindOfClass:[NSDictionary class]]==YES)
        {
            object = [NSMutableDictionary dictionaryWithDictionary:object];
            
            [object setObject:accessToken forKey:@"accessToken"];
        }
    }
    while (0);
   
    if(self.authCompletion!=nil)
    {
        self.authCompletion(object,returnError);
        
        // !! Howard, FB 會在視窗強制關閉時，在送出一個Error, 不過此時登入資料已成功取得，所以 callbak = nil
        
        self.authCompletion = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showAuthFlowFromClientID:(NSString *)clientID
                        secretID:(NSString *)secretID
                      completion:(AuthCompletion)completion;
{
    NSAssert([secretID length]>0, @"secretID length is zero");
    
    NSURLRequest *request = [NSURLRequest requestWithURL:[NSURL URLWithString:[NSString stringWithFormat:@"%@?client_id=%@&redirect_uri=%@&scope=public_profile,email",PPFBLoginViewAPI_OAuth,clientID,PPFBLoginViewAPI_RedirectURL]]];
    
    //////////////////////////////////////////////////

    [super showAuthFlowFromRequest:request
                          clientID:clientID
                          secretID:secretID
                        completion:completion];
}

@end
