///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBTasks.h"

@class DBASYNCLaunchEmptyResult;
@class DBASYNCLaunchResultBase;
@class DBASYNCPollError;
@class DBFILESLookupError;
@class DBNilObject;
@class DBSHARINGAccessInheritance;
@class DBSHARINGAccessLevel;
@class DBSHARINGAclUpdatePolicy;
@class DBSHARINGAddFileMemberError;
@class DBSHARINGAddFolderMemberError;
@class DBSHARINGAddMember;
@class DBSHARINGAddMemberSelectorError;
@class DBSHARINGCreateSharedLinkError;
@class DBSHARINGCreateSharedLinkWithSettingsError;
@class DBSHARINGExpectedSharedContentLinkMetadata;
@class DBSHARINGFileAction;
@class DBSHARINGFileMemberActionError;
@class DBSHARINGFileMemberActionIndividualResult;
@class DBSHARINGFileMemberActionResult;
@class DBSHARINGFileMemberRemoveActionResult;
@class DBSHARINGFilePermission;
@class DBSHARINGFolderAction;
@class DBSHARINGFolderPermission;
@class DBSHARINGFolderPolicy;
@class DBSHARINGGetFileMetadataBatchResult;
@class DBSHARINGGetFileMetadataError;
@class DBSHARINGGetFileMetadataIndividualResult;
@class DBSHARINGGetSharedLinkFileError;
@class DBSHARINGGetSharedLinksError;
@class DBSHARINGGetSharedLinksResult;
@class DBSHARINGGroupMembershipInfo;
@class DBSHARINGInsufficientQuotaAmounts;
@class DBSHARINGInviteeMembershipInfo;
@class DBSHARINGJobError;
@class DBSHARINGJobStatus;
@class DBSHARINGLinkAudience;
@class DBSHARINGLinkExpiry;
@class DBSHARINGLinkMetadata;
@class DBSHARINGLinkPassword;
@class DBSHARINGLinkPermissions;
@class DBSHARINGLinkSettings;
@class DBSHARINGListFileMembersBatchResult;
@class DBSHARINGListFileMembersContinueError;
@class DBSHARINGListFileMembersError;
@class DBSHARINGListFileMembersIndividualResult;
@class DBSHARINGListFilesContinueError;
@class DBSHARINGListFilesResult;
@class DBSHARINGListFolderMembersContinueError;
@class DBSHARINGListFoldersContinueError;
@class DBSHARINGListFoldersResult;
@class DBSHARINGListSharedLinksError;
@class DBSHARINGListSharedLinksResult;
@class DBSHARINGMemberAccessLevelResult;
@class DBSHARINGMemberAction;
@class DBSHARINGMemberPolicy;
@class DBSHARINGMemberSelector;
@class DBSHARINGModifySharedLinkSettingsError;
@class DBSHARINGMountFolderError;
@class DBSHARINGParentFolderAccessInfo;
@class DBSHARINGPathLinkMetadata;
@class DBSHARINGPendingUploadMode;
@class DBSHARINGRelinquishFileMembershipError;
@class DBSHARINGRelinquishFolderMembershipError;
@class DBSHARINGRemoveFileMemberError;
@class DBSHARINGRemoveFolderMemberError;
@class DBSHARINGRemoveMemberJobStatus;
@class DBSHARINGRequestedLinkAccessLevel;
@class DBSHARINGRequestedVisibility;
@class DBSHARINGRevokeSharedLinkError;
@class DBSHARINGSetAccessInheritanceError;
@class DBSHARINGShareFolderError;
@class DBSHARINGShareFolderJobStatus;
@class DBSHARINGShareFolderLaunch;
@class DBSHARINGSharePathError;
@class DBSHARINGSharedContentLinkMetadata;
@class DBSHARINGSharedFileMembers;
@class DBSHARINGSharedFileMetadata;
@class DBSHARINGSharedFolderAccessError;
@class DBSHARINGSharedFolderMemberError;
@class DBSHARINGSharedFolderMembers;
@class DBSHARINGSharedFolderMetadata;
@class DBSHARINGSharedLinkAlreadyExistsMetadata;
@class DBSHARINGSharedLinkError;
@class DBSHARINGSharedLinkMetadata;
@class DBSHARINGSharedLinkPolicy;
@class DBSHARINGSharedLinkSettings;
@class DBSHARINGSharedLinkSettingsError;
@class DBSHARINGSharingFileAccessError;
@class DBSHARINGSharingUserError;
@class DBSHARINGTeamMemberInfo;
@class DBSHARINGTransferFolderError;
@class DBSHARINGUnmountFolderError;
@class DBSHARINGUnshareFileError;
@class DBSHARINGUnshareFolderError;
@class DBSHARINGUpdateFolderMemberError;
@class DBSHARINGUpdateFolderPolicyError;
@class DBSHARINGUserFileMembershipInfo;
@class DBSHARINGUserMembershipInfo;
@class DBSHARINGViewerInfoPolicy;
@class DBSHARINGVisibility;
@class DBUSERSTeam;

@protocol DBTransportClient;

///
/// Routes for the `Sharing` namespace
///

NS_ASSUME_NONNULL_BEGIN

@interface DBSHARINGUserAuthRoutes : NSObject

/// An instance of the networking client that each route will use to submit a
/// request.
@property (nonatomic, readonly) id<DBTransportClient> client;

/// Initializes the `DBSHARINGUserAuthRoutes` namespace container object with a
/// networking client.
- (instancetype)init:(id<DBTransportClient>)client;

///
/// Adds specified members to a file.
///
/// @param file File to which to add members.
/// @param members Members to add. Note that even an email address is given, this may result in a user being directy
/// added to the membership if that email is the user's main account email.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBSHARINGFileMemberActionResult *>` object
/// on success or a `DBSHARINGAddFileMemberError` object on failure.
///
- (DBRpcTask<NSArray<DBSHARINGFileMemberActionResult *> *, DBSHARINGAddFileMemberError *> *)
addFileMember:(NSString *)file
      members:(NSArray<DBSHARINGMemberSelector *> *)members;

///
/// Adds specified members to a file.
///
/// @param file File to which to add members.
/// @param members Members to add. Note that even an email address is given, this may result in a user being directy
/// added to the membership if that email is the user's main account email.
/// @param customMessage Message to send to added members in their invitation.
/// @param quiet Whether added members should be notified via device notifications of their invitation.
/// @param accessLevel AccessLevel union object, describing what access level we want to give new members.
/// @param addMessageAsComment If the custom message should be added as a comment on the file.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBSHARINGFileMemberActionResult *>` object
/// on success or a `DBSHARINGAddFileMemberError` object on failure.
///
- (DBRpcTask<NSArray<DBSHARINGFileMemberActionResult *> *, DBSHARINGAddFileMemberError *> *)
      addFileMember:(NSString *)file
            members:(NSArray<DBSHARINGMemberSelector *> *)members
      customMessage:(nullable NSString *)customMessage
              quiet:(nullable NSNumber *)quiet
        accessLevel:(nullable DBSHARINGAccessLevel *)accessLevel
addMessageAsComment:(nullable NSNumber *)addMessageAsComment;

///
/// Allows an owner or editor (if the ACL update policy allows) of a shared folder to add another member. For the new
/// member to get access to all the functionality for this folder, you will need to call `mountFolder` on their behalf.
///
/// @param sharedFolderId The ID for the shared folder.
/// @param members The intended list of members to add.  Added members will receive invites to join the shared folder.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBSHARINGAddFolderMemberError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBSHARINGAddFolderMemberError *> *)addFolderMember:(NSString *)sharedFolderId
                                                                       members:(NSArray<DBSHARINGAddMember *> *)members;

///
/// Allows an owner or editor (if the ACL update policy allows) of a shared folder to add another member. For the new
/// member to get access to all the functionality for this folder, you will need to call `mountFolder` on their behalf.
///
/// @param sharedFolderId The ID for the shared folder.
/// @param members The intended list of members to add.  Added members will receive invites to join the shared folder.
/// @param quiet Whether added members should be notified via email and device notifications of their invite.
/// @param customMessage Optional message to display to added members in their invitation.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBSHARINGAddFolderMemberError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBSHARINGAddFolderMemberError *> *)addFolderMember:(NSString *)sharedFolderId
                                                                       members:(NSArray<DBSHARINGAddMember *> *)members
                                                                         quiet:(nullable NSNumber *)quiet
                                                                 customMessage:(nullable NSString *)customMessage;

///
/// DEPRECATED: Identical to update_file_member but with less information returned.
///
/// @param file File for which we are changing a member's access.
/// @param member The member whose access we are changing.
/// @param accessLevel The new access level for the member.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGFileMemberActionResult` object on success
/// or a `DBSHARINGFileMemberActionError` object on failure.
///
- (DBRpcTask<DBSHARINGFileMemberActionResult *, DBSHARINGFileMemberActionError *> *)
changeFileMemberAccess:(NSString *)file
                member:(DBSHARINGMemberSelector *)member
           accessLevel:(DBSHARINGAccessLevel *)accessLevel
    __deprecated_msg("changeFileMemberAccess is deprecated. Use updateFileMember.");

///
/// Returns the status of an asynchronous job.
///
/// @param asyncJobId Id of the asynchronous job. This is the value of a response returned from the method that launched
/// the job.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGJobStatus` object on success or a
/// `DBASYNCPollError` object on failure.
///
- (DBRpcTask<DBSHARINGJobStatus *, DBASYNCPollError *> *)checkJobStatus:(NSString *)asyncJobId;

///
/// Returns the status of an asynchronous job for sharing a folder.
///
/// @param asyncJobId Id of the asynchronous job. This is the value of a response returned from the method that launched
/// the job.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGRemoveMemberJobStatus` object on success
/// or a `DBASYNCPollError` object on failure.
///
- (DBRpcTask<DBSHARINGRemoveMemberJobStatus *, DBASYNCPollError *> *)checkRemoveMemberJobStatus:(NSString *)asyncJobId;

///
/// Returns the status of an asynchronous job for sharing a folder.
///
/// @param asyncJobId Id of the asynchronous job. This is the value of a response returned from the method that launched
/// the job.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGShareFolderJobStatus` object on success
/// or a `DBASYNCPollError` object on failure.
///
- (DBRpcTask<DBSHARINGShareFolderJobStatus *, DBASYNCPollError *> *)checkShareJobStatus:(NSString *)asyncJobId;

///
/// DEPRECATED: Create a shared link. If a shared link already exists for the given path, that link is returned. Note
/// that in the returned PathLinkMetadata, the `url` in `DBSHARINGPathLinkMetadata` field is the shortened URL if
/// `shortUrl` in `DBSHARINGCreateSharedLinkArg` argument is set to true. Previously, it was technically possible to
/// break a shared link by moving or renaming the corresponding file or folder. In the future, this will no longer be
/// the case, so your app shouldn't rely on this behavior. Instead, if your app needs to revoke a shared link, use
/// `revokeSharedLink`.
///
/// @param path The path to share.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGPathLinkMetadata` object on success or a
/// `DBSHARINGCreateSharedLinkError` object on failure.
///
- (DBRpcTask<DBSHARINGPathLinkMetadata *, DBSHARINGCreateSharedLinkError *> *)createSharedLink:(NSString *)path
    __deprecated_msg("createSharedLink is deprecated. Use createSharedLinkWithSettings.");

///
/// DEPRECATED: Create a shared link. If a shared link already exists for the given path, that link is returned. Note
/// that in the returned PathLinkMetadata, the `url` in `DBSHARINGPathLinkMetadata` field is the shortened URL if
/// `shortUrl` in `DBSHARINGCreateSharedLinkArg` argument is set to true. Previously, it was technically possible to
/// break a shared link by moving or renaming the corresponding file or folder. In the future, this will no longer be
/// the case, so your app shouldn't rely on this behavior. Instead, if your app needs to revoke a shared link, use
/// `revokeSharedLink`.
///
/// @param path The path to share.
/// @param shortUrl Whether to return a shortened URL.
/// @param pendingUpload If it's okay to share a path that does not yet exist, set this to either `file` in
/// `DBSHARINGPendingUploadMode` or `folder` in `DBSHARINGPendingUploadMode` to indicate whether to assume it's a file
/// or folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGPathLinkMetadata` object on success or a
/// `DBSHARINGCreateSharedLinkError` object on failure.
///
- (DBRpcTask<DBSHARINGPathLinkMetadata *, DBSHARINGCreateSharedLinkError *> *)
createSharedLink:(NSString *)path
        shortUrl:(nullable NSNumber *)shortUrl
   pendingUpload:(nullable DBSHARINGPendingUploadMode *)pendingUpload
    __deprecated_msg("createSharedLink is deprecated. Use createSharedLinkWithSettings.");

///
/// Create a shared link with custom settings. If no settings are given then the default visibility is `public` in
/// `DBSHARINGRequestedVisibility` (The resolved visibility, though, may depend on other aspects such as team and shared
/// folder settings).
///
/// @param path The path to be shared by the shared link.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGCreateSharedLinkWithSettingsError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedLinkMetadata *, DBSHARINGCreateSharedLinkWithSettingsError *> *)
createSharedLinkWithSettings:(NSString *)path;

///
/// Create a shared link with custom settings. If no settings are given then the default visibility is `public` in
/// `DBSHARINGRequestedVisibility` (The resolved visibility, though, may depend on other aspects such as team and shared
/// folder settings).
///
/// @param path The path to be shared by the shared link.
/// @param settings The requested settings for the newly created shared link.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGCreateSharedLinkWithSettingsError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedLinkMetadata *, DBSHARINGCreateSharedLinkWithSettingsError *> *)
createSharedLinkWithSettings:(NSString *)path
                    settings:(nullable DBSHARINGSharedLinkSettings *)settings;

///
/// Returns shared file metadata.
///
/// @param file The file to query.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFileMetadata` object on success or
/// a `DBSHARINGGetFileMetadataError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFileMetadata *, DBSHARINGGetFileMetadataError *> *)getFileMetadata:(NSString *)file;

///
/// Returns shared file metadata.
///
/// @param file The file to query.
/// @param actions A list of `FileAction`s corresponding to `FilePermission`s that should appear in the  response's
/// `permissions` in `DBSHARINGSharedFileMetadata` field describing the actions the  authenticated user can perform on
/// the file.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFileMetadata` object on success or
/// a `DBSHARINGGetFileMetadataError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFileMetadata *, DBSHARINGGetFileMetadataError *> *)
getFileMetadata:(NSString *)file
        actions:(nullable NSArray<DBSHARINGFileAction *> *)actions;

///
/// Returns shared file metadata.
///
/// @param files The files to query.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBSHARINGGetFileMetadataBatchResult *>`
/// object on success or a `DBSHARINGSharingUserError` object on failure.
///
- (DBRpcTask<NSArray<DBSHARINGGetFileMetadataBatchResult *> *, DBSHARINGSharingUserError *> *)getFileMetadataBatch:
    (NSArray<NSString *> *)files;

///
/// Returns shared file metadata.
///
/// @param files The files to query.
/// @param actions A list of `FileAction`s corresponding to `FilePermission`s that should appear in the  response's
/// `permissions` in `DBSHARINGSharedFileMetadata` field describing the actions the  authenticated user can perform on
/// the file.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBSHARINGGetFileMetadataBatchResult *>`
/// object on success or a `DBSHARINGSharingUserError` object on failure.
///
- (DBRpcTask<NSArray<DBSHARINGGetFileMetadataBatchResult *> *, DBSHARINGSharingUserError *> *)
getFileMetadataBatch:(NSArray<NSString *> *)files
             actions:(nullable NSArray<DBSHARINGFileAction *> *)actions;

///
/// Returns shared folder metadata by its folder ID.
///
/// @param sharedFolderId The ID for the shared folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFolderMetadata` object on success
/// or a `DBSHARINGSharedFolderAccessError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFolderMetadata *, DBSHARINGSharedFolderAccessError *> *)getFolderMetadata:
    (NSString *)sharedFolderId;

///
/// Returns shared folder metadata by its folder ID.
///
/// @param sharedFolderId The ID for the shared folder.
/// @param actions A list of `FolderAction`s corresponding to `FolderPermission`s that should appear in the  response's
/// `permissions` in `DBSHARINGSharedFolderMetadata` field describing the actions the  authenticated user can perform on
/// the folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFolderMetadata` object on success
/// or a `DBSHARINGSharedFolderAccessError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFolderMetadata *, DBSHARINGSharedFolderAccessError *> *)
getFolderMetadata:(NSString *)sharedFolderId
          actions:(nullable NSArray<DBSHARINGFolderAction *> *)actions;

///
/// Download the shared link's file from a user's Dropbox.
///
/// @param url URL of the shared link.
/// @param overwrite A boolean to set behavior in the event of a naming conflict. `YES` will overwrite conflicting file
/// at destination. `NO` will take no action, resulting in an `NSError` returned to the response handler in the event of
/// a file conflict.
/// @param destination The file url of the desired download output location.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGGetSharedLinkFileError` object on failure.
///
- (DBDownloadUrlTask<DBSHARINGSharedLinkMetadata *, DBSHARINGGetSharedLinkFileError *> *)
getSharedLinkFileUrl:(NSString *)url
           overwrite:(BOOL)overwrite
         destination:(NSURL *)destination;

///
/// Download the shared link's file from a user's Dropbox.
///
/// @param url URL of the shared link.
/// @param path If the shared link is to a folder, this parameter can be used to retrieve the metadata for a specific
/// file or sub-folder in this folder. A relative path should be used.
/// @param linkPassword If the shared link has a password, this parameter can be used.
/// @param overwrite A boolean to set behavior in the event of a naming conflict. `YES` will overwrite conflicting file
/// at destination. `NO` will take no action, resulting in an `NSError` returned to the response handler in the event of
/// a file conflict.
/// @param destination The file url of the desired download output location.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGGetSharedLinkFileError` object on failure.
///
- (DBDownloadUrlTask<DBSHARINGSharedLinkMetadata *, DBSHARINGGetSharedLinkFileError *> *)
getSharedLinkFileUrl:(NSString *)url
                path:(nullable NSString *)path
        linkPassword:(nullable NSString *)linkPassword
           overwrite:(BOOL)overwrite
         destination:(NSURL *)destination;

///
/// Download the shared link's file from a user's Dropbox.
///
/// @param url URL of the shared link.
/// @param overwrite A boolean to set behavior in the event of a naming conflict. `YES` will overwrite conflicting file
/// at destination. `NO` will take no action, resulting in an `NSError` returned to the response handler in the event of
/// a file conflict.
/// @param destination The file url of the desired download output location.
/// @param byteOffsetStart For partial file download. Download file beginning from this starting byte position. Must
/// include valid end range value.
/// @param byteOffsetEnd For partial file download. Download file up until this ending byte position. Must include valid
/// start range value.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGGetSharedLinkFileError` object on failure.
///
- (DBDownloadUrlTask<DBSHARINGSharedLinkMetadata *, DBSHARINGGetSharedLinkFileError *> *)
getSharedLinkFileUrl:(NSString *)url
           overwrite:(BOOL)overwrite
         destination:(NSURL *)destination
     byteOffsetStart:(NSNumber *)byteOffsetStart
       byteOffsetEnd:(NSNumber *)byteOffsetEnd;

///
/// Download the shared link's file from a user's Dropbox.
///
/// @param url URL of the shared link.
/// @param path If the shared link is to a folder, this parameter can be used to retrieve the metadata for a specific
/// file or sub-folder in this folder. A relative path should be used.
/// @param linkPassword If the shared link has a password, this parameter can be used.
/// @param overwrite A boolean to set behavior in the event of a naming conflict. `YES` will overwrite conflicting file
/// at destination. `NO` will take no action, resulting in an `NSError` returned to the response handler in the event of
/// a file conflict.
/// @param destination The file url of the desired download output location.
/// @param byteOffsetStart For partial file download. Download file beginning from this starting byte position. Must
/// include valid end range value.
/// @param byteOffsetEnd For partial file download. Download file up until this ending byte position. Must include valid
/// start range value.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGGetSharedLinkFileError` object on failure.
///
- (DBDownloadUrlTask<DBSHARINGSharedLinkMetadata *, DBSHARINGGetSharedLinkFileError *> *)
getSharedLinkFileUrl:(NSString *)url
                path:(nullable NSString *)path
        linkPassword:(nullable NSString *)linkPassword
           overwrite:(BOOL)overwrite
         destination:(NSURL *)destination
     byteOffsetStart:(NSNumber *)byteOffsetStart
       byteOffsetEnd:(NSNumber *)byteOffsetEnd;

///
/// Download the shared link's file from a user's Dropbox.
///
/// @param url URL of the shared link.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGGetSharedLinkFileError` object on failure.
///
- (DBDownloadDataTask<DBSHARINGSharedLinkMetadata *, DBSHARINGGetSharedLinkFileError *> *)getSharedLinkFileData:
    (NSString *)url;

///
/// Download the shared link's file from a user's Dropbox.
///
/// @param url URL of the shared link.
/// @param path If the shared link is to a folder, this parameter can be used to retrieve the metadata for a specific
/// file or sub-folder in this folder. A relative path should be used.
/// @param linkPassword If the shared link has a password, this parameter can be used.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGGetSharedLinkFileError` object on failure.
///
- (DBDownloadDataTask<DBSHARINGSharedLinkMetadata *, DBSHARINGGetSharedLinkFileError *> *)
getSharedLinkFileData:(NSString *)url
                 path:(nullable NSString *)path
         linkPassword:(nullable NSString *)linkPassword;

///
/// Download the shared link's file from a user's Dropbox.
///
/// @param url URL of the shared link.
/// @param byteOffsetStart For partial file download. Download file beginning from this starting byte position. Must
/// include valid end range value.
/// @param byteOffsetEnd For partial file download. Download file up until this ending byte position. Must include valid
/// start range value.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGGetSharedLinkFileError` object on failure.
///
- (DBDownloadDataTask<DBSHARINGSharedLinkMetadata *, DBSHARINGGetSharedLinkFileError *> *)
getSharedLinkFileData:(NSString *)url
      byteOffsetStart:(NSNumber *)byteOffsetStart
        byteOffsetEnd:(NSNumber *)byteOffsetEnd;

///
/// Download the shared link's file from a user's Dropbox.
///
/// @param url URL of the shared link.
/// @param path If the shared link is to a folder, this parameter can be used to retrieve the metadata for a specific
/// file or sub-folder in this folder. A relative path should be used.
/// @param linkPassword If the shared link has a password, this parameter can be used.
/// @param byteOffsetStart For partial file download. Download file beginning from this starting byte position. Must
/// include valid end range value.
/// @param byteOffsetEnd For partial file download. Download file up until this ending byte position. Must include valid
/// start range value.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGGetSharedLinkFileError` object on failure.
///
- (DBDownloadDataTask<DBSHARINGSharedLinkMetadata *, DBSHARINGGetSharedLinkFileError *> *)
getSharedLinkFileData:(NSString *)url
                 path:(nullable NSString *)path
         linkPassword:(nullable NSString *)linkPassword
      byteOffsetStart:(NSNumber *)byteOffsetStart
        byteOffsetEnd:(NSNumber *)byteOffsetEnd;

///
/// Get the shared link's metadata.
///
/// @param url URL of the shared link.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGSharedLinkError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedLinkMetadata *, DBSHARINGSharedLinkError *> *)getSharedLinkMetadata:(NSString *)url;

///
/// Get the shared link's metadata.
///
/// @param url URL of the shared link.
/// @param path If the shared link is to a folder, this parameter can be used to retrieve the metadata for a specific
/// file or sub-folder in this folder. A relative path should be used.
/// @param linkPassword If the shared link has a password, this parameter can be used.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGSharedLinkError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedLinkMetadata *, DBSHARINGSharedLinkError *> *)
getSharedLinkMetadata:(NSString *)url
                 path:(nullable NSString *)path
         linkPassword:(nullable NSString *)linkPassword;

///
/// DEPRECATED: Returns a list of LinkMetadata objects for this user, including collection links. If no path is given,
/// returns a list of all shared links for the current user, including collection links, up to a maximum of 1000 links.
/// If a non-empty path is given, returns a list of all shared links that allow access to the given path.  Collection
/// links are never returned in this case. Note that the url field in the response is never the shortened URL.
///
///
/// @return Through the response callback, the caller will receive a `DBSHARINGGetSharedLinksResult` object on success
/// or a `DBSHARINGGetSharedLinksError` object on failure.
///
- (DBRpcTask<DBSHARINGGetSharedLinksResult *, DBSHARINGGetSharedLinksError *> *)getSharedLinks
    __deprecated_msg("getSharedLinks is deprecated. Use listSharedLinks.");

///
/// DEPRECATED: Returns a list of LinkMetadata objects for this user, including collection links. If no path is given,
/// returns a list of all shared links for the current user, including collection links, up to a maximum of 1000 links.
/// If a non-empty path is given, returns a list of all shared links that allow access to the given path.  Collection
/// links are never returned in this case. Note that the url field in the response is never the shortened URL.
///
/// @param path See `getSharedLinks` description.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGGetSharedLinksResult` object on success
/// or a `DBSHARINGGetSharedLinksError` object on failure.
///
- (DBRpcTask<DBSHARINGGetSharedLinksResult *, DBSHARINGGetSharedLinksError *> *)getSharedLinks:(nullable NSString *)path
    __deprecated_msg("getSharedLinks is deprecated. Use listSharedLinks.");

///
/// Use to obtain the members who have been invited to a file, both inherited and uninherited members.
///
/// @param file The file for which you want to see members.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFileMembers` object on success or a
/// `DBSHARINGListFileMembersError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFileMembers *, DBSHARINGListFileMembersError *> *)listFileMembers:(NSString *)file;

///
/// Use to obtain the members who have been invited to a file, both inherited and uninherited members.
///
/// @param file The file for which you want to see members.
/// @param actions The actions for which to return permissions on a member.
/// @param includeInherited Whether to include members who only have access from a parent shared folder.
/// @param limit Number of members to return max per query. Defaults to 100 if no limit is specified.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFileMembers` object on success or a
/// `DBSHARINGListFileMembersError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFileMembers *, DBSHARINGListFileMembersError *> *)
 listFileMembers:(NSString *)file
         actions:(nullable NSArray<DBSHARINGMemberAction *> *)actions
includeInherited:(nullable NSNumber *)includeInherited
           limit:(nullable NSNumber *)limit;

///
/// Get members of multiple files at once. The arguments to this route are more limited, and the limit on query result
/// size per file is more strict. To customize the results more, use the individual file endpoint. Inherited users and
/// groups are not included in the result, and permissions are not returned for this endpoint.
///
/// @param files Files for which to return members.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBSHARINGListFileMembersBatchResult *>`
/// object on success or a `DBSHARINGSharingUserError` object on failure.
///
- (DBRpcTask<NSArray<DBSHARINGListFileMembersBatchResult *> *, DBSHARINGSharingUserError *> *)listFileMembersBatch:
    (NSArray<NSString *> *)files;

///
/// Get members of multiple files at once. The arguments to this route are more limited, and the limit on query result
/// size per file is more strict. To customize the results more, use the individual file endpoint. Inherited users and
/// groups are not included in the result, and permissions are not returned for this endpoint.
///
/// @param files Files for which to return members.
/// @param limit Number of members to return max per query. Defaults to 10 if no limit is specified.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBSHARINGListFileMembersBatchResult *>`
/// object on success or a `DBSHARINGSharingUserError` object on failure.
///
- (DBRpcTask<NSArray<DBSHARINGListFileMembersBatchResult *> *, DBSHARINGSharingUserError *> *)
listFileMembersBatch:(NSArray<NSString *> *)files
               limit:(nullable NSNumber *)limit;

///
/// Once a cursor has been retrieved from `listFileMembers` or `listFileMembersBatch`, use this to paginate through all
/// shared file members.
///
/// @param cursor The cursor returned by your last call to `listFileMembers`, `listFileMembersContinue`, or
/// `listFileMembersBatch`.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFileMembers` object on success or a
/// `DBSHARINGListFileMembersContinueError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFileMembers *, DBSHARINGListFileMembersContinueError *> *)listFileMembersContinue:
    (NSString *)cursor;

///
/// Returns shared folder membership by its folder ID.
///
/// @param sharedFolderId The ID for the shared folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFolderMembers` object on success or
/// a `DBSHARINGSharedFolderAccessError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFolderMembers *, DBSHARINGSharedFolderAccessError *> *)listFolderMembers:
    (NSString *)sharedFolderId;

///
/// Returns shared folder membership by its folder ID.
///
/// @param sharedFolderId The ID for the shared folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFolderMembers` object on success or
/// a `DBSHARINGSharedFolderAccessError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFolderMembers *, DBSHARINGSharedFolderAccessError *> *)
listFolderMembers:(NSString *)sharedFolderId
          actions:(nullable NSArray<DBSHARINGMemberAction *> *)actions
            limit:(nullable NSNumber *)limit;

///
/// Once a cursor has been retrieved from `listFolderMembers`, use this to paginate through all shared folder members.
///
/// @param cursor The cursor returned by your last call to `listFolderMembers` or `listFolderMembersContinue`.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFolderMembers` object on success or
/// a `DBSHARINGListFolderMembersContinueError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFolderMembers *, DBSHARINGListFolderMembersContinueError *> *)listFolderMembersContinue:
    (NSString *)cursor;

///
/// Return the list of all shared folders the current user has access to.
///
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListFoldersResult` object on success or a
/// `void` object on failure.
///
- (DBRpcTask<DBSHARINGListFoldersResult *, DBNilObject *> *)listFolders;

///
/// Return the list of all shared folders the current user has access to.
///
/// @param limit The maximum number of results to return per request.
/// @param actions A list of `FolderAction`s corresponding to `FolderPermission`s that should appear in the  response's
/// `permissions` in `DBSHARINGSharedFolderMetadata` field describing the actions the  authenticated user can perform on
/// the folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListFoldersResult` object on success or a
/// `void` object on failure.
///
- (DBRpcTask<DBSHARINGListFoldersResult *, DBNilObject *> *)listFolders:(nullable NSNumber *)limit
                                                                actions:(nullable NSArray<DBSHARINGFolderAction *> *)
                                                                            actions;

///
/// Once a cursor has been retrieved from `listFolders`, use this to paginate through all shared folders. The cursor
/// must come from a previous call to `listFolders` or `listFoldersContinue`.
///
/// @param cursor The cursor returned by the previous API call specified in the endpoint description.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListFoldersResult` object on success or a
/// `DBSHARINGListFoldersContinueError` object on failure.
///
- (DBRpcTask<DBSHARINGListFoldersResult *, DBSHARINGListFoldersContinueError *> *)listFoldersContinue:
    (NSString *)cursor;

///
/// Return the list of all shared folders the current user can mount or unmount.
///
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListFoldersResult` object on success or a
/// `void` object on failure.
///
- (DBRpcTask<DBSHARINGListFoldersResult *, DBNilObject *> *)listMountableFolders;

///
/// Return the list of all shared folders the current user can mount or unmount.
///
/// @param limit The maximum number of results to return per request.
/// @param actions A list of `FolderAction`s corresponding to `FolderPermission`s that should appear in the  response's
/// `permissions` in `DBSHARINGSharedFolderMetadata` field describing the actions the  authenticated user can perform on
/// the folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListFoldersResult` object on success or a
/// `void` object on failure.
///
- (DBRpcTask<DBSHARINGListFoldersResult *, DBNilObject *> *)
listMountableFolders:(nullable NSNumber *)limit
             actions:(nullable NSArray<DBSHARINGFolderAction *> *)actions;

///
/// Once a cursor has been retrieved from `listMountableFolders`, use this to paginate through all mountable shared
/// folders. The cursor must come from a previous call to `listMountableFolders` or `listMountableFoldersContinue`.
///
/// @param cursor The cursor returned by the previous API call specified in the endpoint description.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListFoldersResult` object on success or a
/// `DBSHARINGListFoldersContinueError` object on failure.
///
- (DBRpcTask<DBSHARINGListFoldersResult *, DBSHARINGListFoldersContinueError *> *)listMountableFoldersContinue:
    (NSString *)cursor;

///
/// Returns a list of all files shared with current user.  Does not include files the user has received via shared
/// folders, and does  not include unclaimed invitations.
///
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListFilesResult` object on success or a
/// `DBSHARINGSharingUserError` object on failure.
///
- (DBRpcTask<DBSHARINGListFilesResult *, DBSHARINGSharingUserError *> *)listReceivedFiles;

///
/// Returns a list of all files shared with current user.  Does not include files the user has received via shared
/// folders, and does  not include unclaimed invitations.
///
/// @param limit Number of files to return max per query. Defaults to 100 if no limit is specified.
/// @param actions A list of `FileAction`s corresponding to `FilePermission`s that should appear in the  response's
/// `permissions` in `DBSHARINGSharedFileMetadata` field describing the actions the  authenticated user can perform on
/// the file.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListFilesResult` object on success or a
/// `DBSHARINGSharingUserError` object on failure.
///
- (DBRpcTask<DBSHARINGListFilesResult *, DBSHARINGSharingUserError *> *)
listReceivedFiles:(nullable NSNumber *)limit
          actions:(nullable NSArray<DBSHARINGFileAction *> *)actions;

///
/// Get more results with a cursor from `listReceivedFiles`.
///
/// @param cursor Cursor in `cursor` in `DBSHARINGListFilesResult`.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListFilesResult` object on success or a
/// `DBSHARINGListFilesContinueError` object on failure.
///
- (DBRpcTask<DBSHARINGListFilesResult *, DBSHARINGListFilesContinueError *> *)listReceivedFilesContinue:
    (NSString *)cursor;

///
/// List shared links of this user. If no path is given, returns a list of all shared links for the current user. For
/// members of business teams using team space and member folders, returns all shared links in the team member's home
/// folder unless the team space ID is specified in the request header. For more information, refer to the Namespace
/// Guide https://www.dropbox.com/developers/reference/namespace-guide. If a non-empty path is given, returns a list of
/// all shared links that allow access to the given path - direct links to the given path and links to parent folders of
/// the given path. Links to parent folders can be suppressed by setting direct_only to true.
///
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListSharedLinksResult` object on success
/// or a `DBSHARINGListSharedLinksError` object on failure.
///
- (DBRpcTask<DBSHARINGListSharedLinksResult *, DBSHARINGListSharedLinksError *> *)listSharedLinks;

///
/// List shared links of this user. If no path is given, returns a list of all shared links for the current user. For
/// members of business teams using team space and member folders, returns all shared links in the team member's home
/// folder unless the team space ID is specified in the request header. For more information, refer to the Namespace
/// Guide https://www.dropbox.com/developers/reference/namespace-guide. If a non-empty path is given, returns a list of
/// all shared links that allow access to the given path - direct links to the given path and links to parent folders of
/// the given path. Links to parent folders can be suppressed by setting direct_only to true.
///
/// @param path See `listSharedLinks` description.
/// @param cursor The cursor returned by your last call to `listSharedLinks`.
/// @param directOnly See `listSharedLinks` description.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGListSharedLinksResult` object on success
/// or a `DBSHARINGListSharedLinksError` object on failure.
///
- (DBRpcTask<DBSHARINGListSharedLinksResult *, DBSHARINGListSharedLinksError *> *)
listSharedLinks:(nullable NSString *)path
         cursor:(nullable NSString *)cursor
     directOnly:(nullable NSNumber *)directOnly;

///
/// Modify the shared link's settings. If the requested visibility conflict with the shared links policy of the team or
/// the shared folder (in case the linked file is part of a shared folder) then the `resolvedVisibility` in
/// `DBSHARINGLinkPermissions` of the returned SharedLinkMetadata will reflect the actual visibility of the shared link
/// and the `requestedVisibility` in `DBSHARINGLinkPermissions` will reflect the requested visibility.
///
/// @param url URL of the shared link to change its settings.
/// @param settings Set of settings for the shared link.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGModifySharedLinkSettingsError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedLinkMetadata *, DBSHARINGModifySharedLinkSettingsError *> *)
modifySharedLinkSettings:(NSString *)url
                settings:(DBSHARINGSharedLinkSettings *)settings;

///
/// Modify the shared link's settings. If the requested visibility conflict with the shared links policy of the team or
/// the shared folder (in case the linked file is part of a shared folder) then the `resolvedVisibility` in
/// `DBSHARINGLinkPermissions` of the returned SharedLinkMetadata will reflect the actual visibility of the shared link
/// and the `requestedVisibility` in `DBSHARINGLinkPermissions` will reflect the requested visibility.
///
/// @param url URL of the shared link to change its settings.
/// @param settings Set of settings for the shared link.
/// @param removeExpiration If set to true, removes the expiration of the shared link.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedLinkMetadata` object on success or
/// a `DBSHARINGModifySharedLinkSettingsError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedLinkMetadata *, DBSHARINGModifySharedLinkSettingsError *> *)
modifySharedLinkSettings:(NSString *)url
                settings:(DBSHARINGSharedLinkSettings *)settings
        removeExpiration:(nullable NSNumber *)removeExpiration;

///
/// The current user mounts the designated folder. Mount a shared folder for a user after they have been added as a
/// member. Once mounted, the shared folder will appear in their Dropbox.
///
/// @param sharedFolderId The ID of the shared folder to mount.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFolderMetadata` object on success
/// or a `DBSHARINGMountFolderError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFolderMetadata *, DBSHARINGMountFolderError *> *)mountFolder:(NSString *)sharedFolderId;

///
/// The current user relinquishes their membership in the designated file. Note that the current user may still have
/// inherited access to this file through the parent folder.
///
/// @param file The path or id for the file.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBSHARINGRelinquishFileMembershipError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBSHARINGRelinquishFileMembershipError *> *)relinquishFileMembership:(NSString *)file;

///
/// The current user relinquishes their membership in the designated shared folder and will no longer have access to the
/// folder.  A folder owner cannot relinquish membership in their own folder. This will run synchronously if
/// leave_a_copy is false, and asynchronously if leave_a_copy is true.
///
/// @param sharedFolderId The ID for the shared folder.
///
/// @return Through the response callback, the caller will receive a `DBASYNCLaunchEmptyResult` object on success or a
/// `DBSHARINGRelinquishFolderMembershipError` object on failure.
///
- (DBRpcTask<DBASYNCLaunchEmptyResult *, DBSHARINGRelinquishFolderMembershipError *> *)relinquishFolderMembership:
    (NSString *)sharedFolderId;

///
/// The current user relinquishes their membership in the designated shared folder and will no longer have access to the
/// folder.  A folder owner cannot relinquish membership in their own folder. This will run synchronously if
/// leave_a_copy is false, and asynchronously if leave_a_copy is true.
///
/// @param sharedFolderId The ID for the shared folder.
/// @param leaveACopy Keep a copy of the folder's contents upon relinquishing membership.
///
/// @return Through the response callback, the caller will receive a `DBASYNCLaunchEmptyResult` object on success or a
/// `DBSHARINGRelinquishFolderMembershipError` object on failure.
///
- (DBRpcTask<DBASYNCLaunchEmptyResult *, DBSHARINGRelinquishFolderMembershipError *> *)
relinquishFolderMembership:(NSString *)sharedFolderId
                leaveACopy:(nullable NSNumber *)leaveACopy;

///
/// DEPRECATED: Identical to remove_file_member_2 but with less information returned.
///
/// @param file File from which to remove members.
/// @param member Member to remove from this file. Note that even if an email is specified, it may result in the removal
/// of a user (not an invitee) if the user's main account corresponds to that email address.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGFileMemberActionIndividualResult` object
/// on success or a `DBSHARINGRemoveFileMemberError` object on failure.
///
- (DBRpcTask<DBSHARINGFileMemberActionIndividualResult *, DBSHARINGRemoveFileMemberError *> *)
removeFileMember:(NSString *)file
          member:(DBSHARINGMemberSelector *)member
    __deprecated_msg("removeFileMember is deprecated. Use removeFileMember2.");

///
/// Removes a specified member from the file.
///
/// @param file File from which to remove members.
/// @param member Member to remove from this file. Note that even if an email is specified, it may result in the removal
/// of a user (not an invitee) if the user's main account corresponds to that email address.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGFileMemberRemoveActionResult` object on
/// success or a `DBSHARINGRemoveFileMemberError` object on failure.
///
- (DBRpcTask<DBSHARINGFileMemberRemoveActionResult *, DBSHARINGRemoveFileMemberError *> *)
removeFileMember2:(NSString *)file
           member:(DBSHARINGMemberSelector *)member;

///
/// Allows an owner or editor (if the ACL update policy allows) of a shared folder to remove another member.
///
/// @param sharedFolderId The ID for the shared folder.
/// @param member The member to remove from the folder.
/// @param leaveACopy If true, the removed user will keep their copy of the folder after it's unshared, assuming it was
/// mounted. Otherwise, it will be removed from their Dropbox. Also, this must be set to false when kicking a group.
///
/// @return Through the response callback, the caller will receive a `DBASYNCLaunchResultBase` object on success or a
/// `DBSHARINGRemoveFolderMemberError` object on failure.
///
- (DBRpcTask<DBASYNCLaunchResultBase *, DBSHARINGRemoveFolderMemberError *> *)
removeFolderMember:(NSString *)sharedFolderId
            member:(DBSHARINGMemberSelector *)member
        leaveACopy:(NSNumber *)leaveACopy;

///
/// Revoke a shared link. Note that even after revoking a shared link to a file, the file may be accessible if there are
/// shared links leading to any of the file parent folders. To list all shared links that enable access to a specific
/// file, you can use the `listSharedLinks` with the file as the `path` in `DBSHARINGListSharedLinksArg` argument.
///
/// @param url URL of the shared link.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBSHARINGRevokeSharedLinkError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBSHARINGRevokeSharedLinkError *> *)revokeSharedLink:(NSString *)url;

///
/// Change the inheritance policy of an existing Shared Folder. Only permitted for shared folders in a shared team root.
/// If a `asyncJobId` in `DBSHARINGShareFolderLaunch` is returned, you'll need to call `checkShareJobStatus` until the
/// action completes to get the metadata for the folder.
///
/// @param sharedFolderId The ID for the shared folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGShareFolderLaunch` object on success or a
/// `DBSHARINGSetAccessInheritanceError` object on failure.
///
- (DBRpcTask<DBSHARINGShareFolderLaunch *, DBSHARINGSetAccessInheritanceError *> *)setAccessInheritance:
    (NSString *)sharedFolderId;

///
/// Change the inheritance policy of an existing Shared Folder. Only permitted for shared folders in a shared team root.
/// If a `asyncJobId` in `DBSHARINGShareFolderLaunch` is returned, you'll need to call `checkShareJobStatus` until the
/// action completes to get the metadata for the folder.
///
/// @param accessInheritance The access inheritance settings for the folder.
/// @param sharedFolderId The ID for the shared folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGShareFolderLaunch` object on success or a
/// `DBSHARINGSetAccessInheritanceError` object on failure.
///
- (DBRpcTask<DBSHARINGShareFolderLaunch *, DBSHARINGSetAccessInheritanceError *> *)
setAccessInheritance:(NSString *)sharedFolderId
   accessInheritance:(nullable DBSHARINGAccessInheritance *)accessInheritance;

///
/// Share a folder with collaborators. Most sharing will be completed synchronously. Large folders will be completed
/// asynchronously. To make testing the async case repeatable, set `ShareFolderArg.force_async`. If a `asyncJobId` in
/// `DBSHARINGShareFolderLaunch` is returned, you'll need to call `checkShareJobStatus` until the action completes to
/// get the metadata for the folder.
///
///
/// @return Through the response callback, the caller will receive a `DBSHARINGShareFolderLaunch` object on success or a
/// `DBSHARINGShareFolderError` object on failure.
///
- (DBRpcTask<DBSHARINGShareFolderLaunch *, DBSHARINGShareFolderError *> *)shareFolder:(NSString *)path;

///
/// Share a folder with collaborators. Most sharing will be completed synchronously. Large folders will be completed
/// asynchronously. To make testing the async case repeatable, set `ShareFolderArg.force_async`. If a `asyncJobId` in
/// `DBSHARINGShareFolderLaunch` is returned, you'll need to call `checkShareJobStatus` until the action completes to
/// get the metadata for the folder.
///
/// @param actions A list of `FolderAction`s corresponding to `FolderPermission`s that should appear in the  response's
/// `permissions` in `DBSHARINGSharedFolderMetadata` field describing the actions the  authenticated user can perform on
/// the folder.
/// @param linkSettings Settings on the link for this folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGShareFolderLaunch` object on success or a
/// `DBSHARINGShareFolderError` object on failure.
///
- (DBRpcTask<DBSHARINGShareFolderLaunch *, DBSHARINGShareFolderError *> *)
      shareFolder:(NSString *)path
  aclUpdatePolicy:(nullable DBSHARINGAclUpdatePolicy *)aclUpdatePolicy
       forceAsync:(nullable NSNumber *)forceAsync
     memberPolicy:(nullable DBSHARINGMemberPolicy *)memberPolicy
 sharedLinkPolicy:(nullable DBSHARINGSharedLinkPolicy *)sharedLinkPolicy
 viewerInfoPolicy:(nullable DBSHARINGViewerInfoPolicy *)viewerInfoPolicy
accessInheritance:(nullable DBSHARINGAccessInheritance *)accessInheritance
          actions:(nullable NSArray<DBSHARINGFolderAction *> *)actions
     linkSettings:(nullable DBSHARINGLinkSettings *)linkSettings;

///
/// Transfer ownership of a shared folder to a member of the shared folder. User must have `owner` in
/// `DBSHARINGAccessLevel` access to the shared folder to perform a transfer.
///
/// @param sharedFolderId The ID for the shared folder.
/// @param toDropboxId A account or team member ID to transfer ownership to.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBSHARINGTransferFolderError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBSHARINGTransferFolderError *> *)transferFolder:(NSString *)sharedFolderId
                                                                 toDropboxId:(NSString *)toDropboxId;

///
/// The current user unmounts the designated folder. They can re-mount the folder at a later time using `mountFolder`.
///
/// @param sharedFolderId The ID for the shared folder.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBSHARINGUnmountFolderError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBSHARINGUnmountFolderError *> *)unmountFolder:(NSString *)sharedFolderId;

///
/// Remove all members from this file. Does not remove inherited members.
///
/// @param file The file to unshare.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBSHARINGUnshareFileError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBSHARINGUnshareFileError *> *)unshareFile:(NSString *)file;

///
/// Allows a shared folder owner to unshare the folder. You'll need to call `checkJobStatus` to determine if the action
/// has completed successfully.
///
/// @param sharedFolderId The ID for the shared folder.
///
/// @return Through the response callback, the caller will receive a `DBASYNCLaunchEmptyResult` object on success or a
/// `DBSHARINGUnshareFolderError` object on failure.
///
- (DBRpcTask<DBASYNCLaunchEmptyResult *, DBSHARINGUnshareFolderError *> *)unshareFolder:(NSString *)sharedFolderId;

///
/// Allows a shared folder owner to unshare the folder. You'll need to call `checkJobStatus` to determine if the action
/// has completed successfully.
///
/// @param sharedFolderId The ID for the shared folder.
/// @param leaveACopy If true, members of this shared folder will get a copy of this folder after it's unshared.
/// Otherwise, it will be removed from their Dropbox. The current user, who is an owner, will always retain their copy.
///
/// @return Through the response callback, the caller will receive a `DBASYNCLaunchEmptyResult` object on success or a
/// `DBSHARINGUnshareFolderError` object on failure.
///
- (DBRpcTask<DBASYNCLaunchEmptyResult *, DBSHARINGUnshareFolderError *> *)unshareFolder:(NSString *)sharedFolderId
                                                                             leaveACopy:(nullable NSNumber *)leaveACopy;

///
/// Changes a member's access on a shared file.
///
///
/// @return Through the response callback, the caller will receive a `DBSHARINGMemberAccessLevelResult` object on
/// success or a `DBSHARINGFileMemberActionError` object on failure.
///
- (DBRpcTask<DBSHARINGMemberAccessLevelResult *, DBSHARINGFileMemberActionError *> *)
updateFileMember:(NSString *)file
          member:(DBSHARINGMemberSelector *)member
     accessLevel:(DBSHARINGAccessLevel *)accessLevel;

///
/// Allows an owner or editor of a shared folder to update another member's permissions.
///
/// @param sharedFolderId The ID for the shared folder.
/// @param member The member of the shared folder to update.  Only the `dropboxId` in `DBSHARINGMemberSelector` may be
/// set at this time.
/// @param accessLevel The new access level for member. `owner` in `DBSHARINGAccessLevel` is disallowed.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGMemberAccessLevelResult` object on
/// success or a `DBSHARINGUpdateFolderMemberError` object on failure.
///
- (DBRpcTask<DBSHARINGMemberAccessLevelResult *, DBSHARINGUpdateFolderMemberError *> *)
updateFolderMember:(NSString *)sharedFolderId
            member:(DBSHARINGMemberSelector *)member
       accessLevel:(DBSHARINGAccessLevel *)accessLevel;

///
/// Update the sharing policies for a shared folder. User must have `owner` in `DBSHARINGAccessLevel` access to the
/// shared folder to update its policies.
///
/// @param sharedFolderId The ID for the shared folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFolderMetadata` object on success
/// or a `DBSHARINGUpdateFolderPolicyError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFolderMetadata *, DBSHARINGUpdateFolderPolicyError *> *)updateFolderPolicy:
    (NSString *)sharedFolderId;

///
/// Update the sharing policies for a shared folder. User must have `owner` in `DBSHARINGAccessLevel` access to the
/// shared folder to update its policies.
///
/// @param sharedFolderId The ID for the shared folder.
/// @param memberPolicy Who can be a member of this shared folder. Only applicable if the current user is on a team.
/// @param aclUpdatePolicy Who can add and remove members of this shared folder.
/// @param viewerInfoPolicy Who can enable/disable viewer info for this shared folder.
/// @param sharedLinkPolicy The policy to apply to shared links created for content inside this shared folder. The
/// current user must be on a team to set this policy to `members` in `DBSHARINGSharedLinkPolicy`.
/// @param linkSettings Settings on the link for this folder.
/// @param actions A list of `FolderAction`s corresponding to `FolderPermission`s that should appear in the  response's
/// `permissions` in `DBSHARINGSharedFolderMetadata` field describing the actions the  authenticated user can perform on
/// the folder.
///
/// @return Through the response callback, the caller will receive a `DBSHARINGSharedFolderMetadata` object on success
/// or a `DBSHARINGUpdateFolderPolicyError` object on failure.
///
- (DBRpcTask<DBSHARINGSharedFolderMetadata *, DBSHARINGUpdateFolderPolicyError *> *)
updateFolderPolicy:(NSString *)sharedFolderId
      memberPolicy:(nullable DBSHARINGMemberPolicy *)memberPolicy
   aclUpdatePolicy:(nullable DBSHARINGAclUpdatePolicy *)aclUpdatePolicy
  viewerInfoPolicy:(nullable DBSHARINGViewerInfoPolicy *)viewerInfoPolicy
  sharedLinkPolicy:(nullable DBSHARINGSharedLinkPolicy *)sharedLinkPolicy
      linkSettings:(nullable DBSHARINGLinkSettings *)linkSettings
           actions:(nullable NSArray<DBSHARINGFolderAction *> *)actions;

@end

NS_ASSUME_NONNULL_END
