///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBTasks.h"

@class DBAUTHTokenFromOAuth1Error;
@class DBAUTHTokenFromOAuth1Result;
@class DBNilObject;

@protocol DBTransportClient;

///
/// Routes for the `Auth` namespace
///

NS_ASSUME_NONNULL_BEGIN

@interface DBAUTHAppAuthRoutes : NSObject

/// An instance of the networking client that each route will use to submit a
/// request.
@property (nonatomic, readonly) id<DBTransportClient> client;

/// Initializes the `DBAUTHAppAuthRoutes` namespace container object with a
/// networking client.
- (instancetype)init:(id<DBTransportClient>)client;

///
/// Creates an OAuth 2.0 access token from the supplied OAuth 1.0 access token.
///
/// @param oauth1Token The supplied OAuth 1.0 access token.
/// @param oauth1TokenSecret The token secret associated with the supplied access token.
///
/// @return Through the response callback, the caller will receive a `DBAUTHTokenFromOAuth1Result` object on success or
/// a `DBAUTHTokenFromOAuth1Error` object on failure.
///
- (DBRpcTask<DBAUTHTokenFromOAuth1Result *, DBAUTHTokenFromOAuth1Error *> *)tokenFromOauth1:(NSString *)oauth1Token
                                                                          oauth1TokenSecret:
                                                                              (NSString *)oauth1TokenSecret;

@end

NS_ASSUME_NONNULL_END
