///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMPOLICIESEmmState;
@class DBTEAMPOLICIESOfficeAddInPolicy;
@class DBTEAMPOLICIESSuggestMembersPolicy;
@class DBTEAMPOLICIESTeamMemberPolicies;
@class DBTEAMPOLICIESTeamSharingPolicies;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamMemberPolicies` struct.
///
/// Policies governing team members.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMPOLICIESTeamMemberPolicies : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Policies governing sharing.
@property (nonatomic, readonly) DBTEAMPOLICIESTeamSharingPolicies *sharing;

/// This describes the Enterprise Mobility Management (EMM) state for this team.
/// This information can be used to understand if an organization is integrating
/// with a third-party EMM vendor to further manage and apply restrictions upon
/// the team's Dropbox usage on mobile devices. This is a new feature and in the
/// future we'll be adding more new fields and additional documentation.
@property (nonatomic, readonly) DBTEAMPOLICIESEmmState *emmState;

/// The admin policy around the Dropbox Office Add-In for this team.
@property (nonatomic, readonly) DBTEAMPOLICIESOfficeAddInPolicy *officeAddin;

/// The team policy on if teammembers are allowed to suggest users for admins to
/// invite to the team.
@property (nonatomic, readonly) DBTEAMPOLICIESSuggestMembersPolicy *suggestMembersPolicy;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sharing Policies governing sharing.
/// @param emmState This describes the Enterprise Mobility Management (EMM)
/// state for this team. This information can be used to understand if an
/// organization is integrating with a third-party EMM vendor to further manage
/// and apply restrictions upon the team's Dropbox usage on mobile devices. This
/// is a new feature and in the future we'll be adding more new fields and
/// additional documentation.
/// @param officeAddin The admin policy around the Dropbox Office Add-In for
/// this team.
/// @param suggestMembersPolicy The team policy on if teammembers are allowed to
/// suggest users for admins to invite to the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithSharing:(DBTEAMPOLICIESTeamSharingPolicies *)sharing
                       emmState:(DBTEAMPOLICIESEmmState *)emmState
                    officeAddin:(DBTEAMPOLICIESOfficeAddInPolicy *)officeAddin
           suggestMembersPolicy:(DBTEAMPOLICIESSuggestMembersPolicy *)suggestMembersPolicy;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `TeamMemberPolicies` struct.
///
@interface DBTEAMPOLICIESTeamMemberPoliciesSerializer : NSObject

///
/// Serializes `DBTEAMPOLICIESTeamMemberPolicies` instances.
///
/// @param instance An instance of the `DBTEAMPOLICIESTeamMemberPolicies` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESTeamMemberPolicies` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESTeamMemberPolicies *)instance;

///
/// Deserializes `DBTEAMPOLICIESTeamMemberPolicies` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESTeamMemberPolicies` API object.
///
/// @return An instantiation of the `DBTEAMPOLICIESTeamMemberPolicies` object.
///
+ (DBTEAMPOLICIESTeamMemberPolicies *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
