///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMPOLICIESPaperDesktopPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperDesktopPolicy` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMPOLICIESPaperDesktopPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMPOLICIESPaperDesktopPolicyTag` enum type represents the possible
/// tag states with which the `DBTEAMPOLICIESPaperDesktopPolicy` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMPOLICIESPaperDesktopPolicyTag){
    /// Do not allow team members to use Paper Desktop.
    DBTEAMPOLICIESPaperDesktopPolicyDisabled,

    /// Allow team members to use Paper Desktop.
    DBTEAMPOLICIESPaperDesktopPolicyEnabled,

    /// (no description).
    DBTEAMPOLICIESPaperDesktopPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMPOLICIESPaperDesktopPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "disabled".
///
/// Description of the "disabled" tag state: Do not allow team members to use
/// Paper Desktop.
///
/// @return An initialized instance.
///
- (instancetype)initWithDisabled;

///
/// Initializes union class with tag state of "enabled".
///
/// Description of the "enabled" tag state: Allow team members to use Paper
/// Desktop.
///
/// @return An initialized instance.
///
- (instancetype)initWithEnabled;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "disabled".
///
/// @return Whether the union's current tag state has value "disabled".
///
- (BOOL)isDisabled;

///
/// Retrieves whether the union's current tag state has value "enabled".
///
/// @return Whether the union's current tag state has value "enabled".
///
- (BOOL)isEnabled;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMPOLICIESPaperDesktopPolicy` union.
///
@interface DBTEAMPOLICIESPaperDesktopPolicySerializer : NSObject

///
/// Serializes `DBTEAMPOLICIESPaperDesktopPolicy` instances.
///
/// @param instance An instance of the `DBTEAMPOLICIESPaperDesktopPolicy` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESPaperDesktopPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESPaperDesktopPolicy *)instance;

///
/// Deserializes `DBTEAMPOLICIESPaperDesktopPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESPaperDesktopPolicy` API object.
///
/// @return An instantiation of the `DBTEAMPOLICIESPaperDesktopPolicy` object.
///
+ (DBTEAMPOLICIESPaperDesktopPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
