///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGTeamDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamDetails` struct.
///
/// More details about the team.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGTeamDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The name of the team.
@property (nonatomic, readonly, copy) NSString *team;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param team The name of the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeam:(NSString *)team;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `TeamDetails` struct.
///
@interface DBTEAMLOGTeamDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGTeamDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGTeamDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGTeamDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGTeamDetails *)instance;

///
/// Deserializes `DBTEAMLOGTeamDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGTeamDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGTeamDetails` object.
///
+ (DBTEAMLOGTeamDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
