///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGAccessLevel;
@class DBTEAMLOGSharedContentRestoreMemberDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedContentRestoreMemberDetails` struct.
///
/// Restored users and/or groups to membership of shared file/folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSharedContentRestoreMemberDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Shared content access level.
@property (nonatomic, readonly) DBSHARINGAccessLevel *sharedContentAccessLevel;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sharedContentAccessLevel Shared content access level.
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentAccessLevel:(DBSHARINGAccessLevel *)sharedContentAccessLevel;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SharedContentRestoreMemberDetails` struct.
///
@interface DBTEAMLOGSharedContentRestoreMemberDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGSharedContentRestoreMemberDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGSharedContentRestoreMemberDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedContentRestoreMemberDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSharedContentRestoreMemberDetails *)instance;

///
/// Deserializes `DBTEAMLOGSharedContentRestoreMemberDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedContentRestoreMemberDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGSharedContentRestoreMemberDetails`
/// object.
///
+ (DBTEAMLOGSharedContentRestoreMemberDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
