///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAdminRole;
@class DBTEAMLOGMemberChangeAdminRoleDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberChangeAdminRoleDetails` struct.
///
/// Changed team member admin role.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGMemberChangeAdminRoleDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New admin role. This field is relevant when the admin role is changed or
/// whenthe user role changes from no admin rights to with admin rights.
@property (nonatomic, readonly, nullable) DBTEAMLOGAdminRole *dNewValue;

/// Previous admin role. This field is relevant when the admin role is changed
/// or when the admin role is removed.
@property (nonatomic, readonly, nullable) DBTEAMLOGAdminRole *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New admin role. This field is relevant when the admin role
/// is changed or whenthe user role changes from no admin rights to with admin
/// rights.
/// @param previousValue Previous admin role. This field is relevant when the
/// admin role is changed or when the admin role is removed.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(nullable DBTEAMLOGAdminRole *)dNewValue
                    previousValue:(nullable DBTEAMLOGAdminRole *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MemberChangeAdminRoleDetails` struct.
///
@interface DBTEAMLOGMemberChangeAdminRoleDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGMemberChangeAdminRoleDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGMemberChangeAdminRoleDetails`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGMemberChangeAdminRoleDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGMemberChangeAdminRoleDetails *)instance;

///
/// Deserializes `DBTEAMLOGMemberChangeAdminRoleDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGMemberChangeAdminRoleDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGMemberChangeAdminRoleDetails`
/// object.
///
+ (DBTEAMLOGMemberChangeAdminRoleDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
