///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGLegalHoldsExportDownloadedDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LegalHoldsExportDownloadedDetails` struct.
///
/// Downloaded export for a hold.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGLegalHoldsExportDownloadedDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Hold ID.
@property (nonatomic, readonly, copy) NSString *legalHoldId;

/// Hold name.
@property (nonatomic, readonly, copy) NSString *name;

/// Export name.
@property (nonatomic, readonly, copy) NSString *exportName;

/// Part.
@property (nonatomic, readonly, copy, nullable) NSString *part;

/// Filename.
@property (nonatomic, readonly, copy, nullable) NSString *fileName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param legalHoldId Hold ID.
/// @param name Hold name.
/// @param exportName Export name.
/// @param part Part.
/// @param fileName Filename.
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldId:(NSString *)legalHoldId
                               name:(NSString *)name
                         exportName:(NSString *)exportName
                               part:(nullable NSString *)part
                           fileName:(nullable NSString *)fileName;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param legalHoldId Hold ID.
/// @param name Hold name.
/// @param exportName Export name.
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldId:(NSString *)legalHoldId name:(NSString *)name exportName:(NSString *)exportName;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `LegalHoldsExportDownloadedDetails` struct.
///
@interface DBTEAMLOGLegalHoldsExportDownloadedDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGLegalHoldsExportDownloadedDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGLegalHoldsExportDownloadedDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGLegalHoldsExportDownloadedDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGLegalHoldsExportDownloadedDetails *)instance;

///
/// Deserializes `DBTEAMLOGLegalHoldsExportDownloadedDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGLegalHoldsExportDownloadedDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGLegalHoldsExportDownloadedDetails`
/// object.
///
+ (DBTEAMLOGLegalHoldsExportDownloadedDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
