///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"
#import "DBTEAMLOGFileOrFolderLogInfo.h"

@class DBTEAMLOGFileLogInfo;
@class DBTEAMLOGPathLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FileLogInfo` struct.
///
/// File's logged information.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGFileLogInfo : DBTEAMLOGFileOrFolderLogInfo <DBSerializable, NSCopying>

#pragma mark - Instance fields

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param path Path relative to event context.
/// @param displayName Display name.
/// @param fileId Unique ID.
/// @param fileSize File or folder size in bytes.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(DBTEAMLOGPathLogInfo *)path
                 displayName:(nullable NSString *)displayName
                      fileId:(nullable NSString *)fileId
                    fileSize:(nullable NSNumber *)fileSize;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param path Path relative to event context.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(DBTEAMLOGPathLogInfo *)path;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `FileLogInfo` struct.
///
@interface DBTEAMLOGFileLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGFileLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGFileLogInfo` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGFileLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGFileLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGFileLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGFileLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGFileLogInfo` object.
///
+ (DBTEAMLOGFileLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
