///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDurationLogInfo;
@class DBTEAMLOGTimeUnit;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DurationLogInfo` struct.
///
/// Represents a time duration: unit and amount
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDurationLogInfo : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Time unit.
@property (nonatomic, readonly) DBTEAMLOGTimeUnit *unit;

/// Amount of time.
@property (nonatomic, readonly) NSNumber *amount;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param unit Time unit.
/// @param amount Amount of time.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnit:(DBTEAMLOGTimeUnit *)unit amount:(NSNumber *)amount;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DurationLogInfo` struct.
///
@interface DBTEAMLOGDurationLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGDurationLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGDurationLogInfo` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDurationLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDurationLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGDurationLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDurationLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGDurationLogInfo` object.
///
+ (DBTEAMLOGDurationLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
