///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"
#import "DBTEAMLOGDeviceSessionLogInfo.h"

@class DBTEAMDesktopPlatform;
@class DBTEAMLOGDesktopDeviceSessionLogInfo;
@class DBTEAMLOGDesktopSessionLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DesktopDeviceSessionLogInfo` struct.
///
/// Information about linked Dropbox desktop client sessions
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDesktopDeviceSessionLogInfo : DBTEAMLOGDeviceSessionLogInfo <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Desktop session unique id.
@property (nonatomic, readonly, nullable) DBTEAMLOGDesktopSessionLogInfo *sessionInfo;

/// Name of the hosting desktop.
@property (nonatomic, readonly, copy) NSString *hostName;

/// The Dropbox desktop client type.
@property (nonatomic, readonly) DBTEAMDesktopPlatform *clientType;

/// The Dropbox client version.
@property (nonatomic, readonly, copy, nullable) NSString *clientVersion;

/// Information on the hosting platform.
@property (nonatomic, readonly, copy) NSString *platform;

/// Whether itu2019s possible to delete all of the account files upon unlinking.
@property (nonatomic, readonly) NSNumber *isDeleteOnUnlinkSupported;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param hostName Name of the hosting desktop.
/// @param clientType The Dropbox desktop client type.
/// @param platform Information on the hosting platform.
/// @param isDeleteOnUnlinkSupported Whether itu2019s possible to delete all of
/// the account files upon unlinking.
/// @param ipAddress The IP address of the last activity from this session.
/// @param created The time this session was created.
/// @param updated The time of the last activity from this session.
/// @param sessionInfo Desktop session unique id.
/// @param clientVersion The Dropbox client version.
///
/// @return An initialized instance.
///
- (instancetype)initWithHostName:(NSString *)hostName
                      clientType:(DBTEAMDesktopPlatform *)clientType
                        platform:(NSString *)platform
       isDeleteOnUnlinkSupported:(NSNumber *)isDeleteOnUnlinkSupported
                       ipAddress:(nullable NSString *)ipAddress
                         created:(nullable NSDate *)created
                         updated:(nullable NSDate *)updated
                     sessionInfo:(nullable DBTEAMLOGDesktopSessionLogInfo *)sessionInfo
                   clientVersion:(nullable NSString *)clientVersion;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param hostName Name of the hosting desktop.
/// @param clientType The Dropbox desktop client type.
/// @param platform Information on the hosting platform.
/// @param isDeleteOnUnlinkSupported Whether itu2019s possible to delete all of
/// the account files upon unlinking.
///
/// @return An initialized instance.
///
- (instancetype)initWithHostName:(NSString *)hostName
                      clientType:(DBTEAMDesktopPlatform *)clientType
                        platform:(NSString *)platform
       isDeleteOnUnlinkSupported:(NSNumber *)isDeleteOnUnlinkSupported;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DesktopDeviceSessionLogInfo` struct.
///
@interface DBTEAMLOGDesktopDeviceSessionLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGDesktopDeviceSessionLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGDesktopDeviceSessionLogInfo`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDesktopDeviceSessionLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDesktopDeviceSessionLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGDesktopDeviceSessionLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDesktopDeviceSessionLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGDesktopDeviceSessionLogInfo`
/// object.
///
+ (DBTEAMLOGDesktopDeviceSessionLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
