///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGCreateTeamInviteLinkDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `CreateTeamInviteLinkDetails` struct.
///
/// Created team invite link.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGCreateTeamInviteLinkDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The invite link url that was created.
@property (nonatomic, readonly, copy) NSString *linkUrl;

/// The expiration date of the invite link.
@property (nonatomic, readonly, copy) NSString *expiryDate;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param linkUrl The invite link url that was created.
/// @param expiryDate The expiration date of the invite link.
///
/// @return An initialized instance.
///
- (instancetype)initWithLinkUrl:(NSString *)linkUrl expiryDate:(NSString *)expiryDate;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `CreateTeamInviteLinkDetails` struct.
///
@interface DBTEAMLOGCreateTeamInviteLinkDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGCreateTeamInviteLinkDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGCreateTeamInviteLinkDetails`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGCreateTeamInviteLinkDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCreateTeamInviteLinkDetails *)instance;

///
/// Deserializes `DBTEAMLOGCreateTeamInviteLinkDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGCreateTeamInviteLinkDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGCreateTeamInviteLinkDetails`
/// object.
///
+ (DBTEAMLOGCreateTeamInviteLinkDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
