///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `TeamCommon` namespace.

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONGroupManagementType.h"

#pragma mark - API Object

@implementation DBTEAMCOMMONGroupManagementType

#pragma mark - Constructors

- (instancetype)initWithUserManaged {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONGroupManagementTypeUserManaged;
  }
  return self;
}

- (instancetype)initWithCompanyManaged {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONGroupManagementTypeCompanyManaged;
  }
  return self;
}

- (instancetype)initWithSystemManaged {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONGroupManagementTypeSystemManaged;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONGroupManagementTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserManaged {
  return _tag == DBTEAMCOMMONGroupManagementTypeUserManaged;
}

- (BOOL)isCompanyManaged {
  return _tag == DBTEAMCOMMONGroupManagementTypeCompanyManaged;
}

- (BOOL)isSystemManaged {
  return _tag == DBTEAMCOMMONGroupManagementTypeSystemManaged;
}

- (BOOL)isOther {
  return _tag == DBTEAMCOMMONGroupManagementTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMCOMMONGroupManagementTypeUserManaged:
    return @"DBTEAMCOMMONGroupManagementTypeUserManaged";
  case DBTEAMCOMMONGroupManagementTypeCompanyManaged:
    return @"DBTEAMCOMMONGroupManagementTypeCompanyManaged";
  case DBTEAMCOMMONGroupManagementTypeSystemManaged:
    return @"DBTEAMCOMMONGroupManagementTypeSystemManaged";
  case DBTEAMCOMMONGroupManagementTypeOther:
    return @"DBTEAMCOMMONGroupManagementTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMCOMMONGroupManagementTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMCOMMONGroupManagementTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMCOMMONGroupManagementTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMCOMMONGroupManagementTypeUserManaged:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMCOMMONGroupManagementTypeCompanyManaged:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMCOMMONGroupManagementTypeSystemManaged:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMCOMMONGroupManagementTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupManagementType:other];
}

- (BOOL)isEqualToGroupManagementType:(DBTEAMCOMMONGroupManagementType *)aGroupManagementType {
  if (self == aGroupManagementType) {
    return YES;
  }
  if (self.tag != aGroupManagementType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMCOMMONGroupManagementTypeUserManaged:
    return [[self tagName] isEqual:[aGroupManagementType tagName]];
  case DBTEAMCOMMONGroupManagementTypeCompanyManaged:
    return [[self tagName] isEqual:[aGroupManagementType tagName]];
  case DBTEAMCOMMONGroupManagementTypeSystemManaged:
    return [[self tagName] isEqual:[aGroupManagementType tagName]];
  case DBTEAMCOMMONGroupManagementTypeOther:
    return [[self tagName] isEqual:[aGroupManagementType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMCOMMONGroupManagementTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMCOMMONGroupManagementType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserManaged]) {
    jsonDict[@".tag"] = @"user_managed";
  } else if ([valueObj isCompanyManaged]) {
    jsonDict[@".tag"] = @"company_managed";
  } else if ([valueObj isSystemManaged]) {
    jsonDict[@".tag"] = @"system_managed";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMCOMMONGroupManagementType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_managed"]) {
    return [[DBTEAMCOMMONGroupManagementType alloc] initWithUserManaged];
  } else if ([tag isEqualToString:@"company_managed"]) {
    return [[DBTEAMCOMMONGroupManagementType alloc] initWithCompanyManaged];
  } else if ([tag isEqualToString:@"system_managed"]) {
    return [[DBTEAMCOMMONGroupManagementType alloc] initWithSystemManaged];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMCOMMONGroupManagementType alloc] initWithOther];
  } else {
    return [[DBTEAMCOMMONGroupManagementType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONGroupManagementType.h"
#import "DBTEAMCOMMONGroupSummary.h"

#pragma mark - API Object

@implementation DBTEAMCOMMONGroupSummary

#pragma mark - Constructors

- (instancetype)initWithGroupName:(NSString *)groupName
                          groupId:(NSString *)groupId
              groupManagementType:(DBTEAMCOMMONGroupManagementType *)groupManagementType
                  groupExternalId:(NSString *)groupExternalId
                      memberCount:(NSNumber *)memberCount {
  [DBStoneValidators nonnullValidator:nil](groupName);
  [DBStoneValidators nonnullValidator:nil](groupId);
  [DBStoneValidators nonnullValidator:nil](groupManagementType);

  self = [super init];
  if (self) {
    _groupName = groupName;
    _groupId = groupId;
    _groupExternalId = groupExternalId;
    _memberCount = memberCount;
    _groupManagementType = groupManagementType;
  }
  return self;
}

- (instancetype)initWithGroupName:(NSString *)groupName
                          groupId:(NSString *)groupId
              groupManagementType:(DBTEAMCOMMONGroupManagementType *)groupManagementType {
  return [self initWithGroupName:groupName
                         groupId:groupId
             groupManagementType:groupManagementType
                 groupExternalId:nil
                     memberCount:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMCOMMONGroupSummarySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMCOMMONGroupSummarySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMCOMMONGroupSummarySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.groupName hash];
  result = prime * result + [self.groupId hash];
  result = prime * result + [self.groupManagementType hash];
  if (self.groupExternalId != nil) {
    result = prime * result + [self.groupExternalId hash];
  }
  if (self.memberCount != nil) {
    result = prime * result + [self.memberCount hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupSummary:other];
}

- (BOOL)isEqualToGroupSummary:(DBTEAMCOMMONGroupSummary *)aGroupSummary {
  if (self == aGroupSummary) {
    return YES;
  }
  if (![self.groupName isEqual:aGroupSummary.groupName]) {
    return NO;
  }
  if (![self.groupId isEqual:aGroupSummary.groupId]) {
    return NO;
  }
  if (![self.groupManagementType isEqual:aGroupSummary.groupManagementType]) {
    return NO;
  }
  if (self.groupExternalId) {
    if (![self.groupExternalId isEqual:aGroupSummary.groupExternalId]) {
      return NO;
    }
  }
  if (self.memberCount) {
    if (![self.memberCount isEqual:aGroupSummary.memberCount]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMCOMMONGroupSummarySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMCOMMONGroupSummary *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group_name"] = valueObj.groupName;
  jsonDict[@"group_id"] = valueObj.groupId;
  jsonDict[@"group_management_type"] =
      [DBTEAMCOMMONGroupManagementTypeSerializer serialize:valueObj.groupManagementType];
  if (valueObj.groupExternalId) {
    jsonDict[@"group_external_id"] = valueObj.groupExternalId;
  }
  if (valueObj.memberCount) {
    jsonDict[@"member_count"] = valueObj.memberCount;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMCOMMONGroupSummary *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *groupName = valueDict[@"group_name"];
  NSString *groupId = valueDict[@"group_id"];
  DBTEAMCOMMONGroupManagementType *groupManagementType =
      [DBTEAMCOMMONGroupManagementTypeSerializer deserialize:valueDict[@"group_management_type"]];
  NSString *groupExternalId = valueDict[@"group_external_id"] ?: nil;
  NSNumber *memberCount = valueDict[@"member_count"] ?: nil;

  return [[DBTEAMCOMMONGroupSummary alloc] initWithGroupName:groupName
                                                     groupId:groupId
                                         groupManagementType:groupManagementType
                                             groupExternalId:groupExternalId
                                                 memberCount:memberCount];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONGroupType.h"

#pragma mark - API Object

@implementation DBTEAMCOMMONGroupType

#pragma mark - Constructors

- (instancetype)initWithTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONGroupTypeTeam;
  }
  return self;
}

- (instancetype)initWithUserManaged {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONGroupTypeUserManaged;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONGroupTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTeam {
  return _tag == DBTEAMCOMMONGroupTypeTeam;
}

- (BOOL)isUserManaged {
  return _tag == DBTEAMCOMMONGroupTypeUserManaged;
}

- (BOOL)isOther {
  return _tag == DBTEAMCOMMONGroupTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMCOMMONGroupTypeTeam:
    return @"DBTEAMCOMMONGroupTypeTeam";
  case DBTEAMCOMMONGroupTypeUserManaged:
    return @"DBTEAMCOMMONGroupTypeUserManaged";
  case DBTEAMCOMMONGroupTypeOther:
    return @"DBTEAMCOMMONGroupTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMCOMMONGroupTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMCOMMONGroupTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMCOMMONGroupTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMCOMMONGroupTypeTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMCOMMONGroupTypeUserManaged:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMCOMMONGroupTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupType:other];
}

- (BOOL)isEqualToGroupType:(DBTEAMCOMMONGroupType *)aGroupType {
  if (self == aGroupType) {
    return YES;
  }
  if (self.tag != aGroupType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMCOMMONGroupTypeTeam:
    return [[self tagName] isEqual:[aGroupType tagName]];
  case DBTEAMCOMMONGroupTypeUserManaged:
    return [[self tagName] isEqual:[aGroupType tagName]];
  case DBTEAMCOMMONGroupTypeOther:
    return [[self tagName] isEqual:[aGroupType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMCOMMONGroupTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMCOMMONGroupType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTeam]) {
    jsonDict[@".tag"] = @"team";
  } else if ([valueObj isUserManaged]) {
    jsonDict[@".tag"] = @"user_managed";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMCOMMONGroupType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"team"]) {
    return [[DBTEAMCOMMONGroupType alloc] initWithTeam];
  } else if ([tag isEqualToString:@"user_managed"]) {
    return [[DBTEAMCOMMONGroupType alloc] initWithUserManaged];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMCOMMONGroupType alloc] initWithOther];
  } else {
    return [[DBTEAMCOMMONGroupType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONMemberSpaceLimitType.h"

#pragma mark - API Object

@implementation DBTEAMCOMMONMemberSpaceLimitType

#pragma mark - Constructors

- (instancetype)initWithOff {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONMemberSpaceLimitTypeOff;
  }
  return self;
}

- (instancetype)initWithAlertOnly {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONMemberSpaceLimitTypeAlertOnly;
  }
  return self;
}

- (instancetype)initWithStopSync {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONMemberSpaceLimitTypeStopSync;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMCOMMONMemberSpaceLimitTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOff {
  return _tag == DBTEAMCOMMONMemberSpaceLimitTypeOff;
}

- (BOOL)isAlertOnly {
  return _tag == DBTEAMCOMMONMemberSpaceLimitTypeAlertOnly;
}

- (BOOL)isStopSync {
  return _tag == DBTEAMCOMMONMemberSpaceLimitTypeStopSync;
}

- (BOOL)isOther {
  return _tag == DBTEAMCOMMONMemberSpaceLimitTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMCOMMONMemberSpaceLimitTypeOff:
    return @"DBTEAMCOMMONMemberSpaceLimitTypeOff";
  case DBTEAMCOMMONMemberSpaceLimitTypeAlertOnly:
    return @"DBTEAMCOMMONMemberSpaceLimitTypeAlertOnly";
  case DBTEAMCOMMONMemberSpaceLimitTypeStopSync:
    return @"DBTEAMCOMMONMemberSpaceLimitTypeStopSync";
  case DBTEAMCOMMONMemberSpaceLimitTypeOther:
    return @"DBTEAMCOMMONMemberSpaceLimitTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMCOMMONMemberSpaceLimitTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMCOMMONMemberSpaceLimitTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMCOMMONMemberSpaceLimitTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMCOMMONMemberSpaceLimitTypeOff:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMCOMMONMemberSpaceLimitTypeAlertOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMCOMMONMemberSpaceLimitTypeStopSync:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMCOMMONMemberSpaceLimitTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberSpaceLimitType:other];
}

- (BOOL)isEqualToMemberSpaceLimitType:(DBTEAMCOMMONMemberSpaceLimitType *)aMemberSpaceLimitType {
  if (self == aMemberSpaceLimitType) {
    return YES;
  }
  if (self.tag != aMemberSpaceLimitType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMCOMMONMemberSpaceLimitTypeOff:
    return [[self tagName] isEqual:[aMemberSpaceLimitType tagName]];
  case DBTEAMCOMMONMemberSpaceLimitTypeAlertOnly:
    return [[self tagName] isEqual:[aMemberSpaceLimitType tagName]];
  case DBTEAMCOMMONMemberSpaceLimitTypeStopSync:
    return [[self tagName] isEqual:[aMemberSpaceLimitType tagName]];
  case DBTEAMCOMMONMemberSpaceLimitTypeOther:
    return [[self tagName] isEqual:[aMemberSpaceLimitType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMCOMMONMemberSpaceLimitTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMCOMMONMemberSpaceLimitType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOff]) {
    jsonDict[@".tag"] = @"off";
  } else if ([valueObj isAlertOnly]) {
    jsonDict[@".tag"] = @"alert_only";
  } else if ([valueObj isStopSync]) {
    jsonDict[@".tag"] = @"stop_sync";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMCOMMONMemberSpaceLimitType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"off"]) {
    return [[DBTEAMCOMMONMemberSpaceLimitType alloc] initWithOff];
  } else if ([tag isEqualToString:@"alert_only"]) {
    return [[DBTEAMCOMMONMemberSpaceLimitType alloc] initWithAlertOnly];
  } else if ([tag isEqualToString:@"stop_sync"]) {
    return [[DBTEAMCOMMONMemberSpaceLimitType alloc] initWithStopSync];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMCOMMONMemberSpaceLimitType alloc] initWithOther];
  } else {
    return [[DBTEAMCOMMONMemberSpaceLimitType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONTimeRange.h"

#pragma mark - API Object

@implementation DBTEAMCOMMONTimeRange

#pragma mark - Constructors

- (instancetype)initWithStartTime:(NSDate *)startTime endTime:(NSDate *)endTime {

  self = [super init];
  if (self) {
    _startTime = startTime;
    _endTime = endTime;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithStartTime:nil endTime:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMCOMMONTimeRangeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMCOMMONTimeRangeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMCOMMONTimeRangeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.startTime != nil) {
    result = prime * result + [self.startTime hash];
  }
  if (self.endTime != nil) {
    result = prime * result + [self.endTime hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTimeRange:other];
}

- (BOOL)isEqualToTimeRange:(DBTEAMCOMMONTimeRange *)aTimeRange {
  if (self == aTimeRange) {
    return YES;
  }
  if (self.startTime) {
    if (![self.startTime isEqual:aTimeRange.startTime]) {
      return NO;
    }
  }
  if (self.endTime) {
    if (![self.endTime isEqual:aTimeRange.endTime]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMCOMMONTimeRangeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMCOMMONTimeRange *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.startTime) {
    jsonDict[@"start_time"] = [DBNSDateSerializer serialize:valueObj.startTime dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.endTime) {
    jsonDict[@"end_time"] = [DBNSDateSerializer serialize:valueObj.endTime dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMCOMMONTimeRange *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSDate *startTime = valueDict[@"start_time"]
                          ? [DBNSDateSerializer deserialize:valueDict[@"start_time"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                          : nil;
  NSDate *endTime = valueDict[@"end_time"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"end_time"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBTEAMCOMMONTimeRange alloc] initWithStartTime:startTime endTime:endTime];
}

@end
