///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMPOLICIESTeamMemberPolicies;
@class DBTEAMTeamGetInfoResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamGetInfoResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMTeamGetInfoResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The name of the team.
@property (nonatomic, readonly, copy) NSString *name;

/// The ID of the team.
@property (nonatomic, readonly, copy) NSString *teamId;

/// The number of licenses available to the team.
@property (nonatomic, readonly) NSNumber *numLicensedUsers;

/// The number of accounts that have been invited or are already active members
/// of the team.
@property (nonatomic, readonly) NSNumber *numProvisionedUsers;

/// (no description).
@property (nonatomic, readonly) DBTEAMPOLICIESTeamMemberPolicies *policies;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param name The name of the team.
/// @param teamId The ID of the team.
/// @param numLicensedUsers The number of licenses available to the team.
/// @param numProvisionedUsers The number of accounts that have been invited or
/// are already active members of the team.
/// @param policies (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithName:(NSString *)name
                      teamId:(NSString *)teamId
            numLicensedUsers:(NSNumber *)numLicensedUsers
         numProvisionedUsers:(NSNumber *)numProvisionedUsers
                    policies:(DBTEAMPOLICIESTeamMemberPolicies *)policies;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `TeamGetInfoResult` struct.
///
@interface DBTEAMTeamGetInfoResultSerializer : NSObject

///
/// Serializes `DBTEAMTeamGetInfoResult` instances.
///
/// @param instance An instance of the `DBTEAMTeamGetInfoResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMTeamGetInfoResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamGetInfoResult *)instance;

///
/// Deserializes `DBTEAMTeamGetInfoResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMTeamGetInfoResult` API object.
///
/// @return An instantiation of the `DBTEAMTeamGetInfoResult` object.
///
+ (DBTEAMTeamGetInfoResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
