///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMMembersRemoveError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MembersRemoveError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMembersRemoveError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMMembersRemoveErrorTag` enum type represents the possible tag
/// states with which the `DBTEAMMembersRemoveError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMMembersRemoveErrorTag){
    /// No matching user found. The provided team_member_id, email, or
    /// external_id does not exist on this team.
    DBTEAMMembersRemoveErrorUserNotFound,

    /// The user is not a member of the team.
    DBTEAMMembersRemoveErrorUserNotInTeam,

    /// (no description).
    DBTEAMMembersRemoveErrorOther,

    /// Expected removed user and transfer_dest user to be different.
    DBTEAMMembersRemoveErrorRemovedAndTransferDestShouldDiffer,

    /// Expected removed user and transfer_admin user to be different.
    DBTEAMMembersRemoveErrorRemovedAndTransferAdminShouldDiffer,

    /// No matching user found for the argument transfer_dest_id.
    DBTEAMMembersRemoveErrorTransferDestUserNotFound,

    /// The provided transfer_dest_id does not exist on this team.
    DBTEAMMembersRemoveErrorTransferDestUserNotInTeam,

    /// The provided transfer_admin_id does not exist on this team.
    DBTEAMMembersRemoveErrorTransferAdminUserNotInTeam,

    /// No matching user found for the argument transfer_admin_id.
    DBTEAMMembersRemoveErrorTransferAdminUserNotFound,

    /// The transfer_admin_id argument must be provided when file transfer is
    /// requested.
    DBTEAMMembersRemoveErrorUnspecifiedTransferAdminId,

    /// Specified transfer_admin user is not a team admin.
    DBTEAMMembersRemoveErrorTransferAdminIsNotAdmin,

    /// The recipient user's email is not verified.
    DBTEAMMembersRemoveErrorRecipientNotVerified,

    /// The user is the last admin of the team, so it cannot be removed from it.
    DBTEAMMembersRemoveErrorRemoveLastAdmin,

    /// Cannot keep account and transfer the data to another user at the same
    /// time.
    DBTEAMMembersRemoveErrorCannotKeepAccountAndTransfer,

    /// Cannot keep account and delete the data at the same time. To keep the
    /// account the argument wipe_data should be set to false.
    DBTEAMMembersRemoveErrorCannotKeepAccountAndDeleteData,

    /// The email address of the user is too long to be disabled.
    DBTEAMMembersRemoveErrorEmailAddressTooLongToBeDisabled,

    /// Cannot keep account of an invited user.
    DBTEAMMembersRemoveErrorCannotKeepInvitedUserAccount,

    /// Cannot retain team shares when the user's data is marked for deletion on
    /// their linked devices. The argument wipe_data should be set to false.
    DBTEAMMembersRemoveErrorCannotRetainSharesWhenDataWiped,

    /// The user's account must be kept in order to retain team shares. The
    /// argument keep_account should be set to true.
    DBTEAMMembersRemoveErrorCannotRetainSharesWhenNoAccountKept,

    /// Externally sharing files, folders, and links must be enabled in team
    /// settings in order to retain team shares for the user.
    DBTEAMMembersRemoveErrorCannotRetainSharesWhenTeamExternalSharingOff,

    /// Only a team admin, can convert this account to a Basic account.
    DBTEAMMembersRemoveErrorCannotKeepAccount,

    /// This user content is currently being held. To convert this member's
    /// account to a Basic account, you'll first need to remove them from the
    /// hold.
    DBTEAMMembersRemoveErrorCannotKeepAccountUnderLegalHold,

    /// To convert this member to a Basic account, they'll first need to sign in
    /// to Dropbox and agree to the terms of service.
    DBTEAMMembersRemoveErrorCannotKeepAccountRequiredToSignTos,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMMembersRemoveErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "user_not_found".
///
/// Description of the "user_not_found" tag state: No matching user found. The
/// provided team_member_id, email, or external_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserNotFound;

///
/// Initializes union class with tag state of "user_not_in_team".
///
/// Description of the "user_not_in_team" tag state: The user is not a member of
/// the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserNotInTeam;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of
/// "removed_and_transfer_dest_should_differ".
///
/// Description of the "removed_and_transfer_dest_should_differ" tag state:
/// Expected removed user and transfer_dest user to be different.
///
/// @return An initialized instance.
///
- (instancetype)initWithRemovedAndTransferDestShouldDiffer;

///
/// Initializes union class with tag state of
/// "removed_and_transfer_admin_should_differ".
///
/// Description of the "removed_and_transfer_admin_should_differ" tag state:
/// Expected removed user and transfer_admin user to be different.
///
/// @return An initialized instance.
///
- (instancetype)initWithRemovedAndTransferAdminShouldDiffer;

///
/// Initializes union class with tag state of "transfer_dest_user_not_found".
///
/// Description of the "transfer_dest_user_not_found" tag state: No matching
/// user found for the argument transfer_dest_id.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferDestUserNotFound;

///
/// Initializes union class with tag state of "transfer_dest_user_not_in_team".
///
/// Description of the "transfer_dest_user_not_in_team" tag state: The provided
/// transfer_dest_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferDestUserNotInTeam;

///
/// Initializes union class with tag state of "transfer_admin_user_not_in_team".
///
/// Description of the "transfer_admin_user_not_in_team" tag state: The provided
/// transfer_admin_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferAdminUserNotInTeam;

///
/// Initializes union class with tag state of "transfer_admin_user_not_found".
///
/// Description of the "transfer_admin_user_not_found" tag state: No matching
/// user found for the argument transfer_admin_id.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferAdminUserNotFound;

///
/// Initializes union class with tag state of "unspecified_transfer_admin_id".
///
/// Description of the "unspecified_transfer_admin_id" tag state: The
/// transfer_admin_id argument must be provided when file transfer is requested.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnspecifiedTransferAdminId;

///
/// Initializes union class with tag state of "transfer_admin_is_not_admin".
///
/// Description of the "transfer_admin_is_not_admin" tag state: Specified
/// transfer_admin user is not a team admin.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferAdminIsNotAdmin;

///
/// Initializes union class with tag state of "recipient_not_verified".
///
/// Description of the "recipient_not_verified" tag state: The recipient user's
/// email is not verified.
///
/// @return An initialized instance.
///
- (instancetype)initWithRecipientNotVerified;

///
/// Initializes union class with tag state of "remove_last_admin".
///
/// Description of the "remove_last_admin" tag state: The user is the last admin
/// of the team, so it cannot be removed from it.
///
/// @return An initialized instance.
///
- (instancetype)initWithRemoveLastAdmin;

///
/// Initializes union class with tag state of
/// "cannot_keep_account_and_transfer".
///
/// Description of the "cannot_keep_account_and_transfer" tag state: Cannot keep
/// account and transfer the data to another user at the same time.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotKeepAccountAndTransfer;

///
/// Initializes union class with tag state of
/// "cannot_keep_account_and_delete_data".
///
/// Description of the "cannot_keep_account_and_delete_data" tag state: Cannot
/// keep account and delete the data at the same time. To keep the account the
/// argument wipe_data should be set to false.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotKeepAccountAndDeleteData;

///
/// Initializes union class with tag state of
/// "email_address_too_long_to_be_disabled".
///
/// Description of the "email_address_too_long_to_be_disabled" tag state: The
/// email address of the user is too long to be disabled.
///
/// @return An initialized instance.
///
- (instancetype)initWithEmailAddressTooLongToBeDisabled;

///
/// Initializes union class with tag state of
/// "cannot_keep_invited_user_account".
///
/// Description of the "cannot_keep_invited_user_account" tag state: Cannot keep
/// account of an invited user.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotKeepInvitedUserAccount;

///
/// Initializes union class with tag state of
/// "cannot_retain_shares_when_data_wiped".
///
/// Description of the "cannot_retain_shares_when_data_wiped" tag state: Cannot
/// retain team shares when the user's data is marked for deletion on their
/// linked devices. The argument wipe_data should be set to false.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotRetainSharesWhenDataWiped;

///
/// Initializes union class with tag state of
/// "cannot_retain_shares_when_no_account_kept".
///
/// Description of the "cannot_retain_shares_when_no_account_kept" tag state:
/// The user's account must be kept in order to retain team shares. The argument
/// keep_account should be set to true.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotRetainSharesWhenNoAccountKept;

///
/// Initializes union class with tag state of
/// "cannot_retain_shares_when_team_external_sharing_off".
///
/// Description of the "cannot_retain_shares_when_team_external_sharing_off" tag
/// state: Externally sharing files, folders, and links must be enabled in team
/// settings in order to retain team shares for the user.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotRetainSharesWhenTeamExternalSharingOff;

///
/// Initializes union class with tag state of "cannot_keep_account".
///
/// Description of the "cannot_keep_account" tag state: Only a team admin, can
/// convert this account to a Basic account.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotKeepAccount;

///
/// Initializes union class with tag state of
/// "cannot_keep_account_under_legal_hold".
///
/// Description of the "cannot_keep_account_under_legal_hold" tag state: This
/// user content is currently being held. To convert this member's account to a
/// Basic account, you'll first need to remove them from the hold.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotKeepAccountUnderLegalHold;

///
/// Initializes union class with tag state of
/// "cannot_keep_account_required_to_sign_tos".
///
/// Description of the "cannot_keep_account_required_to_sign_tos" tag state: To
/// convert this member to a Basic account, they'll first need to sign in to
/// Dropbox and agree to the terms of service.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotKeepAccountRequiredToSignTos;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "user_not_found".
///
/// @return Whether the union's current tag state has value "user_not_found".
///
- (BOOL)isUserNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "user_not_in_team".
///
/// @return Whether the union's current tag state has value "user_not_in_team".
///
- (BOOL)isUserNotInTeam;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value
/// "removed_and_transfer_dest_should_differ".
///
/// @return Whether the union's current tag state has value
/// "removed_and_transfer_dest_should_differ".
///
- (BOOL)isRemovedAndTransferDestShouldDiffer;

///
/// Retrieves whether the union's current tag state has value
/// "removed_and_transfer_admin_should_differ".
///
/// @return Whether the union's current tag state has value
/// "removed_and_transfer_admin_should_differ".
///
- (BOOL)isRemovedAndTransferAdminShouldDiffer;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_dest_user_not_found".
///
/// @return Whether the union's current tag state has value
/// "transfer_dest_user_not_found".
///
- (BOOL)isTransferDestUserNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_dest_user_not_in_team".
///
/// @return Whether the union's current tag state has value
/// "transfer_dest_user_not_in_team".
///
- (BOOL)isTransferDestUserNotInTeam;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_admin_user_not_in_team".
///
/// @return Whether the union's current tag state has value
/// "transfer_admin_user_not_in_team".
///
- (BOOL)isTransferAdminUserNotInTeam;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_admin_user_not_found".
///
/// @return Whether the union's current tag state has value
/// "transfer_admin_user_not_found".
///
- (BOOL)isTransferAdminUserNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "unspecified_transfer_admin_id".
///
/// @return Whether the union's current tag state has value
/// "unspecified_transfer_admin_id".
///
- (BOOL)isUnspecifiedTransferAdminId;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_admin_is_not_admin".
///
/// @return Whether the union's current tag state has value
/// "transfer_admin_is_not_admin".
///
- (BOOL)isTransferAdminIsNotAdmin;

///
/// Retrieves whether the union's current tag state has value
/// "recipient_not_verified".
///
/// @return Whether the union's current tag state has value
/// "recipient_not_verified".
///
- (BOOL)isRecipientNotVerified;

///
/// Retrieves whether the union's current tag state has value
/// "remove_last_admin".
///
/// @return Whether the union's current tag state has value "remove_last_admin".
///
- (BOOL)isRemoveLastAdmin;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_keep_account_and_transfer".
///
/// @return Whether the union's current tag state has value
/// "cannot_keep_account_and_transfer".
///
- (BOOL)isCannotKeepAccountAndTransfer;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_keep_account_and_delete_data".
///
/// @return Whether the union's current tag state has value
/// "cannot_keep_account_and_delete_data".
///
- (BOOL)isCannotKeepAccountAndDeleteData;

///
/// Retrieves whether the union's current tag state has value
/// "email_address_too_long_to_be_disabled".
///
/// @return Whether the union's current tag state has value
/// "email_address_too_long_to_be_disabled".
///
- (BOOL)isEmailAddressTooLongToBeDisabled;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_keep_invited_user_account".
///
/// @return Whether the union's current tag state has value
/// "cannot_keep_invited_user_account".
///
- (BOOL)isCannotKeepInvitedUserAccount;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_retain_shares_when_data_wiped".
///
/// @return Whether the union's current tag state has value
/// "cannot_retain_shares_when_data_wiped".
///
- (BOOL)isCannotRetainSharesWhenDataWiped;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_retain_shares_when_no_account_kept".
///
/// @return Whether the union's current tag state has value
/// "cannot_retain_shares_when_no_account_kept".
///
- (BOOL)isCannotRetainSharesWhenNoAccountKept;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_retain_shares_when_team_external_sharing_off".
///
/// @return Whether the union's current tag state has value
/// "cannot_retain_shares_when_team_external_sharing_off".
///
- (BOOL)isCannotRetainSharesWhenTeamExternalSharingOff;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_keep_account".
///
/// @return Whether the union's current tag state has value
/// "cannot_keep_account".
///
- (BOOL)isCannotKeepAccount;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_keep_account_under_legal_hold".
///
/// @return Whether the union's current tag state has value
/// "cannot_keep_account_under_legal_hold".
///
- (BOOL)isCannotKeepAccountUnderLegalHold;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_keep_account_required_to_sign_tos".
///
/// @return Whether the union's current tag state has value
/// "cannot_keep_account_required_to_sign_tos".
///
- (BOOL)isCannotKeepAccountRequiredToSignTos;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMMembersRemoveError` union.
///
@interface DBTEAMMembersRemoveErrorSerializer : NSObject

///
/// Serializes `DBTEAMMembersRemoveError` instances.
///
/// @param instance An instance of the `DBTEAMMembersRemoveError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMembersRemoveError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersRemoveError *)instance;

///
/// Deserializes `DBTEAMMembersRemoveError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMembersRemoveError` API object.
///
/// @return An instantiation of the `DBTEAMMembersRemoveError` object.
///
+ (DBTEAMMembersRemoveError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
