///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMAdminTier;
@class DBTEAMMemberAddArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberAddArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMemberAddArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// (no description).
@property (nonatomic, readonly, copy) NSString *memberEmail;

/// Member's first name.
@property (nonatomic, readonly, copy, nullable) NSString *memberGivenName;

/// Member's last name.
@property (nonatomic, readonly, copy, nullable) NSString *memberSurname;

/// External ID for member.
@property (nonatomic, readonly, copy, nullable) NSString *memberExternalId;

/// Persistent ID for member. This field is only available to teams using
/// persistent ID SAML configuration.
@property (nonatomic, readonly, copy, nullable) NSString *memberPersistentId;

/// Whether to send a welcome email to the member. If send_welcome_email is
/// false, no email invitation will be sent to the user. This may be useful for
/// apps using single sign-on (SSO) flows for onboarding that want to handle
/// announcements themselves.
@property (nonatomic, readonly) NSNumber *sendWelcomeEmail;

/// (no description).
@property (nonatomic, readonly) DBTEAMAdminTier *role;

/// Whether a user is directory restricted.
@property (nonatomic, readonly, nullable) NSNumber *isDirectoryRestricted;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param memberEmail (no description).
/// @param memberGivenName Member's first name.
/// @param memberSurname Member's last name.
/// @param memberExternalId External ID for member.
/// @param memberPersistentId Persistent ID for member. This field is only
/// available to teams using persistent ID SAML configuration.
/// @param sendWelcomeEmail Whether to send a welcome email to the member. If
/// send_welcome_email is false, no email invitation will be sent to the user.
/// This may be useful for apps using single sign-on (SSO) flows for onboarding
/// that want to handle announcements themselves.
/// @param role (no description).
/// @param isDirectoryRestricted Whether a user is directory restricted.
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberEmail:(NSString *)memberEmail
                    memberGivenName:(nullable NSString *)memberGivenName
                      memberSurname:(nullable NSString *)memberSurname
                   memberExternalId:(nullable NSString *)memberExternalId
                 memberPersistentId:(nullable NSString *)memberPersistentId
                   sendWelcomeEmail:(nullable NSNumber *)sendWelcomeEmail
                               role:(nullable DBTEAMAdminTier *)role
              isDirectoryRestricted:(nullable NSNumber *)isDirectoryRestricted;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param memberEmail (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberEmail:(NSString *)memberEmail;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MemberAddArg` struct.
///
@interface DBTEAMMemberAddArgSerializer : NSObject

///
/// Serializes `DBTEAMMemberAddArg` instances.
///
/// @param instance An instance of the `DBTEAMMemberAddArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMemberAddArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberAddArg *)instance;

///
/// Deserializes `DBTEAMMemberAddArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMemberAddArg` API object.
///
/// @return An instantiation of the `DBTEAMMemberAddArg` object.
///
+ (DBTEAMMemberAddArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
