///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMGroupCreateError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GroupCreateError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMGroupCreateError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMGroupCreateErrorTag` enum type represents the possible tag states
/// with which the `DBTEAMGroupCreateError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMGroupCreateErrorTag){
    /// The requested group name is already being used by another group.
    DBTEAMGroupCreateErrorGroupNameAlreadyUsed,

    /// Group name is empty or has invalid characters.
    DBTEAMGroupCreateErrorGroupNameInvalid,

    /// The requested external ID is already being used by another group.
    DBTEAMGroupCreateErrorExternalIdAlreadyInUse,

    /// System-managed group cannot be manually created.
    DBTEAMGroupCreateErrorSystemManagedGroupDisallowed,

    /// (no description).
    DBTEAMGroupCreateErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMGroupCreateErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "group_name_already_used".
///
/// Description of the "group_name_already_used" tag state: The requested group
/// name is already being used by another group.
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupNameAlreadyUsed;

///
/// Initializes union class with tag state of "group_name_invalid".
///
/// Description of the "group_name_invalid" tag state: Group name is empty or
/// has invalid characters.
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupNameInvalid;

///
/// Initializes union class with tag state of "external_id_already_in_use".
///
/// Description of the "external_id_already_in_use" tag state: The requested
/// external ID is already being used by another group.
///
/// @return An initialized instance.
///
- (instancetype)initWithExternalIdAlreadyInUse;

///
/// Initializes union class with tag state of "system_managed_group_disallowed".
///
/// Description of the "system_managed_group_disallowed" tag state:
/// System-managed group cannot be manually created.
///
/// @return An initialized instance.
///
- (instancetype)initWithSystemManagedGroupDisallowed;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "group_name_already_used".
///
/// @return Whether the union's current tag state has value
/// "group_name_already_used".
///
- (BOOL)isGroupNameAlreadyUsed;

///
/// Retrieves whether the union's current tag state has value
/// "group_name_invalid".
///
/// @return Whether the union's current tag state has value
/// "group_name_invalid".
///
- (BOOL)isGroupNameInvalid;

///
/// Retrieves whether the union's current tag state has value
/// "external_id_already_in_use".
///
/// @return Whether the union's current tag state has value
/// "external_id_already_in_use".
///
- (BOOL)isExternalIdAlreadyInUse;

///
/// Retrieves whether the union's current tag state has value
/// "system_managed_group_disallowed".
///
/// @return Whether the union's current tag state has value
/// "system_managed_group_disallowed".
///
- (BOOL)isSystemManagedGroupDisallowed;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMGroupCreateError` union.
///
@interface DBTEAMGroupCreateErrorSerializer : NSObject

///
/// Serializes `DBTEAMGroupCreateError` instances.
///
/// @param instance An instance of the `DBTEAMGroupCreateError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMGroupCreateError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupCreateError *)instance;

///
/// Deserializes `DBTEAMGroupCreateError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMGroupCreateError` API object.
///
/// @return An instantiation of the `DBTEAMGroupCreateError` object.
///
+ (DBTEAMGroupCreateError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
