///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMCustomQuotaResult;
@class DBTEAMUserCustomQuotaResult;
@class DBTEAMUserSelectorArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `CustomQuotaResult` union.
///
/// User custom quota.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMCustomQuotaResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMCustomQuotaResultTag` enum type represents the possible tag
/// states with which the `DBTEAMCustomQuotaResult` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMCustomQuotaResultTag){
    /// User's custom quota.
    DBTEAMCustomQuotaResultSuccess,

    /// Invalid user (not in team).
    DBTEAMCustomQuotaResultInvalidUser,

    /// (no description).
    DBTEAMCustomQuotaResultOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMCustomQuotaResultTag tag;

/// User's custom quota. @note Ensure the `isSuccess` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMUserCustomQuotaResult *success;

/// Invalid user (not in team). @note Ensure the `isInvalidUser` method returns
/// true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMUserSelectorArg *invalidUser;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "success".
///
/// Description of the "success" tag state: User's custom quota.
///
/// @param success User's custom quota.
///
/// @return An initialized instance.
///
- (instancetype)initWithSuccess:(DBTEAMUserCustomQuotaResult *)success;

///
/// Initializes union class with tag state of "invalid_user".
///
/// Description of the "invalid_user" tag state: Invalid user (not in team).
///
/// @param invalidUser Invalid user (not in team).
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidUser:(DBTEAMUserSelectorArg *)invalidUser;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "success".
///
/// @note Call this method and ensure it returns true before accessing the
/// `success` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "success".
///
- (BOOL)isSuccess;

///
/// Retrieves whether the union's current tag state has value "invalid_user".
///
/// @note Call this method and ensure it returns true before accessing the
/// `invalidUser` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "invalid_user".
///
- (BOOL)isInvalidUser;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMCustomQuotaResult` union.
///
@interface DBTEAMCustomQuotaResultSerializer : NSObject

///
/// Serializes `DBTEAMCustomQuotaResult` instances.
///
/// @param instance An instance of the `DBTEAMCustomQuotaResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMCustomQuotaResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMCustomQuotaResult *)instance;

///
/// Deserializes `DBTEAMCustomQuotaResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMCustomQuotaResult` API object.
///
/// @return An instantiation of the `DBTEAMCustomQuotaResult` object.
///
+ (DBTEAMCustomQuotaResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
