///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGRequestedVisibility;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `RequestedVisibility` union.
///
/// The access permission that can be requested by the caller for the shared
/// link. Note that the final resolved visibility of the shared link takes into
/// account other aspects, such as team and shared folder settings. Check the
/// ResolvedVisibility for more info on the possible resolved visibility values
/// of shared links.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGRequestedVisibility : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGRequestedVisibilityTag` enum type represents the possible tag
/// states with which the `DBSHARINGRequestedVisibility` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGRequestedVisibilityTag){
    /// Anyone who has received the link can access it. No login required.
    DBSHARINGRequestedVisibilityPublic,

    /// Only members of the same team can access the link. Login is required.
    DBSHARINGRequestedVisibilityTeamOnly,

    /// A link-specific password is required to access the link. Login is not
    /// required.
    DBSHARINGRequestedVisibilityPassword,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGRequestedVisibilityTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "public".
///
/// Description of the "public" tag state: Anyone who has received the link can
/// access it. No login required.
///
/// @return An initialized instance.
///
- (instancetype)initWithPublic;

///
/// Initializes union class with tag state of "team_only".
///
/// Description of the "team_only" tag state: Only members of the same team can
/// access the link. Login is required.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamOnly;

///
/// Initializes union class with tag state of "password".
///
/// Description of the "password" tag state: A link-specific password is
/// required to access the link. Login is not required.
///
/// @return An initialized instance.
///
- (instancetype)initWithPassword;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "public".
///
/// @return Whether the union's current tag state has value "public".
///
- (BOOL)isPublic;

///
/// Retrieves whether the union's current tag state has value "team_only".
///
/// @return Whether the union's current tag state has value "team_only".
///
- (BOOL)isTeamOnly;

///
/// Retrieves whether the union's current tag state has value "password".
///
/// @return Whether the union's current tag state has value "password".
///
- (BOOL)isPassword;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGRequestedVisibility` union.
///
@interface DBSHARINGRequestedVisibilitySerializer : NSObject

///
/// Serializes `DBSHARINGRequestedVisibility` instances.
///
/// @param instance An instance of the `DBSHARINGRequestedVisibility` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGRequestedVisibility` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGRequestedVisibility *)instance;

///
/// Deserializes `DBSHARINGRequestedVisibility` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGRequestedVisibility` API object.
///
/// @return An instantiation of the `DBSHARINGRequestedVisibility` object.
///
+ (DBSHARINGRequestedVisibility *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
