///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGAccessInheritance;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AccessInheritance` union.
///
/// Information about the inheritance policy of a shared folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGAccessInheritance : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGAccessInheritanceTag` enum type represents the possible tag
/// states with which the `DBSHARINGAccessInheritance` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGAccessInheritanceTag){
    /// The shared folder inherits its members from the parent folder.
    DBSHARINGAccessInheritanceInherit,

    /// The shared folder does not inherit its members from the parent folder.
    DBSHARINGAccessInheritanceNoInherit,

    /// (no description).
    DBSHARINGAccessInheritanceOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGAccessInheritanceTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "inherit".
///
/// Description of the "inherit" tag state: The shared folder inherits its
/// members from the parent folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithInherit;

///
/// Initializes union class with tag state of "no_inherit".
///
/// Description of the "no_inherit" tag state: The shared folder does not
/// inherit its members from the parent folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithNoInherit;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "inherit".
///
/// @return Whether the union's current tag state has value "inherit".
///
- (BOOL)isInherit;

///
/// Retrieves whether the union's current tag state has value "no_inherit".
///
/// @return Whether the union's current tag state has value "no_inherit".
///
- (BOOL)isNoInherit;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGAccessInheritance` union.
///
@interface DBSHARINGAccessInheritanceSerializer : NSObject

///
/// Serializes `DBSHARINGAccessInheritance` instances.
///
/// @param instance An instance of the `DBSHARINGAccessInheritance` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGAccessInheritance` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGAccessInheritance *)instance;

///
/// Deserializes `DBSHARINGAccessInheritance` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGAccessInheritance` API object.
///
/// @return An instantiation of the `DBSHARINGAccessInheritance` object.
///
+ (DBSHARINGAccessInheritance *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
