///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESThumbnailArg;
@class DBFILESThumbnailFormat;
@class DBFILESThumbnailMode;
@class DBFILESThumbnailSize;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ThumbnailArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESThumbnailArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The path to the image file you want to thumbnail.
@property (nonatomic, readonly, copy) NSString *path;

/// The format for the thumbnail image, jpeg (default) or png. For  images that
/// are photos, jpeg should be preferred, while png is  better for screenshots
/// and digital arts.
@property (nonatomic, readonly) DBFILESThumbnailFormat *format;

/// The size for the thumbnail image.
@property (nonatomic, readonly) DBFILESThumbnailSize *size;

/// How to resize and crop the image to achieve the desired size.
@property (nonatomic, readonly) DBFILESThumbnailMode *mode;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param path The path to the image file you want to thumbnail.
/// @param format The format for the thumbnail image, jpeg (default) or png. For
/// images that are photos, jpeg should be preferred, while png is  better for
/// screenshots and digital arts.
/// @param size The size for the thumbnail image.
/// @param mode How to resize and crop the image to achieve the desired size.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path
                      format:(nullable DBFILESThumbnailFormat *)format
                        size:(nullable DBFILESThumbnailSize *)size
                        mode:(nullable DBFILESThumbnailMode *)mode;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param path The path to the image file you want to thumbnail.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ThumbnailArg` struct.
///
@interface DBFILESThumbnailArgSerializer : NSObject

///
/// Serializes `DBFILESThumbnailArg` instances.
///
/// @param instance An instance of the `DBFILESThumbnailArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESThumbnailArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailArg *)instance;

///
/// Deserializes `DBFILESThumbnailArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESThumbnailArg` API object.
///
/// @return An instantiation of the `DBFILESThumbnailArg` object.
///
+ (DBFILESThumbnailArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
