///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBFILESFileOpsResult.h"
#import "DBSerializableProtocol.h"

@class DBFILESMetadata;
@class DBFILESRelocationResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `RelocationResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESRelocationResult : DBFILESFileOpsResult <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Metadata of the relocated object.
@property (nonatomic, readonly) DBFILESMetadata *metadata;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param metadata Metadata of the relocated object.
///
/// @return An initialized instance.
///
- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `RelocationResult` struct.
///
@interface DBFILESRelocationResultSerializer : NSObject

///
/// Serializes `DBFILESRelocationResult` instances.
///
/// @param instance An instance of the `DBFILESRelocationResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESRelocationResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationResult *)instance;

///
/// Deserializes `DBFILESRelocationResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESRelocationResult` API object.
///
/// @return An instantiation of the `DBFILESRelocationResult` object.
///
+ (DBFILESRelocationResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
