///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESLookupError;
@class DBFILESPaperUpdateError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperUpdateError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESPaperUpdateError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESPaperUpdateErrorTag` enum type represents the possible tag
/// states with which the `DBFILESPaperUpdateError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESPaperUpdateErrorTag){
    /// Your account does not have permissions to edit Paper docs.
    DBFILESPaperUpdateErrorInsufficientPermissions,

    /// The provided content was malformed and cannot be imported to Paper.
    DBFILESPaperUpdateErrorContentMalformed,

    /// The Paper doc would be too large, split the content into multiple docs.
    DBFILESPaperUpdateErrorDocLengthExceeded,

    /// The imported document contains an image that is too large. The current
    /// limit is 1MB. This only applies to HTML with data URI.
    DBFILESPaperUpdateErrorImageSizeExceeded,

    /// (no description).
    DBFILESPaperUpdateErrorOther,

    /// (no description).
    DBFILESPaperUpdateErrorPath,

    /// The provided revision does not match the document head.
    DBFILESPaperUpdateErrorRevisionMismatch,

    /// This operation is not allowed on archived Paper docs.
    DBFILESPaperUpdateErrorDocArchived,

    /// This operation is not allowed on deleted Paper docs.
    DBFILESPaperUpdateErrorDocDeleted,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESPaperUpdateErrorTag tag;

/// (no description). @note Ensure the `isPath` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESLookupError *path;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "insufficient_permissions".
///
/// Description of the "insufficient_permissions" tag state: Your account does
/// not have permissions to edit Paper docs.
///
/// @return An initialized instance.
///
- (instancetype)initWithInsufficientPermissions;

///
/// Initializes union class with tag state of "content_malformed".
///
/// Description of the "content_malformed" tag state: The provided content was
/// malformed and cannot be imported to Paper.
///
/// @return An initialized instance.
///
- (instancetype)initWithContentMalformed;

///
/// Initializes union class with tag state of "doc_length_exceeded".
///
/// Description of the "doc_length_exceeded" tag state: The Paper doc would be
/// too large, split the content into multiple docs.
///
/// @return An initialized instance.
///
- (instancetype)initWithDocLengthExceeded;

///
/// Initializes union class with tag state of "image_size_exceeded".
///
/// Description of the "image_size_exceeded" tag state: The imported document
/// contains an image that is too large. The current limit is 1MB. This only
/// applies to HTML with data URI.
///
/// @return An initialized instance.
///
- (instancetype)initWithImageSizeExceeded;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of "path".
///
/// @param path (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(DBFILESLookupError *)path;

///
/// Initializes union class with tag state of "revision_mismatch".
///
/// Description of the "revision_mismatch" tag state: The provided revision does
/// not match the document head.
///
/// @return An initialized instance.
///
- (instancetype)initWithRevisionMismatch;

///
/// Initializes union class with tag state of "doc_archived".
///
/// Description of the "doc_archived" tag state: This operation is not allowed
/// on archived Paper docs.
///
/// @return An initialized instance.
///
- (instancetype)initWithDocArchived;

///
/// Initializes union class with tag state of "doc_deleted".
///
/// Description of the "doc_deleted" tag state: This operation is not allowed on
/// deleted Paper docs.
///
/// @return An initialized instance.
///
- (instancetype)initWithDocDeleted;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "insufficient_permissions".
///
/// @return Whether the union's current tag state has value
/// "insufficient_permissions".
///
- (BOOL)isInsufficientPermissions;

///
/// Retrieves whether the union's current tag state has value
/// "content_malformed".
///
/// @return Whether the union's current tag state has value "content_malformed".
///
- (BOOL)isContentMalformed;

///
/// Retrieves whether the union's current tag state has value
/// "doc_length_exceeded".
///
/// @return Whether the union's current tag state has value
/// "doc_length_exceeded".
///
- (BOOL)isDocLengthExceeded;

///
/// Retrieves whether the union's current tag state has value
/// "image_size_exceeded".
///
/// @return Whether the union's current tag state has value
/// "image_size_exceeded".
///
- (BOOL)isImageSizeExceeded;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value "path".
///
/// @note Call this method and ensure it returns true before accessing the
/// `path` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path".
///
- (BOOL)isPath;

///
/// Retrieves whether the union's current tag state has value
/// "revision_mismatch".
///
/// @return Whether the union's current tag state has value "revision_mismatch".
///
- (BOOL)isRevisionMismatch;

///
/// Retrieves whether the union's current tag state has value "doc_archived".
///
/// @return Whether the union's current tag state has value "doc_archived".
///
- (BOOL)isDocArchived;

///
/// Retrieves whether the union's current tag state has value "doc_deleted".
///
/// @return Whether the union's current tag state has value "doc_deleted".
///
- (BOOL)isDocDeleted;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESPaperUpdateError` union.
///
@interface DBFILESPaperUpdateErrorSerializer : NSObject

///
/// Serializes `DBFILESPaperUpdateError` instances.
///
/// @param instance An instance of the `DBFILESPaperUpdateError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESPaperUpdateError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESPaperUpdateError *)instance;

///
/// Deserializes `DBFILESPaperUpdateError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESPaperUpdateError` API object.
///
/// @return An instantiation of the `DBFILESPaperUpdateError` object.
///
+ (DBFILESPaperUpdateError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
