///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESMetadata;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `Metadata` struct.
///
/// Metadata for a file or folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESMetadata : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The last component of the path (including extension). This never contains a
/// slash.
@property (nonatomic, readonly, copy) NSString *name;

/// The lowercased full path in the user's Dropbox. This always starts with a
/// slash. This field will be null if the file or folder is not mounted.
@property (nonatomic, readonly, copy, nullable) NSString *pathLower;

/// The cased path to be used for display purposes only. In rare instances the
/// casing will not correctly match the user's filesystem, but this behavior
/// will match the path provided in the Core API v1, and at least the last path
/// component will have the correct casing. Changes to only the casing of paths
/// won't be returned by `listFolderContinue`. This field will be null if the
/// file or folder is not mounted.
@property (nonatomic, readonly, copy, nullable) NSString *pathDisplay;

/// Please use `parentSharedFolderId` in `DBFILESFileSharingInfo` or
/// `parentSharedFolderId` in `DBFILESFolderSharingInfo` instead.
@property (nonatomic, readonly, copy, nullable) NSString *parentSharedFolderId;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param name The last component of the path (including extension). This never
/// contains a slash.
/// @param pathLower The lowercased full path in the user's Dropbox. This always
/// starts with a slash. This field will be null if the file or folder is not
/// mounted.
/// @param pathDisplay The cased path to be used for display purposes only. In
/// rare instances the casing will not correctly match the user's filesystem,
/// but this behavior will match the path provided in the Core API v1, and at
/// least the last path component will have the correct casing. Changes to only
/// the casing of paths won't be returned by `listFolderContinue`. This field
/// will be null if the file or folder is not mounted.
/// @param parentSharedFolderId Please use `parentSharedFolderId` in
/// `DBFILESFileSharingInfo` or `parentSharedFolderId` in
/// `DBFILESFolderSharingInfo` instead.
///
/// @return An initialized instance.
///
- (instancetype)initWithName:(NSString *)name
                   pathLower:(nullable NSString *)pathLower
                 pathDisplay:(nullable NSString *)pathDisplay
        parentSharedFolderId:(nullable NSString *)parentSharedFolderId;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param name The last component of the path (including extension). This never
/// contains a slash.
///
/// @return An initialized instance.
///
- (instancetype)initWithName:(NSString *)name;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `Metadata` struct.
///
@interface DBFILESMetadataSerializer : NSObject

///
/// Serializes `DBFILESMetadata` instances.
///
/// @param instance An instance of the `DBFILESMetadata` API object.
///
/// @return A json-compatible dictionary representation of the `DBFILESMetadata`
/// API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESMetadata *)instance;

///
/// Deserializes `DBFILESMetadata` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESMetadata` API object.
///
/// @return An instantiation of the `DBFILESMetadata` object.
///
+ (DBFILESMetadata *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
