///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESTemplateFilterBase;
@class DBFILESListFolderArg;
@class DBFILESSharedLink;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListFolderArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESListFolderArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// A unique identifier for the file.
@property (nonatomic, readonly, copy) NSString *path;

/// If true, the list folder operation will be applied recursively to all
/// subfolders and the response will contain contents of all subfolders.
@property (nonatomic, readonly) NSNumber *recursive;

/// If true, `mediaInfo` in `DBFILESFileMetadata` is set for photo and video.
/// This parameter will no longer have an effect starting December 2, 2019.
@property (nonatomic, readonly) NSNumber *includeMediaInfo;

/// If true, the results will include entries for files and folders that used to
/// exist but were deleted.
@property (nonatomic, readonly) NSNumber *includeDeleted;

/// If true, the results will include a flag for each file indicating whether or
/// not  that file has any explicit members.
@property (nonatomic, readonly) NSNumber *includeHasExplicitSharedMembers;

/// If true, the results will include entries under mounted folders which
/// includes app folder, shared folder and team folder.
@property (nonatomic, readonly) NSNumber *includeMountedFolders;

/// The maximum number of results to return per request. Note: This is an
/// approximate number and there can be slightly more entries returned in some
/// cases.
@property (nonatomic, readonly, nullable) NSNumber *limit;

/// A shared link to list the contents of. If the link is password-protected,
/// the password must be provided. If this field is present, `path` in
/// `DBFILESListFolderArg` will be relative to root of the shared link. Only
/// non-recursive mode is supported for shared link.
@property (nonatomic, readonly, nullable) DBFILESSharedLink *sharedLink;

/// If set to a valid list of template IDs, `propertyGroups` in
/// `DBFILESFileMetadata` is set if there exists property data associated with
/// the file and each of the listed templates.
@property (nonatomic, readonly, nullable) DBFILEPROPERTIESTemplateFilterBase *includePropertyGroups;

/// If true, include files that are not downloadable, i.e. Google Docs.
@property (nonatomic, readonly) NSNumber *includeNonDownloadableFiles;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param path A unique identifier for the file.
/// @param recursive If true, the list folder operation will be applied
/// recursively to all subfolders and the response will contain contents of all
/// subfolders.
/// @param includeMediaInfo If true, `mediaInfo` in `DBFILESFileMetadata` is set
/// for photo and video. This parameter will no longer have an effect starting
/// December 2, 2019.
/// @param includeDeleted If true, the results will include entries for files
/// and folders that used to exist but were deleted.
/// @param includeHasExplicitSharedMembers If true, the results will include a
/// flag for each file indicating whether or not  that file has any explicit
/// members.
/// @param includeMountedFolders If true, the results will include entries under
/// mounted folders which includes app folder, shared folder and team folder.
/// @param limit The maximum number of results to return per request. Note: This
/// is an approximate number and there can be slightly more entries returned in
/// some cases.
/// @param sharedLink A shared link to list the contents of. If the link is
/// password-protected, the password must be provided. If this field is present,
/// `path` in `DBFILESListFolderArg` will be relative to root of the shared
/// link. Only non-recursive mode is supported for shared link.
/// @param includePropertyGroups If set to a valid list of template IDs,
/// `propertyGroups` in `DBFILESFileMetadata` is set if there exists property
/// data associated with the file and each of the listed templates.
/// @param includeNonDownloadableFiles If true, include files that are not
/// downloadable, i.e. Google Docs.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path
                          recursive:(nullable NSNumber *)recursive
                   includeMediaInfo:(nullable NSNumber *)includeMediaInfo
                     includeDeleted:(nullable NSNumber *)includeDeleted
    includeHasExplicitSharedMembers:(nullable NSNumber *)includeHasExplicitSharedMembers
              includeMountedFolders:(nullable NSNumber *)includeMountedFolders
                              limit:(nullable NSNumber *)limit
                         sharedLink:(nullable DBFILESSharedLink *)sharedLink
              includePropertyGroups:(nullable DBFILEPROPERTIESTemplateFilterBase *)includePropertyGroups
        includeNonDownloadableFiles:(nullable NSNumber *)includeNonDownloadableFiles;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param path A unique identifier for the file.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ListFolderArg` struct.
///
@interface DBFILESListFolderArgSerializer : NSObject

///
/// Serializes `DBFILESListFolderArg` instances.
///
/// @param instance An instance of the `DBFILESListFolderArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESListFolderArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderArg *)instance;

///
/// Deserializes `DBFILESListFolderArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESListFolderArg` API object.
///
/// @return An instantiation of the `DBFILESListFolderArg` object.
///
+ (DBFILESListFolderArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
