///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `Files` namespace.

#import "DBFILEPROPERTIESTemplateFilterBase.h"
#import "DBFILESGetMetadataArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetMetadataArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                   includeMediaInfo:(NSNumber *)includeMediaInfo
                     includeDeleted:(NSNumber *)includeDeleted
    includeHasExplicitSharedMembers:(NSNumber *)includeHasExplicitSharedMembers
              includePropertyGroups:(DBFILEPROPERTIESTemplateFilterBase *)includePropertyGroups {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
    _includeMediaInfo = includeMediaInfo ?: @NO;
    _includeDeleted = includeDeleted ?: @NO;
    _includeHasExplicitSharedMembers = includeHasExplicitSharedMembers ?: @NO;
    _includePropertyGroups = includePropertyGroups;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path
                     includeMediaInfo:nil
                       includeDeleted:nil
      includeHasExplicitSharedMembers:nil
                includePropertyGroups:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetMetadataArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetMetadataArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetMetadataArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.includeMediaInfo hash];
  result = prime * result + [self.includeDeleted hash];
  result = prime * result + [self.includeHasExplicitSharedMembers hash];
  if (self.includePropertyGroups != nil) {
    result = prime * result + [self.includePropertyGroups hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetMetadataArg:other];
}

- (BOOL)isEqualToGetMetadataArg:(DBFILESGetMetadataArg *)aGetMetadataArg {
  if (self == aGetMetadataArg) {
    return YES;
  }
  if (![self.path isEqual:aGetMetadataArg.path]) {
    return NO;
  }
  if (![self.includeMediaInfo isEqual:aGetMetadataArg.includeMediaInfo]) {
    return NO;
  }
  if (![self.includeDeleted isEqual:aGetMetadataArg.includeDeleted]) {
    return NO;
  }
  if (![self.includeHasExplicitSharedMembers isEqual:aGetMetadataArg.includeHasExplicitSharedMembers]) {
    return NO;
  }
  if (self.includePropertyGroups) {
    if (![self.includePropertyGroups isEqual:aGetMetadataArg.includePropertyGroups]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetMetadataArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetMetadataArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"include_media_info"] = valueObj.includeMediaInfo;
  jsonDict[@"include_deleted"] = valueObj.includeDeleted;
  jsonDict[@"include_has_explicit_shared_members"] = valueObj.includeHasExplicitSharedMembers;
  if (valueObj.includePropertyGroups) {
    jsonDict[@"include_property_groups"] =
        [DBFILEPROPERTIESTemplateFilterBaseSerializer serialize:valueObj.includePropertyGroups];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetMetadataArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSNumber *includeMediaInfo = valueDict[@"include_media_info"] ?: @NO;
  NSNumber *includeDeleted = valueDict[@"include_deleted"] ?: @NO;
  NSNumber *includeHasExplicitSharedMembers = valueDict[@"include_has_explicit_shared_members"] ?: @NO;
  DBFILEPROPERTIESTemplateFilterBase *includePropertyGroups =
      valueDict[@"include_property_groups"]
          ? [DBFILEPROPERTIESTemplateFilterBaseSerializer deserialize:valueDict[@"include_property_groups"]]
          : nil;

  return [[DBFILESGetMetadataArg alloc] initWithPath:path
                                    includeMediaInfo:includeMediaInfo
                                      includeDeleted:includeDeleted
                     includeHasExplicitSharedMembers:includeHasExplicitSharedMembers
                               includePropertyGroups:includePropertyGroups];
}

@end

#import "DBFILEPROPERTIESTemplateFilterBase.h"
#import "DBFILESAlphaGetMetadataArg.h"
#import "DBFILESGetMetadataArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESAlphaGetMetadataArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                   includeMediaInfo:(NSNumber *)includeMediaInfo
                     includeDeleted:(NSNumber *)includeDeleted
    includeHasExplicitSharedMembers:(NSNumber *)includeHasExplicitSharedMembers
              includePropertyGroups:(DBFILEPROPERTIESTemplateFilterBase *)includePropertyGroups
           includePropertyTemplates:(NSArray<NSString *> *)includePropertyTemplates {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators
                         arrayValidator:nil
                               maxItems:nil
                          itemValidator:[DBStoneValidators
                                            nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                                                                      maxLength:nil
                                                                                        pattern:@"(/|ptid:).*"]]]](
      includePropertyTemplates);

  self = [super initWithPath:path
                     includeMediaInfo:includeMediaInfo
                       includeDeleted:includeDeleted
      includeHasExplicitSharedMembers:includeHasExplicitSharedMembers
                includePropertyGroups:includePropertyGroups];
  if (self) {
    _includePropertyTemplates = includePropertyTemplates;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path
                     includeMediaInfo:nil
                       includeDeleted:nil
      includeHasExplicitSharedMembers:nil
                includePropertyGroups:nil
             includePropertyTemplates:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESAlphaGetMetadataArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESAlphaGetMetadataArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESAlphaGetMetadataArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.includeMediaInfo hash];
  result = prime * result + [self.includeDeleted hash];
  result = prime * result + [self.includeHasExplicitSharedMembers hash];
  if (self.includePropertyGroups != nil) {
    result = prime * result + [self.includePropertyGroups hash];
  }
  if (self.includePropertyTemplates != nil) {
    result = prime * result + [self.includePropertyTemplates hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAlphaGetMetadataArg:other];
}

- (BOOL)isEqualToAlphaGetMetadataArg:(DBFILESAlphaGetMetadataArg *)anAlphaGetMetadataArg {
  if (self == anAlphaGetMetadataArg) {
    return YES;
  }
  if (![self.path isEqual:anAlphaGetMetadataArg.path]) {
    return NO;
  }
  if (![self.includeMediaInfo isEqual:anAlphaGetMetadataArg.includeMediaInfo]) {
    return NO;
  }
  if (![self.includeDeleted isEqual:anAlphaGetMetadataArg.includeDeleted]) {
    return NO;
  }
  if (![self.includeHasExplicitSharedMembers isEqual:anAlphaGetMetadataArg.includeHasExplicitSharedMembers]) {
    return NO;
  }
  if (self.includePropertyGroups) {
    if (![self.includePropertyGroups isEqual:anAlphaGetMetadataArg.includePropertyGroups]) {
      return NO;
    }
  }
  if (self.includePropertyTemplates) {
    if (![self.includePropertyTemplates isEqual:anAlphaGetMetadataArg.includePropertyTemplates]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESAlphaGetMetadataArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESAlphaGetMetadataArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"include_media_info"] = valueObj.includeMediaInfo;
  jsonDict[@"include_deleted"] = valueObj.includeDeleted;
  jsonDict[@"include_has_explicit_shared_members"] = valueObj.includeHasExplicitSharedMembers;
  if (valueObj.includePropertyGroups) {
    jsonDict[@"include_property_groups"] =
        [DBFILEPROPERTIESTemplateFilterBaseSerializer serialize:valueObj.includePropertyGroups];
  }
  if (valueObj.includePropertyTemplates) {
    jsonDict[@"include_property_templates"] = [DBArraySerializer serialize:valueObj.includePropertyTemplates
                                                                 withBlock:^id(id elem0) {
                                                                   return elem0;
                                                                 }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESAlphaGetMetadataArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSNumber *includeMediaInfo = valueDict[@"include_media_info"] ?: @NO;
  NSNumber *includeDeleted = valueDict[@"include_deleted"] ?: @NO;
  NSNumber *includeHasExplicitSharedMembers = valueDict[@"include_has_explicit_shared_members"] ?: @NO;
  DBFILEPROPERTIESTemplateFilterBase *includePropertyGroups =
      valueDict[@"include_property_groups"]
          ? [DBFILEPROPERTIESTemplateFilterBaseSerializer deserialize:valueDict[@"include_property_groups"]]
          : nil;
  NSArray<NSString *> *includePropertyTemplates =
      valueDict[@"include_property_templates"] ? [DBArraySerializer deserialize:valueDict[@"include_property_templates"]
                                                                      withBlock:^id(id elem0) {
                                                                        return elem0;
                                                                      }]
                                               : nil;

  return [[DBFILESAlphaGetMetadataArg alloc] initWithPath:path
                                         includeMediaInfo:includeMediaInfo
                                           includeDeleted:includeDeleted
                          includeHasExplicitSharedMembers:includeHasExplicitSharedMembers
                                    includePropertyGroups:includePropertyGroups
                                 includePropertyTemplates:includePropertyTemplates];
}

@end

#import "DBFILESGetMetadataError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetMetadataError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESGetMetadataErrorPath;
    _path = path;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESGetMetadataErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESGetMetadataErrorPath;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESGetMetadataErrorPath:
    return @"DBFILESGetMetadataErrorPath";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetMetadataErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetMetadataErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetMetadataErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESGetMetadataErrorPath:
    result = prime * result + [self.path hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetMetadataError:other];
}

- (BOOL)isEqualToGetMetadataError:(DBFILESGetMetadataError *)aGetMetadataError {
  if (self == aGetMetadataError) {
    return YES;
  }
  if (self.tag != aGetMetadataError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESGetMetadataErrorPath:
    return [self.path isEqual:aGetMetadataError.path];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetMetadataErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetMetadataError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetMetadataError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESGetMetadataError alloc] initWithPath:path];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILEPROPERTIESLookUpPropertiesError.h"
#import "DBFILESAlphaGetMetadataError.h"
#import "DBFILESGetMetadataError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESAlphaGetMetadataError

@synthesize path = _path;
@synthesize propertiesError = _propertiesError;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESAlphaGetMetadataErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithPropertiesError:(DBFILEPROPERTIESLookUpPropertiesError *)propertiesError {
  self = [super init];
  if (self) {
    _tag = DBFILESAlphaGetMetadataErrorPropertiesError;
    _propertiesError = propertiesError;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESAlphaGetMetadataErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

- (DBFILEPROPERTIESLookUpPropertiesError *)propertiesError {
  if (![self isPropertiesError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESAlphaGetMetadataErrorPropertiesError, but was %@.", [self tagName]];
  }
  return _propertiesError;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESAlphaGetMetadataErrorPath;
}

- (BOOL)isPropertiesError {
  return _tag == DBFILESAlphaGetMetadataErrorPropertiesError;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESAlphaGetMetadataErrorPath:
    return @"DBFILESAlphaGetMetadataErrorPath";
  case DBFILESAlphaGetMetadataErrorPropertiesError:
    return @"DBFILESAlphaGetMetadataErrorPropertiesError";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESAlphaGetMetadataErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESAlphaGetMetadataErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESAlphaGetMetadataErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESAlphaGetMetadataErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESAlphaGetMetadataErrorPropertiesError:
    result = prime * result + [self.propertiesError hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAlphaGetMetadataError:other];
}

- (BOOL)isEqualToAlphaGetMetadataError:(DBFILESAlphaGetMetadataError *)anAlphaGetMetadataError {
  if (self == anAlphaGetMetadataError) {
    return YES;
  }
  if (self.tag != anAlphaGetMetadataError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESAlphaGetMetadataErrorPath:
    return [self.path isEqual:anAlphaGetMetadataError.path];
  case DBFILESAlphaGetMetadataErrorPropertiesError:
    return [self.propertiesError isEqual:anAlphaGetMetadataError.propertiesError];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESAlphaGetMetadataErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESAlphaGetMetadataError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isPropertiesError]) {
    jsonDict[@"properties_error"] =
        [[DBFILEPROPERTIESLookUpPropertiesErrorSerializer serialize:valueObj.propertiesError] mutableCopy];
    jsonDict[@".tag"] = @"properties_error";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESAlphaGetMetadataError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESAlphaGetMetadataError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"properties_error"]) {
    DBFILEPROPERTIESLookUpPropertiesError *propertiesError =
        [DBFILEPROPERTIESLookUpPropertiesErrorSerializer deserialize:valueDict[@"properties_error"]];
    return [[DBFILESAlphaGetMetadataError alloc] initWithPropertiesError:propertiesError];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILEPROPERTIESPropertyGroup.h"
#import "DBFILESCommitInfo.h"
#import "DBFILESWriteMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCommitInfo

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                        mode:(DBFILESWriteMode *)mode
                  autorename:(NSNumber *)autorename
              clientModified:(NSDate *)clientModified
                        mute:(NSNumber *)mute
              propertyGroups:(NSArray<DBFILEPROPERTIESPropertyGroup *> *)propertyGroups
              strictConflict:(NSNumber *)strictConflict {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](path);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](propertyGroups);

  self = [super init];
  if (self) {
    _path = path;
    _mode = mode ?: [[DBFILESWriteMode alloc] initWithAdd];
    _autorename = autorename ?: @NO;
    _clientModified = clientModified;
    _mute = mute ?: @NO;
    _propertyGroups = propertyGroups;
    _strictConflict = strictConflict ?: @NO;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path
                       mode:nil
                 autorename:nil
             clientModified:nil
                       mute:nil
             propertyGroups:nil
             strictConflict:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCommitInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCommitInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCommitInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.mode hash];
  result = prime * result + [self.autorename hash];
  if (self.clientModified != nil) {
    result = prime * result + [self.clientModified hash];
  }
  result = prime * result + [self.mute hash];
  if (self.propertyGroups != nil) {
    result = prime * result + [self.propertyGroups hash];
  }
  result = prime * result + [self.strictConflict hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCommitInfo:other];
}

- (BOOL)isEqualToCommitInfo:(DBFILESCommitInfo *)aCommitInfo {
  if (self == aCommitInfo) {
    return YES;
  }
  if (![self.path isEqual:aCommitInfo.path]) {
    return NO;
  }
  if (![self.mode isEqual:aCommitInfo.mode]) {
    return NO;
  }
  if (![self.autorename isEqual:aCommitInfo.autorename]) {
    return NO;
  }
  if (self.clientModified) {
    if (![self.clientModified isEqual:aCommitInfo.clientModified]) {
      return NO;
    }
  }
  if (![self.mute isEqual:aCommitInfo.mute]) {
    return NO;
  }
  if (self.propertyGroups) {
    if (![self.propertyGroups isEqual:aCommitInfo.propertyGroups]) {
      return NO;
    }
  }
  if (![self.strictConflict isEqual:aCommitInfo.strictConflict]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCommitInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCommitInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"mode"] = [DBFILESWriteModeSerializer serialize:valueObj.mode];
  jsonDict[@"autorename"] = valueObj.autorename;
  if (valueObj.clientModified) {
    jsonDict[@"client_modified"] =
        [DBNSDateSerializer serialize:valueObj.clientModified dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  jsonDict[@"mute"] = valueObj.mute;
  if (valueObj.propertyGroups) {
    jsonDict[@"property_groups"] =
        [DBArraySerializer serialize:valueObj.propertyGroups
                           withBlock:^id(id elem0) {
                             return [DBFILEPROPERTIESPropertyGroupSerializer serialize:elem0];
                           }];
  }
  jsonDict[@"strict_conflict"] = valueObj.strictConflict;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCommitInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  DBFILESWriteMode *mode = valueDict[@"mode"] ? [DBFILESWriteModeSerializer deserialize:valueDict[@"mode"]]
                                              : [[DBFILESWriteMode alloc] initWithAdd];
  NSNumber *autorename = valueDict[@"autorename"] ?: @NO;
  NSDate *clientModified = valueDict[@"client_modified"] ? [DBNSDateSerializer deserialize:valueDict[@"client_modified"]
                                                                                dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                                                         : nil;
  NSNumber *mute = valueDict[@"mute"] ?: @NO;
  NSArray<DBFILEPROPERTIESPropertyGroup *> *propertyGroups =
      valueDict[@"property_groups"]
          ? [DBArraySerializer deserialize:valueDict[@"property_groups"]
                                 withBlock:^id(id elem0) {
                                   return [DBFILEPROPERTIESPropertyGroupSerializer deserialize:elem0];
                                 }]
          : nil;
  NSNumber *strictConflict = valueDict[@"strict_conflict"] ?: @NO;

  return [[DBFILESCommitInfo alloc] initWithPath:path
                                            mode:mode
                                      autorename:autorename
                                  clientModified:clientModified
                                            mute:mute
                                  propertyGroups:propertyGroups
                                  strictConflict:strictConflict];
}

@end

#import "DBFILEPROPERTIESPropertyGroup.h"
#import "DBFILESCommitInfo.h"
#import "DBFILESCommitInfoWithProperties.h"
#import "DBFILESWriteMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCommitInfoWithProperties

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                        mode:(DBFILESWriteMode *)mode
                  autorename:(NSNumber *)autorename
              clientModified:(NSDate *)clientModified
                        mute:(NSNumber *)mute
              propertyGroups:(NSArray<DBFILEPROPERTIESPropertyGroup *> *)propertyGroups
              strictConflict:(NSNumber *)strictConflict {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](path);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](propertyGroups);

  self = [super initWithPath:path
                        mode:mode
                  autorename:autorename
              clientModified:clientModified
                        mute:mute
              propertyGroups:propertyGroups
              strictConflict:strictConflict];
  if (self) {
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path
                       mode:nil
                 autorename:nil
             clientModified:nil
                       mute:nil
             propertyGroups:nil
             strictConflict:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCommitInfoWithPropertiesSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCommitInfoWithPropertiesSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCommitInfoWithPropertiesSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.mode hash];
  result = prime * result + [self.autorename hash];
  if (self.clientModified != nil) {
    result = prime * result + [self.clientModified hash];
  }
  result = prime * result + [self.mute hash];
  if (self.propertyGroups != nil) {
    result = prime * result + [self.propertyGroups hash];
  }
  result = prime * result + [self.strictConflict hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCommitInfoWithProperties:other];
}

- (BOOL)isEqualToCommitInfoWithProperties:(DBFILESCommitInfoWithProperties *)aCommitInfoWithProperties {
  if (self == aCommitInfoWithProperties) {
    return YES;
  }
  if (![self.path isEqual:aCommitInfoWithProperties.path]) {
    return NO;
  }
  if (![self.mode isEqual:aCommitInfoWithProperties.mode]) {
    return NO;
  }
  if (![self.autorename isEqual:aCommitInfoWithProperties.autorename]) {
    return NO;
  }
  if (self.clientModified) {
    if (![self.clientModified isEqual:aCommitInfoWithProperties.clientModified]) {
      return NO;
    }
  }
  if (![self.mute isEqual:aCommitInfoWithProperties.mute]) {
    return NO;
  }
  if (self.propertyGroups) {
    if (![self.propertyGroups isEqual:aCommitInfoWithProperties.propertyGroups]) {
      return NO;
    }
  }
  if (![self.strictConflict isEqual:aCommitInfoWithProperties.strictConflict]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCommitInfoWithPropertiesSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCommitInfoWithProperties *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"mode"] = [DBFILESWriteModeSerializer serialize:valueObj.mode];
  jsonDict[@"autorename"] = valueObj.autorename;
  if (valueObj.clientModified) {
    jsonDict[@"client_modified"] =
        [DBNSDateSerializer serialize:valueObj.clientModified dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  jsonDict[@"mute"] = valueObj.mute;
  if (valueObj.propertyGroups) {
    jsonDict[@"property_groups"] =
        [DBArraySerializer serialize:valueObj.propertyGroups
                           withBlock:^id(id elem0) {
                             return [DBFILEPROPERTIESPropertyGroupSerializer serialize:elem0];
                           }];
  }
  jsonDict[@"strict_conflict"] = valueObj.strictConflict;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCommitInfoWithProperties *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  DBFILESWriteMode *mode = valueDict[@"mode"] ? [DBFILESWriteModeSerializer deserialize:valueDict[@"mode"]]
                                              : [[DBFILESWriteMode alloc] initWithAdd];
  NSNumber *autorename = valueDict[@"autorename"] ?: @NO;
  NSDate *clientModified = valueDict[@"client_modified"] ? [DBNSDateSerializer deserialize:valueDict[@"client_modified"]
                                                                                dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                                                         : nil;
  NSNumber *mute = valueDict[@"mute"] ?: @NO;
  NSArray<DBFILEPROPERTIESPropertyGroup *> *propertyGroups =
      valueDict[@"property_groups"]
          ? [DBArraySerializer deserialize:valueDict[@"property_groups"]
                                 withBlock:^id(id elem0) {
                                   return [DBFILEPROPERTIESPropertyGroupSerializer deserialize:elem0];
                                 }]
          : nil;
  NSNumber *strictConflict = valueDict[@"strict_conflict"] ?: @NO;

  return [[DBFILESCommitInfoWithProperties alloc] initWithPath:path
                                                          mode:mode
                                                    autorename:autorename
                                                clientModified:clientModified
                                                          mute:mute
                                                propertyGroups:propertyGroups
                                                strictConflict:strictConflict];
}

@end

#import "DBFILESContentSyncSetting.h"
#import "DBFILESSyncSetting.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESContentSyncSetting

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_ syncSetting:(DBFILESSyncSetting *)syncSetting {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(4) maxLength:nil pattern:@"id:.+"]](id_);
  [DBStoneValidators nonnullValidator:nil](syncSetting);

  self = [super init];
  if (self) {
    _id_ = id_;
    _syncSetting = syncSetting;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESContentSyncSettingSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESContentSyncSettingSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESContentSyncSettingSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  result = prime * result + [self.syncSetting hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToContentSyncSetting:other];
}

- (BOOL)isEqualToContentSyncSetting:(DBFILESContentSyncSetting *)aContentSyncSetting {
  if (self == aContentSyncSetting) {
    return YES;
  }
  if (![self.id_ isEqual:aContentSyncSetting.id_]) {
    return NO;
  }
  if (![self.syncSetting isEqual:aContentSyncSetting.syncSetting]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESContentSyncSettingSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESContentSyncSetting *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  jsonDict[@"sync_setting"] = [DBFILESSyncSettingSerializer serialize:valueObj.syncSetting];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESContentSyncSetting *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  DBFILESSyncSetting *syncSetting = [DBFILESSyncSettingSerializer deserialize:valueDict[@"sync_setting"]];

  return [[DBFILESContentSyncSetting alloc] initWithId_:id_ syncSetting:syncSetting];
}

@end

#import "DBFILESContentSyncSettingArg.h"
#import "DBFILESSyncSettingArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESContentSyncSettingArg

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_ syncSetting:(DBFILESSyncSettingArg *)syncSetting {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(4) maxLength:nil pattern:@"id:.+"]](id_);
  [DBStoneValidators nonnullValidator:nil](syncSetting);

  self = [super init];
  if (self) {
    _id_ = id_;
    _syncSetting = syncSetting;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESContentSyncSettingArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESContentSyncSettingArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESContentSyncSettingArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  result = prime * result + [self.syncSetting hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToContentSyncSettingArg:other];
}

- (BOOL)isEqualToContentSyncSettingArg:(DBFILESContentSyncSettingArg *)aContentSyncSettingArg {
  if (self == aContentSyncSettingArg) {
    return YES;
  }
  if (![self.id_ isEqual:aContentSyncSettingArg.id_]) {
    return NO;
  }
  if (![self.syncSetting isEqual:aContentSyncSettingArg.syncSetting]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESContentSyncSettingArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESContentSyncSettingArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  jsonDict[@"sync_setting"] = [DBFILESSyncSettingArgSerializer serialize:valueObj.syncSetting];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESContentSyncSettingArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  DBFILESSyncSettingArg *syncSetting = [DBFILESSyncSettingArgSerializer deserialize:valueDict[@"sync_setting"]];

  return [[DBFILESContentSyncSettingArg alloc] initWithId_:id_ syncSetting:syncSetting];
}

@end

#import "DBFILESCreateFolderArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path autorename:(NSNumber *)autorename {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil
                                                               maxLength:nil
                                                                 pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
    _autorename = autorename ?: @NO;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path autorename:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.autorename hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderArg:other];
}

- (BOOL)isEqualToCreateFolderArg:(DBFILESCreateFolderArg *)aCreateFolderArg {
  if (self == aCreateFolderArg) {
    return YES;
  }
  if (![self.path isEqual:aCreateFolderArg.path]) {
    return NO;
  }
  if (![self.autorename isEqual:aCreateFolderArg.autorename]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"autorename"] = valueObj.autorename;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSNumber *autorename = valueDict[@"autorename"] ?: @NO;

  return [[DBFILESCreateFolderArg alloc] initWithPath:path autorename:autorename];
}

@end

#import "DBFILESCreateFolderBatchArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderBatchArg

#pragma mark - Constructors

- (instancetype)initWithPaths:(NSArray<NSString *> *)paths
                   autorename:(NSNumber *)autorename
                   forceAsync:(NSNumber *)forceAsync {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        arrayValidator:nil
                              maxItems:@(10000)
                         itemValidator:[DBStoneValidators
                                           nonnullValidator:[DBStoneValidators stringValidator:nil
                                                                                     maxLength:nil
                                                                                       pattern:@"(/(.|[\\r\\n])*)|(ns:["
                                                                                               @"0-9]+(/.*)?)"]]]](
      paths);

  self = [super init];
  if (self) {
    _paths = paths;
    _autorename = autorename ?: @NO;
    _forceAsync = forceAsync ?: @NO;
  }
  return self;
}

- (instancetype)initWithPaths:(NSArray<NSString *> *)paths {
  return [self initWithPaths:paths autorename:nil forceAsync:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.paths hash];
  result = prime * result + [self.autorename hash];
  result = prime * result + [self.forceAsync hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderBatchArg:other];
}

- (BOOL)isEqualToCreateFolderBatchArg:(DBFILESCreateFolderBatchArg *)aCreateFolderBatchArg {
  if (self == aCreateFolderBatchArg) {
    return YES;
  }
  if (![self.paths isEqual:aCreateFolderBatchArg.paths]) {
    return NO;
  }
  if (![self.autorename isEqual:aCreateFolderBatchArg.autorename]) {
    return NO;
  }
  if (![self.forceAsync isEqual:aCreateFolderBatchArg.forceAsync]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"paths"] = [DBArraySerializer serialize:valueObj.paths
                                          withBlock:^id(id elem0) {
                                            return elem0;
                                          }];
  jsonDict[@"autorename"] = valueObj.autorename;
  jsonDict[@"force_async"] = valueObj.forceAsync;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *paths = [DBArraySerializer deserialize:valueDict[@"paths"]
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];
  NSNumber *autorename = valueDict[@"autorename"] ?: @NO;
  NSNumber *forceAsync = valueDict[@"force_async"] ?: @NO;

  return [[DBFILESCreateFolderBatchArg alloc] initWithPaths:paths autorename:autorename forceAsync:forceAsync];
}

@end

#import "DBFILESCreateFolderBatchError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderBatchError

#pragma mark - Constructors

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTooManyFiles {
  return _tag == DBFILESCreateFolderBatchErrorTooManyFiles;
}

- (BOOL)isOther {
  return _tag == DBFILESCreateFolderBatchErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESCreateFolderBatchErrorTooManyFiles:
    return @"DBFILESCreateFolderBatchErrorTooManyFiles";
  case DBFILESCreateFolderBatchErrorOther:
    return @"DBFILESCreateFolderBatchErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderBatchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderBatchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderBatchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESCreateFolderBatchErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESCreateFolderBatchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderBatchError:other];
}

- (BOOL)isEqualToCreateFolderBatchError:(DBFILESCreateFolderBatchError *)aCreateFolderBatchError {
  if (self == aCreateFolderBatchError) {
    return YES;
  }
  if (self.tag != aCreateFolderBatchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESCreateFolderBatchErrorTooManyFiles:
    return [[self tagName] isEqual:[aCreateFolderBatchError tagName]];
  case DBFILESCreateFolderBatchErrorOther:
    return [[self tagName] isEqual:[aCreateFolderBatchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderBatchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderBatchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderBatchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBFILESCreateFolderBatchError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESCreateFolderBatchError alloc] initWithOther];
  } else {
    return [[DBFILESCreateFolderBatchError alloc] initWithOther];
  }
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBFILESCreateFolderBatchError.h"
#import "DBFILESCreateFolderBatchJobStatus.h"
#import "DBFILESCreateFolderBatchResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderBatchJobStatus

@synthesize complete = _complete;
@synthesize failed = _failed;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESCreateFolderBatchResult *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchJobStatusComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithFailed:(DBFILESCreateFolderBatchError *)failed {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchJobStatusFailed;
    _failed = failed;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchJobStatusOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESCreateFolderBatchResult *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESCreateFolderBatchJobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

- (DBFILESCreateFolderBatchError *)failed {
  if (![self isFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESCreateFolderBatchJobStatusFailed, but was %@.", [self tagName]];
  }
  return _failed;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBFILESCreateFolderBatchJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBFILESCreateFolderBatchJobStatusComplete;
}

- (BOOL)isFailed {
  return _tag == DBFILESCreateFolderBatchJobStatusFailed;
}

- (BOOL)isOther {
  return _tag == DBFILESCreateFolderBatchJobStatusOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESCreateFolderBatchJobStatusInProgress:
    return @"DBFILESCreateFolderBatchJobStatusInProgress";
  case DBFILESCreateFolderBatchJobStatusComplete:
    return @"DBFILESCreateFolderBatchJobStatusComplete";
  case DBFILESCreateFolderBatchJobStatusFailed:
    return @"DBFILESCreateFolderBatchJobStatusFailed";
  case DBFILESCreateFolderBatchJobStatusOther:
    return @"DBFILESCreateFolderBatchJobStatusOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderBatchJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderBatchJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderBatchJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESCreateFolderBatchJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESCreateFolderBatchJobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBFILESCreateFolderBatchJobStatusFailed:
    result = prime * result + [self.failed hash];
    break;
  case DBFILESCreateFolderBatchJobStatusOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderBatchJobStatus:other];
}

- (BOOL)isEqualToCreateFolderBatchJobStatus:(DBFILESCreateFolderBatchJobStatus *)aCreateFolderBatchJobStatus {
  if (self == aCreateFolderBatchJobStatus) {
    return YES;
  }
  if (self.tag != aCreateFolderBatchJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESCreateFolderBatchJobStatusInProgress:
    return [[self tagName] isEqual:[aCreateFolderBatchJobStatus tagName]];
  case DBFILESCreateFolderBatchJobStatusComplete:
    return [self.complete isEqual:aCreateFolderBatchJobStatus.complete];
  case DBFILESCreateFolderBatchJobStatusFailed:
    return [self.failed isEqual:aCreateFolderBatchJobStatus.failed];
  case DBFILESCreateFolderBatchJobStatusOther:
    return [[self tagName] isEqual:[aCreateFolderBatchJobStatus tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderBatchJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderBatchJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESCreateFolderBatchResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isFailed]) {
    jsonDict[@"failed"] = [[DBFILESCreateFolderBatchErrorSerializer serialize:valueObj.failed] mutableCopy];
    jsonDict[@".tag"] = @"failed";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderBatchJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBFILESCreateFolderBatchJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESCreateFolderBatchResult *complete = [DBFILESCreateFolderBatchResultSerializer deserialize:valueDict];
    return [[DBFILESCreateFolderBatchJobStatus alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"failed"]) {
    DBFILESCreateFolderBatchError *failed = [DBFILESCreateFolderBatchErrorSerializer deserialize:valueDict[@"failed"]];
    return [[DBFILESCreateFolderBatchJobStatus alloc] initWithFailed:failed];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESCreateFolderBatchJobStatus alloc] initWithOther];
  } else {
    return [[DBFILESCreateFolderBatchJobStatus alloc] initWithOther];
  }
}

@end

#import "DBASYNCLaunchResultBase.h"
#import "DBFILESCreateFolderBatchLaunch.h"
#import "DBFILESCreateFolderBatchResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderBatchLaunch

@synthesize asyncJobId = _asyncJobId;
@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchLaunchAsyncJobId;
    _asyncJobId = asyncJobId;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESCreateFolderBatchResult *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchLaunchComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchLaunchOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)asyncJobId {
  if (![self isAsyncJobId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESCreateFolderBatchLaunchAsyncJobId, but was %@.", [self tagName]];
  }
  return _asyncJobId;
}

- (DBFILESCreateFolderBatchResult *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESCreateFolderBatchLaunchComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isAsyncJobId {
  return _tag == DBFILESCreateFolderBatchLaunchAsyncJobId;
}

- (BOOL)isComplete {
  return _tag == DBFILESCreateFolderBatchLaunchComplete;
}

- (BOOL)isOther {
  return _tag == DBFILESCreateFolderBatchLaunchOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESCreateFolderBatchLaunchAsyncJobId:
    return @"DBFILESCreateFolderBatchLaunchAsyncJobId";
  case DBFILESCreateFolderBatchLaunchComplete:
    return @"DBFILESCreateFolderBatchLaunchComplete";
  case DBFILESCreateFolderBatchLaunchOther:
    return @"DBFILESCreateFolderBatchLaunchOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderBatchLaunchSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderBatchLaunchSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderBatchLaunchSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESCreateFolderBatchLaunchAsyncJobId:
    result = prime * result + [self.asyncJobId hash];
    break;
  case DBFILESCreateFolderBatchLaunchComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBFILESCreateFolderBatchLaunchOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderBatchLaunch:other];
}

- (BOOL)isEqualToCreateFolderBatchLaunch:(DBFILESCreateFolderBatchLaunch *)aCreateFolderBatchLaunch {
  if (self == aCreateFolderBatchLaunch) {
    return YES;
  }
  if (self.tag != aCreateFolderBatchLaunch.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESCreateFolderBatchLaunchAsyncJobId:
    return [self.asyncJobId isEqual:aCreateFolderBatchLaunch.asyncJobId];
  case DBFILESCreateFolderBatchLaunchComplete:
    return [self.complete isEqual:aCreateFolderBatchLaunch.complete];
  case DBFILESCreateFolderBatchLaunchOther:
    return [[self tagName] isEqual:[aCreateFolderBatchLaunch tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderBatchLaunchSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderBatchLaunch *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAsyncJobId]) {
    jsonDict[@"async_job_id"] = valueObj.asyncJobId;
    jsonDict[@".tag"] = @"async_job_id";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESCreateFolderBatchResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderBatchLaunch *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"async_job_id"]) {
    NSString *asyncJobId = valueDict[@"async_job_id"];
    return [[DBFILESCreateFolderBatchLaunch alloc] initWithAsyncJobId:asyncJobId];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESCreateFolderBatchResult *complete = [DBFILESCreateFolderBatchResultSerializer deserialize:valueDict];
    return [[DBFILESCreateFolderBatchLaunch alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESCreateFolderBatchLaunch alloc] initWithOther];
  } else {
    return [[DBFILESCreateFolderBatchLaunch alloc] initWithOther];
  }
}

@end

#import "DBFILESFileOpsResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFileOpsResult

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFileOpsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFileOpsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFileOpsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileOpsResult:other];
}

- (BOOL)isEqualToFileOpsResult:(DBFILESFileOpsResult *)aFileOpsResult {
  if (self == aFileOpsResult) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFileOpsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFileOpsResult *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFileOpsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBFILESFileOpsResult alloc] initDefault];
}

@end

#import "DBFILESCreateFolderBatchResult.h"
#import "DBFILESCreateFolderBatchResultEntry.h"
#import "DBFILESFileOpsResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderBatchResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESCreateFolderBatchResultEntry *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super initDefault];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderBatchResult:other];
}

- (BOOL)isEqualToCreateFolderBatchResult:(DBFILESCreateFolderBatchResult *)aCreateFolderBatchResult {
  if (self == aCreateFolderBatchResult) {
    return YES;
  }
  if (![self.entries isEqual:aCreateFolderBatchResult.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESCreateFolderBatchResultEntrySerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESCreateFolderBatchResultEntry *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESCreateFolderBatchResultEntrySerializer deserialize:elem0];
                           }];

  return [[DBFILESCreateFolderBatchResult alloc] initWithEntries:entries];
}

@end

#import "DBFILESCreateFolderBatchResultEntry.h"
#import "DBFILESCreateFolderEntryError.h"
#import "DBFILESCreateFolderEntryResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderBatchResultEntry

@synthesize success = _success;
@synthesize failure = _failure;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBFILESCreateFolderEntryResult *)success {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchResultEntrySuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithFailure:(DBFILESCreateFolderEntryError *)failure {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderBatchResultEntryFailure;
    _failure = failure;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESCreateFolderEntryResult *)success {
  if (![self isSuccess]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESCreateFolderBatchResultEntrySuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBFILESCreateFolderEntryError *)failure {
  if (![self isFailure]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESCreateFolderBatchResultEntryFailure, but was %@.", [self tagName]];
  }
  return _failure;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBFILESCreateFolderBatchResultEntrySuccess;
}

- (BOOL)isFailure {
  return _tag == DBFILESCreateFolderBatchResultEntryFailure;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESCreateFolderBatchResultEntrySuccess:
    return @"DBFILESCreateFolderBatchResultEntrySuccess";
  case DBFILESCreateFolderBatchResultEntryFailure:
    return @"DBFILESCreateFolderBatchResultEntryFailure";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderBatchResultEntrySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderBatchResultEntrySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderBatchResultEntrySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESCreateFolderBatchResultEntrySuccess:
    result = prime * result + [self.success hash];
    break;
  case DBFILESCreateFolderBatchResultEntryFailure:
    result = prime * result + [self.failure hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderBatchResultEntry:other];
}

- (BOOL)isEqualToCreateFolderBatchResultEntry:(DBFILESCreateFolderBatchResultEntry *)aCreateFolderBatchResultEntry {
  if (self == aCreateFolderBatchResultEntry) {
    return YES;
  }
  if (self.tag != aCreateFolderBatchResultEntry.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESCreateFolderBatchResultEntrySuccess:
    return [self.success isEqual:aCreateFolderBatchResultEntry.success];
  case DBFILESCreateFolderBatchResultEntryFailure:
    return [self.failure isEqual:aCreateFolderBatchResultEntry.failure];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderBatchResultEntrySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderBatchResultEntry *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict = [[DBFILESCreateFolderEntryResultSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isFailure]) {
    jsonDict[@"failure"] = [[DBFILESCreateFolderEntryErrorSerializer serialize:valueObj.failure] mutableCopy];
    jsonDict[@".tag"] = @"failure";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderBatchResultEntry *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBFILESCreateFolderEntryResult *success = [DBFILESCreateFolderEntryResultSerializer deserialize:valueDict];
    return [[DBFILESCreateFolderBatchResultEntry alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"failure"]) {
    DBFILESCreateFolderEntryError *failure =
        [DBFILESCreateFolderEntryErrorSerializer deserialize:valueDict[@"failure"]];
    return [[DBFILESCreateFolderBatchResultEntry alloc] initWithFailure:failure];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESCreateFolderEntryError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderEntryError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESWriteError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderEntryErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderEntryErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESWriteError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESCreateFolderEntryErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESCreateFolderEntryErrorPath;
}

- (BOOL)isOther {
  return _tag == DBFILESCreateFolderEntryErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESCreateFolderEntryErrorPath:
    return @"DBFILESCreateFolderEntryErrorPath";
  case DBFILESCreateFolderEntryErrorOther:
    return @"DBFILESCreateFolderEntryErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderEntryErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderEntryErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderEntryErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESCreateFolderEntryErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESCreateFolderEntryErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderEntryError:other];
}

- (BOOL)isEqualToCreateFolderEntryError:(DBFILESCreateFolderEntryError *)aCreateFolderEntryError {
  if (self == aCreateFolderEntryError) {
    return YES;
  }
  if (self.tag != aCreateFolderEntryError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESCreateFolderEntryErrorPath:
    return [self.path isEqual:aCreateFolderEntryError.path];
  case DBFILESCreateFolderEntryErrorOther:
    return [[self tagName] isEqual:[aCreateFolderEntryError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderEntryErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderEntryError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESWriteErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderEntryError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESWriteError *path = [DBFILESWriteErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESCreateFolderEntryError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESCreateFolderEntryError alloc] initWithOther];
  } else {
    return [[DBFILESCreateFolderEntryError alloc] initWithOther];
  }
}

@end

#import "DBFILESCreateFolderEntryResult.h"
#import "DBFILESFolderMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderEntryResult

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESFolderMetadata *)metadata {
  [DBStoneValidators nonnullValidator:nil](metadata);

  self = [super init];
  if (self) {
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderEntryResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderEntryResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderEntryResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderEntryResult:other];
}

- (BOOL)isEqualToCreateFolderEntryResult:(DBFILESCreateFolderEntryResult *)aCreateFolderEntryResult {
  if (self == aCreateFolderEntryResult) {
    return YES;
  }
  if (![self.metadata isEqual:aCreateFolderEntryResult.metadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderEntryResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderEntryResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESFolderMetadataSerializer serialize:valueObj.metadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderEntryResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESFolderMetadata *metadata = [DBFILESFolderMetadataSerializer deserialize:valueDict[@"metadata"]];

  return [[DBFILESCreateFolderEntryResult alloc] initWithMetadata:metadata];
}

@end

#import "DBFILESCreateFolderError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESWriteError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESCreateFolderErrorPath;
    _path = path;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESWriteError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESCreateFolderErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESCreateFolderErrorPath;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESCreateFolderErrorPath:
    return @"DBFILESCreateFolderErrorPath";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESCreateFolderErrorPath:
    result = prime * result + [self.path hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderError:other];
}

- (BOOL)isEqualToCreateFolderError:(DBFILESCreateFolderError *)aCreateFolderError {
  if (self == aCreateFolderError) {
    return YES;
  }
  if (self.tag != aCreateFolderError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESCreateFolderErrorPath:
    return [self.path isEqual:aCreateFolderError.path];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESWriteErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESWriteError *path = [DBFILESWriteErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESCreateFolderError alloc] initWithPath:path];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESCreateFolderResult.h"
#import "DBFILESFileOpsResult.h"
#import "DBFILESFolderMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESCreateFolderResult

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESFolderMetadata *)metadata {
  [DBStoneValidators nonnullValidator:nil](metadata);

  self = [super initDefault];
  if (self) {
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESCreateFolderResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESCreateFolderResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESCreateFolderResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderResult:other];
}

- (BOOL)isEqualToCreateFolderResult:(DBFILESCreateFolderResult *)aCreateFolderResult {
  if (self == aCreateFolderResult) {
    return YES;
  }
  if (![self.metadata isEqual:aCreateFolderResult.metadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESCreateFolderResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESFolderMetadataSerializer serialize:valueObj.metadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESCreateFolderResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESFolderMetadata *metadata = [DBFILESFolderMetadataSerializer deserialize:valueDict[@"metadata"]];

  return [[DBFILESCreateFolderResult alloc] initWithMetadata:metadata];
}

@end

#import "DBFILESDeleteArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path parentRev:(NSString *)parentRev {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](path);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:@(9) maxLength:nil pattern:@"[0-9a-f]+"]](parentRev);

  self = [super init];
  if (self) {
    _path = path;
    _parentRev = parentRev;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path parentRev:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  if (self.parentRev != nil) {
    result = prime * result + [self.parentRev hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteArg:other];
}

- (BOOL)isEqualToDeleteArg:(DBFILESDeleteArg *)aDeleteArg {
  if (self == aDeleteArg) {
    return YES;
  }
  if (![self.path isEqual:aDeleteArg.path]) {
    return NO;
  }
  if (self.parentRev) {
    if (![self.parentRev isEqual:aDeleteArg.parentRev]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  if (valueObj.parentRev) {
    jsonDict[@"parent_rev"] = valueObj.parentRev;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSString *parentRev = valueDict[@"parent_rev"] ?: nil;

  return [[DBFILESDeleteArg alloc] initWithPath:path parentRev:parentRev];
}

@end

#import "DBFILESDeleteArg.h"
#import "DBFILESDeleteBatchArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteBatchArg

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESDeleteArg *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteBatchArg:other];
}

- (BOOL)isEqualToDeleteBatchArg:(DBFILESDeleteBatchArg *)aDeleteBatchArg {
  if (self == aDeleteBatchArg) {
    return YES;
  }
  if (![self.entries isEqual:aDeleteBatchArg.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESDeleteArgSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESDeleteArg *> *entries = [DBArraySerializer deserialize:valueDict[@"entries"]
                                                              withBlock:^id(id elem0) {
                                                                return [DBFILESDeleteArgSerializer deserialize:elem0];
                                                              }];

  return [[DBFILESDeleteBatchArg alloc] initWithEntries:entries];
}

@end

#import "DBFILESDeleteBatchError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteBatchError

#pragma mark - Constructors

- (instancetype)initWithTooManyWriteOperations {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchErrorTooManyWriteOperations;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTooManyWriteOperations {
  return _tag == DBFILESDeleteBatchErrorTooManyWriteOperations;
}

- (BOOL)isOther {
  return _tag == DBFILESDeleteBatchErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESDeleteBatchErrorTooManyWriteOperations:
    return @"DBFILESDeleteBatchErrorTooManyWriteOperations";
  case DBFILESDeleteBatchErrorOther:
    return @"DBFILESDeleteBatchErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteBatchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteBatchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteBatchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESDeleteBatchErrorTooManyWriteOperations:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESDeleteBatchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteBatchError:other];
}

- (BOOL)isEqualToDeleteBatchError:(DBFILESDeleteBatchError *)aDeleteBatchError {
  if (self == aDeleteBatchError) {
    return YES;
  }
  if (self.tag != aDeleteBatchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESDeleteBatchErrorTooManyWriteOperations:
    return [[self tagName] isEqual:[aDeleteBatchError tagName]];
  case DBFILESDeleteBatchErrorOther:
    return [[self tagName] isEqual:[aDeleteBatchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteBatchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteBatchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTooManyWriteOperations]) {
    jsonDict[@".tag"] = @"too_many_write_operations";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteBatchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"too_many_write_operations"]) {
    return [[DBFILESDeleteBatchError alloc] initWithTooManyWriteOperations];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESDeleteBatchError alloc] initWithOther];
  } else {
    return [[DBFILESDeleteBatchError alloc] initWithOther];
  }
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBFILESDeleteBatchError.h"
#import "DBFILESDeleteBatchJobStatus.h"
#import "DBFILESDeleteBatchResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteBatchJobStatus

@synthesize complete = _complete;
@synthesize failed = _failed;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESDeleteBatchResult *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchJobStatusComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithFailed:(DBFILESDeleteBatchError *)failed {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchJobStatusFailed;
    _failed = failed;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchJobStatusOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESDeleteBatchResult *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDeleteBatchJobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

- (DBFILESDeleteBatchError *)failed {
  if (![self isFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDeleteBatchJobStatusFailed, but was %@.", [self tagName]];
  }
  return _failed;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBFILESDeleteBatchJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBFILESDeleteBatchJobStatusComplete;
}

- (BOOL)isFailed {
  return _tag == DBFILESDeleteBatchJobStatusFailed;
}

- (BOOL)isOther {
  return _tag == DBFILESDeleteBatchJobStatusOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESDeleteBatchJobStatusInProgress:
    return @"DBFILESDeleteBatchJobStatusInProgress";
  case DBFILESDeleteBatchJobStatusComplete:
    return @"DBFILESDeleteBatchJobStatusComplete";
  case DBFILESDeleteBatchJobStatusFailed:
    return @"DBFILESDeleteBatchJobStatusFailed";
  case DBFILESDeleteBatchJobStatusOther:
    return @"DBFILESDeleteBatchJobStatusOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteBatchJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteBatchJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteBatchJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESDeleteBatchJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESDeleteBatchJobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBFILESDeleteBatchJobStatusFailed:
    result = prime * result + [self.failed hash];
    break;
  case DBFILESDeleteBatchJobStatusOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteBatchJobStatus:other];
}

- (BOOL)isEqualToDeleteBatchJobStatus:(DBFILESDeleteBatchJobStatus *)aDeleteBatchJobStatus {
  if (self == aDeleteBatchJobStatus) {
    return YES;
  }
  if (self.tag != aDeleteBatchJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESDeleteBatchJobStatusInProgress:
    return [[self tagName] isEqual:[aDeleteBatchJobStatus tagName]];
  case DBFILESDeleteBatchJobStatusComplete:
    return [self.complete isEqual:aDeleteBatchJobStatus.complete];
  case DBFILESDeleteBatchJobStatusFailed:
    return [self.failed isEqual:aDeleteBatchJobStatus.failed];
  case DBFILESDeleteBatchJobStatusOther:
    return [[self tagName] isEqual:[aDeleteBatchJobStatus tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteBatchJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteBatchJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESDeleteBatchResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isFailed]) {
    jsonDict[@"failed"] = [[DBFILESDeleteBatchErrorSerializer serialize:valueObj.failed] mutableCopy];
    jsonDict[@".tag"] = @"failed";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteBatchJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBFILESDeleteBatchJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESDeleteBatchResult *complete = [DBFILESDeleteBatchResultSerializer deserialize:valueDict];
    return [[DBFILESDeleteBatchJobStatus alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"failed"]) {
    DBFILESDeleteBatchError *failed = [DBFILESDeleteBatchErrorSerializer deserialize:valueDict[@"failed"]];
    return [[DBFILESDeleteBatchJobStatus alloc] initWithFailed:failed];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESDeleteBatchJobStatus alloc] initWithOther];
  } else {
    return [[DBFILESDeleteBatchJobStatus alloc] initWithOther];
  }
}

@end

#import "DBASYNCLaunchResultBase.h"
#import "DBFILESDeleteBatchLaunch.h"
#import "DBFILESDeleteBatchResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteBatchLaunch

@synthesize asyncJobId = _asyncJobId;
@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchLaunchAsyncJobId;
    _asyncJobId = asyncJobId;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESDeleteBatchResult *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchLaunchComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchLaunchOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)asyncJobId {
  if (![self isAsyncJobId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDeleteBatchLaunchAsyncJobId, but was %@.", [self tagName]];
  }
  return _asyncJobId;
}

- (DBFILESDeleteBatchResult *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDeleteBatchLaunchComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isAsyncJobId {
  return _tag == DBFILESDeleteBatchLaunchAsyncJobId;
}

- (BOOL)isComplete {
  return _tag == DBFILESDeleteBatchLaunchComplete;
}

- (BOOL)isOther {
  return _tag == DBFILESDeleteBatchLaunchOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESDeleteBatchLaunchAsyncJobId:
    return @"DBFILESDeleteBatchLaunchAsyncJobId";
  case DBFILESDeleteBatchLaunchComplete:
    return @"DBFILESDeleteBatchLaunchComplete";
  case DBFILESDeleteBatchLaunchOther:
    return @"DBFILESDeleteBatchLaunchOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteBatchLaunchSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteBatchLaunchSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteBatchLaunchSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESDeleteBatchLaunchAsyncJobId:
    result = prime * result + [self.asyncJobId hash];
    break;
  case DBFILESDeleteBatchLaunchComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBFILESDeleteBatchLaunchOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteBatchLaunch:other];
}

- (BOOL)isEqualToDeleteBatchLaunch:(DBFILESDeleteBatchLaunch *)aDeleteBatchLaunch {
  if (self == aDeleteBatchLaunch) {
    return YES;
  }
  if (self.tag != aDeleteBatchLaunch.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESDeleteBatchLaunchAsyncJobId:
    return [self.asyncJobId isEqual:aDeleteBatchLaunch.asyncJobId];
  case DBFILESDeleteBatchLaunchComplete:
    return [self.complete isEqual:aDeleteBatchLaunch.complete];
  case DBFILESDeleteBatchLaunchOther:
    return [[self tagName] isEqual:[aDeleteBatchLaunch tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteBatchLaunchSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteBatchLaunch *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAsyncJobId]) {
    jsonDict[@"async_job_id"] = valueObj.asyncJobId;
    jsonDict[@".tag"] = @"async_job_id";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESDeleteBatchResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteBatchLaunch *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"async_job_id"]) {
    NSString *asyncJobId = valueDict[@"async_job_id"];
    return [[DBFILESDeleteBatchLaunch alloc] initWithAsyncJobId:asyncJobId];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESDeleteBatchResult *complete = [DBFILESDeleteBatchResultSerializer deserialize:valueDict];
    return [[DBFILESDeleteBatchLaunch alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESDeleteBatchLaunch alloc] initWithOther];
  } else {
    return [[DBFILESDeleteBatchLaunch alloc] initWithOther];
  }
}

@end

#import "DBFILESDeleteBatchResult.h"
#import "DBFILESDeleteBatchResultEntry.h"
#import "DBFILESFileOpsResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteBatchResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESDeleteBatchResultEntry *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super initDefault];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteBatchResult:other];
}

- (BOOL)isEqualToDeleteBatchResult:(DBFILESDeleteBatchResult *)aDeleteBatchResult {
  if (self == aDeleteBatchResult) {
    return YES;
  }
  if (![self.entries isEqual:aDeleteBatchResult.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESDeleteBatchResultEntrySerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESDeleteBatchResultEntry *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESDeleteBatchResultEntrySerializer deserialize:elem0];
                           }];

  return [[DBFILESDeleteBatchResult alloc] initWithEntries:entries];
}

@end

#import "DBFILESDeleteBatchResultData.h"
#import "DBFILESMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteBatchResultData

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata {
  [DBStoneValidators nonnullValidator:nil](metadata);

  self = [super init];
  if (self) {
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteBatchResultDataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteBatchResultDataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteBatchResultDataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteBatchResultData:other];
}

- (BOOL)isEqualToDeleteBatchResultData:(DBFILESDeleteBatchResultData *)aDeleteBatchResultData {
  if (self == aDeleteBatchResultData) {
    return YES;
  }
  if (![self.metadata isEqual:aDeleteBatchResultData.metadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteBatchResultDataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteBatchResultData *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESMetadataSerializer serialize:valueObj.metadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteBatchResultData *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESMetadata *metadata = [DBFILESMetadataSerializer deserialize:valueDict[@"metadata"]];

  return [[DBFILESDeleteBatchResultData alloc] initWithMetadata:metadata];
}

@end

#import "DBFILESDeleteBatchResultData.h"
#import "DBFILESDeleteBatchResultEntry.h"
#import "DBFILESDeleteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteBatchResultEntry

@synthesize success = _success;
@synthesize failure = _failure;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBFILESDeleteBatchResultData *)success {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchResultEntrySuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithFailure:(DBFILESDeleteError *)failure {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteBatchResultEntryFailure;
    _failure = failure;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESDeleteBatchResultData *)success {
  if (![self isSuccess]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDeleteBatchResultEntrySuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBFILESDeleteError *)failure {
  if (![self isFailure]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDeleteBatchResultEntryFailure, but was %@.", [self tagName]];
  }
  return _failure;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBFILESDeleteBatchResultEntrySuccess;
}

- (BOOL)isFailure {
  return _tag == DBFILESDeleteBatchResultEntryFailure;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESDeleteBatchResultEntrySuccess:
    return @"DBFILESDeleteBatchResultEntrySuccess";
  case DBFILESDeleteBatchResultEntryFailure:
    return @"DBFILESDeleteBatchResultEntryFailure";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteBatchResultEntrySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteBatchResultEntrySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteBatchResultEntrySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESDeleteBatchResultEntrySuccess:
    result = prime * result + [self.success hash];
    break;
  case DBFILESDeleteBatchResultEntryFailure:
    result = prime * result + [self.failure hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteBatchResultEntry:other];
}

- (BOOL)isEqualToDeleteBatchResultEntry:(DBFILESDeleteBatchResultEntry *)aDeleteBatchResultEntry {
  if (self == aDeleteBatchResultEntry) {
    return YES;
  }
  if (self.tag != aDeleteBatchResultEntry.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESDeleteBatchResultEntrySuccess:
    return [self.success isEqual:aDeleteBatchResultEntry.success];
  case DBFILESDeleteBatchResultEntryFailure:
    return [self.failure isEqual:aDeleteBatchResultEntry.failure];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteBatchResultEntrySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteBatchResultEntry *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict = [[DBFILESDeleteBatchResultDataSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isFailure]) {
    jsonDict[@"failure"] = [[DBFILESDeleteErrorSerializer serialize:valueObj.failure] mutableCopy];
    jsonDict[@".tag"] = @"failure";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteBatchResultEntry *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBFILESDeleteBatchResultData *success = [DBFILESDeleteBatchResultDataSerializer deserialize:valueDict];
    return [[DBFILESDeleteBatchResultEntry alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"failure"]) {
    DBFILESDeleteError *failure = [DBFILESDeleteErrorSerializer deserialize:valueDict[@"failure"]];
    return [[DBFILESDeleteBatchResultEntry alloc] initWithFailure:failure];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESDeleteError.h"
#import "DBFILESLookupError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteError

@synthesize pathLookup = _pathLookup;
@synthesize pathWrite = _pathWrite;

#pragma mark - Constructors

- (instancetype)initWithPathLookup:(DBFILESLookupError *)pathLookup {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteErrorPathLookup;
    _pathLookup = pathLookup;
  }
  return self;
}

- (instancetype)initWithPathWrite:(DBFILESWriteError *)pathWrite {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteErrorPathWrite;
    _pathWrite = pathWrite;
  }
  return self;
}

- (instancetype)initWithTooManyWriteOperations {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteErrorTooManyWriteOperations;
  }
  return self;
}

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESDeleteErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)pathLookup {
  if (![self isPathLookup]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDeleteErrorPathLookup, but was %@.", [self tagName]];
  }
  return _pathLookup;
}

- (DBFILESWriteError *)pathWrite {
  if (![self isPathWrite]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDeleteErrorPathWrite, but was %@.", [self tagName]];
  }
  return _pathWrite;
}

#pragma mark - Tag state methods

- (BOOL)isPathLookup {
  return _tag == DBFILESDeleteErrorPathLookup;
}

- (BOOL)isPathWrite {
  return _tag == DBFILESDeleteErrorPathWrite;
}

- (BOOL)isTooManyWriteOperations {
  return _tag == DBFILESDeleteErrorTooManyWriteOperations;
}

- (BOOL)isTooManyFiles {
  return _tag == DBFILESDeleteErrorTooManyFiles;
}

- (BOOL)isOther {
  return _tag == DBFILESDeleteErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESDeleteErrorPathLookup:
    return @"DBFILESDeleteErrorPathLookup";
  case DBFILESDeleteErrorPathWrite:
    return @"DBFILESDeleteErrorPathWrite";
  case DBFILESDeleteErrorTooManyWriteOperations:
    return @"DBFILESDeleteErrorTooManyWriteOperations";
  case DBFILESDeleteErrorTooManyFiles:
    return @"DBFILESDeleteErrorTooManyFiles";
  case DBFILESDeleteErrorOther:
    return @"DBFILESDeleteErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESDeleteErrorPathLookup:
    result = prime * result + [self.pathLookup hash];
    break;
  case DBFILESDeleteErrorPathWrite:
    result = prime * result + [self.pathWrite hash];
    break;
  case DBFILESDeleteErrorTooManyWriteOperations:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESDeleteErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESDeleteErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteError:other];
}

- (BOOL)isEqualToDeleteError:(DBFILESDeleteError *)aDeleteError {
  if (self == aDeleteError) {
    return YES;
  }
  if (self.tag != aDeleteError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESDeleteErrorPathLookup:
    return [self.pathLookup isEqual:aDeleteError.pathLookup];
  case DBFILESDeleteErrorPathWrite:
    return [self.pathWrite isEqual:aDeleteError.pathWrite];
  case DBFILESDeleteErrorTooManyWriteOperations:
    return [[self tagName] isEqual:[aDeleteError tagName]];
  case DBFILESDeleteErrorTooManyFiles:
    return [[self tagName] isEqual:[aDeleteError tagName]];
  case DBFILESDeleteErrorOther:
    return [[self tagName] isEqual:[aDeleteError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPathLookup]) {
    jsonDict[@"path_lookup"] = [[DBFILESLookupErrorSerializer serialize:valueObj.pathLookup] mutableCopy];
    jsonDict[@".tag"] = @"path_lookup";
  } else if ([valueObj isPathWrite]) {
    jsonDict[@"path_write"] = [[DBFILESWriteErrorSerializer serialize:valueObj.pathWrite] mutableCopy];
    jsonDict[@".tag"] = @"path_write";
  } else if ([valueObj isTooManyWriteOperations]) {
    jsonDict[@".tag"] = @"too_many_write_operations";
  } else if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path_lookup"]) {
    DBFILESLookupError *pathLookup = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path_lookup"]];
    return [[DBFILESDeleteError alloc] initWithPathLookup:pathLookup];
  } else if ([tag isEqualToString:@"path_write"]) {
    DBFILESWriteError *pathWrite = [DBFILESWriteErrorSerializer deserialize:valueDict[@"path_write"]];
    return [[DBFILESDeleteError alloc] initWithPathWrite:pathWrite];
  } else if ([tag isEqualToString:@"too_many_write_operations"]) {
    return [[DBFILESDeleteError alloc] initWithTooManyWriteOperations];
  } else if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBFILESDeleteError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESDeleteError alloc] initWithOther];
  } else {
    return [[DBFILESDeleteError alloc] initWithOther];
  }
}

@end

#import "DBFILESDeleteResult.h"
#import "DBFILESFileOpsResult.h"
#import "DBFILESMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeleteResult

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata {
  [DBStoneValidators nonnullValidator:nil](metadata);

  self = [super initDefault];
  if (self) {
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeleteResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeleteResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeleteResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteResult:other];
}

- (BOOL)isEqualToDeleteResult:(DBFILESDeleteResult *)aDeleteResult {
  if (self == aDeleteResult) {
    return YES;
  }
  if (![self.metadata isEqual:aDeleteResult.metadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeleteResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESMetadataSerializer serialize:valueObj.metadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeleteResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESMetadata *metadata = [DBFILESMetadataSerializer deserialize:valueDict[@"metadata"]];

  return [[DBFILESDeleteResult alloc] initWithMetadata:metadata];
}

@end

#import "DBFILESDeletedMetadata.h"
#import "DBFILESFileMetadata.h"
#import "DBFILESFolderMetadata.h"
#import "DBFILESMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESMetadata

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name
                   pathLower:(NSString *)pathLower
                 pathDisplay:(NSString *)pathDisplay
        parentSharedFolderId:(NSString *)parentSharedFolderId {
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](
      parentSharedFolderId);

  self = [super init];
  if (self) {
    _name = name;
    _pathLower = pathLower;
    _pathDisplay = pathDisplay;
    _parentSharedFolderId = parentSharedFolderId;
  }
  return self;
}

- (instancetype)initWithName:(NSString *)name {
  return [self initWithName:name pathLower:nil pathDisplay:nil parentSharedFolderId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.pathDisplay != nil) {
    result = prime * result + [self.pathDisplay hash];
  }
  if (self.parentSharedFolderId != nil) {
    result = prime * result + [self.parentSharedFolderId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMetadata:other];
}

- (BOOL)isEqualToMetadata:(DBFILESMetadata *)aMetadata {
  if (self == aMetadata) {
    return YES;
  }
  if (![self.name isEqual:aMetadata.name]) {
    return NO;
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aMetadata.pathLower]) {
      return NO;
    }
  }
  if (self.pathDisplay) {
    if (![self.pathDisplay isEqual:aMetadata.pathDisplay]) {
      return NO;
    }
  }
  if (self.parentSharedFolderId) {
    if (![self.parentSharedFolderId isEqual:aMetadata.parentSharedFolderId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.pathDisplay) {
    jsonDict[@"path_display"] = valueObj.pathDisplay;
  }
  if (valueObj.parentSharedFolderId) {
    jsonDict[@"parent_shared_folder_id"] = valueObj.parentSharedFolderId;
  }

  if ([valueObj isKindOfClass:[DBFILESFileMetadata class]]) {
    NSDictionary *subTypeFields = [DBFILESFileMetadataSerializer serialize:(DBFILESFileMetadata *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"file";
  } else if ([valueObj isKindOfClass:[DBFILESFolderMetadata class]]) {
    NSDictionary *subTypeFields = [DBFILESFolderMetadataSerializer serialize:(DBFILESFolderMetadata *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"folder";
  } else if ([valueObj isKindOfClass:[DBFILESDeletedMetadata class]]) {
    NSDictionary *subTypeFields = [DBFILESDeletedMetadataSerializer serialize:(DBFILESDeletedMetadata *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"deleted";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  if ([valueDict[@".tag"] isEqualToString:@"file"]) {
    return [DBFILESFileMetadataSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"folder"]) {
    return [DBFILESFolderMetadataSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"deleted"]) {
    return [DBFILESDeletedMetadataSerializer deserialize:valueDict];
  }

  @throw([NSException
      exceptionWithName:@"InvalidTag"
                 reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
               userInfo:nil]);
}

@end

#import "DBFILESDeletedMetadata.h"
#import "DBFILESMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDeletedMetadata

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name
                   pathLower:(NSString *)pathLower
                 pathDisplay:(NSString *)pathDisplay
        parentSharedFolderId:(NSString *)parentSharedFolderId {
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](
      parentSharedFolderId);

  self =
      [super initWithName:name pathLower:pathLower pathDisplay:pathDisplay parentSharedFolderId:parentSharedFolderId];
  if (self) {
  }
  return self;
}

- (instancetype)initWithName:(NSString *)name {
  return [self initWithName:name pathLower:nil pathDisplay:nil parentSharedFolderId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDeletedMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDeletedMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDeletedMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.pathDisplay != nil) {
    result = prime * result + [self.pathDisplay hash];
  }
  if (self.parentSharedFolderId != nil) {
    result = prime * result + [self.parentSharedFolderId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeletedMetadata:other];
}

- (BOOL)isEqualToDeletedMetadata:(DBFILESDeletedMetadata *)aDeletedMetadata {
  if (self == aDeletedMetadata) {
    return YES;
  }
  if (![self.name isEqual:aDeletedMetadata.name]) {
    return NO;
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aDeletedMetadata.pathLower]) {
      return NO;
    }
  }
  if (self.pathDisplay) {
    if (![self.pathDisplay isEqual:aDeletedMetadata.pathDisplay]) {
      return NO;
    }
  }
  if (self.parentSharedFolderId) {
    if (![self.parentSharedFolderId isEqual:aDeletedMetadata.parentSharedFolderId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDeletedMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDeletedMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.pathDisplay) {
    jsonDict[@"path_display"] = valueObj.pathDisplay;
  }
  if (valueObj.parentSharedFolderId) {
    jsonDict[@"parent_shared_folder_id"] = valueObj.parentSharedFolderId;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDeletedMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *name = valueDict[@"name"];
  NSString *pathLower = valueDict[@"path_lower"] ?: nil;
  NSString *pathDisplay = valueDict[@"path_display"] ?: nil;
  NSString *parentSharedFolderId = valueDict[@"parent_shared_folder_id"] ?: nil;

  return [[DBFILESDeletedMetadata alloc] initWithName:name
                                            pathLower:pathLower
                                          pathDisplay:pathDisplay
                                 parentSharedFolderId:parentSharedFolderId];
}

@end

#import "DBFILESDimensions.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDimensions

#pragma mark - Constructors

- (instancetype)initWithHeight:(NSNumber *)height width:(NSNumber *)width {
  [DBStoneValidators nonnullValidator:nil](height);
  [DBStoneValidators nonnullValidator:nil](width);

  self = [super init];
  if (self) {
    _height = height;
    _width = width;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDimensionsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDimensionsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDimensionsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.height hash];
  result = prime * result + [self.width hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDimensions:other];
}

- (BOOL)isEqualToDimensions:(DBFILESDimensions *)aDimensions {
  if (self == aDimensions) {
    return YES;
  }
  if (![self.height isEqual:aDimensions.height]) {
    return NO;
  }
  if (![self.width isEqual:aDimensions.width]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDimensionsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDimensions *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"height"] = valueObj.height;
  jsonDict[@"width"] = valueObj.width;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDimensions *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *height = valueDict[@"height"];
  NSNumber *width = valueDict[@"width"];

  return [[DBFILESDimensions alloc] initWithHeight:height width:width];
}

@end

#import "DBFILESDownloadArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDownloadArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path rev:(NSString *)rev {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:@(9) maxLength:nil pattern:@"[0-9a-f]+"]](rev);

  self = [super init];
  if (self) {
    _path = path;
    _rev = rev;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path rev:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDownloadArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDownloadArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDownloadArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  if (self.rev != nil) {
    result = prime * result + [self.rev hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDownloadArg:other];
}

- (BOOL)isEqualToDownloadArg:(DBFILESDownloadArg *)aDownloadArg {
  if (self == aDownloadArg) {
    return YES;
  }
  if (![self.path isEqual:aDownloadArg.path]) {
    return NO;
  }
  if (self.rev) {
    if (![self.rev isEqual:aDownloadArg.rev]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDownloadArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDownloadArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  if (valueObj.rev) {
    jsonDict[@"rev"] = valueObj.rev;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDownloadArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSString *rev = valueDict[@"rev"] ?: nil;

  return [[DBFILESDownloadArg alloc] initWithPath:path rev:rev];
}

@end

#import "DBFILESDownloadError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDownloadError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESDownloadErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithUnsupportedFile {
  self = [super init];
  if (self) {
    _tag = DBFILESDownloadErrorUnsupportedFile;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESDownloadErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDownloadErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESDownloadErrorPath;
}

- (BOOL)isUnsupportedFile {
  return _tag == DBFILESDownloadErrorUnsupportedFile;
}

- (BOOL)isOther {
  return _tag == DBFILESDownloadErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESDownloadErrorPath:
    return @"DBFILESDownloadErrorPath";
  case DBFILESDownloadErrorUnsupportedFile:
    return @"DBFILESDownloadErrorUnsupportedFile";
  case DBFILESDownloadErrorOther:
    return @"DBFILESDownloadErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDownloadErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDownloadErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDownloadErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESDownloadErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESDownloadErrorUnsupportedFile:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESDownloadErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDownloadError:other];
}

- (BOOL)isEqualToDownloadError:(DBFILESDownloadError *)aDownloadError {
  if (self == aDownloadError) {
    return YES;
  }
  if (self.tag != aDownloadError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESDownloadErrorPath:
    return [self.path isEqual:aDownloadError.path];
  case DBFILESDownloadErrorUnsupportedFile:
    return [[self tagName] isEqual:[aDownloadError tagName]];
  case DBFILESDownloadErrorOther:
    return [[self tagName] isEqual:[aDownloadError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDownloadErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDownloadError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isUnsupportedFile]) {
    jsonDict[@".tag"] = @"unsupported_file";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDownloadError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESDownloadError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"unsupported_file"]) {
    return [[DBFILESDownloadError alloc] initWithUnsupportedFile];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESDownloadError alloc] initWithOther];
  } else {
    return [[DBFILESDownloadError alloc] initWithOther];
  }
}

@end

#import "DBFILESDownloadZipArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDownloadZipArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDownloadZipArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDownloadZipArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDownloadZipArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDownloadZipArg:other];
}

- (BOOL)isEqualToDownloadZipArg:(DBFILESDownloadZipArg *)aDownloadZipArg {
  if (self == aDownloadZipArg) {
    return YES;
  }
  if (![self.path isEqual:aDownloadZipArg.path]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDownloadZipArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDownloadZipArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDownloadZipArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];

  return [[DBFILESDownloadZipArg alloc] initWithPath:path];
}

@end

#import "DBFILESDownloadZipError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDownloadZipError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESDownloadZipErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithTooLarge {
  self = [super init];
  if (self) {
    _tag = DBFILESDownloadZipErrorTooLarge;
  }
  return self;
}

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBFILESDownloadZipErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESDownloadZipErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESDownloadZipErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESDownloadZipErrorPath;
}

- (BOOL)isTooLarge {
  return _tag == DBFILESDownloadZipErrorTooLarge;
}

- (BOOL)isTooManyFiles {
  return _tag == DBFILESDownloadZipErrorTooManyFiles;
}

- (BOOL)isOther {
  return _tag == DBFILESDownloadZipErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESDownloadZipErrorPath:
    return @"DBFILESDownloadZipErrorPath";
  case DBFILESDownloadZipErrorTooLarge:
    return @"DBFILESDownloadZipErrorTooLarge";
  case DBFILESDownloadZipErrorTooManyFiles:
    return @"DBFILESDownloadZipErrorTooManyFiles";
  case DBFILESDownloadZipErrorOther:
    return @"DBFILESDownloadZipErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDownloadZipErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDownloadZipErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDownloadZipErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESDownloadZipErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESDownloadZipErrorTooLarge:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESDownloadZipErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESDownloadZipErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDownloadZipError:other];
}

- (BOOL)isEqualToDownloadZipError:(DBFILESDownloadZipError *)aDownloadZipError {
  if (self == aDownloadZipError) {
    return YES;
  }
  if (self.tag != aDownloadZipError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESDownloadZipErrorPath:
    return [self.path isEqual:aDownloadZipError.path];
  case DBFILESDownloadZipErrorTooLarge:
    return [[self tagName] isEqual:[aDownloadZipError tagName]];
  case DBFILESDownloadZipErrorTooManyFiles:
    return [[self tagName] isEqual:[aDownloadZipError tagName]];
  case DBFILESDownloadZipErrorOther:
    return [[self tagName] isEqual:[aDownloadZipError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDownloadZipErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDownloadZipError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isTooLarge]) {
    jsonDict[@".tag"] = @"too_large";
  } else if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDownloadZipError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESDownloadZipError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"too_large"]) {
    return [[DBFILESDownloadZipError alloc] initWithTooLarge];
  } else if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBFILESDownloadZipError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESDownloadZipError alloc] initWithOther];
  } else {
    return [[DBFILESDownloadZipError alloc] initWithOther];
  }
}

@end

#import "DBFILESDownloadZipResult.h"
#import "DBFILESFolderMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESDownloadZipResult

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESFolderMetadata *)metadata {
  [DBStoneValidators nonnullValidator:nil](metadata);

  self = [super init];
  if (self) {
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESDownloadZipResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESDownloadZipResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESDownloadZipResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDownloadZipResult:other];
}

- (BOOL)isEqualToDownloadZipResult:(DBFILESDownloadZipResult *)aDownloadZipResult {
  if (self == aDownloadZipResult) {
    return YES;
  }
  if (![self.metadata isEqual:aDownloadZipResult.metadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESDownloadZipResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESDownloadZipResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESFolderMetadataSerializer serialize:valueObj.metadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESDownloadZipResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESFolderMetadata *metadata = [DBFILESFolderMetadataSerializer deserialize:valueDict[@"metadata"]];

  return [[DBFILESDownloadZipResult alloc] initWithMetadata:metadata];
}

@end

#import "DBFILESExportArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESExportArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path exportFormat:(NSString *)exportFormat {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
    _exportFormat = exportFormat;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path exportFormat:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESExportArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESExportArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESExportArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  if (self.exportFormat != nil) {
    result = prime * result + [self.exportFormat hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExportArg:other];
}

- (BOOL)isEqualToExportArg:(DBFILESExportArg *)anExportArg {
  if (self == anExportArg) {
    return YES;
  }
  if (![self.path isEqual:anExportArg.path]) {
    return NO;
  }
  if (self.exportFormat) {
    if (![self.exportFormat isEqual:anExportArg.exportFormat]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESExportArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESExportArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  if (valueObj.exportFormat) {
    jsonDict[@"export_format"] = valueObj.exportFormat;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESExportArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSString *exportFormat = valueDict[@"export_format"] ?: nil;

  return [[DBFILESExportArg alloc] initWithPath:path exportFormat:exportFormat];
}

@end

#import "DBFILESExportError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESExportError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESExportErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithNonExportable {
  self = [super init];
  if (self) {
    _tag = DBFILESExportErrorNonExportable;
  }
  return self;
}

- (instancetype)initWithInvalidExportFormat {
  self = [super init];
  if (self) {
    _tag = DBFILESExportErrorInvalidExportFormat;
  }
  return self;
}

- (instancetype)initWithRetryError {
  self = [super init];
  if (self) {
    _tag = DBFILESExportErrorRetryError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESExportErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESExportErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESExportErrorPath;
}

- (BOOL)isNonExportable {
  return _tag == DBFILESExportErrorNonExportable;
}

- (BOOL)isInvalidExportFormat {
  return _tag == DBFILESExportErrorInvalidExportFormat;
}

- (BOOL)isRetryError {
  return _tag == DBFILESExportErrorRetryError;
}

- (BOOL)isOther {
  return _tag == DBFILESExportErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESExportErrorPath:
    return @"DBFILESExportErrorPath";
  case DBFILESExportErrorNonExportable:
    return @"DBFILESExportErrorNonExportable";
  case DBFILESExportErrorInvalidExportFormat:
    return @"DBFILESExportErrorInvalidExportFormat";
  case DBFILESExportErrorRetryError:
    return @"DBFILESExportErrorRetryError";
  case DBFILESExportErrorOther:
    return @"DBFILESExportErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESExportErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESExportErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESExportErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESExportErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESExportErrorNonExportable:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESExportErrorInvalidExportFormat:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESExportErrorRetryError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESExportErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExportError:other];
}

- (BOOL)isEqualToExportError:(DBFILESExportError *)anExportError {
  if (self == anExportError) {
    return YES;
  }
  if (self.tag != anExportError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESExportErrorPath:
    return [self.path isEqual:anExportError.path];
  case DBFILESExportErrorNonExportable:
    return [[self tagName] isEqual:[anExportError tagName]];
  case DBFILESExportErrorInvalidExportFormat:
    return [[self tagName] isEqual:[anExportError tagName]];
  case DBFILESExportErrorRetryError:
    return [[self tagName] isEqual:[anExportError tagName]];
  case DBFILESExportErrorOther:
    return [[self tagName] isEqual:[anExportError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESExportErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESExportError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isNonExportable]) {
    jsonDict[@".tag"] = @"non_exportable";
  } else if ([valueObj isInvalidExportFormat]) {
    jsonDict[@".tag"] = @"invalid_export_format";
  } else if ([valueObj isRetryError]) {
    jsonDict[@".tag"] = @"retry_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESExportError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESExportError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"non_exportable"]) {
    return [[DBFILESExportError alloc] initWithNonExportable];
  } else if ([tag isEqualToString:@"invalid_export_format"]) {
    return [[DBFILESExportError alloc] initWithInvalidExportFormat];
  } else if ([tag isEqualToString:@"retry_error"]) {
    return [[DBFILESExportError alloc] initWithRetryError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESExportError alloc] initWithOther];
  } else {
    return [[DBFILESExportError alloc] initWithOther];
  }
}

@end

#import "DBFILESExportInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESExportInfo

#pragma mark - Constructors

- (instancetype)initWithExportAs:(NSString *)exportAs exportOptions:(NSArray<NSString *> *)exportOptions {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](exportOptions);

  self = [super init];
  if (self) {
    _exportAs = exportAs;
    _exportOptions = exportOptions;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithExportAs:nil exportOptions:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESExportInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESExportInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESExportInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.exportAs != nil) {
    result = prime * result + [self.exportAs hash];
  }
  if (self.exportOptions != nil) {
    result = prime * result + [self.exportOptions hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExportInfo:other];
}

- (BOOL)isEqualToExportInfo:(DBFILESExportInfo *)anExportInfo {
  if (self == anExportInfo) {
    return YES;
  }
  if (self.exportAs) {
    if (![self.exportAs isEqual:anExportInfo.exportAs]) {
      return NO;
    }
  }
  if (self.exportOptions) {
    if (![self.exportOptions isEqual:anExportInfo.exportOptions]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESExportInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESExportInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.exportAs) {
    jsonDict[@"export_as"] = valueObj.exportAs;
  }
  if (valueObj.exportOptions) {
    jsonDict[@"export_options"] = [DBArraySerializer serialize:valueObj.exportOptions
                                                     withBlock:^id(id elem0) {
                                                       return elem0;
                                                     }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESExportInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *exportAs = valueDict[@"export_as"] ?: nil;
  NSArray<NSString *> *exportOptions = valueDict[@"export_options"]
                                           ? [DBArraySerializer deserialize:valueDict[@"export_options"]
                                                                  withBlock:^id(id elem0) {
                                                                    return elem0;
                                                                  }]
                                           : nil;

  return [[DBFILESExportInfo alloc] initWithExportAs:exportAs exportOptions:exportOptions];
}

@end

#import "DBFILESExportMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESExportMetadata

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name
                        size:(NSNumber *)size
                  exportHash:(NSString *)exportHash
               paperRevision:(NSNumber *)paperRevision {
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](size);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:@(64) maxLength:@(64) pattern:nil]](exportHash);

  self = [super init];
  if (self) {
    _name = name;
    _size = size;
    _exportHash = exportHash;
    _paperRevision = paperRevision;
  }
  return self;
}

- (instancetype)initWithName:(NSString *)name size:(NSNumber *)size {
  return [self initWithName:name size:size exportHash:nil paperRevision:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESExportMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESExportMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESExportMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];
  result = prime * result + [self.size hash];
  if (self.exportHash != nil) {
    result = prime * result + [self.exportHash hash];
  }
  if (self.paperRevision != nil) {
    result = prime * result + [self.paperRevision hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExportMetadata:other];
}

- (BOOL)isEqualToExportMetadata:(DBFILESExportMetadata *)anExportMetadata {
  if (self == anExportMetadata) {
    return YES;
  }
  if (![self.name isEqual:anExportMetadata.name]) {
    return NO;
  }
  if (![self.size isEqual:anExportMetadata.size]) {
    return NO;
  }
  if (self.exportHash) {
    if (![self.exportHash isEqual:anExportMetadata.exportHash]) {
      return NO;
    }
  }
  if (self.paperRevision) {
    if (![self.paperRevision isEqual:anExportMetadata.paperRevision]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESExportMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESExportMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"size"] = valueObj.size;
  if (valueObj.exportHash) {
    jsonDict[@"export_hash"] = valueObj.exportHash;
  }
  if (valueObj.paperRevision) {
    jsonDict[@"paper_revision"] = valueObj.paperRevision;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESExportMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *name = valueDict[@"name"];
  NSNumber *size = valueDict[@"size"];
  NSString *exportHash = valueDict[@"export_hash"] ?: nil;
  NSNumber *paperRevision = valueDict[@"paper_revision"] ?: nil;

  return [[DBFILESExportMetadata alloc] initWithName:name size:size exportHash:exportHash paperRevision:paperRevision];
}

@end

#import "DBFILESExportMetadata.h"
#import "DBFILESExportResult.h"
#import "DBFILESFileMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESExportResult

#pragma mark - Constructors

- (instancetype)initWithExportMetadata:(DBFILESExportMetadata *)exportMetadata
                          fileMetadata:(DBFILESFileMetadata *)fileMetadata {
  [DBStoneValidators nonnullValidator:nil](exportMetadata);
  [DBStoneValidators nonnullValidator:nil](fileMetadata);

  self = [super init];
  if (self) {
    _exportMetadata = exportMetadata;
    _fileMetadata = fileMetadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESExportResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESExportResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESExportResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.exportMetadata hash];
  result = prime * result + [self.fileMetadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExportResult:other];
}

- (BOOL)isEqualToExportResult:(DBFILESExportResult *)anExportResult {
  if (self == anExportResult) {
    return YES;
  }
  if (![self.exportMetadata isEqual:anExportResult.exportMetadata]) {
    return NO;
  }
  if (![self.fileMetadata isEqual:anExportResult.fileMetadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESExportResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESExportResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"export_metadata"] = [DBFILESExportMetadataSerializer serialize:valueObj.exportMetadata];
  jsonDict[@"file_metadata"] = [DBFILESFileMetadataSerializer serialize:valueObj.fileMetadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESExportResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESExportMetadata *exportMetadata = [DBFILESExportMetadataSerializer deserialize:valueDict[@"export_metadata"]];
  DBFILESFileMetadata *fileMetadata = [DBFILESFileMetadataSerializer deserialize:valueDict[@"file_metadata"]];

  return [[DBFILESExportResult alloc] initWithExportMetadata:exportMetadata fileMetadata:fileMetadata];
}

@end

#import "DBFILESFileCategory.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFileCategory

#pragma mark - Constructors

- (instancetype)initWithImage {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryImage;
  }
  return self;
}

- (instancetype)initWithDocument {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryDocument;
  }
  return self;
}

- (instancetype)initWithPdf {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryPdf;
  }
  return self;
}

- (instancetype)initWithSpreadsheet {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategorySpreadsheet;
  }
  return self;
}

- (instancetype)initWithPresentation {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryPresentation;
  }
  return self;
}

- (instancetype)initWithAudio {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryAudio;
  }
  return self;
}

- (instancetype)initWithVideo {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryVideo;
  }
  return self;
}

- (instancetype)initWithFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryFolder;
  }
  return self;
}

- (instancetype)initWithPaper {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryPaper;
  }
  return self;
}

- (instancetype)initWithOthers {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryOthers;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESFileCategoryOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isImage {
  return _tag == DBFILESFileCategoryImage;
}

- (BOOL)isDocument {
  return _tag == DBFILESFileCategoryDocument;
}

- (BOOL)isPdf {
  return _tag == DBFILESFileCategoryPdf;
}

- (BOOL)isSpreadsheet {
  return _tag == DBFILESFileCategorySpreadsheet;
}

- (BOOL)isPresentation {
  return _tag == DBFILESFileCategoryPresentation;
}

- (BOOL)isAudio {
  return _tag == DBFILESFileCategoryAudio;
}

- (BOOL)isVideo {
  return _tag == DBFILESFileCategoryVideo;
}

- (BOOL)isFolder {
  return _tag == DBFILESFileCategoryFolder;
}

- (BOOL)isPaper {
  return _tag == DBFILESFileCategoryPaper;
}

- (BOOL)isOthers {
  return _tag == DBFILESFileCategoryOthers;
}

- (BOOL)isOther {
  return _tag == DBFILESFileCategoryOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESFileCategoryImage:
    return @"DBFILESFileCategoryImage";
  case DBFILESFileCategoryDocument:
    return @"DBFILESFileCategoryDocument";
  case DBFILESFileCategoryPdf:
    return @"DBFILESFileCategoryPdf";
  case DBFILESFileCategorySpreadsheet:
    return @"DBFILESFileCategorySpreadsheet";
  case DBFILESFileCategoryPresentation:
    return @"DBFILESFileCategoryPresentation";
  case DBFILESFileCategoryAudio:
    return @"DBFILESFileCategoryAudio";
  case DBFILESFileCategoryVideo:
    return @"DBFILESFileCategoryVideo";
  case DBFILESFileCategoryFolder:
    return @"DBFILESFileCategoryFolder";
  case DBFILESFileCategoryPaper:
    return @"DBFILESFileCategoryPaper";
  case DBFILESFileCategoryOthers:
    return @"DBFILESFileCategoryOthers";
  case DBFILESFileCategoryOther:
    return @"DBFILESFileCategoryOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFileCategorySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFileCategorySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFileCategorySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESFileCategoryImage:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategoryDocument:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategoryPdf:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategorySpreadsheet:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategoryPresentation:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategoryAudio:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategoryVideo:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategoryFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategoryPaper:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategoryOthers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileCategoryOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileCategory:other];
}

- (BOOL)isEqualToFileCategory:(DBFILESFileCategory *)aFileCategory {
  if (self == aFileCategory) {
    return YES;
  }
  if (self.tag != aFileCategory.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESFileCategoryImage:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategoryDocument:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategoryPdf:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategorySpreadsheet:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategoryPresentation:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategoryAudio:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategoryVideo:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategoryFolder:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategoryPaper:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategoryOthers:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  case DBFILESFileCategoryOther:
    return [[self tagName] isEqual:[aFileCategory tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFileCategorySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFileCategory *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isImage]) {
    jsonDict[@".tag"] = @"image";
  } else if ([valueObj isDocument]) {
    jsonDict[@".tag"] = @"document";
  } else if ([valueObj isPdf]) {
    jsonDict[@".tag"] = @"pdf";
  } else if ([valueObj isSpreadsheet]) {
    jsonDict[@".tag"] = @"spreadsheet";
  } else if ([valueObj isPresentation]) {
    jsonDict[@".tag"] = @"presentation";
  } else if ([valueObj isAudio]) {
    jsonDict[@".tag"] = @"audio";
  } else if ([valueObj isVideo]) {
    jsonDict[@".tag"] = @"video";
  } else if ([valueObj isFolder]) {
    jsonDict[@".tag"] = @"folder";
  } else if ([valueObj isPaper]) {
    jsonDict[@".tag"] = @"paper";
  } else if ([valueObj isOthers]) {
    jsonDict[@".tag"] = @"others";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFileCategory *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"image"]) {
    return [[DBFILESFileCategory alloc] initWithImage];
  } else if ([tag isEqualToString:@"document"]) {
    return [[DBFILESFileCategory alloc] initWithDocument];
  } else if ([tag isEqualToString:@"pdf"]) {
    return [[DBFILESFileCategory alloc] initWithPdf];
  } else if ([tag isEqualToString:@"spreadsheet"]) {
    return [[DBFILESFileCategory alloc] initWithSpreadsheet];
  } else if ([tag isEqualToString:@"presentation"]) {
    return [[DBFILESFileCategory alloc] initWithPresentation];
  } else if ([tag isEqualToString:@"audio"]) {
    return [[DBFILESFileCategory alloc] initWithAudio];
  } else if ([tag isEqualToString:@"video"]) {
    return [[DBFILESFileCategory alloc] initWithVideo];
  } else if ([tag isEqualToString:@"folder"]) {
    return [[DBFILESFileCategory alloc] initWithFolder];
  } else if ([tag isEqualToString:@"paper"]) {
    return [[DBFILESFileCategory alloc] initWithPaper];
  } else if ([tag isEqualToString:@"others"]) {
    return [[DBFILESFileCategory alloc] initWithOthers];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESFileCategory alloc] initWithOther];
  } else {
    return [[DBFILESFileCategory alloc] initWithOther];
  }
}

@end

#import "DBFILESFileLock.h"
#import "DBFILESFileLockContent.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFileLock

#pragma mark - Constructors

- (instancetype)initWithContent:(DBFILESFileLockContent *)content {
  [DBStoneValidators nonnullValidator:nil](content);

  self = [super init];
  if (self) {
    _content = content;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFileLockSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFileLockSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFileLockSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.content hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileLock:other];
}

- (BOOL)isEqualToFileLock:(DBFILESFileLock *)aFileLock {
  if (self == aFileLock) {
    return YES;
  }
  if (![self.content isEqual:aFileLock.content]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFileLockSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFileLock *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"content"] = [DBFILESFileLockContentSerializer serialize:valueObj.content];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFileLock *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESFileLockContent *content = [DBFILESFileLockContentSerializer deserialize:valueDict[@"content"]];

  return [[DBFILESFileLock alloc] initWithContent:content];
}

@end

#import "DBFILESFileLockContent.h"
#import "DBFILESSingleUserLock.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFileLockContent

@synthesize singleUser = _singleUser;

#pragma mark - Constructors

- (instancetype)initWithUnlocked {
  self = [super init];
  if (self) {
    _tag = DBFILESFileLockContentUnlocked;
  }
  return self;
}

- (instancetype)initWithSingleUser:(DBFILESSingleUserLock *)singleUser {
  self = [super init];
  if (self) {
    _tag = DBFILESFileLockContentSingleUser;
    _singleUser = singleUser;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESFileLockContentOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESSingleUserLock *)singleUser {
  if (![self isSingleUser]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESFileLockContentSingleUser, but was %@.", [self tagName]];
  }
  return _singleUser;
}

#pragma mark - Tag state methods

- (BOOL)isUnlocked {
  return _tag == DBFILESFileLockContentUnlocked;
}

- (BOOL)isSingleUser {
  return _tag == DBFILESFileLockContentSingleUser;
}

- (BOOL)isOther {
  return _tag == DBFILESFileLockContentOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESFileLockContentUnlocked:
    return @"DBFILESFileLockContentUnlocked";
  case DBFILESFileLockContentSingleUser:
    return @"DBFILESFileLockContentSingleUser";
  case DBFILESFileLockContentOther:
    return @"DBFILESFileLockContentOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFileLockContentSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFileLockContentSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFileLockContentSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESFileLockContentUnlocked:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileLockContentSingleUser:
    result = prime * result + [self.singleUser hash];
    break;
  case DBFILESFileLockContentOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileLockContent:other];
}

- (BOOL)isEqualToFileLockContent:(DBFILESFileLockContent *)aFileLockContent {
  if (self == aFileLockContent) {
    return YES;
  }
  if (self.tag != aFileLockContent.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESFileLockContentUnlocked:
    return [[self tagName] isEqual:[aFileLockContent tagName]];
  case DBFILESFileLockContentSingleUser:
    return [self.singleUser isEqual:aFileLockContent.singleUser];
  case DBFILESFileLockContentOther:
    return [[self tagName] isEqual:[aFileLockContent tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFileLockContentSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFileLockContent *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnlocked]) {
    jsonDict[@".tag"] = @"unlocked";
  } else if ([valueObj isSingleUser]) {
    jsonDict = [[DBFILESSingleUserLockSerializer serialize:valueObj.singleUser] mutableCopy];
    jsonDict[@".tag"] = @"single_user";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFileLockContent *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unlocked"]) {
    return [[DBFILESFileLockContent alloc] initWithUnlocked];
  } else if ([tag isEqualToString:@"single_user"]) {
    DBFILESSingleUserLock *singleUser = [DBFILESSingleUserLockSerializer deserialize:valueDict];
    return [[DBFILESFileLockContent alloc] initWithSingleUser:singleUser];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESFileLockContent alloc] initWithOther];
  } else {
    return [[DBFILESFileLockContent alloc] initWithOther];
  }
}

@end

#import "DBFILESFileLockMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFileLockMetadata

#pragma mark - Constructors

- (instancetype)initWithIsLockholder:(NSNumber *)isLockholder
                      lockholderName:(NSString *)lockholderName
                 lockholderAccountId:(NSString *)lockholderAccountId
                             created:(NSDate *)created {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:@(40) maxLength:@(40) pattern:nil]](lockholderAccountId);

  self = [super init];
  if (self) {
    _isLockholder = isLockholder;
    _lockholderName = lockholderName;
    _lockholderAccountId = lockholderAccountId;
    _created = created;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithIsLockholder:nil lockholderName:nil lockholderAccountId:nil created:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFileLockMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFileLockMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFileLockMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.isLockholder != nil) {
    result = prime * result + [self.isLockholder hash];
  }
  if (self.lockholderName != nil) {
    result = prime * result + [self.lockholderName hash];
  }
  if (self.lockholderAccountId != nil) {
    result = prime * result + [self.lockholderAccountId hash];
  }
  if (self.created != nil) {
    result = prime * result + [self.created hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileLockMetadata:other];
}

- (BOOL)isEqualToFileLockMetadata:(DBFILESFileLockMetadata *)aFileLockMetadata {
  if (self == aFileLockMetadata) {
    return YES;
  }
  if (self.isLockholder) {
    if (![self.isLockholder isEqual:aFileLockMetadata.isLockholder]) {
      return NO;
    }
  }
  if (self.lockholderName) {
    if (![self.lockholderName isEqual:aFileLockMetadata.lockholderName]) {
      return NO;
    }
  }
  if (self.lockholderAccountId) {
    if (![self.lockholderAccountId isEqual:aFileLockMetadata.lockholderAccountId]) {
      return NO;
    }
  }
  if (self.created) {
    if (![self.created isEqual:aFileLockMetadata.created]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFileLockMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFileLockMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.isLockholder) {
    jsonDict[@"is_lockholder"] = valueObj.isLockholder;
  }
  if (valueObj.lockholderName) {
    jsonDict[@"lockholder_name"] = valueObj.lockholderName;
  }
  if (valueObj.lockholderAccountId) {
    jsonDict[@"lockholder_account_id"] = valueObj.lockholderAccountId;
  }
  if (valueObj.created) {
    jsonDict[@"created"] = [DBNSDateSerializer serialize:valueObj.created dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFileLockMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *isLockholder = valueDict[@"is_lockholder"] ?: nil;
  NSString *lockholderName = valueDict[@"lockholder_name"] ?: nil;
  NSString *lockholderAccountId = valueDict[@"lockholder_account_id"] ?: nil;
  NSDate *created = valueDict[@"created"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"created"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBFILESFileLockMetadata alloc] initWithIsLockholder:isLockholder
                                                lockholderName:lockholderName
                                           lockholderAccountId:lockholderAccountId
                                                       created:created];
}

@end

#import "DBFILEPROPERTIESPropertyGroup.h"
#import "DBFILESExportInfo.h"
#import "DBFILESFileLockMetadata.h"
#import "DBFILESFileMetadata.h"
#import "DBFILESFileSharingInfo.h"
#import "DBFILESMediaInfo.h"
#import "DBFILESMetadata.h"
#import "DBFILESSymlinkInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFileMetadata

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name
                         id_:(NSString *)id_
              clientModified:(NSDate *)clientModified
              serverModified:(NSDate *)serverModified
                         rev:(NSString *)rev
                        size:(NSNumber *)size
                   pathLower:(NSString *)pathLower
                 pathDisplay:(NSString *)pathDisplay
        parentSharedFolderId:(NSString *)parentSharedFolderId
                   mediaInfo:(DBFILESMediaInfo *)mediaInfo
                 symlinkInfo:(DBFILESSymlinkInfo *)symlinkInfo
                 sharingInfo:(DBFILESFileSharingInfo *)sharingInfo
              isDownloadable:(NSNumber *)isDownloadable
                  exportInfo:(DBFILESExportInfo *)exportInfo
              propertyGroups:(NSArray<DBFILEPROPERTIESPropertyGroup *> *)propertyGroups
    hasExplicitSharedMembers:(NSNumber *)hasExplicitSharedMembers
                 contentHash:(NSString *)contentHash
                fileLockInfo:(DBFILESFileLockMetadata *)fileLockInfo {
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](id_);
  [DBStoneValidators nonnullValidator:nil](clientModified);
  [DBStoneValidators nonnullValidator:nil](serverModified);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(9) maxLength:nil pattern:@"[0-9a-f]+"]](rev);
  [DBStoneValidators nonnullValidator:nil](size);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](
      parentSharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](propertyGroups);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:@(64) maxLength:@(64) pattern:nil]](contentHash);

  self =
      [super initWithName:name pathLower:pathLower pathDisplay:pathDisplay parentSharedFolderId:parentSharedFolderId];
  if (self) {
    _id_ = id_;
    _clientModified = clientModified;
    _serverModified = serverModified;
    _rev = rev;
    _size = size;
    _mediaInfo = mediaInfo;
    _symlinkInfo = symlinkInfo;
    _sharingInfo = sharingInfo;
    _isDownloadable = isDownloadable ?: @YES;
    _exportInfo = exportInfo;
    _propertyGroups = propertyGroups;
    _hasExplicitSharedMembers = hasExplicitSharedMembers;
    _contentHash = contentHash;
    _fileLockInfo = fileLockInfo;
  }
  return self;
}

- (instancetype)initWithName:(NSString *)name
                         id_:(NSString *)id_
              clientModified:(NSDate *)clientModified
              serverModified:(NSDate *)serverModified
                         rev:(NSString *)rev
                        size:(NSNumber *)size {
  return [self initWithName:name
                           id_:id_
                clientModified:clientModified
                serverModified:serverModified
                           rev:rev
                          size:size
                     pathLower:nil
                   pathDisplay:nil
          parentSharedFolderId:nil
                     mediaInfo:nil
                   symlinkInfo:nil
                   sharingInfo:nil
                isDownloadable:nil
                    exportInfo:nil
                propertyGroups:nil
      hasExplicitSharedMembers:nil
                   contentHash:nil
                  fileLockInfo:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFileMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFileMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFileMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];
  result = prime * result + [self.id_ hash];
  result = prime * result + [self.clientModified hash];
  result = prime * result + [self.serverModified hash];
  result = prime * result + [self.rev hash];
  result = prime * result + [self.size hash];
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.pathDisplay != nil) {
    result = prime * result + [self.pathDisplay hash];
  }
  if (self.parentSharedFolderId != nil) {
    result = prime * result + [self.parentSharedFolderId hash];
  }
  if (self.mediaInfo != nil) {
    result = prime * result + [self.mediaInfo hash];
  }
  if (self.symlinkInfo != nil) {
    result = prime * result + [self.symlinkInfo hash];
  }
  if (self.sharingInfo != nil) {
    result = prime * result + [self.sharingInfo hash];
  }
  result = prime * result + [self.isDownloadable hash];
  if (self.exportInfo != nil) {
    result = prime * result + [self.exportInfo hash];
  }
  if (self.propertyGroups != nil) {
    result = prime * result + [self.propertyGroups hash];
  }
  if (self.hasExplicitSharedMembers != nil) {
    result = prime * result + [self.hasExplicitSharedMembers hash];
  }
  if (self.contentHash != nil) {
    result = prime * result + [self.contentHash hash];
  }
  if (self.fileLockInfo != nil) {
    result = prime * result + [self.fileLockInfo hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileMetadata:other];
}

- (BOOL)isEqualToFileMetadata:(DBFILESFileMetadata *)aFileMetadata {
  if (self == aFileMetadata) {
    return YES;
  }
  if (![self.name isEqual:aFileMetadata.name]) {
    return NO;
  }
  if (![self.id_ isEqual:aFileMetadata.id_]) {
    return NO;
  }
  if (![self.clientModified isEqual:aFileMetadata.clientModified]) {
    return NO;
  }
  if (![self.serverModified isEqual:aFileMetadata.serverModified]) {
    return NO;
  }
  if (![self.rev isEqual:aFileMetadata.rev]) {
    return NO;
  }
  if (![self.size isEqual:aFileMetadata.size]) {
    return NO;
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aFileMetadata.pathLower]) {
      return NO;
    }
  }
  if (self.pathDisplay) {
    if (![self.pathDisplay isEqual:aFileMetadata.pathDisplay]) {
      return NO;
    }
  }
  if (self.parentSharedFolderId) {
    if (![self.parentSharedFolderId isEqual:aFileMetadata.parentSharedFolderId]) {
      return NO;
    }
  }
  if (self.mediaInfo) {
    if (![self.mediaInfo isEqual:aFileMetadata.mediaInfo]) {
      return NO;
    }
  }
  if (self.symlinkInfo) {
    if (![self.symlinkInfo isEqual:aFileMetadata.symlinkInfo]) {
      return NO;
    }
  }
  if (self.sharingInfo) {
    if (![self.sharingInfo isEqual:aFileMetadata.sharingInfo]) {
      return NO;
    }
  }
  if (![self.isDownloadable isEqual:aFileMetadata.isDownloadable]) {
    return NO;
  }
  if (self.exportInfo) {
    if (![self.exportInfo isEqual:aFileMetadata.exportInfo]) {
      return NO;
    }
  }
  if (self.propertyGroups) {
    if (![self.propertyGroups isEqual:aFileMetadata.propertyGroups]) {
      return NO;
    }
  }
  if (self.hasExplicitSharedMembers) {
    if (![self.hasExplicitSharedMembers isEqual:aFileMetadata.hasExplicitSharedMembers]) {
      return NO;
    }
  }
  if (self.contentHash) {
    if (![self.contentHash isEqual:aFileMetadata.contentHash]) {
      return NO;
    }
  }
  if (self.fileLockInfo) {
    if (![self.fileLockInfo isEqual:aFileMetadata.fileLockInfo]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFileMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFileMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"id"] = valueObj.id_;
  jsonDict[@"client_modified"] =
      [DBNSDateSerializer serialize:valueObj.clientModified dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  jsonDict[@"server_modified"] =
      [DBNSDateSerializer serialize:valueObj.serverModified dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  jsonDict[@"rev"] = valueObj.rev;
  jsonDict[@"size"] = valueObj.size;
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.pathDisplay) {
    jsonDict[@"path_display"] = valueObj.pathDisplay;
  }
  if (valueObj.parentSharedFolderId) {
    jsonDict[@"parent_shared_folder_id"] = valueObj.parentSharedFolderId;
  }
  if (valueObj.mediaInfo) {
    jsonDict[@"media_info"] = [DBFILESMediaInfoSerializer serialize:valueObj.mediaInfo];
  }
  if (valueObj.symlinkInfo) {
    jsonDict[@"symlink_info"] = [DBFILESSymlinkInfoSerializer serialize:valueObj.symlinkInfo];
  }
  if (valueObj.sharingInfo) {
    jsonDict[@"sharing_info"] = [DBFILESFileSharingInfoSerializer serialize:valueObj.sharingInfo];
  }
  jsonDict[@"is_downloadable"] = valueObj.isDownloadable;
  if (valueObj.exportInfo) {
    jsonDict[@"export_info"] = [DBFILESExportInfoSerializer serialize:valueObj.exportInfo];
  }
  if (valueObj.propertyGroups) {
    jsonDict[@"property_groups"] =
        [DBArraySerializer serialize:valueObj.propertyGroups
                           withBlock:^id(id elem0) {
                             return [DBFILEPROPERTIESPropertyGroupSerializer serialize:elem0];
                           }];
  }
  if (valueObj.hasExplicitSharedMembers) {
    jsonDict[@"has_explicit_shared_members"] = valueObj.hasExplicitSharedMembers;
  }
  if (valueObj.contentHash) {
    jsonDict[@"content_hash"] = valueObj.contentHash;
  }
  if (valueObj.fileLockInfo) {
    jsonDict[@"file_lock_info"] = [DBFILESFileLockMetadataSerializer serialize:valueObj.fileLockInfo];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFileMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *name = valueDict[@"name"];
  NSString *id_ = valueDict[@"id"];
  NSDate *clientModified =
      [DBNSDateSerializer deserialize:valueDict[@"client_modified"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  NSDate *serverModified =
      [DBNSDateSerializer deserialize:valueDict[@"server_modified"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  NSString *rev = valueDict[@"rev"];
  NSNumber *size = valueDict[@"size"];
  NSString *pathLower = valueDict[@"path_lower"] ?: nil;
  NSString *pathDisplay = valueDict[@"path_display"] ?: nil;
  NSString *parentSharedFolderId = valueDict[@"parent_shared_folder_id"] ?: nil;
  DBFILESMediaInfo *mediaInfo =
      valueDict[@"media_info"] ? [DBFILESMediaInfoSerializer deserialize:valueDict[@"media_info"]] : nil;
  DBFILESSymlinkInfo *symlinkInfo =
      valueDict[@"symlink_info"] ? [DBFILESSymlinkInfoSerializer deserialize:valueDict[@"symlink_info"]] : nil;
  DBFILESFileSharingInfo *sharingInfo =
      valueDict[@"sharing_info"] ? [DBFILESFileSharingInfoSerializer deserialize:valueDict[@"sharing_info"]] : nil;
  NSNumber *isDownloadable = valueDict[@"is_downloadable"] ?: @YES;
  DBFILESExportInfo *exportInfo =
      valueDict[@"export_info"] ? [DBFILESExportInfoSerializer deserialize:valueDict[@"export_info"]] : nil;
  NSArray<DBFILEPROPERTIESPropertyGroup *> *propertyGroups =
      valueDict[@"property_groups"]
          ? [DBArraySerializer deserialize:valueDict[@"property_groups"]
                                 withBlock:^id(id elem0) {
                                   return [DBFILEPROPERTIESPropertyGroupSerializer deserialize:elem0];
                                 }]
          : nil;
  NSNumber *hasExplicitSharedMembers = valueDict[@"has_explicit_shared_members"] ?: nil;
  NSString *contentHash = valueDict[@"content_hash"] ?: nil;
  DBFILESFileLockMetadata *fileLockInfo =
      valueDict[@"file_lock_info"] ? [DBFILESFileLockMetadataSerializer deserialize:valueDict[@"file_lock_info"]] : nil;

  return [[DBFILESFileMetadata alloc] initWithName:name
                                               id_:id_
                                    clientModified:clientModified
                                    serverModified:serverModified
                                               rev:rev
                                              size:size
                                         pathLower:pathLower
                                       pathDisplay:pathDisplay
                              parentSharedFolderId:parentSharedFolderId
                                         mediaInfo:mediaInfo
                                       symlinkInfo:symlinkInfo
                                       sharingInfo:sharingInfo
                                    isDownloadable:isDownloadable
                                        exportInfo:exportInfo
                                    propertyGroups:propertyGroups
                          hasExplicitSharedMembers:hasExplicitSharedMembers
                                       contentHash:contentHash
                                      fileLockInfo:fileLockInfo];
}

@end

#import "DBFILESSharingInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSharingInfo

#pragma mark - Constructors

- (instancetype)initWithReadOnly:(NSNumber *)readOnly {
  [DBStoneValidators nonnullValidator:nil](readOnly);

  self = [super init];
  if (self) {
    _readOnly = readOnly;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSharingInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSharingInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSharingInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.readOnly hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharingInfo:other];
}

- (BOOL)isEqualToSharingInfo:(DBFILESSharingInfo *)aSharingInfo {
  if (self == aSharingInfo) {
    return YES;
  }
  if (![self.readOnly isEqual:aSharingInfo.readOnly]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSharingInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSharingInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"read_only"] = valueObj.readOnly;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSharingInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *readOnly = valueDict[@"read_only"];

  return [[DBFILESSharingInfo alloc] initWithReadOnly:readOnly];
}

@end

#import "DBFILESFileSharingInfo.h"
#import "DBFILESSharingInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFileSharingInfo

#pragma mark - Constructors

- (instancetype)initWithReadOnly:(NSNumber *)readOnly
            parentSharedFolderId:(NSString *)parentSharedFolderId
                      modifiedBy:(NSString *)modifiedBy {
  [DBStoneValidators nonnullValidator:nil](readOnly);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](
      parentSharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:@(40) maxLength:@(40) pattern:nil]](modifiedBy);

  self = [super initWithReadOnly:readOnly];
  if (self) {
    _parentSharedFolderId = parentSharedFolderId;
    _modifiedBy = modifiedBy;
  }
  return self;
}

- (instancetype)initWithReadOnly:(NSNumber *)readOnly parentSharedFolderId:(NSString *)parentSharedFolderId {
  return [self initWithReadOnly:readOnly parentSharedFolderId:parentSharedFolderId modifiedBy:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFileSharingInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFileSharingInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFileSharingInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.readOnly hash];
  result = prime * result + [self.parentSharedFolderId hash];
  if (self.modifiedBy != nil) {
    result = prime * result + [self.modifiedBy hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileSharingInfo:other];
}

- (BOOL)isEqualToFileSharingInfo:(DBFILESFileSharingInfo *)aFileSharingInfo {
  if (self == aFileSharingInfo) {
    return YES;
  }
  if (![self.readOnly isEqual:aFileSharingInfo.readOnly]) {
    return NO;
  }
  if (![self.parentSharedFolderId isEqual:aFileSharingInfo.parentSharedFolderId]) {
    return NO;
  }
  if (self.modifiedBy) {
    if (![self.modifiedBy isEqual:aFileSharingInfo.modifiedBy]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFileSharingInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFileSharingInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"read_only"] = valueObj.readOnly;
  jsonDict[@"parent_shared_folder_id"] = valueObj.parentSharedFolderId;
  if (valueObj.modifiedBy) {
    jsonDict[@"modified_by"] = valueObj.modifiedBy;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFileSharingInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *readOnly = valueDict[@"read_only"];
  NSString *parentSharedFolderId = valueDict[@"parent_shared_folder_id"];
  NSString *modifiedBy = valueDict[@"modified_by"] ?: nil;

  return [[DBFILESFileSharingInfo alloc] initWithReadOnly:readOnly
                                     parentSharedFolderId:parentSharedFolderId
                                               modifiedBy:modifiedBy];
}

@end

#import "DBFILESFileStatus.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFileStatus

#pragma mark - Constructors

- (instancetype)initWithActive {
  self = [super init];
  if (self) {
    _tag = DBFILESFileStatusActive;
  }
  return self;
}

- (instancetype)initWithDeleted {
  self = [super init];
  if (self) {
    _tag = DBFILESFileStatusDeleted;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESFileStatusOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isActive {
  return _tag == DBFILESFileStatusActive;
}

- (BOOL)isDeleted {
  return _tag == DBFILESFileStatusDeleted;
}

- (BOOL)isOther {
  return _tag == DBFILESFileStatusOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESFileStatusActive:
    return @"DBFILESFileStatusActive";
  case DBFILESFileStatusDeleted:
    return @"DBFILESFileStatusDeleted";
  case DBFILESFileStatusOther:
    return @"DBFILESFileStatusOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFileStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFileStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFileStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESFileStatusActive:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileStatusDeleted:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESFileStatusOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileStatus:other];
}

- (BOOL)isEqualToFileStatus:(DBFILESFileStatus *)aFileStatus {
  if (self == aFileStatus) {
    return YES;
  }
  if (self.tag != aFileStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESFileStatusActive:
    return [[self tagName] isEqual:[aFileStatus tagName]];
  case DBFILESFileStatusDeleted:
    return [[self tagName] isEqual:[aFileStatus tagName]];
  case DBFILESFileStatusOther:
    return [[self tagName] isEqual:[aFileStatus tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFileStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFileStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isActive]) {
    jsonDict[@".tag"] = @"active";
  } else if ([valueObj isDeleted]) {
    jsonDict[@".tag"] = @"deleted";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFileStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"active"]) {
    return [[DBFILESFileStatus alloc] initWithActive];
  } else if ([tag isEqualToString:@"deleted"]) {
    return [[DBFILESFileStatus alloc] initWithDeleted];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESFileStatus alloc] initWithOther];
  } else {
    return [[DBFILESFileStatus alloc] initWithOther];
  }
}

@end

#import "DBFILEPROPERTIESPropertyGroup.h"
#import "DBFILESFolderMetadata.h"
#import "DBFILESFolderSharingInfo.h"
#import "DBFILESMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFolderMetadata

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name
                         id_:(NSString *)id_
                   pathLower:(NSString *)pathLower
                 pathDisplay:(NSString *)pathDisplay
        parentSharedFolderId:(NSString *)parentSharedFolderId
              sharedFolderId:(NSString *)sharedFolderId
                 sharingInfo:(DBFILESFolderSharingInfo *)sharingInfo
              propertyGroups:(NSArray<DBFILEPROPERTIESPropertyGroup *> *)propertyGroups {
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](id_);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](
      parentSharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](propertyGroups);

  self =
      [super initWithName:name pathLower:pathLower pathDisplay:pathDisplay parentSharedFolderId:parentSharedFolderId];
  if (self) {
    _id_ = id_;
    _sharedFolderId = sharedFolderId;
    _sharingInfo = sharingInfo;
    _propertyGroups = propertyGroups;
  }
  return self;
}

- (instancetype)initWithName:(NSString *)name id_:(NSString *)id_ {
  return [self initWithName:name
                        id_:id_
                  pathLower:nil
                pathDisplay:nil
       parentSharedFolderId:nil
             sharedFolderId:nil
                sharingInfo:nil
             propertyGroups:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFolderMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFolderMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFolderMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];
  result = prime * result + [self.id_ hash];
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.pathDisplay != nil) {
    result = prime * result + [self.pathDisplay hash];
  }
  if (self.parentSharedFolderId != nil) {
    result = prime * result + [self.parentSharedFolderId hash];
  }
  if (self.sharedFolderId != nil) {
    result = prime * result + [self.sharedFolderId hash];
  }
  if (self.sharingInfo != nil) {
    result = prime * result + [self.sharingInfo hash];
  }
  if (self.propertyGroups != nil) {
    result = prime * result + [self.propertyGroups hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFolderMetadata:other];
}

- (BOOL)isEqualToFolderMetadata:(DBFILESFolderMetadata *)aFolderMetadata {
  if (self == aFolderMetadata) {
    return YES;
  }
  if (![self.name isEqual:aFolderMetadata.name]) {
    return NO;
  }
  if (![self.id_ isEqual:aFolderMetadata.id_]) {
    return NO;
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aFolderMetadata.pathLower]) {
      return NO;
    }
  }
  if (self.pathDisplay) {
    if (![self.pathDisplay isEqual:aFolderMetadata.pathDisplay]) {
      return NO;
    }
  }
  if (self.parentSharedFolderId) {
    if (![self.parentSharedFolderId isEqual:aFolderMetadata.parentSharedFolderId]) {
      return NO;
    }
  }
  if (self.sharedFolderId) {
    if (![self.sharedFolderId isEqual:aFolderMetadata.sharedFolderId]) {
      return NO;
    }
  }
  if (self.sharingInfo) {
    if (![self.sharingInfo isEqual:aFolderMetadata.sharingInfo]) {
      return NO;
    }
  }
  if (self.propertyGroups) {
    if (![self.propertyGroups isEqual:aFolderMetadata.propertyGroups]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFolderMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFolderMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"id"] = valueObj.id_;
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.pathDisplay) {
    jsonDict[@"path_display"] = valueObj.pathDisplay;
  }
  if (valueObj.parentSharedFolderId) {
    jsonDict[@"parent_shared_folder_id"] = valueObj.parentSharedFolderId;
  }
  if (valueObj.sharedFolderId) {
    jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  }
  if (valueObj.sharingInfo) {
    jsonDict[@"sharing_info"] = [DBFILESFolderSharingInfoSerializer serialize:valueObj.sharingInfo];
  }
  if (valueObj.propertyGroups) {
    jsonDict[@"property_groups"] =
        [DBArraySerializer serialize:valueObj.propertyGroups
                           withBlock:^id(id elem0) {
                             return [DBFILEPROPERTIESPropertyGroupSerializer serialize:elem0];
                           }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFolderMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *name = valueDict[@"name"];
  NSString *id_ = valueDict[@"id"];
  NSString *pathLower = valueDict[@"path_lower"] ?: nil;
  NSString *pathDisplay = valueDict[@"path_display"] ?: nil;
  NSString *parentSharedFolderId = valueDict[@"parent_shared_folder_id"] ?: nil;
  NSString *sharedFolderId = valueDict[@"shared_folder_id"] ?: nil;
  DBFILESFolderSharingInfo *sharingInfo =
      valueDict[@"sharing_info"] ? [DBFILESFolderSharingInfoSerializer deserialize:valueDict[@"sharing_info"]] : nil;
  NSArray<DBFILEPROPERTIESPropertyGroup *> *propertyGroups =
      valueDict[@"property_groups"]
          ? [DBArraySerializer deserialize:valueDict[@"property_groups"]
                                 withBlock:^id(id elem0) {
                                   return [DBFILEPROPERTIESPropertyGroupSerializer deserialize:elem0];
                                 }]
          : nil;

  return [[DBFILESFolderMetadata alloc] initWithName:name
                                                 id_:id_
                                           pathLower:pathLower
                                         pathDisplay:pathDisplay
                                parentSharedFolderId:parentSharedFolderId
                                      sharedFolderId:sharedFolderId
                                         sharingInfo:sharingInfo
                                      propertyGroups:propertyGroups];
}

@end

#import "DBFILESFolderSharingInfo.h"
#import "DBFILESSharingInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESFolderSharingInfo

#pragma mark - Constructors

- (instancetype)initWithReadOnly:(NSNumber *)readOnly
            parentSharedFolderId:(NSString *)parentSharedFolderId
                  sharedFolderId:(NSString *)sharedFolderId
                    traverseOnly:(NSNumber *)traverseOnly
                        noAccess:(NSNumber *)noAccess {
  [DBStoneValidators nonnullValidator:nil](readOnly);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](
      parentSharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);

  self = [super initWithReadOnly:readOnly];
  if (self) {
    _parentSharedFolderId = parentSharedFolderId;
    _sharedFolderId = sharedFolderId;
    _traverseOnly = traverseOnly ?: @NO;
    _noAccess = noAccess ?: @NO;
  }
  return self;
}

- (instancetype)initWithReadOnly:(NSNumber *)readOnly {
  return [self initWithReadOnly:readOnly parentSharedFolderId:nil sharedFolderId:nil traverseOnly:nil noAccess:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESFolderSharingInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESFolderSharingInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESFolderSharingInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.readOnly hash];
  if (self.parentSharedFolderId != nil) {
    result = prime * result + [self.parentSharedFolderId hash];
  }
  if (self.sharedFolderId != nil) {
    result = prime * result + [self.sharedFolderId hash];
  }
  result = prime * result + [self.traverseOnly hash];
  result = prime * result + [self.noAccess hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFolderSharingInfo:other];
}

- (BOOL)isEqualToFolderSharingInfo:(DBFILESFolderSharingInfo *)aFolderSharingInfo {
  if (self == aFolderSharingInfo) {
    return YES;
  }
  if (![self.readOnly isEqual:aFolderSharingInfo.readOnly]) {
    return NO;
  }
  if (self.parentSharedFolderId) {
    if (![self.parentSharedFolderId isEqual:aFolderSharingInfo.parentSharedFolderId]) {
      return NO;
    }
  }
  if (self.sharedFolderId) {
    if (![self.sharedFolderId isEqual:aFolderSharingInfo.sharedFolderId]) {
      return NO;
    }
  }
  if (![self.traverseOnly isEqual:aFolderSharingInfo.traverseOnly]) {
    return NO;
  }
  if (![self.noAccess isEqual:aFolderSharingInfo.noAccess]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESFolderSharingInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESFolderSharingInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"read_only"] = valueObj.readOnly;
  if (valueObj.parentSharedFolderId) {
    jsonDict[@"parent_shared_folder_id"] = valueObj.parentSharedFolderId;
  }
  if (valueObj.sharedFolderId) {
    jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  }
  jsonDict[@"traverse_only"] = valueObj.traverseOnly;
  jsonDict[@"no_access"] = valueObj.noAccess;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESFolderSharingInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *readOnly = valueDict[@"read_only"];
  NSString *parentSharedFolderId = valueDict[@"parent_shared_folder_id"] ?: nil;
  NSString *sharedFolderId = valueDict[@"shared_folder_id"] ?: nil;
  NSNumber *traverseOnly = valueDict[@"traverse_only"] ?: @NO;
  NSNumber *noAccess = valueDict[@"no_access"] ?: @NO;

  return [[DBFILESFolderSharingInfo alloc] initWithReadOnly:readOnly
                                       parentSharedFolderId:parentSharedFolderId
                                             sharedFolderId:sharedFolderId
                                               traverseOnly:traverseOnly
                                                   noAccess:noAccess];
}

@end

#import "DBFILESGetCopyReferenceArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetCopyReferenceArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetCopyReferenceArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetCopyReferenceArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetCopyReferenceArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetCopyReferenceArg:other];
}

- (BOOL)isEqualToGetCopyReferenceArg:(DBFILESGetCopyReferenceArg *)aGetCopyReferenceArg {
  if (self == aGetCopyReferenceArg) {
    return YES;
  }
  if (![self.path isEqual:aGetCopyReferenceArg.path]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetCopyReferenceArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetCopyReferenceArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetCopyReferenceArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];

  return [[DBFILESGetCopyReferenceArg alloc] initWithPath:path];
}

@end

#import "DBFILESGetCopyReferenceError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetCopyReferenceError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESGetCopyReferenceErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESGetCopyReferenceErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESGetCopyReferenceErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESGetCopyReferenceErrorPath;
}

- (BOOL)isOther {
  return _tag == DBFILESGetCopyReferenceErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESGetCopyReferenceErrorPath:
    return @"DBFILESGetCopyReferenceErrorPath";
  case DBFILESGetCopyReferenceErrorOther:
    return @"DBFILESGetCopyReferenceErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetCopyReferenceErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetCopyReferenceErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetCopyReferenceErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESGetCopyReferenceErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESGetCopyReferenceErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetCopyReferenceError:other];
}

- (BOOL)isEqualToGetCopyReferenceError:(DBFILESGetCopyReferenceError *)aGetCopyReferenceError {
  if (self == aGetCopyReferenceError) {
    return YES;
  }
  if (self.tag != aGetCopyReferenceError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESGetCopyReferenceErrorPath:
    return [self.path isEqual:aGetCopyReferenceError.path];
  case DBFILESGetCopyReferenceErrorOther:
    return [[self tagName] isEqual:[aGetCopyReferenceError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetCopyReferenceErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetCopyReferenceError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetCopyReferenceError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESGetCopyReferenceError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESGetCopyReferenceError alloc] initWithOther];
  } else {
    return [[DBFILESGetCopyReferenceError alloc] initWithOther];
  }
}

@end

#import "DBFILESGetCopyReferenceResult.h"
#import "DBFILESMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetCopyReferenceResult

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata
                  dCopyReference:(NSString *)dCopyReference
                         expires:(NSDate *)expires {
  [DBStoneValidators nonnullValidator:nil](metadata);
  [DBStoneValidators nonnullValidator:nil](dCopyReference);
  [DBStoneValidators nonnullValidator:nil](expires);

  self = [super init];
  if (self) {
    _metadata = metadata;
    _dCopyReference = dCopyReference;
    _expires = expires;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetCopyReferenceResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetCopyReferenceResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetCopyReferenceResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];
  result = prime * result + [self.dCopyReference hash];
  result = prime * result + [self.expires hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetCopyReferenceResult:other];
}

- (BOOL)isEqualToGetCopyReferenceResult:(DBFILESGetCopyReferenceResult *)aGetCopyReferenceResult {
  if (self == aGetCopyReferenceResult) {
    return YES;
  }
  if (![self.metadata isEqual:aGetCopyReferenceResult.metadata]) {
    return NO;
  }
  if (![self.dCopyReference isEqual:aGetCopyReferenceResult.dCopyReference]) {
    return NO;
  }
  if (![self.expires isEqual:aGetCopyReferenceResult.expires]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetCopyReferenceResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetCopyReferenceResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESMetadataSerializer serialize:valueObj.metadata];
  jsonDict[@"copy_reference"] = valueObj.dCopyReference;
  jsonDict[@"expires"] = [DBNSDateSerializer serialize:valueObj.expires dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetCopyReferenceResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESMetadata *metadata = [DBFILESMetadataSerializer deserialize:valueDict[@"metadata"]];
  NSString *dCopyReference = valueDict[@"copy_reference"];
  NSDate *expires = [DBNSDateSerializer deserialize:valueDict[@"expires"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];

  return
      [[DBFILESGetCopyReferenceResult alloc] initWithMetadata:metadata dCopyReference:dCopyReference expires:expires];
}

@end

#import "DBFILESGetTemporaryLinkArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetTemporaryLinkArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetTemporaryLinkArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetTemporaryLinkArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetTemporaryLinkArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetTemporaryLinkArg:other];
}

- (BOOL)isEqualToGetTemporaryLinkArg:(DBFILESGetTemporaryLinkArg *)aGetTemporaryLinkArg {
  if (self == aGetTemporaryLinkArg) {
    return YES;
  }
  if (![self.path isEqual:aGetTemporaryLinkArg.path]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetTemporaryLinkArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetTemporaryLinkArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetTemporaryLinkArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];

  return [[DBFILESGetTemporaryLinkArg alloc] initWithPath:path];
}

@end

#import "DBFILESGetTemporaryLinkError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetTemporaryLinkError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESGetTemporaryLinkErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithEmailNotVerified {
  self = [super init];
  if (self) {
    _tag = DBFILESGetTemporaryLinkErrorEmailNotVerified;
  }
  return self;
}

- (instancetype)initWithUnsupportedFile {
  self = [super init];
  if (self) {
    _tag = DBFILESGetTemporaryLinkErrorUnsupportedFile;
  }
  return self;
}

- (instancetype)initWithNotAllowed {
  self = [super init];
  if (self) {
    _tag = DBFILESGetTemporaryLinkErrorNotAllowed;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESGetTemporaryLinkErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESGetTemporaryLinkErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESGetTemporaryLinkErrorPath;
}

- (BOOL)isEmailNotVerified {
  return _tag == DBFILESGetTemporaryLinkErrorEmailNotVerified;
}

- (BOOL)isUnsupportedFile {
  return _tag == DBFILESGetTemporaryLinkErrorUnsupportedFile;
}

- (BOOL)isNotAllowed {
  return _tag == DBFILESGetTemporaryLinkErrorNotAllowed;
}

- (BOOL)isOther {
  return _tag == DBFILESGetTemporaryLinkErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESGetTemporaryLinkErrorPath:
    return @"DBFILESGetTemporaryLinkErrorPath";
  case DBFILESGetTemporaryLinkErrorEmailNotVerified:
    return @"DBFILESGetTemporaryLinkErrorEmailNotVerified";
  case DBFILESGetTemporaryLinkErrorUnsupportedFile:
    return @"DBFILESGetTemporaryLinkErrorUnsupportedFile";
  case DBFILESGetTemporaryLinkErrorNotAllowed:
    return @"DBFILESGetTemporaryLinkErrorNotAllowed";
  case DBFILESGetTemporaryLinkErrorOther:
    return @"DBFILESGetTemporaryLinkErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetTemporaryLinkErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetTemporaryLinkErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetTemporaryLinkErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESGetTemporaryLinkErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESGetTemporaryLinkErrorEmailNotVerified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESGetTemporaryLinkErrorUnsupportedFile:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESGetTemporaryLinkErrorNotAllowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESGetTemporaryLinkErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetTemporaryLinkError:other];
}

- (BOOL)isEqualToGetTemporaryLinkError:(DBFILESGetTemporaryLinkError *)aGetTemporaryLinkError {
  if (self == aGetTemporaryLinkError) {
    return YES;
  }
  if (self.tag != aGetTemporaryLinkError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESGetTemporaryLinkErrorPath:
    return [self.path isEqual:aGetTemporaryLinkError.path];
  case DBFILESGetTemporaryLinkErrorEmailNotVerified:
    return [[self tagName] isEqual:[aGetTemporaryLinkError tagName]];
  case DBFILESGetTemporaryLinkErrorUnsupportedFile:
    return [[self tagName] isEqual:[aGetTemporaryLinkError tagName]];
  case DBFILESGetTemporaryLinkErrorNotAllowed:
    return [[self tagName] isEqual:[aGetTemporaryLinkError tagName]];
  case DBFILESGetTemporaryLinkErrorOther:
    return [[self tagName] isEqual:[aGetTemporaryLinkError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetTemporaryLinkErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetTemporaryLinkError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isEmailNotVerified]) {
    jsonDict[@".tag"] = @"email_not_verified";
  } else if ([valueObj isUnsupportedFile]) {
    jsonDict[@".tag"] = @"unsupported_file";
  } else if ([valueObj isNotAllowed]) {
    jsonDict[@".tag"] = @"not_allowed";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetTemporaryLinkError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESGetTemporaryLinkError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"email_not_verified"]) {
    return [[DBFILESGetTemporaryLinkError alloc] initWithEmailNotVerified];
  } else if ([tag isEqualToString:@"unsupported_file"]) {
    return [[DBFILESGetTemporaryLinkError alloc] initWithUnsupportedFile];
  } else if ([tag isEqualToString:@"not_allowed"]) {
    return [[DBFILESGetTemporaryLinkError alloc] initWithNotAllowed];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESGetTemporaryLinkError alloc] initWithOther];
  } else {
    return [[DBFILESGetTemporaryLinkError alloc] initWithOther];
  }
}

@end

#import "DBFILESFileMetadata.h"
#import "DBFILESGetTemporaryLinkResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetTemporaryLinkResult

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESFileMetadata *)metadata link:(NSString *)link {
  [DBStoneValidators nonnullValidator:nil](metadata);
  [DBStoneValidators nonnullValidator:nil](link);

  self = [super init];
  if (self) {
    _metadata = metadata;
    _link = link;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetTemporaryLinkResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetTemporaryLinkResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetTemporaryLinkResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];
  result = prime * result + [self.link hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetTemporaryLinkResult:other];
}

- (BOOL)isEqualToGetTemporaryLinkResult:(DBFILESGetTemporaryLinkResult *)aGetTemporaryLinkResult {
  if (self == aGetTemporaryLinkResult) {
    return YES;
  }
  if (![self.metadata isEqual:aGetTemporaryLinkResult.metadata]) {
    return NO;
  }
  if (![self.link isEqual:aGetTemporaryLinkResult.link]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetTemporaryLinkResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetTemporaryLinkResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESFileMetadataSerializer serialize:valueObj.metadata];
  jsonDict[@"link"] = valueObj.link;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetTemporaryLinkResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESFileMetadata *metadata = [DBFILESFileMetadataSerializer deserialize:valueDict[@"metadata"]];
  NSString *link = valueDict[@"link"];

  return [[DBFILESGetTemporaryLinkResult alloc] initWithMetadata:metadata link:link];
}

@end

#import "DBFILESCommitInfo.h"
#import "DBFILESGetTemporaryUploadLinkArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetTemporaryUploadLinkArg

#pragma mark - Constructors

- (instancetype)initWithCommitInfo:(DBFILESCommitInfo *)commitInfo duration:(NSNumber *)duration {
  [DBStoneValidators nonnullValidator:nil](commitInfo);

  self = [super init];
  if (self) {
    _commitInfo = commitInfo;
    _duration = duration ?: @(14400.0);
  }
  return self;
}

- (instancetype)initWithCommitInfo:(DBFILESCommitInfo *)commitInfo {
  return [self initWithCommitInfo:commitInfo duration:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetTemporaryUploadLinkArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetTemporaryUploadLinkArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetTemporaryUploadLinkArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.commitInfo hash];
  result = prime * result + [self.duration hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetTemporaryUploadLinkArg:other];
}

- (BOOL)isEqualToGetTemporaryUploadLinkArg:(DBFILESGetTemporaryUploadLinkArg *)aGetTemporaryUploadLinkArg {
  if (self == aGetTemporaryUploadLinkArg) {
    return YES;
  }
  if (![self.commitInfo isEqual:aGetTemporaryUploadLinkArg.commitInfo]) {
    return NO;
  }
  if (![self.duration isEqual:aGetTemporaryUploadLinkArg.duration]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetTemporaryUploadLinkArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetTemporaryUploadLinkArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"commit_info"] = [DBFILESCommitInfoSerializer serialize:valueObj.commitInfo];
  jsonDict[@"duration"] = valueObj.duration;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetTemporaryUploadLinkArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESCommitInfo *commitInfo = [DBFILESCommitInfoSerializer deserialize:valueDict[@"commit_info"]];
  NSNumber *duration = valueDict[@"duration"] ?: @(14400.0);

  return [[DBFILESGetTemporaryUploadLinkArg alloc] initWithCommitInfo:commitInfo duration:duration];
}

@end

#import "DBFILESGetTemporaryUploadLinkResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetTemporaryUploadLinkResult

#pragma mark - Constructors

- (instancetype)initWithLink:(NSString *)link {
  [DBStoneValidators nonnullValidator:nil](link);

  self = [super init];
  if (self) {
    _link = link;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetTemporaryUploadLinkResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetTemporaryUploadLinkResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetTemporaryUploadLinkResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.link hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetTemporaryUploadLinkResult:other];
}

- (BOOL)isEqualToGetTemporaryUploadLinkResult:(DBFILESGetTemporaryUploadLinkResult *)aGetTemporaryUploadLinkResult {
  if (self == aGetTemporaryUploadLinkResult) {
    return YES;
  }
  if (![self.link isEqual:aGetTemporaryUploadLinkResult.link]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetTemporaryUploadLinkResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetTemporaryUploadLinkResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"link"] = valueObj.link;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetTemporaryUploadLinkResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *link = valueDict[@"link"];

  return [[DBFILESGetTemporaryUploadLinkResult alloc] initWithLink:link];
}

@end

#import "DBFILESGetThumbnailBatchArg.h"
#import "DBFILESThumbnailArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetThumbnailBatchArg

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESThumbnailArg *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetThumbnailBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetThumbnailBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetThumbnailBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetThumbnailBatchArg:other];
}

- (BOOL)isEqualToGetThumbnailBatchArg:(DBFILESGetThumbnailBatchArg *)aGetThumbnailBatchArg {
  if (self == aGetThumbnailBatchArg) {
    return YES;
  }
  if (![self.entries isEqual:aGetThumbnailBatchArg.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetThumbnailBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetThumbnailBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESThumbnailArgSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetThumbnailBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESThumbnailArg *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESThumbnailArgSerializer deserialize:elem0];
                           }];

  return [[DBFILESGetThumbnailBatchArg alloc] initWithEntries:entries];
}

@end

#import "DBFILESGetThumbnailBatchError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetThumbnailBatchError

#pragma mark - Constructors

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBFILESGetThumbnailBatchErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESGetThumbnailBatchErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTooManyFiles {
  return _tag == DBFILESGetThumbnailBatchErrorTooManyFiles;
}

- (BOOL)isOther {
  return _tag == DBFILESGetThumbnailBatchErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESGetThumbnailBatchErrorTooManyFiles:
    return @"DBFILESGetThumbnailBatchErrorTooManyFiles";
  case DBFILESGetThumbnailBatchErrorOther:
    return @"DBFILESGetThumbnailBatchErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetThumbnailBatchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetThumbnailBatchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetThumbnailBatchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESGetThumbnailBatchErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESGetThumbnailBatchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetThumbnailBatchError:other];
}

- (BOOL)isEqualToGetThumbnailBatchError:(DBFILESGetThumbnailBatchError *)aGetThumbnailBatchError {
  if (self == aGetThumbnailBatchError) {
    return YES;
  }
  if (self.tag != aGetThumbnailBatchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESGetThumbnailBatchErrorTooManyFiles:
    return [[self tagName] isEqual:[aGetThumbnailBatchError tagName]];
  case DBFILESGetThumbnailBatchErrorOther:
    return [[self tagName] isEqual:[aGetThumbnailBatchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetThumbnailBatchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetThumbnailBatchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetThumbnailBatchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBFILESGetThumbnailBatchError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESGetThumbnailBatchError alloc] initWithOther];
  } else {
    return [[DBFILESGetThumbnailBatchError alloc] initWithOther];
  }
}

@end

#import "DBFILESGetThumbnailBatchResult.h"
#import "DBFILESGetThumbnailBatchResultEntry.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetThumbnailBatchResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESGetThumbnailBatchResultEntry *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetThumbnailBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetThumbnailBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetThumbnailBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetThumbnailBatchResult:other];
}

- (BOOL)isEqualToGetThumbnailBatchResult:(DBFILESGetThumbnailBatchResult *)aGetThumbnailBatchResult {
  if (self == aGetThumbnailBatchResult) {
    return YES;
  }
  if (![self.entries isEqual:aGetThumbnailBatchResult.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetThumbnailBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetThumbnailBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESGetThumbnailBatchResultEntrySerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetThumbnailBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESGetThumbnailBatchResultEntry *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESGetThumbnailBatchResultEntrySerializer deserialize:elem0];
                           }];

  return [[DBFILESGetThumbnailBatchResult alloc] initWithEntries:entries];
}

@end

#import "DBFILESFileMetadata.h"
#import "DBFILESGetThumbnailBatchResultData.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetThumbnailBatchResultData

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESFileMetadata *)metadata thumbnail:(NSString *)thumbnail {
  [DBStoneValidators nonnullValidator:nil](metadata);
  [DBStoneValidators nonnullValidator:nil](thumbnail);

  self = [super init];
  if (self) {
    _metadata = metadata;
    _thumbnail = thumbnail;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetThumbnailBatchResultDataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetThumbnailBatchResultDataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetThumbnailBatchResultDataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];
  result = prime * result + [self.thumbnail hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetThumbnailBatchResultData:other];
}

- (BOOL)isEqualToGetThumbnailBatchResultData:(DBFILESGetThumbnailBatchResultData *)aGetThumbnailBatchResultData {
  if (self == aGetThumbnailBatchResultData) {
    return YES;
  }
  if (![self.metadata isEqual:aGetThumbnailBatchResultData.metadata]) {
    return NO;
  }
  if (![self.thumbnail isEqual:aGetThumbnailBatchResultData.thumbnail]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetThumbnailBatchResultDataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetThumbnailBatchResultData *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESFileMetadataSerializer serialize:valueObj.metadata];
  jsonDict[@"thumbnail"] = valueObj.thumbnail;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetThumbnailBatchResultData *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESFileMetadata *metadata = [DBFILESFileMetadataSerializer deserialize:valueDict[@"metadata"]];
  NSString *thumbnail = valueDict[@"thumbnail"];

  return [[DBFILESGetThumbnailBatchResultData alloc] initWithMetadata:metadata thumbnail:thumbnail];
}

@end

#import "DBFILESGetThumbnailBatchResultData.h"
#import "DBFILESGetThumbnailBatchResultEntry.h"
#import "DBFILESThumbnailError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGetThumbnailBatchResultEntry

@synthesize success = _success;
@synthesize failure = _failure;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBFILESGetThumbnailBatchResultData *)success {
  self = [super init];
  if (self) {
    _tag = DBFILESGetThumbnailBatchResultEntrySuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithFailure:(DBFILESThumbnailError *)failure {
  self = [super init];
  if (self) {
    _tag = DBFILESGetThumbnailBatchResultEntryFailure;
    _failure = failure;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESGetThumbnailBatchResultEntryOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESGetThumbnailBatchResultData *)success {
  if (![self isSuccess]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESGetThumbnailBatchResultEntrySuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBFILESThumbnailError *)failure {
  if (![self isFailure]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESGetThumbnailBatchResultEntryFailure, but was %@.", [self tagName]];
  }
  return _failure;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBFILESGetThumbnailBatchResultEntrySuccess;
}

- (BOOL)isFailure {
  return _tag == DBFILESGetThumbnailBatchResultEntryFailure;
}

- (BOOL)isOther {
  return _tag == DBFILESGetThumbnailBatchResultEntryOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESGetThumbnailBatchResultEntrySuccess:
    return @"DBFILESGetThumbnailBatchResultEntrySuccess";
  case DBFILESGetThumbnailBatchResultEntryFailure:
    return @"DBFILESGetThumbnailBatchResultEntryFailure";
  case DBFILESGetThumbnailBatchResultEntryOther:
    return @"DBFILESGetThumbnailBatchResultEntryOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGetThumbnailBatchResultEntrySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGetThumbnailBatchResultEntrySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGetThumbnailBatchResultEntrySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESGetThumbnailBatchResultEntrySuccess:
    result = prime * result + [self.success hash];
    break;
  case DBFILESGetThumbnailBatchResultEntryFailure:
    result = prime * result + [self.failure hash];
    break;
  case DBFILESGetThumbnailBatchResultEntryOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetThumbnailBatchResultEntry:other];
}

- (BOOL)isEqualToGetThumbnailBatchResultEntry:(DBFILESGetThumbnailBatchResultEntry *)aGetThumbnailBatchResultEntry {
  if (self == aGetThumbnailBatchResultEntry) {
    return YES;
  }
  if (self.tag != aGetThumbnailBatchResultEntry.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESGetThumbnailBatchResultEntrySuccess:
    return [self.success isEqual:aGetThumbnailBatchResultEntry.success];
  case DBFILESGetThumbnailBatchResultEntryFailure:
    return [self.failure isEqual:aGetThumbnailBatchResultEntry.failure];
  case DBFILESGetThumbnailBatchResultEntryOther:
    return [[self tagName] isEqual:[aGetThumbnailBatchResultEntry tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGetThumbnailBatchResultEntrySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGetThumbnailBatchResultEntry *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict = [[DBFILESGetThumbnailBatchResultDataSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isFailure]) {
    jsonDict[@"failure"] = [[DBFILESThumbnailErrorSerializer serialize:valueObj.failure] mutableCopy];
    jsonDict[@".tag"] = @"failure";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGetThumbnailBatchResultEntry *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBFILESGetThumbnailBatchResultData *success = [DBFILESGetThumbnailBatchResultDataSerializer deserialize:valueDict];
    return [[DBFILESGetThumbnailBatchResultEntry alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"failure"]) {
    DBFILESThumbnailError *failure = [DBFILESThumbnailErrorSerializer deserialize:valueDict[@"failure"]];
    return [[DBFILESGetThumbnailBatchResultEntry alloc] initWithFailure:failure];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESGetThumbnailBatchResultEntry alloc] initWithOther];
  } else {
    return [[DBFILESGetThumbnailBatchResultEntry alloc] initWithOther];
  }
}

@end

#import "DBFILESGpsCoordinates.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESGpsCoordinates

#pragma mark - Constructors

- (instancetype)initWithLatitude:(NSNumber *)latitude longitude:(NSNumber *)longitude {
  [DBStoneValidators nonnullValidator:nil](latitude);
  [DBStoneValidators nonnullValidator:nil](longitude);

  self = [super init];
  if (self) {
    _latitude = latitude;
    _longitude = longitude;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESGpsCoordinatesSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESGpsCoordinatesSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESGpsCoordinatesSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.latitude hash];
  result = prime * result + [self.longitude hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGpsCoordinates:other];
}

- (BOOL)isEqualToGpsCoordinates:(DBFILESGpsCoordinates *)aGpsCoordinates {
  if (self == aGpsCoordinates) {
    return YES;
  }
  if (![self.latitude isEqual:aGpsCoordinates.latitude]) {
    return NO;
  }
  if (![self.longitude isEqual:aGpsCoordinates.longitude]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESGpsCoordinatesSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESGpsCoordinates *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"latitude"] = valueObj.latitude;
  jsonDict[@"longitude"] = valueObj.longitude;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESGpsCoordinates *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *latitude = valueDict[@"latitude"];
  NSNumber *longitude = valueDict[@"longitude"];

  return [[DBFILESGpsCoordinates alloc] initWithLatitude:latitude longitude:longitude];
}

@end

#import "DBFILESHighlightSpan.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESHighlightSpan

#pragma mark - Constructors

- (instancetype)initWithHighlightStr:(NSString *)highlightStr isHighlighted:(NSNumber *)isHighlighted {
  [DBStoneValidators nonnullValidator:nil](highlightStr);
  [DBStoneValidators nonnullValidator:nil](isHighlighted);

  self = [super init];
  if (self) {
    _highlightStr = highlightStr;
    _isHighlighted = isHighlighted;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESHighlightSpanSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESHighlightSpanSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESHighlightSpanSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.highlightStr hash];
  result = prime * result + [self.isHighlighted hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToHighlightSpan:other];
}

- (BOOL)isEqualToHighlightSpan:(DBFILESHighlightSpan *)aHighlightSpan {
  if (self == aHighlightSpan) {
    return YES;
  }
  if (![self.highlightStr isEqual:aHighlightSpan.highlightStr]) {
    return NO;
  }
  if (![self.isHighlighted isEqual:aHighlightSpan.isHighlighted]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESHighlightSpanSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESHighlightSpan *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"highlight_str"] = valueObj.highlightStr;
  jsonDict[@"is_highlighted"] = valueObj.isHighlighted;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESHighlightSpan *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *highlightStr = valueDict[@"highlight_str"];
  NSNumber *isHighlighted = valueDict[@"is_highlighted"];

  return [[DBFILESHighlightSpan alloc] initWithHighlightStr:highlightStr isHighlighted:isHighlighted];
}

@end

#import "DBFILESImportFormat.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESImportFormat

#pragma mark - Constructors

- (instancetype)initWithHtml {
  self = [super init];
  if (self) {
    _tag = DBFILESImportFormatHtml;
  }
  return self;
}

- (instancetype)initWithMarkdown {
  self = [super init];
  if (self) {
    _tag = DBFILESImportFormatMarkdown;
  }
  return self;
}

- (instancetype)initWithPlainText {
  self = [super init];
  if (self) {
    _tag = DBFILESImportFormatPlainText;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESImportFormatOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isHtml {
  return _tag == DBFILESImportFormatHtml;
}

- (BOOL)isMarkdown {
  return _tag == DBFILESImportFormatMarkdown;
}

- (BOOL)isPlainText {
  return _tag == DBFILESImportFormatPlainText;
}

- (BOOL)isOther {
  return _tag == DBFILESImportFormatOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESImportFormatHtml:
    return @"DBFILESImportFormatHtml";
  case DBFILESImportFormatMarkdown:
    return @"DBFILESImportFormatMarkdown";
  case DBFILESImportFormatPlainText:
    return @"DBFILESImportFormatPlainText";
  case DBFILESImportFormatOther:
    return @"DBFILESImportFormatOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESImportFormatSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESImportFormatSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESImportFormatSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESImportFormatHtml:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESImportFormatMarkdown:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESImportFormatPlainText:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESImportFormatOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToImportFormat:other];
}

- (BOOL)isEqualToImportFormat:(DBFILESImportFormat *)anImportFormat {
  if (self == anImportFormat) {
    return YES;
  }
  if (self.tag != anImportFormat.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESImportFormatHtml:
    return [[self tagName] isEqual:[anImportFormat tagName]];
  case DBFILESImportFormatMarkdown:
    return [[self tagName] isEqual:[anImportFormat tagName]];
  case DBFILESImportFormatPlainText:
    return [[self tagName] isEqual:[anImportFormat tagName]];
  case DBFILESImportFormatOther:
    return [[self tagName] isEqual:[anImportFormat tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESImportFormatSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESImportFormat *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isHtml]) {
    jsonDict[@".tag"] = @"html";
  } else if ([valueObj isMarkdown]) {
    jsonDict[@".tag"] = @"markdown";
  } else if ([valueObj isPlainText]) {
    jsonDict[@".tag"] = @"plain_text";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESImportFormat *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"html"]) {
    return [[DBFILESImportFormat alloc] initWithHtml];
  } else if ([tag isEqualToString:@"markdown"]) {
    return [[DBFILESImportFormat alloc] initWithMarkdown];
  } else if ([tag isEqualToString:@"plain_text"]) {
    return [[DBFILESImportFormat alloc] initWithPlainText];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESImportFormat alloc] initWithOther];
  } else {
    return [[DBFILESImportFormat alloc] initWithOther];
  }
}

@end

#import "DBFILEPROPERTIESTemplateFilterBase.h"
#import "DBFILESListFolderArg.h"
#import "DBFILESSharedLink.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListFolderArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                          recursive:(NSNumber *)recursive
                   includeMediaInfo:(NSNumber *)includeMediaInfo
                     includeDeleted:(NSNumber *)includeDeleted
    includeHasExplicitSharedMembers:(NSNumber *)includeHasExplicitSharedMembers
              includeMountedFolders:(NSNumber *)includeMountedFolders
                              limit:(NSNumber *)limit
                         sharedLink:(DBFILESSharedLink *)sharedLink
              includePropertyGroups:(DBFILEPROPERTIESTemplateFilterBase *)includePropertyGroups
        includeNonDownloadableFiles:(NSNumber *)includeNonDownloadableFiles {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)?|id:.*|(ns:[0-9]+(/.*)?)"]](path);
  [DBStoneValidators nullableValidator:[DBStoneValidators numericValidator:@(1) maxValue:@(2000)]](limit);

  self = [super init];
  if (self) {
    _path = path;
    _recursive = recursive ?: @NO;
    _includeMediaInfo = includeMediaInfo ?: @NO;
    _includeDeleted = includeDeleted ?: @NO;
    _includeHasExplicitSharedMembers = includeHasExplicitSharedMembers ?: @NO;
    _includeMountedFolders = includeMountedFolders ?: @YES;
    _limit = limit;
    _sharedLink = sharedLink;
    _includePropertyGroups = includePropertyGroups;
    _includeNonDownloadableFiles = includeNonDownloadableFiles ?: @YES;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path
                            recursive:nil
                     includeMediaInfo:nil
                       includeDeleted:nil
      includeHasExplicitSharedMembers:nil
                includeMountedFolders:nil
                                limit:nil
                           sharedLink:nil
                includePropertyGroups:nil
          includeNonDownloadableFiles:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListFolderArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListFolderArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListFolderArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.recursive hash];
  result = prime * result + [self.includeMediaInfo hash];
  result = prime * result + [self.includeDeleted hash];
  result = prime * result + [self.includeHasExplicitSharedMembers hash];
  result = prime * result + [self.includeMountedFolders hash];
  if (self.limit != nil) {
    result = prime * result + [self.limit hash];
  }
  if (self.sharedLink != nil) {
    result = prime * result + [self.sharedLink hash];
  }
  if (self.includePropertyGroups != nil) {
    result = prime * result + [self.includePropertyGroups hash];
  }
  result = prime * result + [self.includeNonDownloadableFiles hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderArg:other];
}

- (BOOL)isEqualToListFolderArg:(DBFILESListFolderArg *)aListFolderArg {
  if (self == aListFolderArg) {
    return YES;
  }
  if (![self.path isEqual:aListFolderArg.path]) {
    return NO;
  }
  if (![self.recursive isEqual:aListFolderArg.recursive]) {
    return NO;
  }
  if (![self.includeMediaInfo isEqual:aListFolderArg.includeMediaInfo]) {
    return NO;
  }
  if (![self.includeDeleted isEqual:aListFolderArg.includeDeleted]) {
    return NO;
  }
  if (![self.includeHasExplicitSharedMembers isEqual:aListFolderArg.includeHasExplicitSharedMembers]) {
    return NO;
  }
  if (![self.includeMountedFolders isEqual:aListFolderArg.includeMountedFolders]) {
    return NO;
  }
  if (self.limit) {
    if (![self.limit isEqual:aListFolderArg.limit]) {
      return NO;
    }
  }
  if (self.sharedLink) {
    if (![self.sharedLink isEqual:aListFolderArg.sharedLink]) {
      return NO;
    }
  }
  if (self.includePropertyGroups) {
    if (![self.includePropertyGroups isEqual:aListFolderArg.includePropertyGroups]) {
      return NO;
    }
  }
  if (![self.includeNonDownloadableFiles isEqual:aListFolderArg.includeNonDownloadableFiles]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListFolderArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"recursive"] = valueObj.recursive;
  jsonDict[@"include_media_info"] = valueObj.includeMediaInfo;
  jsonDict[@"include_deleted"] = valueObj.includeDeleted;
  jsonDict[@"include_has_explicit_shared_members"] = valueObj.includeHasExplicitSharedMembers;
  jsonDict[@"include_mounted_folders"] = valueObj.includeMountedFolders;
  if (valueObj.limit) {
    jsonDict[@"limit"] = valueObj.limit;
  }
  if (valueObj.sharedLink) {
    jsonDict[@"shared_link"] = [DBFILESSharedLinkSerializer serialize:valueObj.sharedLink];
  }
  if (valueObj.includePropertyGroups) {
    jsonDict[@"include_property_groups"] =
        [DBFILEPROPERTIESTemplateFilterBaseSerializer serialize:valueObj.includePropertyGroups];
  }
  jsonDict[@"include_non_downloadable_files"] = valueObj.includeNonDownloadableFiles;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListFolderArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSNumber *recursive = valueDict[@"recursive"] ?: @NO;
  NSNumber *includeMediaInfo = valueDict[@"include_media_info"] ?: @NO;
  NSNumber *includeDeleted = valueDict[@"include_deleted"] ?: @NO;
  NSNumber *includeHasExplicitSharedMembers = valueDict[@"include_has_explicit_shared_members"] ?: @NO;
  NSNumber *includeMountedFolders = valueDict[@"include_mounted_folders"] ?: @YES;
  NSNumber *limit = valueDict[@"limit"] ?: nil;
  DBFILESSharedLink *sharedLink =
      valueDict[@"shared_link"] ? [DBFILESSharedLinkSerializer deserialize:valueDict[@"shared_link"]] : nil;
  DBFILEPROPERTIESTemplateFilterBase *includePropertyGroups =
      valueDict[@"include_property_groups"]
          ? [DBFILEPROPERTIESTemplateFilterBaseSerializer deserialize:valueDict[@"include_property_groups"]]
          : nil;
  NSNumber *includeNonDownloadableFiles = valueDict[@"include_non_downloadable_files"] ?: @YES;

  return [[DBFILESListFolderArg alloc] initWithPath:path
                                          recursive:recursive
                                   includeMediaInfo:includeMediaInfo
                                     includeDeleted:includeDeleted
                    includeHasExplicitSharedMembers:includeHasExplicitSharedMembers
                              includeMountedFolders:includeMountedFolders
                                              limit:limit
                                         sharedLink:sharedLink
                              includePropertyGroups:includePropertyGroups
                        includeNonDownloadableFiles:includeNonDownloadableFiles];
}

@end

#import "DBFILESListFolderContinueArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListFolderContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListFolderContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListFolderContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListFolderContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderContinueArg:other];
}

- (BOOL)isEqualToListFolderContinueArg:(DBFILESListFolderContinueArg *)aListFolderContinueArg {
  if (self == aListFolderContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aListFolderContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListFolderContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListFolderContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBFILESListFolderContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBFILESListFolderContinueError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListFolderContinueError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESListFolderContinueErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithReset {
  self = [super init];
  if (self) {
    _tag = DBFILESListFolderContinueErrorReset;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESListFolderContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESListFolderContinueErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESListFolderContinueErrorPath;
}

- (BOOL)isReset {
  return _tag == DBFILESListFolderContinueErrorReset;
}

- (BOOL)isOther {
  return _tag == DBFILESListFolderContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESListFolderContinueErrorPath:
    return @"DBFILESListFolderContinueErrorPath";
  case DBFILESListFolderContinueErrorReset:
    return @"DBFILESListFolderContinueErrorReset";
  case DBFILESListFolderContinueErrorOther:
    return @"DBFILESListFolderContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListFolderContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListFolderContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListFolderContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESListFolderContinueErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESListFolderContinueErrorReset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESListFolderContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderContinueError:other];
}

- (BOOL)isEqualToListFolderContinueError:(DBFILESListFolderContinueError *)aListFolderContinueError {
  if (self == aListFolderContinueError) {
    return YES;
  }
  if (self.tag != aListFolderContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESListFolderContinueErrorPath:
    return [self.path isEqual:aListFolderContinueError.path];
  case DBFILESListFolderContinueErrorReset:
    return [[self tagName] isEqual:[aListFolderContinueError tagName]];
  case DBFILESListFolderContinueErrorOther:
    return [[self tagName] isEqual:[aListFolderContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListFolderContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isReset]) {
    jsonDict[@".tag"] = @"reset";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListFolderContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESListFolderContinueError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"reset"]) {
    return [[DBFILESListFolderContinueError alloc] initWithReset];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESListFolderContinueError alloc] initWithOther];
  } else {
    return [[DBFILESListFolderContinueError alloc] initWithOther];
  }
}

@end

#import "DBFILEPROPERTIESTemplateError.h"
#import "DBFILESListFolderError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListFolderError

@synthesize path = _path;
@synthesize templateError = _templateError;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESListFolderErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithTemplateError:(DBFILEPROPERTIESTemplateError *)templateError {
  self = [super init];
  if (self) {
    _tag = DBFILESListFolderErrorTemplateError;
    _templateError = templateError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESListFolderErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESListFolderErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

- (DBFILEPROPERTIESTemplateError *)templateError {
  if (![self isTemplateError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESListFolderErrorTemplateError, but was %@.", [self tagName]];
  }
  return _templateError;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESListFolderErrorPath;
}

- (BOOL)isTemplateError {
  return _tag == DBFILESListFolderErrorTemplateError;
}

- (BOOL)isOther {
  return _tag == DBFILESListFolderErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESListFolderErrorPath:
    return @"DBFILESListFolderErrorPath";
  case DBFILESListFolderErrorTemplateError:
    return @"DBFILESListFolderErrorTemplateError";
  case DBFILESListFolderErrorOther:
    return @"DBFILESListFolderErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListFolderErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListFolderErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListFolderErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESListFolderErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESListFolderErrorTemplateError:
    result = prime * result + [self.templateError hash];
    break;
  case DBFILESListFolderErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderError:other];
}

- (BOOL)isEqualToListFolderError:(DBFILESListFolderError *)aListFolderError {
  if (self == aListFolderError) {
    return YES;
  }
  if (self.tag != aListFolderError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESListFolderErrorPath:
    return [self.path isEqual:aListFolderError.path];
  case DBFILESListFolderErrorTemplateError:
    return [self.templateError isEqual:aListFolderError.templateError];
  case DBFILESListFolderErrorOther:
    return [[self tagName] isEqual:[aListFolderError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListFolderErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isTemplateError]) {
    jsonDict[@"template_error"] =
        [[DBFILEPROPERTIESTemplateErrorSerializer serialize:valueObj.templateError] mutableCopy];
    jsonDict[@".tag"] = @"template_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListFolderError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESListFolderError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"template_error"]) {
    DBFILEPROPERTIESTemplateError *templateError =
        [DBFILEPROPERTIESTemplateErrorSerializer deserialize:valueDict[@"template_error"]];
    return [[DBFILESListFolderError alloc] initWithTemplateError:templateError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESListFolderError alloc] initWithOther];
  } else {
    return [[DBFILESListFolderError alloc] initWithOther];
  }
}

@end

#import "DBFILESListFolderGetLatestCursorResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListFolderGetLatestCursorResult

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListFolderGetLatestCursorResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListFolderGetLatestCursorResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListFolderGetLatestCursorResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderGetLatestCursorResult:other];
}

- (BOOL)isEqualToListFolderGetLatestCursorResult:
    (DBFILESListFolderGetLatestCursorResult *)aListFolderGetLatestCursorResult {
  if (self == aListFolderGetLatestCursorResult) {
    return YES;
  }
  if (![self.cursor isEqual:aListFolderGetLatestCursorResult.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListFolderGetLatestCursorResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderGetLatestCursorResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListFolderGetLatestCursorResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBFILESListFolderGetLatestCursorResult alloc] initWithCursor:cursor];
}

@end

#import "DBFILESListFolderLongpollArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListFolderLongpollArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor timeout:(NSNumber *)timeout {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
    _timeout = timeout ?: @(30);
  }
  return self;
}

- (instancetype)initWithCursor:(NSString *)cursor {
  return [self initWithCursor:cursor timeout:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListFolderLongpollArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListFolderLongpollArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListFolderLongpollArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];
  result = prime * result + [self.timeout hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderLongpollArg:other];
}

- (BOOL)isEqualToListFolderLongpollArg:(DBFILESListFolderLongpollArg *)aListFolderLongpollArg {
  if (self == aListFolderLongpollArg) {
    return YES;
  }
  if (![self.cursor isEqual:aListFolderLongpollArg.cursor]) {
    return NO;
  }
  if (![self.timeout isEqual:aListFolderLongpollArg.timeout]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListFolderLongpollArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderLongpollArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;
  jsonDict[@"timeout"] = valueObj.timeout;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListFolderLongpollArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];
  NSNumber *timeout = valueDict[@"timeout"] ?: @(30);

  return [[DBFILESListFolderLongpollArg alloc] initWithCursor:cursor timeout:timeout];
}

@end

#import "DBFILESListFolderLongpollError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListFolderLongpollError

#pragma mark - Constructors

- (instancetype)initWithReset {
  self = [super init];
  if (self) {
    _tag = DBFILESListFolderLongpollErrorReset;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESListFolderLongpollErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isReset {
  return _tag == DBFILESListFolderLongpollErrorReset;
}

- (BOOL)isOther {
  return _tag == DBFILESListFolderLongpollErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESListFolderLongpollErrorReset:
    return @"DBFILESListFolderLongpollErrorReset";
  case DBFILESListFolderLongpollErrorOther:
    return @"DBFILESListFolderLongpollErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListFolderLongpollErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListFolderLongpollErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListFolderLongpollErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESListFolderLongpollErrorReset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESListFolderLongpollErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderLongpollError:other];
}

- (BOOL)isEqualToListFolderLongpollError:(DBFILESListFolderLongpollError *)aListFolderLongpollError {
  if (self == aListFolderLongpollError) {
    return YES;
  }
  if (self.tag != aListFolderLongpollError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESListFolderLongpollErrorReset:
    return [[self tagName] isEqual:[aListFolderLongpollError tagName]];
  case DBFILESListFolderLongpollErrorOther:
    return [[self tagName] isEqual:[aListFolderLongpollError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListFolderLongpollErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderLongpollError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isReset]) {
    jsonDict[@".tag"] = @"reset";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListFolderLongpollError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"reset"]) {
    return [[DBFILESListFolderLongpollError alloc] initWithReset];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESListFolderLongpollError alloc] initWithOther];
  } else {
    return [[DBFILESListFolderLongpollError alloc] initWithOther];
  }
}

@end

#import "DBFILESListFolderLongpollResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListFolderLongpollResult

#pragma mark - Constructors

- (instancetype)initWithChanges:(NSNumber *)changes backoff:(NSNumber *)backoff {
  [DBStoneValidators nonnullValidator:nil](changes);

  self = [super init];
  if (self) {
    _changes = changes;
    _backoff = backoff;
  }
  return self;
}

- (instancetype)initWithChanges:(NSNumber *)changes {
  return [self initWithChanges:changes backoff:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListFolderLongpollResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListFolderLongpollResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListFolderLongpollResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.changes hash];
  if (self.backoff != nil) {
    result = prime * result + [self.backoff hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderLongpollResult:other];
}

- (BOOL)isEqualToListFolderLongpollResult:(DBFILESListFolderLongpollResult *)aListFolderLongpollResult {
  if (self == aListFolderLongpollResult) {
    return YES;
  }
  if (![self.changes isEqual:aListFolderLongpollResult.changes]) {
    return NO;
  }
  if (self.backoff) {
    if (![self.backoff isEqual:aListFolderLongpollResult.backoff]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListFolderLongpollResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderLongpollResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"changes"] = valueObj.changes;
  if (valueObj.backoff) {
    jsonDict[@"backoff"] = valueObj.backoff;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListFolderLongpollResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *changes = valueDict[@"changes"];
  NSNumber *backoff = valueDict[@"backoff"] ?: nil;

  return [[DBFILESListFolderLongpollResult alloc] initWithChanges:changes backoff:backoff];
}

@end

#import "DBFILESListFolderResult.h"
#import "DBFILESMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListFolderResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESMetadata *> *)entries
                         cursor:(NSString *)cursor
                        hasMore:(NSNumber *)hasMore {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](cursor);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _entries = entries;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListFolderResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListFolderResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListFolderResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];
  result = prime * result + [self.cursor hash];
  result = prime * result + [self.hasMore hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderResult:other];
}

- (BOOL)isEqualToListFolderResult:(DBFILESListFolderResult *)aListFolderResult {
  if (self == aListFolderResult) {
    return YES;
  }
  if (![self.entries isEqual:aListFolderResult.entries]) {
    return NO;
  }
  if (![self.cursor isEqual:aListFolderResult.cursor]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListFolderResult.hasMore]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListFolderResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESMetadataSerializer serialize:elem0];
                                            }];
  jsonDict[@"cursor"] = valueObj.cursor;
  jsonDict[@"has_more"] = valueObj.hasMore;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListFolderResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESMetadata *> *entries = [DBArraySerializer deserialize:valueDict[@"entries"]
                                                             withBlock:^id(id elem0) {
                                                               return [DBFILESMetadataSerializer deserialize:elem0];
                                                             }];
  NSString *cursor = valueDict[@"cursor"];
  NSNumber *hasMore = valueDict[@"has_more"];

  return [[DBFILESListFolderResult alloc] initWithEntries:entries cursor:cursor hasMore:hasMore];
}

@end

#import "DBFILESListRevisionsArg.h"
#import "DBFILESListRevisionsMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListRevisionsArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path mode:(DBFILESListRevisionsMode *)mode limit:(NSNumber *)limit {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"/(.|[\\r\\n])*|id:.*|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
    _mode = mode ?: [[DBFILESListRevisionsMode alloc] initWithPath];
    _limit = limit ?: @(10);
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path mode:nil limit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListRevisionsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListRevisionsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListRevisionsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.mode hash];
  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListRevisionsArg:other];
}

- (BOOL)isEqualToListRevisionsArg:(DBFILESListRevisionsArg *)aListRevisionsArg {
  if (self == aListRevisionsArg) {
    return YES;
  }
  if (![self.path isEqual:aListRevisionsArg.path]) {
    return NO;
  }
  if (![self.mode isEqual:aListRevisionsArg.mode]) {
    return NO;
  }
  if (![self.limit isEqual:aListRevisionsArg.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListRevisionsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListRevisionsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"mode"] = [DBFILESListRevisionsModeSerializer serialize:valueObj.mode];
  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListRevisionsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  DBFILESListRevisionsMode *mode = valueDict[@"mode"]
                                       ? [DBFILESListRevisionsModeSerializer deserialize:valueDict[@"mode"]]
                                       : [[DBFILESListRevisionsMode alloc] initWithPath];
  NSNumber *limit = valueDict[@"limit"] ?: @(10);

  return [[DBFILESListRevisionsArg alloc] initWithPath:path mode:mode limit:limit];
}

@end

#import "DBFILESListRevisionsError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListRevisionsError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESListRevisionsErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESListRevisionsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESListRevisionsErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESListRevisionsErrorPath;
}

- (BOOL)isOther {
  return _tag == DBFILESListRevisionsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESListRevisionsErrorPath:
    return @"DBFILESListRevisionsErrorPath";
  case DBFILESListRevisionsErrorOther:
    return @"DBFILESListRevisionsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListRevisionsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListRevisionsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListRevisionsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESListRevisionsErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESListRevisionsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListRevisionsError:other];
}

- (BOOL)isEqualToListRevisionsError:(DBFILESListRevisionsError *)aListRevisionsError {
  if (self == aListRevisionsError) {
    return YES;
  }
  if (self.tag != aListRevisionsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESListRevisionsErrorPath:
    return [self.path isEqual:aListRevisionsError.path];
  case DBFILESListRevisionsErrorOther:
    return [[self tagName] isEqual:[aListRevisionsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListRevisionsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListRevisionsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListRevisionsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESListRevisionsError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESListRevisionsError alloc] initWithOther];
  } else {
    return [[DBFILESListRevisionsError alloc] initWithOther];
  }
}

@end

#import "DBFILESListRevisionsMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListRevisionsMode

#pragma mark - Constructors

- (instancetype)initWithPath {
  self = [super init];
  if (self) {
    _tag = DBFILESListRevisionsModePath;
  }
  return self;
}

- (instancetype)initWithId_ {
  self = [super init];
  if (self) {
    _tag = DBFILESListRevisionsModeId_;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESListRevisionsModeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESListRevisionsModePath;
}

- (BOOL)isId_ {
  return _tag == DBFILESListRevisionsModeId_;
}

- (BOOL)isOther {
  return _tag == DBFILESListRevisionsModeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESListRevisionsModePath:
    return @"DBFILESListRevisionsModePath";
  case DBFILESListRevisionsModeId_:
    return @"DBFILESListRevisionsModeId_";
  case DBFILESListRevisionsModeOther:
    return @"DBFILESListRevisionsModeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListRevisionsModeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListRevisionsModeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListRevisionsModeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESListRevisionsModePath:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESListRevisionsModeId_:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESListRevisionsModeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListRevisionsMode:other];
}

- (BOOL)isEqualToListRevisionsMode:(DBFILESListRevisionsMode *)aListRevisionsMode {
  if (self == aListRevisionsMode) {
    return YES;
  }
  if (self.tag != aListRevisionsMode.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESListRevisionsModePath:
    return [[self tagName] isEqual:[aListRevisionsMode tagName]];
  case DBFILESListRevisionsModeId_:
    return [[self tagName] isEqual:[aListRevisionsMode tagName]];
  case DBFILESListRevisionsModeOther:
    return [[self tagName] isEqual:[aListRevisionsMode tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListRevisionsModeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListRevisionsMode *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isId_]) {
    jsonDict[@".tag"] = @"id";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListRevisionsMode *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    return [[DBFILESListRevisionsMode alloc] initWithPath];
  } else if ([tag isEqualToString:@"id"]) {
    return [[DBFILESListRevisionsMode alloc] initWithId_];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESListRevisionsMode alloc] initWithOther];
  } else {
    return [[DBFILESListRevisionsMode alloc] initWithOther];
  }
}

@end

#import "DBFILESFileMetadata.h"
#import "DBFILESListRevisionsResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESListRevisionsResult

#pragma mark - Constructors

- (instancetype)initWithIsDeleted:(NSNumber *)isDeleted
                          entries:(NSArray<DBFILESFileMetadata *> *)entries
                    serverDeleted:(NSDate *)serverDeleted {
  [DBStoneValidators nonnullValidator:nil](isDeleted);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _isDeleted = isDeleted;
    _serverDeleted = serverDeleted;
    _entries = entries;
  }
  return self;
}

- (instancetype)initWithIsDeleted:(NSNumber *)isDeleted entries:(NSArray<DBFILESFileMetadata *> *)entries {
  return [self initWithIsDeleted:isDeleted entries:entries serverDeleted:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESListRevisionsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESListRevisionsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESListRevisionsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.isDeleted hash];
  result = prime * result + [self.entries hash];
  if (self.serverDeleted != nil) {
    result = prime * result + [self.serverDeleted hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListRevisionsResult:other];
}

- (BOOL)isEqualToListRevisionsResult:(DBFILESListRevisionsResult *)aListRevisionsResult {
  if (self == aListRevisionsResult) {
    return YES;
  }
  if (![self.isDeleted isEqual:aListRevisionsResult.isDeleted]) {
    return NO;
  }
  if (![self.entries isEqual:aListRevisionsResult.entries]) {
    return NO;
  }
  if (self.serverDeleted) {
    if (![self.serverDeleted isEqual:aListRevisionsResult.serverDeleted]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESListRevisionsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESListRevisionsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"is_deleted"] = valueObj.isDeleted;
  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESFileMetadataSerializer serialize:elem0];
                                            }];
  if (valueObj.serverDeleted) {
    jsonDict[@"server_deleted"] =
        [DBNSDateSerializer serialize:valueObj.serverDeleted dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESListRevisionsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *isDeleted = valueDict[@"is_deleted"];
  NSArray<DBFILESFileMetadata *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESFileMetadataSerializer deserialize:elem0];
                           }];
  NSDate *serverDeleted = valueDict[@"server_deleted"] ? [DBNSDateSerializer deserialize:valueDict[@"server_deleted"]
                                                                              dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                                                       : nil;

  return [[DBFILESListRevisionsResult alloc] initWithIsDeleted:isDeleted entries:entries serverDeleted:serverDeleted];
}

@end

#import "DBFILESFileLock.h"
#import "DBFILESLockConflictError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESLockConflictError

#pragma mark - Constructors

- (instancetype)initWithLock:(DBFILESFileLock *)lock {
  [DBStoneValidators nonnullValidator:nil](lock);

  self = [super init];
  if (self) {
    _lock = lock;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESLockConflictErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESLockConflictErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESLockConflictErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.lock hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLockConflictError:other];
}

- (BOOL)isEqualToLockConflictError:(DBFILESLockConflictError *)aLockConflictError {
  if (self == aLockConflictError) {
    return YES;
  }
  if (![self.lock isEqual:aLockConflictError.lock]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESLockConflictErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESLockConflictError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"lock"] = [DBFILESFileLockSerializer serialize:valueObj.lock];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESLockConflictError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESFileLock *lock = [DBFILESFileLockSerializer deserialize:valueDict[@"lock"]];

  return [[DBFILESLockConflictError alloc] initWithLock:lock];
}

@end

#import "DBFILESLockFileArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESLockFileArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](path);

  self = [super init];
  if (self) {
    _path = path;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESLockFileArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESLockFileArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESLockFileArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLockFileArg:other];
}

- (BOOL)isEqualToLockFileArg:(DBFILESLockFileArg *)aLockFileArg {
  if (self == aLockFileArg) {
    return YES;
  }
  if (![self.path isEqual:aLockFileArg.path]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESLockFileArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESLockFileArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESLockFileArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];

  return [[DBFILESLockFileArg alloc] initWithPath:path];
}

@end

#import "DBFILESLockFileArg.h"
#import "DBFILESLockFileBatchArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESLockFileBatchArg

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESLockFileArg *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESLockFileBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESLockFileBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESLockFileBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLockFileBatchArg:other];
}

- (BOOL)isEqualToLockFileBatchArg:(DBFILESLockFileBatchArg *)aLockFileBatchArg {
  if (self == aLockFileBatchArg) {
    return YES;
  }
  if (![self.entries isEqual:aLockFileBatchArg.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESLockFileBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESLockFileBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESLockFileArgSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESLockFileBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESLockFileArg *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESLockFileArgSerializer deserialize:elem0];
                           }];

  return [[DBFILESLockFileBatchArg alloc] initWithEntries:entries];
}

@end

#import "DBFILESFileOpsResult.h"
#import "DBFILESLockFileBatchResult.h"
#import "DBFILESLockFileResultEntry.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESLockFileBatchResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESLockFileResultEntry *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super initDefault];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESLockFileBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESLockFileBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESLockFileBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLockFileBatchResult:other];
}

- (BOOL)isEqualToLockFileBatchResult:(DBFILESLockFileBatchResult *)aLockFileBatchResult {
  if (self == aLockFileBatchResult) {
    return YES;
  }
  if (![self.entries isEqual:aLockFileBatchResult.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESLockFileBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESLockFileBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESLockFileResultEntrySerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESLockFileBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESLockFileResultEntry *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESLockFileResultEntrySerializer deserialize:elem0];
                           }];

  return [[DBFILESLockFileBatchResult alloc] initWithEntries:entries];
}

@end

#import "DBFILESLockConflictError.h"
#import "DBFILESLockFileError.h"
#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESLockFileError

@synthesize pathLookup = _pathLookup;
@synthesize lockConflict = _lockConflict;

#pragma mark - Constructors

- (instancetype)initWithPathLookup:(DBFILESLookupError *)pathLookup {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileErrorPathLookup;
    _pathLookup = pathLookup;
  }
  return self;
}

- (instancetype)initWithTooManyWriteOperations {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileErrorTooManyWriteOperations;
  }
  return self;
}

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithNoWritePermission {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileErrorNoWritePermission;
  }
  return self;
}

- (instancetype)initWithCannotBeLocked {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileErrorCannotBeLocked;
  }
  return self;
}

- (instancetype)initWithFileNotShared {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileErrorFileNotShared;
  }
  return self;
}

- (instancetype)initWithLockConflict:(DBFILESLockConflictError *)lockConflict {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileErrorLockConflict;
    _lockConflict = lockConflict;
  }
  return self;
}

- (instancetype)initWithInternalError {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileErrorInternalError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)pathLookup {
  if (![self isPathLookup]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESLockFileErrorPathLookup, but was %@.", [self tagName]];
  }
  return _pathLookup;
}

- (DBFILESLockConflictError *)lockConflict {
  if (![self isLockConflict]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESLockFileErrorLockConflict, but was %@.", [self tagName]];
  }
  return _lockConflict;
}

#pragma mark - Tag state methods

- (BOOL)isPathLookup {
  return _tag == DBFILESLockFileErrorPathLookup;
}

- (BOOL)isTooManyWriteOperations {
  return _tag == DBFILESLockFileErrorTooManyWriteOperations;
}

- (BOOL)isTooManyFiles {
  return _tag == DBFILESLockFileErrorTooManyFiles;
}

- (BOOL)isNoWritePermission {
  return _tag == DBFILESLockFileErrorNoWritePermission;
}

- (BOOL)isCannotBeLocked {
  return _tag == DBFILESLockFileErrorCannotBeLocked;
}

- (BOOL)isFileNotShared {
  return _tag == DBFILESLockFileErrorFileNotShared;
}

- (BOOL)isLockConflict {
  return _tag == DBFILESLockFileErrorLockConflict;
}

- (BOOL)isInternalError {
  return _tag == DBFILESLockFileErrorInternalError;
}

- (BOOL)isOther {
  return _tag == DBFILESLockFileErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESLockFileErrorPathLookup:
    return @"DBFILESLockFileErrorPathLookup";
  case DBFILESLockFileErrorTooManyWriteOperations:
    return @"DBFILESLockFileErrorTooManyWriteOperations";
  case DBFILESLockFileErrorTooManyFiles:
    return @"DBFILESLockFileErrorTooManyFiles";
  case DBFILESLockFileErrorNoWritePermission:
    return @"DBFILESLockFileErrorNoWritePermission";
  case DBFILESLockFileErrorCannotBeLocked:
    return @"DBFILESLockFileErrorCannotBeLocked";
  case DBFILESLockFileErrorFileNotShared:
    return @"DBFILESLockFileErrorFileNotShared";
  case DBFILESLockFileErrorLockConflict:
    return @"DBFILESLockFileErrorLockConflict";
  case DBFILESLockFileErrorInternalError:
    return @"DBFILESLockFileErrorInternalError";
  case DBFILESLockFileErrorOther:
    return @"DBFILESLockFileErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESLockFileErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESLockFileErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESLockFileErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESLockFileErrorPathLookup:
    result = prime * result + [self.pathLookup hash];
    break;
  case DBFILESLockFileErrorTooManyWriteOperations:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLockFileErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLockFileErrorNoWritePermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLockFileErrorCannotBeLocked:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLockFileErrorFileNotShared:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLockFileErrorLockConflict:
    result = prime * result + [self.lockConflict hash];
    break;
  case DBFILESLockFileErrorInternalError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLockFileErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLockFileError:other];
}

- (BOOL)isEqualToLockFileError:(DBFILESLockFileError *)aLockFileError {
  if (self == aLockFileError) {
    return YES;
  }
  if (self.tag != aLockFileError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESLockFileErrorPathLookup:
    return [self.pathLookup isEqual:aLockFileError.pathLookup];
  case DBFILESLockFileErrorTooManyWriteOperations:
    return [[self tagName] isEqual:[aLockFileError tagName]];
  case DBFILESLockFileErrorTooManyFiles:
    return [[self tagName] isEqual:[aLockFileError tagName]];
  case DBFILESLockFileErrorNoWritePermission:
    return [[self tagName] isEqual:[aLockFileError tagName]];
  case DBFILESLockFileErrorCannotBeLocked:
    return [[self tagName] isEqual:[aLockFileError tagName]];
  case DBFILESLockFileErrorFileNotShared:
    return [[self tagName] isEqual:[aLockFileError tagName]];
  case DBFILESLockFileErrorLockConflict:
    return [self.lockConflict isEqual:aLockFileError.lockConflict];
  case DBFILESLockFileErrorInternalError:
    return [[self tagName] isEqual:[aLockFileError tagName]];
  case DBFILESLockFileErrorOther:
    return [[self tagName] isEqual:[aLockFileError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESLockFileErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESLockFileError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPathLookup]) {
    jsonDict[@"path_lookup"] = [[DBFILESLookupErrorSerializer serialize:valueObj.pathLookup] mutableCopy];
    jsonDict[@".tag"] = @"path_lookup";
  } else if ([valueObj isTooManyWriteOperations]) {
    jsonDict[@".tag"] = @"too_many_write_operations";
  } else if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isNoWritePermission]) {
    jsonDict[@".tag"] = @"no_write_permission";
  } else if ([valueObj isCannotBeLocked]) {
    jsonDict[@".tag"] = @"cannot_be_locked";
  } else if ([valueObj isFileNotShared]) {
    jsonDict[@".tag"] = @"file_not_shared";
  } else if ([valueObj isLockConflict]) {
    jsonDict = [[DBFILESLockConflictErrorSerializer serialize:valueObj.lockConflict] mutableCopy];
    jsonDict[@".tag"] = @"lock_conflict";
  } else if ([valueObj isInternalError]) {
    jsonDict[@".tag"] = @"internal_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESLockFileError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path_lookup"]) {
    DBFILESLookupError *pathLookup = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path_lookup"]];
    return [[DBFILESLockFileError alloc] initWithPathLookup:pathLookup];
  } else if ([tag isEqualToString:@"too_many_write_operations"]) {
    return [[DBFILESLockFileError alloc] initWithTooManyWriteOperations];
  } else if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBFILESLockFileError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"no_write_permission"]) {
    return [[DBFILESLockFileError alloc] initWithNoWritePermission];
  } else if ([tag isEqualToString:@"cannot_be_locked"]) {
    return [[DBFILESLockFileError alloc] initWithCannotBeLocked];
  } else if ([tag isEqualToString:@"file_not_shared"]) {
    return [[DBFILESLockFileError alloc] initWithFileNotShared];
  } else if ([tag isEqualToString:@"lock_conflict"]) {
    DBFILESLockConflictError *lockConflict = [DBFILESLockConflictErrorSerializer deserialize:valueDict];
    return [[DBFILESLockFileError alloc] initWithLockConflict:lockConflict];
  } else if ([tag isEqualToString:@"internal_error"]) {
    return [[DBFILESLockFileError alloc] initWithInternalError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESLockFileError alloc] initWithOther];
  } else {
    return [[DBFILESLockFileError alloc] initWithOther];
  }
}

@end

#import "DBFILESFileLock.h"
#import "DBFILESLockFileResult.h"
#import "DBFILESMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESLockFileResult

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata lock:(DBFILESFileLock *)lock {
  [DBStoneValidators nonnullValidator:nil](metadata);
  [DBStoneValidators nonnullValidator:nil](lock);

  self = [super init];
  if (self) {
    _metadata = metadata;
    _lock = lock;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESLockFileResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESLockFileResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESLockFileResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];
  result = prime * result + [self.lock hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLockFileResult:other];
}

- (BOOL)isEqualToLockFileResult:(DBFILESLockFileResult *)aLockFileResult {
  if (self == aLockFileResult) {
    return YES;
  }
  if (![self.metadata isEqual:aLockFileResult.metadata]) {
    return NO;
  }
  if (![self.lock isEqual:aLockFileResult.lock]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESLockFileResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESLockFileResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESMetadataSerializer serialize:valueObj.metadata];
  jsonDict[@"lock"] = [DBFILESFileLockSerializer serialize:valueObj.lock];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESLockFileResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESMetadata *metadata = [DBFILESMetadataSerializer deserialize:valueDict[@"metadata"]];
  DBFILESFileLock *lock = [DBFILESFileLockSerializer deserialize:valueDict[@"lock"]];

  return [[DBFILESLockFileResult alloc] initWithMetadata:metadata lock:lock];
}

@end

#import "DBFILESLockFileError.h"
#import "DBFILESLockFileResult.h"
#import "DBFILESLockFileResultEntry.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESLockFileResultEntry

@synthesize success = _success;
@synthesize failure = _failure;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBFILESLockFileResult *)success {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileResultEntrySuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithFailure:(DBFILESLockFileError *)failure {
  self = [super init];
  if (self) {
    _tag = DBFILESLockFileResultEntryFailure;
    _failure = failure;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLockFileResult *)success {
  if (![self isSuccess]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESLockFileResultEntrySuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBFILESLockFileError *)failure {
  if (![self isFailure]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESLockFileResultEntryFailure, but was %@.", [self tagName]];
  }
  return _failure;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBFILESLockFileResultEntrySuccess;
}

- (BOOL)isFailure {
  return _tag == DBFILESLockFileResultEntryFailure;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESLockFileResultEntrySuccess:
    return @"DBFILESLockFileResultEntrySuccess";
  case DBFILESLockFileResultEntryFailure:
    return @"DBFILESLockFileResultEntryFailure";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESLockFileResultEntrySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESLockFileResultEntrySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESLockFileResultEntrySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESLockFileResultEntrySuccess:
    result = prime * result + [self.success hash];
    break;
  case DBFILESLockFileResultEntryFailure:
    result = prime * result + [self.failure hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLockFileResultEntry:other];
}

- (BOOL)isEqualToLockFileResultEntry:(DBFILESLockFileResultEntry *)aLockFileResultEntry {
  if (self == aLockFileResultEntry) {
    return YES;
  }
  if (self.tag != aLockFileResultEntry.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESLockFileResultEntrySuccess:
    return [self.success isEqual:aLockFileResultEntry.success];
  case DBFILESLockFileResultEntryFailure:
    return [self.failure isEqual:aLockFileResultEntry.failure];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESLockFileResultEntrySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESLockFileResultEntry *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict = [[DBFILESLockFileResultSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isFailure]) {
    jsonDict[@"failure"] = [[DBFILESLockFileErrorSerializer serialize:valueObj.failure] mutableCopy];
    jsonDict[@".tag"] = @"failure";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESLockFileResultEntry *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBFILESLockFileResult *success = [DBFILESLockFileResultSerializer deserialize:valueDict];
    return [[DBFILESLockFileResultEntry alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"failure"]) {
    DBFILESLockFileError *failure = [DBFILESLockFileErrorSerializer deserialize:valueDict[@"failure"]];
    return [[DBFILESLockFileResultEntry alloc] initWithFailure:failure];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESLookupError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESLookupError

@synthesize malformedPath = _malformedPath;

#pragma mark - Constructors

- (instancetype)initWithMalformedPath:(NSString *)malformedPath {
  self = [super init];
  if (self) {
    _tag = DBFILESLookupErrorMalformedPath;
    _malformedPath = malformedPath;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILESLookupErrorNotFound;
  }
  return self;
}

- (instancetype)initWithNotFile {
  self = [super init];
  if (self) {
    _tag = DBFILESLookupErrorNotFile;
  }
  return self;
}

- (instancetype)initWithNotFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESLookupErrorNotFolder;
  }
  return self;
}

- (instancetype)initWithRestrictedContent {
  self = [super init];
  if (self) {
    _tag = DBFILESLookupErrorRestrictedContent;
  }
  return self;
}

- (instancetype)initWithUnsupportedContentType {
  self = [super init];
  if (self) {
    _tag = DBFILESLookupErrorUnsupportedContentType;
  }
  return self;
}

- (instancetype)initWithLocked {
  self = [super init];
  if (self) {
    _tag = DBFILESLookupErrorLocked;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESLookupErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)malformedPath {
  if (![self isMalformedPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESLookupErrorMalformedPath, but was %@.", [self tagName]];
  }
  return _malformedPath;
}

#pragma mark - Tag state methods

- (BOOL)isMalformedPath {
  return _tag == DBFILESLookupErrorMalformedPath;
}

- (BOOL)isNotFound {
  return _tag == DBFILESLookupErrorNotFound;
}

- (BOOL)isNotFile {
  return _tag == DBFILESLookupErrorNotFile;
}

- (BOOL)isNotFolder {
  return _tag == DBFILESLookupErrorNotFolder;
}

- (BOOL)isRestrictedContent {
  return _tag == DBFILESLookupErrorRestrictedContent;
}

- (BOOL)isUnsupportedContentType {
  return _tag == DBFILESLookupErrorUnsupportedContentType;
}

- (BOOL)isLocked {
  return _tag == DBFILESLookupErrorLocked;
}

- (BOOL)isOther {
  return _tag == DBFILESLookupErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESLookupErrorMalformedPath:
    return @"DBFILESLookupErrorMalformedPath";
  case DBFILESLookupErrorNotFound:
    return @"DBFILESLookupErrorNotFound";
  case DBFILESLookupErrorNotFile:
    return @"DBFILESLookupErrorNotFile";
  case DBFILESLookupErrorNotFolder:
    return @"DBFILESLookupErrorNotFolder";
  case DBFILESLookupErrorRestrictedContent:
    return @"DBFILESLookupErrorRestrictedContent";
  case DBFILESLookupErrorUnsupportedContentType:
    return @"DBFILESLookupErrorUnsupportedContentType";
  case DBFILESLookupErrorLocked:
    return @"DBFILESLookupErrorLocked";
  case DBFILESLookupErrorOther:
    return @"DBFILESLookupErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESLookupErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESLookupErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESLookupErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESLookupErrorMalformedPath:
    if (self.malformedPath != nil) {
      result = prime * result + [self.malformedPath hash];
    }
    break;
  case DBFILESLookupErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLookupErrorNotFile:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLookupErrorNotFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLookupErrorRestrictedContent:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLookupErrorUnsupportedContentType:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLookupErrorLocked:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESLookupErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLookupError:other];
}

- (BOOL)isEqualToLookupError:(DBFILESLookupError *)aLookupError {
  if (self == aLookupError) {
    return YES;
  }
  if (self.tag != aLookupError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESLookupErrorMalformedPath:
    if (self.malformedPath) {
      return [self.malformedPath isEqual:aLookupError.malformedPath];
    }
  case DBFILESLookupErrorNotFound:
    return [[self tagName] isEqual:[aLookupError tagName]];
  case DBFILESLookupErrorNotFile:
    return [[self tagName] isEqual:[aLookupError tagName]];
  case DBFILESLookupErrorNotFolder:
    return [[self tagName] isEqual:[aLookupError tagName]];
  case DBFILESLookupErrorRestrictedContent:
    return [[self tagName] isEqual:[aLookupError tagName]];
  case DBFILESLookupErrorUnsupportedContentType:
    return [[self tagName] isEqual:[aLookupError tagName]];
  case DBFILESLookupErrorLocked:
    return [[self tagName] isEqual:[aLookupError tagName]];
  case DBFILESLookupErrorOther:
    return [[self tagName] isEqual:[aLookupError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESLookupErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESLookupError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isMalformedPath]) {
    if (valueObj.malformedPath) {
      jsonDict[@"malformed_path"] = valueObj.malformedPath;
    }
    jsonDict[@".tag"] = @"malformed_path";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isNotFile]) {
    jsonDict[@".tag"] = @"not_file";
  } else if ([valueObj isNotFolder]) {
    jsonDict[@".tag"] = @"not_folder";
  } else if ([valueObj isRestrictedContent]) {
    jsonDict[@".tag"] = @"restricted_content";
  } else if ([valueObj isUnsupportedContentType]) {
    jsonDict[@".tag"] = @"unsupported_content_type";
  } else if ([valueObj isLocked]) {
    jsonDict[@".tag"] = @"locked";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESLookupError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"malformed_path"]) {
    NSString *malformedPath = valueDict[@"malformed_path"] ? valueDict[@"malformed_path"] : nil;
    return [[DBFILESLookupError alloc] initWithMalformedPath:malformedPath];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILESLookupError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"not_file"]) {
    return [[DBFILESLookupError alloc] initWithNotFile];
  } else if ([tag isEqualToString:@"not_folder"]) {
    return [[DBFILESLookupError alloc] initWithNotFolder];
  } else if ([tag isEqualToString:@"restricted_content"]) {
    return [[DBFILESLookupError alloc] initWithRestrictedContent];
  } else if ([tag isEqualToString:@"unsupported_content_type"]) {
    return [[DBFILESLookupError alloc] initWithUnsupportedContentType];
  } else if ([tag isEqualToString:@"locked"]) {
    return [[DBFILESLookupError alloc] initWithLocked];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESLookupError alloc] initWithOther];
  } else {
    return [[DBFILESLookupError alloc] initWithOther];
  }
}

@end

#import "DBFILESMediaInfo.h"
#import "DBFILESMediaMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESMediaInfo

@synthesize metadata = _metadata;

#pragma mark - Constructors

- (instancetype)initWithPending {
  self = [super init];
  if (self) {
    _tag = DBFILESMediaInfoPending;
  }
  return self;
}

- (instancetype)initWithMetadata:(DBFILESMediaMetadata *)metadata {
  self = [super init];
  if (self) {
    _tag = DBFILESMediaInfoMetadata;
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESMediaMetadata *)metadata {
  if (![self isMetadata]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESMediaInfoMetadata, but was %@.", [self tagName]];
  }
  return _metadata;
}

#pragma mark - Tag state methods

- (BOOL)isPending {
  return _tag == DBFILESMediaInfoPending;
}

- (BOOL)isMetadata {
  return _tag == DBFILESMediaInfoMetadata;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESMediaInfoPending:
    return @"DBFILESMediaInfoPending";
  case DBFILESMediaInfoMetadata:
    return @"DBFILESMediaInfoMetadata";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESMediaInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESMediaInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESMediaInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESMediaInfoPending:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESMediaInfoMetadata:
    result = prime * result + [self.metadata hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMediaInfo:other];
}

- (BOOL)isEqualToMediaInfo:(DBFILESMediaInfo *)aMediaInfo {
  if (self == aMediaInfo) {
    return YES;
  }
  if (self.tag != aMediaInfo.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESMediaInfoPending:
    return [[self tagName] isEqual:[aMediaInfo tagName]];
  case DBFILESMediaInfoMetadata:
    return [self.metadata isEqual:aMediaInfo.metadata];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESMediaInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESMediaInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPending]) {
    jsonDict[@".tag"] = @"pending";
  } else if ([valueObj isMetadata]) {
    jsonDict[@"metadata"] = [[DBFILESMediaMetadataSerializer serialize:valueObj.metadata] mutableCopy];
    jsonDict[@".tag"] = @"metadata";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESMediaInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"pending"]) {
    return [[DBFILESMediaInfo alloc] initWithPending];
  } else if ([tag isEqualToString:@"metadata"]) {
    DBFILESMediaMetadata *metadata = [DBFILESMediaMetadataSerializer deserialize:valueDict[@"metadata"]];
    return [[DBFILESMediaInfo alloc] initWithMetadata:metadata];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESDimensions.h"
#import "DBFILESGpsCoordinates.h"
#import "DBFILESMediaMetadata.h"
#import "DBFILESPhotoMetadata.h"
#import "DBFILESVideoMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESMediaMetadata

#pragma mark - Constructors

- (instancetype)initWithDimensions:(DBFILESDimensions *)dimensions
                          location:(DBFILESGpsCoordinates *)location
                         timeTaken:(NSDate *)timeTaken {

  self = [super init];
  if (self) {
    _dimensions = dimensions;
    _location = location;
    _timeTaken = timeTaken;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithDimensions:nil location:nil timeTaken:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESMediaMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESMediaMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESMediaMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.dimensions != nil) {
    result = prime * result + [self.dimensions hash];
  }
  if (self.location != nil) {
    result = prime * result + [self.location hash];
  }
  if (self.timeTaken != nil) {
    result = prime * result + [self.timeTaken hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMediaMetadata:other];
}

- (BOOL)isEqualToMediaMetadata:(DBFILESMediaMetadata *)aMediaMetadata {
  if (self == aMediaMetadata) {
    return YES;
  }
  if (self.dimensions) {
    if (![self.dimensions isEqual:aMediaMetadata.dimensions]) {
      return NO;
    }
  }
  if (self.location) {
    if (![self.location isEqual:aMediaMetadata.location]) {
      return NO;
    }
  }
  if (self.timeTaken) {
    if (![self.timeTaken isEqual:aMediaMetadata.timeTaken]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESMediaMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESMediaMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.dimensions) {
    jsonDict[@"dimensions"] = [DBFILESDimensionsSerializer serialize:valueObj.dimensions];
  }
  if (valueObj.location) {
    jsonDict[@"location"] = [DBFILESGpsCoordinatesSerializer serialize:valueObj.location];
  }
  if (valueObj.timeTaken) {
    jsonDict[@"time_taken"] = [DBNSDateSerializer serialize:valueObj.timeTaken dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  if ([valueObj isKindOfClass:[DBFILESPhotoMetadata class]]) {
    NSDictionary *subTypeFields = [DBFILESPhotoMetadataSerializer serialize:(DBFILESPhotoMetadata *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"photo";
  } else if ([valueObj isKindOfClass:[DBFILESVideoMetadata class]]) {
    NSDictionary *subTypeFields = [DBFILESVideoMetadataSerializer serialize:(DBFILESVideoMetadata *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"video";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESMediaMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  if ([valueDict[@".tag"] isEqualToString:@"photo"]) {
    return [DBFILESPhotoMetadataSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"video"]) {
    return [DBFILESVideoMetadataSerializer deserialize:valueDict];
  }

  @throw([NSException
      exceptionWithName:@"InvalidTag"
                 reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
               userInfo:nil]);
}

@end

#import "DBFILESMetadata.h"
#import "DBFILESMetadataV2.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESMetadataV2

@synthesize metadata = _metadata;

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata {
  self = [super init];
  if (self) {
    _tag = DBFILESMetadataV2Metadata;
    _metadata = metadata;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESMetadataV2Other;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESMetadata *)metadata {
  if (![self isMetadata]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESMetadataV2Metadata, but was %@.", [self tagName]];
  }
  return _metadata;
}

#pragma mark - Tag state methods

- (BOOL)isMetadata {
  return _tag == DBFILESMetadataV2Metadata;
}

- (BOOL)isOther {
  return _tag == DBFILESMetadataV2Other;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESMetadataV2Metadata:
    return @"DBFILESMetadataV2Metadata";
  case DBFILESMetadataV2Other:
    return @"DBFILESMetadataV2Other";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESMetadataV2Serializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESMetadataV2Serializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESMetadataV2Serializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESMetadataV2Metadata:
    result = prime * result + [self.metadata hash];
    break;
  case DBFILESMetadataV2Other:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMetadataV2:other];
}

- (BOOL)isEqualToMetadataV2:(DBFILESMetadataV2 *)aMetadataV2 {
  if (self == aMetadataV2) {
    return YES;
  }
  if (self.tag != aMetadataV2.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESMetadataV2Metadata:
    return [self.metadata isEqual:aMetadataV2.metadata];
  case DBFILESMetadataV2Other:
    return [[self tagName] isEqual:[aMetadataV2 tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESMetadataV2Serializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESMetadataV2 *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isMetadata]) {
    jsonDict[@"metadata"] = [[DBFILESMetadataSerializer serialize:valueObj.metadata] mutableCopy];
    jsonDict[@".tag"] = @"metadata";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESMetadataV2 *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"metadata"]) {
    DBFILESMetadata *metadata = [DBFILESMetadataSerializer deserialize:valueDict[@"metadata"]];
    return [[DBFILESMetadataV2 alloc] initWithMetadata:metadata];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESMetadataV2 alloc] initWithOther];
  } else {
    return [[DBFILESMetadataV2 alloc] initWithOther];
  }
}

@end

#import "DBFILESMinimalFileLinkMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESMinimalFileLinkMetadata

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url rev:(NSString *)rev id_:(NSString *)id_ path:(NSString *)path {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(9) maxLength:nil pattern:@"[0-9a-f]+"]](rev);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](id_);

  self = [super init];
  if (self) {
    _url = url;
    _id_ = id_;
    _path = path;
    _rev = rev;
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url rev:(NSString *)rev {
  return [self initWithUrl:url rev:rev id_:nil path:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESMinimalFileLinkMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESMinimalFileLinkMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESMinimalFileLinkMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  result = prime * result + [self.rev hash];
  if (self.id_ != nil) {
    result = prime * result + [self.id_ hash];
  }
  if (self.path != nil) {
    result = prime * result + [self.path hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMinimalFileLinkMetadata:other];
}

- (BOOL)isEqualToMinimalFileLinkMetadata:(DBFILESMinimalFileLinkMetadata *)aMinimalFileLinkMetadata {
  if (self == aMinimalFileLinkMetadata) {
    return YES;
  }
  if (![self.url isEqual:aMinimalFileLinkMetadata.url]) {
    return NO;
  }
  if (![self.rev isEqual:aMinimalFileLinkMetadata.rev]) {
    return NO;
  }
  if (self.id_) {
    if (![self.id_ isEqual:aMinimalFileLinkMetadata.id_]) {
      return NO;
    }
  }
  if (self.path) {
    if (![self.path isEqual:aMinimalFileLinkMetadata.path]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESMinimalFileLinkMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESMinimalFileLinkMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"rev"] = valueObj.rev;
  if (valueObj.id_) {
    jsonDict[@"id"] = valueObj.id_;
  }
  if (valueObj.path) {
    jsonDict[@"path"] = valueObj.path;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESMinimalFileLinkMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  NSString *rev = valueDict[@"rev"];
  NSString *id_ = valueDict[@"id"] ?: nil;
  NSString *path = valueDict[@"path"] ?: nil;

  return [[DBFILESMinimalFileLinkMetadata alloc] initWithUrl:url rev:rev id_:id_ path:path];
}

@end

#import "DBFILESRelocationBatchArgBase.h"
#import "DBFILESRelocationPath.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchArgBase

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESRelocationPath *> *)entries autorename:(NSNumber *)autorename {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:@(1)
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
    _autorename = autorename ?: @NO;
  }
  return self;
}

- (instancetype)initWithEntries:(NSArray<DBFILESRelocationPath *> *)entries {
  return [self initWithEntries:entries autorename:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchArgBaseSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchArgBaseSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchArgBaseSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];
  result = prime * result + [self.autorename hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchArgBase:other];
}

- (BOOL)isEqualToRelocationBatchArgBase:(DBFILESRelocationBatchArgBase *)aRelocationBatchArgBase {
  if (self == aRelocationBatchArgBase) {
    return YES;
  }
  if (![self.entries isEqual:aRelocationBatchArgBase.entries]) {
    return NO;
  }
  if (![self.autorename isEqual:aRelocationBatchArgBase.autorename]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchArgBaseSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchArgBase *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESRelocationPathSerializer serialize:elem0];
                                            }];
  jsonDict[@"autorename"] = valueObj.autorename;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchArgBase *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESRelocationPath *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESRelocationPathSerializer deserialize:elem0];
                           }];
  NSNumber *autorename = valueDict[@"autorename"] ?: @NO;

  return [[DBFILESRelocationBatchArgBase alloc] initWithEntries:entries autorename:autorename];
}

@end

#import "DBFILESMoveBatchArg.h"
#import "DBFILESRelocationBatchArgBase.h"
#import "DBFILESRelocationPath.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESMoveBatchArg

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESRelocationPath *> *)entries
                     autorename:(NSNumber *)autorename
         allowOwnershipTransfer:(NSNumber *)allowOwnershipTransfer {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:@(1)
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super initWithEntries:entries autorename:autorename];
  if (self) {
    _allowOwnershipTransfer = allowOwnershipTransfer ?: @NO;
  }
  return self;
}

- (instancetype)initWithEntries:(NSArray<DBFILESRelocationPath *> *)entries {
  return [self initWithEntries:entries autorename:nil allowOwnershipTransfer:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESMoveBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESMoveBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESMoveBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];
  result = prime * result + [self.autorename hash];
  result = prime * result + [self.allowOwnershipTransfer hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMoveBatchArg:other];
}

- (BOOL)isEqualToMoveBatchArg:(DBFILESMoveBatchArg *)aMoveBatchArg {
  if (self == aMoveBatchArg) {
    return YES;
  }
  if (![self.entries isEqual:aMoveBatchArg.entries]) {
    return NO;
  }
  if (![self.autorename isEqual:aMoveBatchArg.autorename]) {
    return NO;
  }
  if (![self.allowOwnershipTransfer isEqual:aMoveBatchArg.allowOwnershipTransfer]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESMoveBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESMoveBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESRelocationPathSerializer serialize:elem0];
                                            }];
  jsonDict[@"autorename"] = valueObj.autorename;
  jsonDict[@"allow_ownership_transfer"] = valueObj.allowOwnershipTransfer;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESMoveBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESRelocationPath *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESRelocationPathSerializer deserialize:elem0];
                           }];
  NSNumber *autorename = valueDict[@"autorename"] ?: @NO;
  NSNumber *allowOwnershipTransfer = valueDict[@"allow_ownership_transfer"] ?: @NO;

  return [[DBFILESMoveBatchArg alloc] initWithEntries:entries
                                           autorename:autorename
                               allowOwnershipTransfer:allowOwnershipTransfer];
}

@end

#import "DBFILESMoveIntoVaultError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESMoveIntoVaultError

#pragma mark - Constructors

- (instancetype)initWithIsSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESMoveIntoVaultErrorIsSharedFolder;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESMoveIntoVaultErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isIsSharedFolder {
  return _tag == DBFILESMoveIntoVaultErrorIsSharedFolder;
}

- (BOOL)isOther {
  return _tag == DBFILESMoveIntoVaultErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESMoveIntoVaultErrorIsSharedFolder:
    return @"DBFILESMoveIntoVaultErrorIsSharedFolder";
  case DBFILESMoveIntoVaultErrorOther:
    return @"DBFILESMoveIntoVaultErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESMoveIntoVaultErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESMoveIntoVaultErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESMoveIntoVaultErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESMoveIntoVaultErrorIsSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESMoveIntoVaultErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMoveIntoVaultError:other];
}

- (BOOL)isEqualToMoveIntoVaultError:(DBFILESMoveIntoVaultError *)aMoveIntoVaultError {
  if (self == aMoveIntoVaultError) {
    return YES;
  }
  if (self.tag != aMoveIntoVaultError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESMoveIntoVaultErrorIsSharedFolder:
    return [[self tagName] isEqual:[aMoveIntoVaultError tagName]];
  case DBFILESMoveIntoVaultErrorOther:
    return [[self tagName] isEqual:[aMoveIntoVaultError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESMoveIntoVaultErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESMoveIntoVaultError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isIsSharedFolder]) {
    jsonDict[@".tag"] = @"is_shared_folder";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESMoveIntoVaultError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"is_shared_folder"]) {
    return [[DBFILESMoveIntoVaultError alloc] initWithIsSharedFolder];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESMoveIntoVaultError alloc] initWithOther];
  } else {
    return [[DBFILESMoveIntoVaultError alloc] initWithOther];
  }
}

@end

#import "DBFILESPaperContentError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPaperContentError

#pragma mark - Constructors

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperContentErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithContentMalformed {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperContentErrorContentMalformed;
  }
  return self;
}

- (instancetype)initWithDocLengthExceeded {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperContentErrorDocLengthExceeded;
  }
  return self;
}

- (instancetype)initWithImageSizeExceeded {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperContentErrorImageSizeExceeded;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperContentErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInsufficientPermissions {
  return _tag == DBFILESPaperContentErrorInsufficientPermissions;
}

- (BOOL)isContentMalformed {
  return _tag == DBFILESPaperContentErrorContentMalformed;
}

- (BOOL)isDocLengthExceeded {
  return _tag == DBFILESPaperContentErrorDocLengthExceeded;
}

- (BOOL)isImageSizeExceeded {
  return _tag == DBFILESPaperContentErrorImageSizeExceeded;
}

- (BOOL)isOther {
  return _tag == DBFILESPaperContentErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESPaperContentErrorInsufficientPermissions:
    return @"DBFILESPaperContentErrorInsufficientPermissions";
  case DBFILESPaperContentErrorContentMalformed:
    return @"DBFILESPaperContentErrorContentMalformed";
  case DBFILESPaperContentErrorDocLengthExceeded:
    return @"DBFILESPaperContentErrorDocLengthExceeded";
  case DBFILESPaperContentErrorImageSizeExceeded:
    return @"DBFILESPaperContentErrorImageSizeExceeded";
  case DBFILESPaperContentErrorOther:
    return @"DBFILESPaperContentErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPaperContentErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPaperContentErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPaperContentErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESPaperContentErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperContentErrorContentMalformed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperContentErrorDocLengthExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperContentErrorImageSizeExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperContentErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperContentError:other];
}

- (BOOL)isEqualToPaperContentError:(DBFILESPaperContentError *)aPaperContentError {
  if (self == aPaperContentError) {
    return YES;
  }
  if (self.tag != aPaperContentError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESPaperContentErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aPaperContentError tagName]];
  case DBFILESPaperContentErrorContentMalformed:
    return [[self tagName] isEqual:[aPaperContentError tagName]];
  case DBFILESPaperContentErrorDocLengthExceeded:
    return [[self tagName] isEqual:[aPaperContentError tagName]];
  case DBFILESPaperContentErrorImageSizeExceeded:
    return [[self tagName] isEqual:[aPaperContentError tagName]];
  case DBFILESPaperContentErrorOther:
    return [[self tagName] isEqual:[aPaperContentError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPaperContentErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPaperContentError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isContentMalformed]) {
    jsonDict[@".tag"] = @"content_malformed";
  } else if ([valueObj isDocLengthExceeded]) {
    jsonDict[@".tag"] = @"doc_length_exceeded";
  } else if ([valueObj isImageSizeExceeded]) {
    jsonDict[@".tag"] = @"image_size_exceeded";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPaperContentError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBFILESPaperContentError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"content_malformed"]) {
    return [[DBFILESPaperContentError alloc] initWithContentMalformed];
  } else if ([tag isEqualToString:@"doc_length_exceeded"]) {
    return [[DBFILESPaperContentError alloc] initWithDocLengthExceeded];
  } else if ([tag isEqualToString:@"image_size_exceeded"]) {
    return [[DBFILESPaperContentError alloc] initWithImageSizeExceeded];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESPaperContentError alloc] initWithOther];
  } else {
    return [[DBFILESPaperContentError alloc] initWithOther];
  }
}

@end

#import "DBFILESImportFormat.h"
#import "DBFILESPaperCreateArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPaperCreateArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path importFormat:(DBFILESImportFormat *)importFormat {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"/(.|[\\r\\n])*"]](path);
  [DBStoneValidators nonnullValidator:nil](importFormat);

  self = [super init];
  if (self) {
    _path = path;
    _importFormat = importFormat;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPaperCreateArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPaperCreateArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPaperCreateArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.importFormat hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperCreateArg:other];
}

- (BOOL)isEqualToPaperCreateArg:(DBFILESPaperCreateArg *)aPaperCreateArg {
  if (self == aPaperCreateArg) {
    return YES;
  }
  if (![self.path isEqual:aPaperCreateArg.path]) {
    return NO;
  }
  if (![self.importFormat isEqual:aPaperCreateArg.importFormat]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPaperCreateArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPaperCreateArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"import_format"] = [DBFILESImportFormatSerializer serialize:valueObj.importFormat];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPaperCreateArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  DBFILESImportFormat *importFormat = [DBFILESImportFormatSerializer deserialize:valueDict[@"import_format"]];

  return [[DBFILESPaperCreateArg alloc] initWithPath:path importFormat:importFormat];
}

@end

#import "DBFILESPaperContentError.h"
#import "DBFILESPaperCreateError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPaperCreateError

#pragma mark - Constructors

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperCreateErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithContentMalformed {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperCreateErrorContentMalformed;
  }
  return self;
}

- (instancetype)initWithDocLengthExceeded {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperCreateErrorDocLengthExceeded;
  }
  return self;
}

- (instancetype)initWithImageSizeExceeded {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperCreateErrorImageSizeExceeded;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperCreateErrorOther;
  }
  return self;
}

- (instancetype)initWithInvalidPath {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperCreateErrorInvalidPath;
  }
  return self;
}

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperCreateErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithInvalidFileExtension {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperCreateErrorInvalidFileExtension;
  }
  return self;
}

- (instancetype)initWithPaperDisabled {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperCreateErrorPaperDisabled;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInsufficientPermissions {
  return _tag == DBFILESPaperCreateErrorInsufficientPermissions;
}

- (BOOL)isContentMalformed {
  return _tag == DBFILESPaperCreateErrorContentMalformed;
}

- (BOOL)isDocLengthExceeded {
  return _tag == DBFILESPaperCreateErrorDocLengthExceeded;
}

- (BOOL)isImageSizeExceeded {
  return _tag == DBFILESPaperCreateErrorImageSizeExceeded;
}

- (BOOL)isOther {
  return _tag == DBFILESPaperCreateErrorOther;
}

- (BOOL)isInvalidPath {
  return _tag == DBFILESPaperCreateErrorInvalidPath;
}

- (BOOL)isEmailUnverified {
  return _tag == DBFILESPaperCreateErrorEmailUnverified;
}

- (BOOL)isInvalidFileExtension {
  return _tag == DBFILESPaperCreateErrorInvalidFileExtension;
}

- (BOOL)isPaperDisabled {
  return _tag == DBFILESPaperCreateErrorPaperDisabled;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESPaperCreateErrorInsufficientPermissions:
    return @"DBFILESPaperCreateErrorInsufficientPermissions";
  case DBFILESPaperCreateErrorContentMalformed:
    return @"DBFILESPaperCreateErrorContentMalformed";
  case DBFILESPaperCreateErrorDocLengthExceeded:
    return @"DBFILESPaperCreateErrorDocLengthExceeded";
  case DBFILESPaperCreateErrorImageSizeExceeded:
    return @"DBFILESPaperCreateErrorImageSizeExceeded";
  case DBFILESPaperCreateErrorOther:
    return @"DBFILESPaperCreateErrorOther";
  case DBFILESPaperCreateErrorInvalidPath:
    return @"DBFILESPaperCreateErrorInvalidPath";
  case DBFILESPaperCreateErrorEmailUnverified:
    return @"DBFILESPaperCreateErrorEmailUnverified";
  case DBFILESPaperCreateErrorInvalidFileExtension:
    return @"DBFILESPaperCreateErrorInvalidFileExtension";
  case DBFILESPaperCreateErrorPaperDisabled:
    return @"DBFILESPaperCreateErrorPaperDisabled";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPaperCreateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPaperCreateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPaperCreateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESPaperCreateErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperCreateErrorContentMalformed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperCreateErrorDocLengthExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperCreateErrorImageSizeExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperCreateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperCreateErrorInvalidPath:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperCreateErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperCreateErrorInvalidFileExtension:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperCreateErrorPaperDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperCreateError:other];
}

- (BOOL)isEqualToPaperCreateError:(DBFILESPaperCreateError *)aPaperCreateError {
  if (self == aPaperCreateError) {
    return YES;
  }
  if (self.tag != aPaperCreateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESPaperCreateErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aPaperCreateError tagName]];
  case DBFILESPaperCreateErrorContentMalformed:
    return [[self tagName] isEqual:[aPaperCreateError tagName]];
  case DBFILESPaperCreateErrorDocLengthExceeded:
    return [[self tagName] isEqual:[aPaperCreateError tagName]];
  case DBFILESPaperCreateErrorImageSizeExceeded:
    return [[self tagName] isEqual:[aPaperCreateError tagName]];
  case DBFILESPaperCreateErrorOther:
    return [[self tagName] isEqual:[aPaperCreateError tagName]];
  case DBFILESPaperCreateErrorInvalidPath:
    return [[self tagName] isEqual:[aPaperCreateError tagName]];
  case DBFILESPaperCreateErrorEmailUnverified:
    return [[self tagName] isEqual:[aPaperCreateError tagName]];
  case DBFILESPaperCreateErrorInvalidFileExtension:
    return [[self tagName] isEqual:[aPaperCreateError tagName]];
  case DBFILESPaperCreateErrorPaperDisabled:
    return [[self tagName] isEqual:[aPaperCreateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPaperCreateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPaperCreateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isContentMalformed]) {
    jsonDict[@".tag"] = @"content_malformed";
  } else if ([valueObj isDocLengthExceeded]) {
    jsonDict[@".tag"] = @"doc_length_exceeded";
  } else if ([valueObj isImageSizeExceeded]) {
    jsonDict[@".tag"] = @"image_size_exceeded";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isInvalidPath]) {
    jsonDict[@".tag"] = @"invalid_path";
  } else if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isInvalidFileExtension]) {
    jsonDict[@".tag"] = @"invalid_file_extension";
  } else if ([valueObj isPaperDisabled]) {
    jsonDict[@".tag"] = @"paper_disabled";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPaperCreateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBFILESPaperCreateError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"content_malformed"]) {
    return [[DBFILESPaperCreateError alloc] initWithContentMalformed];
  } else if ([tag isEqualToString:@"doc_length_exceeded"]) {
    return [[DBFILESPaperCreateError alloc] initWithDocLengthExceeded];
  } else if ([tag isEqualToString:@"image_size_exceeded"]) {
    return [[DBFILESPaperCreateError alloc] initWithImageSizeExceeded];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESPaperCreateError alloc] initWithOther];
  } else if ([tag isEqualToString:@"invalid_path"]) {
    return [[DBFILESPaperCreateError alloc] initWithInvalidPath];
  } else if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBFILESPaperCreateError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"invalid_file_extension"]) {
    return [[DBFILESPaperCreateError alloc] initWithInvalidFileExtension];
  } else if ([tag isEqualToString:@"paper_disabled"]) {
    return [[DBFILESPaperCreateError alloc] initWithPaperDisabled];
  } else {
    return [[DBFILESPaperCreateError alloc] initWithOther];
  }
}

@end

#import "DBFILESPaperCreateResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPaperCreateResult

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url
                 resultPath:(NSString *)resultPath
                     fileId:(NSString *)fileId
              paperRevision:(NSNumber *)paperRevision {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators nonnullValidator:nil](resultPath);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(4) maxLength:nil pattern:@"id:.+"]](fileId);
  [DBStoneValidators nonnullValidator:nil](paperRevision);

  self = [super init];
  if (self) {
    _url = url;
    _resultPath = resultPath;
    _fileId = fileId;
    _paperRevision = paperRevision;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPaperCreateResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPaperCreateResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPaperCreateResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  result = prime * result + [self.resultPath hash];
  result = prime * result + [self.fileId hash];
  result = prime * result + [self.paperRevision hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperCreateResult:other];
}

- (BOOL)isEqualToPaperCreateResult:(DBFILESPaperCreateResult *)aPaperCreateResult {
  if (self == aPaperCreateResult) {
    return YES;
  }
  if (![self.url isEqual:aPaperCreateResult.url]) {
    return NO;
  }
  if (![self.resultPath isEqual:aPaperCreateResult.resultPath]) {
    return NO;
  }
  if (![self.fileId isEqual:aPaperCreateResult.fileId]) {
    return NO;
  }
  if (![self.paperRevision isEqual:aPaperCreateResult.paperRevision]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPaperCreateResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPaperCreateResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"result_path"] = valueObj.resultPath;
  jsonDict[@"file_id"] = valueObj.fileId;
  jsonDict[@"paper_revision"] = valueObj.paperRevision;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPaperCreateResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  NSString *resultPath = valueDict[@"result_path"];
  NSString *fileId = valueDict[@"file_id"];
  NSNumber *paperRevision = valueDict[@"paper_revision"];

  return [[DBFILESPaperCreateResult alloc] initWithUrl:url
                                            resultPath:resultPath
                                                fileId:fileId
                                         paperRevision:paperRevision];
}

@end

#import "DBFILESPaperDocUpdatePolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPaperDocUpdatePolicy

#pragma mark - Constructors

- (instancetype)initWithUpdate {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperDocUpdatePolicyUpdate;
  }
  return self;
}

- (instancetype)initWithOverwrite {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperDocUpdatePolicyOverwrite;
  }
  return self;
}

- (instancetype)initWithPrepend {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperDocUpdatePolicyPrepend;
  }
  return self;
}

- (instancetype)initWithAppend {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperDocUpdatePolicyAppend;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperDocUpdatePolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUpdate {
  return _tag == DBFILESPaperDocUpdatePolicyUpdate;
}

- (BOOL)isOverwrite {
  return _tag == DBFILESPaperDocUpdatePolicyOverwrite;
}

- (BOOL)isPrepend {
  return _tag == DBFILESPaperDocUpdatePolicyPrepend;
}

- (BOOL)isAppend {
  return _tag == DBFILESPaperDocUpdatePolicyAppend;
}

- (BOOL)isOther {
  return _tag == DBFILESPaperDocUpdatePolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESPaperDocUpdatePolicyUpdate:
    return @"DBFILESPaperDocUpdatePolicyUpdate";
  case DBFILESPaperDocUpdatePolicyOverwrite:
    return @"DBFILESPaperDocUpdatePolicyOverwrite";
  case DBFILESPaperDocUpdatePolicyPrepend:
    return @"DBFILESPaperDocUpdatePolicyPrepend";
  case DBFILESPaperDocUpdatePolicyAppend:
    return @"DBFILESPaperDocUpdatePolicyAppend";
  case DBFILESPaperDocUpdatePolicyOther:
    return @"DBFILESPaperDocUpdatePolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPaperDocUpdatePolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPaperDocUpdatePolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPaperDocUpdatePolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESPaperDocUpdatePolicyUpdate:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperDocUpdatePolicyOverwrite:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperDocUpdatePolicyPrepend:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperDocUpdatePolicyAppend:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperDocUpdatePolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocUpdatePolicy:other];
}

- (BOOL)isEqualToPaperDocUpdatePolicy:(DBFILESPaperDocUpdatePolicy *)aPaperDocUpdatePolicy {
  if (self == aPaperDocUpdatePolicy) {
    return YES;
  }
  if (self.tag != aPaperDocUpdatePolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESPaperDocUpdatePolicyUpdate:
    return [[self tagName] isEqual:[aPaperDocUpdatePolicy tagName]];
  case DBFILESPaperDocUpdatePolicyOverwrite:
    return [[self tagName] isEqual:[aPaperDocUpdatePolicy tagName]];
  case DBFILESPaperDocUpdatePolicyPrepend:
    return [[self tagName] isEqual:[aPaperDocUpdatePolicy tagName]];
  case DBFILESPaperDocUpdatePolicyAppend:
    return [[self tagName] isEqual:[aPaperDocUpdatePolicy tagName]];
  case DBFILESPaperDocUpdatePolicyOther:
    return [[self tagName] isEqual:[aPaperDocUpdatePolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPaperDocUpdatePolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPaperDocUpdatePolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUpdate]) {
    jsonDict[@".tag"] = @"update";
  } else if ([valueObj isOverwrite]) {
    jsonDict[@".tag"] = @"overwrite";
  } else if ([valueObj isPrepend]) {
    jsonDict[@".tag"] = @"prepend";
  } else if ([valueObj isAppend]) {
    jsonDict[@".tag"] = @"append";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPaperDocUpdatePolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"update"]) {
    return [[DBFILESPaperDocUpdatePolicy alloc] initWithUpdate];
  } else if ([tag isEqualToString:@"overwrite"]) {
    return [[DBFILESPaperDocUpdatePolicy alloc] initWithOverwrite];
  } else if ([tag isEqualToString:@"prepend"]) {
    return [[DBFILESPaperDocUpdatePolicy alloc] initWithPrepend];
  } else if ([tag isEqualToString:@"append"]) {
    return [[DBFILESPaperDocUpdatePolicy alloc] initWithAppend];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESPaperDocUpdatePolicy alloc] initWithOther];
  } else {
    return [[DBFILESPaperDocUpdatePolicy alloc] initWithOther];
  }
}

@end

#import "DBFILESImportFormat.h"
#import "DBFILESPaperDocUpdatePolicy.h"
#import "DBFILESPaperUpdateArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPaperUpdateArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                importFormat:(DBFILESImportFormat *)importFormat
             docUpdatePolicy:(DBFILESPaperDocUpdatePolicy *)docUpdatePolicy
               paperRevision:(NSNumber *)paperRevision {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](path);
  [DBStoneValidators nonnullValidator:nil](importFormat);
  [DBStoneValidators nonnullValidator:nil](docUpdatePolicy);

  self = [super init];
  if (self) {
    _path = path;
    _importFormat = importFormat;
    _docUpdatePolicy = docUpdatePolicy;
    _paperRevision = paperRevision;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path
                importFormat:(DBFILESImportFormat *)importFormat
             docUpdatePolicy:(DBFILESPaperDocUpdatePolicy *)docUpdatePolicy {
  return [self initWithPath:path importFormat:importFormat docUpdatePolicy:docUpdatePolicy paperRevision:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPaperUpdateArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPaperUpdateArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPaperUpdateArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.importFormat hash];
  result = prime * result + [self.docUpdatePolicy hash];
  if (self.paperRevision != nil) {
    result = prime * result + [self.paperRevision hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperUpdateArg:other];
}

- (BOOL)isEqualToPaperUpdateArg:(DBFILESPaperUpdateArg *)aPaperUpdateArg {
  if (self == aPaperUpdateArg) {
    return YES;
  }
  if (![self.path isEqual:aPaperUpdateArg.path]) {
    return NO;
  }
  if (![self.importFormat isEqual:aPaperUpdateArg.importFormat]) {
    return NO;
  }
  if (![self.docUpdatePolicy isEqual:aPaperUpdateArg.docUpdatePolicy]) {
    return NO;
  }
  if (self.paperRevision) {
    if (![self.paperRevision isEqual:aPaperUpdateArg.paperRevision]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPaperUpdateArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPaperUpdateArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"import_format"] = [DBFILESImportFormatSerializer serialize:valueObj.importFormat];
  jsonDict[@"doc_update_policy"] = [DBFILESPaperDocUpdatePolicySerializer serialize:valueObj.docUpdatePolicy];
  if (valueObj.paperRevision) {
    jsonDict[@"paper_revision"] = valueObj.paperRevision;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPaperUpdateArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  DBFILESImportFormat *importFormat = [DBFILESImportFormatSerializer deserialize:valueDict[@"import_format"]];
  DBFILESPaperDocUpdatePolicy *docUpdatePolicy =
      [DBFILESPaperDocUpdatePolicySerializer deserialize:valueDict[@"doc_update_policy"]];
  NSNumber *paperRevision = valueDict[@"paper_revision"] ?: nil;

  return [[DBFILESPaperUpdateArg alloc] initWithPath:path
                                        importFormat:importFormat
                                     docUpdatePolicy:docUpdatePolicy
                                       paperRevision:paperRevision];
}

@end

#import "DBFILESLookupError.h"
#import "DBFILESPaperContentError.h"
#import "DBFILESPaperUpdateError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPaperUpdateError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperUpdateErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithContentMalformed {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperUpdateErrorContentMalformed;
  }
  return self;
}

- (instancetype)initWithDocLengthExceeded {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperUpdateErrorDocLengthExceeded;
  }
  return self;
}

- (instancetype)initWithImageSizeExceeded {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperUpdateErrorImageSizeExceeded;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperUpdateErrorOther;
  }
  return self;
}

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperUpdateErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithRevisionMismatch {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperUpdateErrorRevisionMismatch;
  }
  return self;
}

- (instancetype)initWithDocArchived {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperUpdateErrorDocArchived;
  }
  return self;
}

- (instancetype)initWithDocDeleted {
  self = [super init];
  if (self) {
    _tag = DBFILESPaperUpdateErrorDocDeleted;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESPaperUpdateErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isInsufficientPermissions {
  return _tag == DBFILESPaperUpdateErrorInsufficientPermissions;
}

- (BOOL)isContentMalformed {
  return _tag == DBFILESPaperUpdateErrorContentMalformed;
}

- (BOOL)isDocLengthExceeded {
  return _tag == DBFILESPaperUpdateErrorDocLengthExceeded;
}

- (BOOL)isImageSizeExceeded {
  return _tag == DBFILESPaperUpdateErrorImageSizeExceeded;
}

- (BOOL)isOther {
  return _tag == DBFILESPaperUpdateErrorOther;
}

- (BOOL)isPath {
  return _tag == DBFILESPaperUpdateErrorPath;
}

- (BOOL)isRevisionMismatch {
  return _tag == DBFILESPaperUpdateErrorRevisionMismatch;
}

- (BOOL)isDocArchived {
  return _tag == DBFILESPaperUpdateErrorDocArchived;
}

- (BOOL)isDocDeleted {
  return _tag == DBFILESPaperUpdateErrorDocDeleted;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESPaperUpdateErrorInsufficientPermissions:
    return @"DBFILESPaperUpdateErrorInsufficientPermissions";
  case DBFILESPaperUpdateErrorContentMalformed:
    return @"DBFILESPaperUpdateErrorContentMalformed";
  case DBFILESPaperUpdateErrorDocLengthExceeded:
    return @"DBFILESPaperUpdateErrorDocLengthExceeded";
  case DBFILESPaperUpdateErrorImageSizeExceeded:
    return @"DBFILESPaperUpdateErrorImageSizeExceeded";
  case DBFILESPaperUpdateErrorOther:
    return @"DBFILESPaperUpdateErrorOther";
  case DBFILESPaperUpdateErrorPath:
    return @"DBFILESPaperUpdateErrorPath";
  case DBFILESPaperUpdateErrorRevisionMismatch:
    return @"DBFILESPaperUpdateErrorRevisionMismatch";
  case DBFILESPaperUpdateErrorDocArchived:
    return @"DBFILESPaperUpdateErrorDocArchived";
  case DBFILESPaperUpdateErrorDocDeleted:
    return @"DBFILESPaperUpdateErrorDocDeleted";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPaperUpdateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPaperUpdateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPaperUpdateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESPaperUpdateErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperUpdateErrorContentMalformed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperUpdateErrorDocLengthExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperUpdateErrorImageSizeExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperUpdateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperUpdateErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESPaperUpdateErrorRevisionMismatch:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperUpdateErrorDocArchived:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPaperUpdateErrorDocDeleted:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperUpdateError:other];
}

- (BOOL)isEqualToPaperUpdateError:(DBFILESPaperUpdateError *)aPaperUpdateError {
  if (self == aPaperUpdateError) {
    return YES;
  }
  if (self.tag != aPaperUpdateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESPaperUpdateErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aPaperUpdateError tagName]];
  case DBFILESPaperUpdateErrorContentMalformed:
    return [[self tagName] isEqual:[aPaperUpdateError tagName]];
  case DBFILESPaperUpdateErrorDocLengthExceeded:
    return [[self tagName] isEqual:[aPaperUpdateError tagName]];
  case DBFILESPaperUpdateErrorImageSizeExceeded:
    return [[self tagName] isEqual:[aPaperUpdateError tagName]];
  case DBFILESPaperUpdateErrorOther:
    return [[self tagName] isEqual:[aPaperUpdateError tagName]];
  case DBFILESPaperUpdateErrorPath:
    return [self.path isEqual:aPaperUpdateError.path];
  case DBFILESPaperUpdateErrorRevisionMismatch:
    return [[self tagName] isEqual:[aPaperUpdateError tagName]];
  case DBFILESPaperUpdateErrorDocArchived:
    return [[self tagName] isEqual:[aPaperUpdateError tagName]];
  case DBFILESPaperUpdateErrorDocDeleted:
    return [[self tagName] isEqual:[aPaperUpdateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPaperUpdateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPaperUpdateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isContentMalformed]) {
    jsonDict[@".tag"] = @"content_malformed";
  } else if ([valueObj isDocLengthExceeded]) {
    jsonDict[@".tag"] = @"doc_length_exceeded";
  } else if ([valueObj isImageSizeExceeded]) {
    jsonDict[@".tag"] = @"image_size_exceeded";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isRevisionMismatch]) {
    jsonDict[@".tag"] = @"revision_mismatch";
  } else if ([valueObj isDocArchived]) {
    jsonDict[@".tag"] = @"doc_archived";
  } else if ([valueObj isDocDeleted]) {
    jsonDict[@".tag"] = @"doc_deleted";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPaperUpdateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBFILESPaperUpdateError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"content_malformed"]) {
    return [[DBFILESPaperUpdateError alloc] initWithContentMalformed];
  } else if ([tag isEqualToString:@"doc_length_exceeded"]) {
    return [[DBFILESPaperUpdateError alloc] initWithDocLengthExceeded];
  } else if ([tag isEqualToString:@"image_size_exceeded"]) {
    return [[DBFILESPaperUpdateError alloc] initWithImageSizeExceeded];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESPaperUpdateError alloc] initWithOther];
  } else if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESPaperUpdateError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"revision_mismatch"]) {
    return [[DBFILESPaperUpdateError alloc] initWithRevisionMismatch];
  } else if ([tag isEqualToString:@"doc_archived"]) {
    return [[DBFILESPaperUpdateError alloc] initWithDocArchived];
  } else if ([tag isEqualToString:@"doc_deleted"]) {
    return [[DBFILESPaperUpdateError alloc] initWithDocDeleted];
  } else {
    return [[DBFILESPaperUpdateError alloc] initWithOther];
  }
}

@end

#import "DBFILESPaperUpdateResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPaperUpdateResult

#pragma mark - Constructors

- (instancetype)initWithPaperRevision:(NSNumber *)paperRevision {
  [DBStoneValidators nonnullValidator:nil](paperRevision);

  self = [super init];
  if (self) {
    _paperRevision = paperRevision;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPaperUpdateResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPaperUpdateResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPaperUpdateResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.paperRevision hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperUpdateResult:other];
}

- (BOOL)isEqualToPaperUpdateResult:(DBFILESPaperUpdateResult *)aPaperUpdateResult {
  if (self == aPaperUpdateResult) {
    return YES;
  }
  if (![self.paperRevision isEqual:aPaperUpdateResult.paperRevision]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPaperUpdateResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPaperUpdateResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"paper_revision"] = valueObj.paperRevision;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPaperUpdateResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *paperRevision = valueDict[@"paper_revision"];

  return [[DBFILESPaperUpdateResult alloc] initWithPaperRevision:paperRevision];
}

@end

#import "DBFILESPathOrLink.h"
#import "DBFILESSharedLinkFileInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPathOrLink

@synthesize path = _path;
@synthesize link = _link;

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESPathOrLinkPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithLink:(DBFILESSharedLinkFileInfo *)link {
  self = [super init];
  if (self) {
    _tag = DBFILESPathOrLinkLink;
    _link = link;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESPathOrLinkOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESPathOrLinkPath, but was %@.", [self tagName]];
  }
  return _path;
}

- (DBFILESSharedLinkFileInfo *)link {
  if (![self isLink]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESPathOrLinkLink, but was %@.", [self tagName]];
  }
  return _link;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESPathOrLinkPath;
}

- (BOOL)isLink {
  return _tag == DBFILESPathOrLinkLink;
}

- (BOOL)isOther {
  return _tag == DBFILESPathOrLinkOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESPathOrLinkPath:
    return @"DBFILESPathOrLinkPath";
  case DBFILESPathOrLinkLink:
    return @"DBFILESPathOrLinkLink";
  case DBFILESPathOrLinkOther:
    return @"DBFILESPathOrLinkOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPathOrLinkSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPathOrLinkSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPathOrLinkSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESPathOrLinkPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESPathOrLinkLink:
    result = prime * result + [self.link hash];
    break;
  case DBFILESPathOrLinkOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPathOrLink:other];
}

- (BOOL)isEqualToPathOrLink:(DBFILESPathOrLink *)aPathOrLink {
  if (self == aPathOrLink) {
    return YES;
  }
  if (self.tag != aPathOrLink.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESPathOrLinkPath:
    return [self.path isEqual:aPathOrLink.path];
  case DBFILESPathOrLinkLink:
    return [self.link isEqual:aPathOrLink.link];
  case DBFILESPathOrLinkOther:
    return [[self tagName] isEqual:[aPathOrLink tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPathOrLinkSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPathOrLink *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = valueObj.path;
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isLink]) {
    jsonDict = [[DBFILESSharedLinkFileInfoSerializer serialize:valueObj.link] mutableCopy];
    jsonDict[@".tag"] = @"link";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPathOrLink *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    NSString *path = valueDict[@"path"];
    return [[DBFILESPathOrLink alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"link"]) {
    DBFILESSharedLinkFileInfo *link = [DBFILESSharedLinkFileInfoSerializer deserialize:valueDict];
    return [[DBFILESPathOrLink alloc] initWithLink:link];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESPathOrLink alloc] initWithOther];
  } else {
    return [[DBFILESPathOrLink alloc] initWithOther];
  }
}

@end

#import "DBFILESDimensions.h"
#import "DBFILESGpsCoordinates.h"
#import "DBFILESMediaMetadata.h"
#import "DBFILESPhotoMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPhotoMetadata

#pragma mark - Constructors

- (instancetype)initWithDimensions:(DBFILESDimensions *)dimensions
                          location:(DBFILESGpsCoordinates *)location
                         timeTaken:(NSDate *)timeTaken {

  self = [super initWithDimensions:dimensions location:location timeTaken:timeTaken];
  if (self) {
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithDimensions:nil location:nil timeTaken:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPhotoMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPhotoMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPhotoMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.dimensions != nil) {
    result = prime * result + [self.dimensions hash];
  }
  if (self.location != nil) {
    result = prime * result + [self.location hash];
  }
  if (self.timeTaken != nil) {
    result = prime * result + [self.timeTaken hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPhotoMetadata:other];
}

- (BOOL)isEqualToPhotoMetadata:(DBFILESPhotoMetadata *)aPhotoMetadata {
  if (self == aPhotoMetadata) {
    return YES;
  }
  if (self.dimensions) {
    if (![self.dimensions isEqual:aPhotoMetadata.dimensions]) {
      return NO;
    }
  }
  if (self.location) {
    if (![self.location isEqual:aPhotoMetadata.location]) {
      return NO;
    }
  }
  if (self.timeTaken) {
    if (![self.timeTaken isEqual:aPhotoMetadata.timeTaken]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPhotoMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPhotoMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.dimensions) {
    jsonDict[@"dimensions"] = [DBFILESDimensionsSerializer serialize:valueObj.dimensions];
  }
  if (valueObj.location) {
    jsonDict[@"location"] = [DBFILESGpsCoordinatesSerializer serialize:valueObj.location];
  }
  if (valueObj.timeTaken) {
    jsonDict[@"time_taken"] = [DBNSDateSerializer serialize:valueObj.timeTaken dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPhotoMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESDimensions *dimensions =
      valueDict[@"dimensions"] ? [DBFILESDimensionsSerializer deserialize:valueDict[@"dimensions"]] : nil;
  DBFILESGpsCoordinates *location =
      valueDict[@"location"] ? [DBFILESGpsCoordinatesSerializer deserialize:valueDict[@"location"]] : nil;
  NSDate *timeTaken = valueDict[@"time_taken"]
                          ? [DBNSDateSerializer deserialize:valueDict[@"time_taken"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                          : nil;

  return [[DBFILESPhotoMetadata alloc] initWithDimensions:dimensions location:location timeTaken:timeTaken];
}

@end

#import "DBFILESPreviewArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPreviewArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path rev:(NSString *)rev {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:@(9) maxLength:nil pattern:@"[0-9a-f]+"]](rev);

  self = [super init];
  if (self) {
    _path = path;
    _rev = rev;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path rev:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPreviewArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPreviewArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPreviewArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  if (self.rev != nil) {
    result = prime * result + [self.rev hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPreviewArg:other];
}

- (BOOL)isEqualToPreviewArg:(DBFILESPreviewArg *)aPreviewArg {
  if (self == aPreviewArg) {
    return YES;
  }
  if (![self.path isEqual:aPreviewArg.path]) {
    return NO;
  }
  if (self.rev) {
    if (![self.rev isEqual:aPreviewArg.rev]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPreviewArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPreviewArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  if (valueObj.rev) {
    jsonDict[@"rev"] = valueObj.rev;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPreviewArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSString *rev = valueDict[@"rev"] ?: nil;

  return [[DBFILESPreviewArg alloc] initWithPath:path rev:rev];
}

@end

#import "DBFILESLookupError.h"
#import "DBFILESPreviewError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPreviewError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESPreviewErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBFILESPreviewErrorInProgress;
  }
  return self;
}

- (instancetype)initWithUnsupportedExtension {
  self = [super init];
  if (self) {
    _tag = DBFILESPreviewErrorUnsupportedExtension;
  }
  return self;
}

- (instancetype)initWithUnsupportedContent {
  self = [super init];
  if (self) {
    _tag = DBFILESPreviewErrorUnsupportedContent;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESPreviewErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESPreviewErrorPath;
}

- (BOOL)isInProgress {
  return _tag == DBFILESPreviewErrorInProgress;
}

- (BOOL)isUnsupportedExtension {
  return _tag == DBFILESPreviewErrorUnsupportedExtension;
}

- (BOOL)isUnsupportedContent {
  return _tag == DBFILESPreviewErrorUnsupportedContent;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESPreviewErrorPath:
    return @"DBFILESPreviewErrorPath";
  case DBFILESPreviewErrorInProgress:
    return @"DBFILESPreviewErrorInProgress";
  case DBFILESPreviewErrorUnsupportedExtension:
    return @"DBFILESPreviewErrorUnsupportedExtension";
  case DBFILESPreviewErrorUnsupportedContent:
    return @"DBFILESPreviewErrorUnsupportedContent";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPreviewErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPreviewErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPreviewErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESPreviewErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESPreviewErrorInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPreviewErrorUnsupportedExtension:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESPreviewErrorUnsupportedContent:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPreviewError:other];
}

- (BOOL)isEqualToPreviewError:(DBFILESPreviewError *)aPreviewError {
  if (self == aPreviewError) {
    return YES;
  }
  if (self.tag != aPreviewError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESPreviewErrorPath:
    return [self.path isEqual:aPreviewError.path];
  case DBFILESPreviewErrorInProgress:
    return [[self tagName] isEqual:[aPreviewError tagName]];
  case DBFILESPreviewErrorUnsupportedExtension:
    return [[self tagName] isEqual:[aPreviewError tagName]];
  case DBFILESPreviewErrorUnsupportedContent:
    return [[self tagName] isEqual:[aPreviewError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPreviewErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPreviewError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isUnsupportedExtension]) {
    jsonDict[@".tag"] = @"unsupported_extension";
  } else if ([valueObj isUnsupportedContent]) {
    jsonDict[@".tag"] = @"unsupported_content";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPreviewError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESPreviewError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"in_progress"]) {
    return [[DBFILESPreviewError alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"unsupported_extension"]) {
    return [[DBFILESPreviewError alloc] initWithUnsupportedExtension];
  } else if ([tag isEqualToString:@"unsupported_content"]) {
    return [[DBFILESPreviewError alloc] initWithUnsupportedContent];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESFileMetadata.h"
#import "DBFILESMinimalFileLinkMetadata.h"
#import "DBFILESPreviewResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESPreviewResult

#pragma mark - Constructors

- (instancetype)initWithFileMetadata:(DBFILESFileMetadata *)fileMetadata
                        linkMetadata:(DBFILESMinimalFileLinkMetadata *)linkMetadata {

  self = [super init];
  if (self) {
    _fileMetadata = fileMetadata;
    _linkMetadata = linkMetadata;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithFileMetadata:nil linkMetadata:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESPreviewResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESPreviewResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESPreviewResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.fileMetadata != nil) {
    result = prime * result + [self.fileMetadata hash];
  }
  if (self.linkMetadata != nil) {
    result = prime * result + [self.linkMetadata hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPreviewResult:other];
}

- (BOOL)isEqualToPreviewResult:(DBFILESPreviewResult *)aPreviewResult {
  if (self == aPreviewResult) {
    return YES;
  }
  if (self.fileMetadata) {
    if (![self.fileMetadata isEqual:aPreviewResult.fileMetadata]) {
      return NO;
    }
  }
  if (self.linkMetadata) {
    if (![self.linkMetadata isEqual:aPreviewResult.linkMetadata]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESPreviewResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESPreviewResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.fileMetadata) {
    jsonDict[@"file_metadata"] = [DBFILESFileMetadataSerializer serialize:valueObj.fileMetadata];
  }
  if (valueObj.linkMetadata) {
    jsonDict[@"link_metadata"] = [DBFILESMinimalFileLinkMetadataSerializer serialize:valueObj.linkMetadata];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESPreviewResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESFileMetadata *fileMetadata =
      valueDict[@"file_metadata"] ? [DBFILESFileMetadataSerializer deserialize:valueDict[@"file_metadata"]] : nil;
  DBFILESMinimalFileLinkMetadata *linkMetadata =
      valueDict[@"link_metadata"] ? [DBFILESMinimalFileLinkMetadataSerializer deserialize:valueDict[@"link_metadata"]]
                                  : nil;

  return [[DBFILESPreviewResult alloc] initWithFileMetadata:fileMetadata linkMetadata:linkMetadata];
}

@end

#import "DBFILESRelocationPath.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationPath

#pragma mark - Constructors

- (instancetype)initWithFromPath:(NSString *)fromPath toPath:(NSString *)toPath {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](fromPath);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](toPath);

  self = [super init];
  if (self) {
    _fromPath = fromPath;
    _toPath = toPath;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationPathSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationPathSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationPathSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.fromPath hash];
  result = prime * result + [self.toPath hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationPath:other];
}

- (BOOL)isEqualToRelocationPath:(DBFILESRelocationPath *)aRelocationPath {
  if (self == aRelocationPath) {
    return YES;
  }
  if (![self.fromPath isEqual:aRelocationPath.fromPath]) {
    return NO;
  }
  if (![self.toPath isEqual:aRelocationPath.toPath]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationPathSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationPath *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"from_path"] = valueObj.fromPath;
  jsonDict[@"to_path"] = valueObj.toPath;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationPath *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *fromPath = valueDict[@"from_path"];
  NSString *toPath = valueDict[@"to_path"];

  return [[DBFILESRelocationPath alloc] initWithFromPath:fromPath toPath:toPath];
}

@end

#import "DBFILESRelocationArg.h"
#import "DBFILESRelocationPath.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationArg

#pragma mark - Constructors

- (instancetype)initWithFromPath:(NSString *)fromPath
                          toPath:(NSString *)toPath
               allowSharedFolder:(NSNumber *)allowSharedFolder
                      autorename:(NSNumber *)autorename
          allowOwnershipTransfer:(NSNumber *)allowOwnershipTransfer {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](fromPath);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](toPath);

  self = [super initWithFromPath:fromPath toPath:toPath];
  if (self) {
    _allowSharedFolder = allowSharedFolder ?: @NO;
    _autorename = autorename ?: @NO;
    _allowOwnershipTransfer = allowOwnershipTransfer ?: @NO;
  }
  return self;
}

- (instancetype)initWithFromPath:(NSString *)fromPath toPath:(NSString *)toPath {
  return [self initWithFromPath:fromPath toPath:toPath allowSharedFolder:nil autorename:nil allowOwnershipTransfer:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.fromPath hash];
  result = prime * result + [self.toPath hash];
  result = prime * result + [self.allowSharedFolder hash];
  result = prime * result + [self.autorename hash];
  result = prime * result + [self.allowOwnershipTransfer hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationArg:other];
}

- (BOOL)isEqualToRelocationArg:(DBFILESRelocationArg *)aRelocationArg {
  if (self == aRelocationArg) {
    return YES;
  }
  if (![self.fromPath isEqual:aRelocationArg.fromPath]) {
    return NO;
  }
  if (![self.toPath isEqual:aRelocationArg.toPath]) {
    return NO;
  }
  if (![self.allowSharedFolder isEqual:aRelocationArg.allowSharedFolder]) {
    return NO;
  }
  if (![self.autorename isEqual:aRelocationArg.autorename]) {
    return NO;
  }
  if (![self.allowOwnershipTransfer isEqual:aRelocationArg.allowOwnershipTransfer]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"from_path"] = valueObj.fromPath;
  jsonDict[@"to_path"] = valueObj.toPath;
  jsonDict[@"allow_shared_folder"] = valueObj.allowSharedFolder;
  jsonDict[@"autorename"] = valueObj.autorename;
  jsonDict[@"allow_ownership_transfer"] = valueObj.allowOwnershipTransfer;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *fromPath = valueDict[@"from_path"];
  NSString *toPath = valueDict[@"to_path"];
  NSNumber *allowSharedFolder = valueDict[@"allow_shared_folder"] ?: @NO;
  NSNumber *autorename = valueDict[@"autorename"] ?: @NO;
  NSNumber *allowOwnershipTransfer = valueDict[@"allow_ownership_transfer"] ?: @NO;

  return [[DBFILESRelocationArg alloc] initWithFromPath:fromPath
                                                 toPath:toPath
                                      allowSharedFolder:allowSharedFolder
                                             autorename:autorename
                                 allowOwnershipTransfer:allowOwnershipTransfer];
}

@end

#import "DBFILESRelocationBatchArg.h"
#import "DBFILESRelocationBatchArgBase.h"
#import "DBFILESRelocationPath.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchArg

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESRelocationPath *> *)entries
                     autorename:(NSNumber *)autorename
              allowSharedFolder:(NSNumber *)allowSharedFolder
         allowOwnershipTransfer:(NSNumber *)allowOwnershipTransfer {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:@(1)
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super initWithEntries:entries autorename:autorename];
  if (self) {
    _allowSharedFolder = allowSharedFolder ?: @NO;
    _allowOwnershipTransfer = allowOwnershipTransfer ?: @NO;
  }
  return self;
}

- (instancetype)initWithEntries:(NSArray<DBFILESRelocationPath *> *)entries {
  return [self initWithEntries:entries autorename:nil allowSharedFolder:nil allowOwnershipTransfer:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];
  result = prime * result + [self.autorename hash];
  result = prime * result + [self.allowSharedFolder hash];
  result = prime * result + [self.allowOwnershipTransfer hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchArg:other];
}

- (BOOL)isEqualToRelocationBatchArg:(DBFILESRelocationBatchArg *)aRelocationBatchArg {
  if (self == aRelocationBatchArg) {
    return YES;
  }
  if (![self.entries isEqual:aRelocationBatchArg.entries]) {
    return NO;
  }
  if (![self.autorename isEqual:aRelocationBatchArg.autorename]) {
    return NO;
  }
  if (![self.allowSharedFolder isEqual:aRelocationBatchArg.allowSharedFolder]) {
    return NO;
  }
  if (![self.allowOwnershipTransfer isEqual:aRelocationBatchArg.allowOwnershipTransfer]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESRelocationPathSerializer serialize:elem0];
                                            }];
  jsonDict[@"autorename"] = valueObj.autorename;
  jsonDict[@"allow_shared_folder"] = valueObj.allowSharedFolder;
  jsonDict[@"allow_ownership_transfer"] = valueObj.allowOwnershipTransfer;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESRelocationPath *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESRelocationPathSerializer deserialize:elem0];
                           }];
  NSNumber *autorename = valueDict[@"autorename"] ?: @NO;
  NSNumber *allowSharedFolder = valueDict[@"allow_shared_folder"] ?: @NO;
  NSNumber *allowOwnershipTransfer = valueDict[@"allow_ownership_transfer"] ?: @NO;

  return [[DBFILESRelocationBatchArg alloc] initWithEntries:entries
                                                 autorename:autorename
                                          allowSharedFolder:allowSharedFolder
                                     allowOwnershipTransfer:allowOwnershipTransfer];
}

@end

#import "DBFILESLookupError.h"
#import "DBFILESMoveIntoVaultError.h"
#import "DBFILESRelocationError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationError

@synthesize fromLookup = _fromLookup;
@synthesize fromWrite = _fromWrite;
@synthesize to = _to;
@synthesize cantMoveIntoVault = _cantMoveIntoVault;

#pragma mark - Constructors

- (instancetype)initWithFromLookup:(DBFILESLookupError *)fromLookup {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorFromLookup;
    _fromLookup = fromLookup;
  }
  return self;
}

- (instancetype)initWithFromWrite:(DBFILESWriteError *)fromWrite {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorFromWrite;
    _fromWrite = fromWrite;
  }
  return self;
}

- (instancetype)initWithTo:(DBFILESWriteError *)to {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorTo;
    _to = to;
  }
  return self;
}

- (instancetype)initWithCantCopySharedFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorCantCopySharedFolder;
  }
  return self;
}

- (instancetype)initWithCantNestSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorCantNestSharedFolder;
  }
  return self;
}

- (instancetype)initWithCantMoveFolderIntoItself {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorCantMoveFolderIntoItself;
  }
  return self;
}

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithDuplicatedOrNestedPaths {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorDuplicatedOrNestedPaths;
  }
  return self;
}

- (instancetype)initWithCantTransferOwnership {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorCantTransferOwnership;
  }
  return self;
}

- (instancetype)initWithInsufficientQuota {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorInsufficientQuota;
  }
  return self;
}

- (instancetype)initWithInternalError {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorInternalError;
  }
  return self;
}

- (instancetype)initWithCantMoveSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorCantMoveSharedFolder;
  }
  return self;
}

- (instancetype)initWithCantMoveIntoVault:(DBFILESMoveIntoVaultError *)cantMoveIntoVault {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorCantMoveIntoVault;
    _cantMoveIntoVault = cantMoveIntoVault;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)fromLookup {
  if (![self isFromLookup]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationErrorFromLookup, but was %@.", [self tagName]];
  }
  return _fromLookup;
}

- (DBFILESWriteError *)fromWrite {
  if (![self isFromWrite]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationErrorFromWrite, but was %@.", [self tagName]];
  }
  return _fromWrite;
}

- (DBFILESWriteError *)to {
  if (![self isTo]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationErrorTo, but was %@.", [self tagName]];
  }
  return _to;
}

- (DBFILESMoveIntoVaultError *)cantMoveIntoVault {
  if (![self isCantMoveIntoVault]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationErrorCantMoveIntoVault, but was %@.", [self tagName]];
  }
  return _cantMoveIntoVault;
}

#pragma mark - Tag state methods

- (BOOL)isFromLookup {
  return _tag == DBFILESRelocationErrorFromLookup;
}

- (BOOL)isFromWrite {
  return _tag == DBFILESRelocationErrorFromWrite;
}

- (BOOL)isTo {
  return _tag == DBFILESRelocationErrorTo;
}

- (BOOL)isCantCopySharedFolder {
  return _tag == DBFILESRelocationErrorCantCopySharedFolder;
}

- (BOOL)isCantNestSharedFolder {
  return _tag == DBFILESRelocationErrorCantNestSharedFolder;
}

- (BOOL)isCantMoveFolderIntoItself {
  return _tag == DBFILESRelocationErrorCantMoveFolderIntoItself;
}

- (BOOL)isTooManyFiles {
  return _tag == DBFILESRelocationErrorTooManyFiles;
}

- (BOOL)isDuplicatedOrNestedPaths {
  return _tag == DBFILESRelocationErrorDuplicatedOrNestedPaths;
}

- (BOOL)isCantTransferOwnership {
  return _tag == DBFILESRelocationErrorCantTransferOwnership;
}

- (BOOL)isInsufficientQuota {
  return _tag == DBFILESRelocationErrorInsufficientQuota;
}

- (BOOL)isInternalError {
  return _tag == DBFILESRelocationErrorInternalError;
}

- (BOOL)isCantMoveSharedFolder {
  return _tag == DBFILESRelocationErrorCantMoveSharedFolder;
}

- (BOOL)isCantMoveIntoVault {
  return _tag == DBFILESRelocationErrorCantMoveIntoVault;
}

- (BOOL)isOther {
  return _tag == DBFILESRelocationErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESRelocationErrorFromLookup:
    return @"DBFILESRelocationErrorFromLookup";
  case DBFILESRelocationErrorFromWrite:
    return @"DBFILESRelocationErrorFromWrite";
  case DBFILESRelocationErrorTo:
    return @"DBFILESRelocationErrorTo";
  case DBFILESRelocationErrorCantCopySharedFolder:
    return @"DBFILESRelocationErrorCantCopySharedFolder";
  case DBFILESRelocationErrorCantNestSharedFolder:
    return @"DBFILESRelocationErrorCantNestSharedFolder";
  case DBFILESRelocationErrorCantMoveFolderIntoItself:
    return @"DBFILESRelocationErrorCantMoveFolderIntoItself";
  case DBFILESRelocationErrorTooManyFiles:
    return @"DBFILESRelocationErrorTooManyFiles";
  case DBFILESRelocationErrorDuplicatedOrNestedPaths:
    return @"DBFILESRelocationErrorDuplicatedOrNestedPaths";
  case DBFILESRelocationErrorCantTransferOwnership:
    return @"DBFILESRelocationErrorCantTransferOwnership";
  case DBFILESRelocationErrorInsufficientQuota:
    return @"DBFILESRelocationErrorInsufficientQuota";
  case DBFILESRelocationErrorInternalError:
    return @"DBFILESRelocationErrorInternalError";
  case DBFILESRelocationErrorCantMoveSharedFolder:
    return @"DBFILESRelocationErrorCantMoveSharedFolder";
  case DBFILESRelocationErrorCantMoveIntoVault:
    return @"DBFILESRelocationErrorCantMoveIntoVault";
  case DBFILESRelocationErrorOther:
    return @"DBFILESRelocationErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESRelocationErrorFromLookup:
    result = prime * result + [self.fromLookup hash];
    break;
  case DBFILESRelocationErrorFromWrite:
    result = prime * result + [self.fromWrite hash];
    break;
  case DBFILESRelocationErrorTo:
    result = prime * result + [self.to hash];
    break;
  case DBFILESRelocationErrorCantCopySharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationErrorCantNestSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationErrorCantMoveFolderIntoItself:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationErrorDuplicatedOrNestedPaths:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationErrorCantTransferOwnership:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationErrorInsufficientQuota:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationErrorInternalError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationErrorCantMoveSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationErrorCantMoveIntoVault:
    result = prime * result + [self.cantMoveIntoVault hash];
    break;
  case DBFILESRelocationErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationError:other];
}

- (BOOL)isEqualToRelocationError:(DBFILESRelocationError *)aRelocationError {
  if (self == aRelocationError) {
    return YES;
  }
  if (self.tag != aRelocationError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESRelocationErrorFromLookup:
    return [self.fromLookup isEqual:aRelocationError.fromLookup];
  case DBFILESRelocationErrorFromWrite:
    return [self.fromWrite isEqual:aRelocationError.fromWrite];
  case DBFILESRelocationErrorTo:
    return [self.to isEqual:aRelocationError.to];
  case DBFILESRelocationErrorCantCopySharedFolder:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  case DBFILESRelocationErrorCantNestSharedFolder:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  case DBFILESRelocationErrorCantMoveFolderIntoItself:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  case DBFILESRelocationErrorTooManyFiles:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  case DBFILESRelocationErrorDuplicatedOrNestedPaths:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  case DBFILESRelocationErrorCantTransferOwnership:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  case DBFILESRelocationErrorInsufficientQuota:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  case DBFILESRelocationErrorInternalError:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  case DBFILESRelocationErrorCantMoveSharedFolder:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  case DBFILESRelocationErrorCantMoveIntoVault:
    return [self.cantMoveIntoVault isEqual:aRelocationError.cantMoveIntoVault];
  case DBFILESRelocationErrorOther:
    return [[self tagName] isEqual:[aRelocationError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFromLookup]) {
    jsonDict[@"from_lookup"] = [[DBFILESLookupErrorSerializer serialize:valueObj.fromLookup] mutableCopy];
    jsonDict[@".tag"] = @"from_lookup";
  } else if ([valueObj isFromWrite]) {
    jsonDict[@"from_write"] = [[DBFILESWriteErrorSerializer serialize:valueObj.fromWrite] mutableCopy];
    jsonDict[@".tag"] = @"from_write";
  } else if ([valueObj isTo]) {
    jsonDict[@"to"] = [[DBFILESWriteErrorSerializer serialize:valueObj.to] mutableCopy];
    jsonDict[@".tag"] = @"to";
  } else if ([valueObj isCantCopySharedFolder]) {
    jsonDict[@".tag"] = @"cant_copy_shared_folder";
  } else if ([valueObj isCantNestSharedFolder]) {
    jsonDict[@".tag"] = @"cant_nest_shared_folder";
  } else if ([valueObj isCantMoveFolderIntoItself]) {
    jsonDict[@".tag"] = @"cant_move_folder_into_itself";
  } else if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isDuplicatedOrNestedPaths]) {
    jsonDict[@".tag"] = @"duplicated_or_nested_paths";
  } else if ([valueObj isCantTransferOwnership]) {
    jsonDict[@".tag"] = @"cant_transfer_ownership";
  } else if ([valueObj isInsufficientQuota]) {
    jsonDict[@".tag"] = @"insufficient_quota";
  } else if ([valueObj isInternalError]) {
    jsonDict[@".tag"] = @"internal_error";
  } else if ([valueObj isCantMoveSharedFolder]) {
    jsonDict[@".tag"] = @"cant_move_shared_folder";
  } else if ([valueObj isCantMoveIntoVault]) {
    jsonDict[@"cant_move_into_vault"] =
        [[DBFILESMoveIntoVaultErrorSerializer serialize:valueObj.cantMoveIntoVault] mutableCopy];
    jsonDict[@".tag"] = @"cant_move_into_vault";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"from_lookup"]) {
    DBFILESLookupError *fromLookup = [DBFILESLookupErrorSerializer deserialize:valueDict[@"from_lookup"]];
    return [[DBFILESRelocationError alloc] initWithFromLookup:fromLookup];
  } else if ([tag isEqualToString:@"from_write"]) {
    DBFILESWriteError *fromWrite = [DBFILESWriteErrorSerializer deserialize:valueDict[@"from_write"]];
    return [[DBFILESRelocationError alloc] initWithFromWrite:fromWrite];
  } else if ([tag isEqualToString:@"to"]) {
    DBFILESWriteError *to = [DBFILESWriteErrorSerializer deserialize:valueDict[@"to"]];
    return [[DBFILESRelocationError alloc] initWithTo:to];
  } else if ([tag isEqualToString:@"cant_copy_shared_folder"]) {
    return [[DBFILESRelocationError alloc] initWithCantCopySharedFolder];
  } else if ([tag isEqualToString:@"cant_nest_shared_folder"]) {
    return [[DBFILESRelocationError alloc] initWithCantNestSharedFolder];
  } else if ([tag isEqualToString:@"cant_move_folder_into_itself"]) {
    return [[DBFILESRelocationError alloc] initWithCantMoveFolderIntoItself];
  } else if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBFILESRelocationError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"duplicated_or_nested_paths"]) {
    return [[DBFILESRelocationError alloc] initWithDuplicatedOrNestedPaths];
  } else if ([tag isEqualToString:@"cant_transfer_ownership"]) {
    return [[DBFILESRelocationError alloc] initWithCantTransferOwnership];
  } else if ([tag isEqualToString:@"insufficient_quota"]) {
    return [[DBFILESRelocationError alloc] initWithInsufficientQuota];
  } else if ([tag isEqualToString:@"internal_error"]) {
    return [[DBFILESRelocationError alloc] initWithInternalError];
  } else if ([tag isEqualToString:@"cant_move_shared_folder"]) {
    return [[DBFILESRelocationError alloc] initWithCantMoveSharedFolder];
  } else if ([tag isEqualToString:@"cant_move_into_vault"]) {
    DBFILESMoveIntoVaultError *cantMoveIntoVault =
        [DBFILESMoveIntoVaultErrorSerializer deserialize:valueDict[@"cant_move_into_vault"]];
    return [[DBFILESRelocationError alloc] initWithCantMoveIntoVault:cantMoveIntoVault];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESRelocationError alloc] initWithOther];
  } else {
    return [[DBFILESRelocationError alloc] initWithOther];
  }
}

@end

#import "DBFILESLookupError.h"
#import "DBFILESMoveIntoVaultError.h"
#import "DBFILESRelocationBatchError.h"
#import "DBFILESRelocationError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchError

@synthesize fromLookup = _fromLookup;
@synthesize fromWrite = _fromWrite;
@synthesize to = _to;
@synthesize cantMoveIntoVault = _cantMoveIntoVault;

#pragma mark - Constructors

- (instancetype)initWithFromLookup:(DBFILESLookupError *)fromLookup {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorFromLookup;
    _fromLookup = fromLookup;
  }
  return self;
}

- (instancetype)initWithFromWrite:(DBFILESWriteError *)fromWrite {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorFromWrite;
    _fromWrite = fromWrite;
  }
  return self;
}

- (instancetype)initWithTo:(DBFILESWriteError *)to {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorTo;
    _to = to;
  }
  return self;
}

- (instancetype)initWithCantCopySharedFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorCantCopySharedFolder;
  }
  return self;
}

- (instancetype)initWithCantNestSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorCantNestSharedFolder;
  }
  return self;
}

- (instancetype)initWithCantMoveFolderIntoItself {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorCantMoveFolderIntoItself;
  }
  return self;
}

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithDuplicatedOrNestedPaths {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorDuplicatedOrNestedPaths;
  }
  return self;
}

- (instancetype)initWithCantTransferOwnership {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorCantTransferOwnership;
  }
  return self;
}

- (instancetype)initWithInsufficientQuota {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorInsufficientQuota;
  }
  return self;
}

- (instancetype)initWithInternalError {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorInternalError;
  }
  return self;
}

- (instancetype)initWithCantMoveSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorCantMoveSharedFolder;
  }
  return self;
}

- (instancetype)initWithCantMoveIntoVault:(DBFILESMoveIntoVaultError *)cantMoveIntoVault {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorCantMoveIntoVault;
    _cantMoveIntoVault = cantMoveIntoVault;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorOther;
  }
  return self;
}

- (instancetype)initWithTooManyWriteOperations {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorTooManyWriteOperations;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)fromLookup {
  if (![self isFromLookup]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchErrorFromLookup, but was %@.", [self tagName]];
  }
  return _fromLookup;
}

- (DBFILESWriteError *)fromWrite {
  if (![self isFromWrite]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchErrorFromWrite, but was %@.", [self tagName]];
  }
  return _fromWrite;
}

- (DBFILESWriteError *)to {
  if (![self isTo]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchErrorTo, but was %@.", [self tagName]];
  }
  return _to;
}

- (DBFILESMoveIntoVaultError *)cantMoveIntoVault {
  if (![self isCantMoveIntoVault]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESRelocationBatchErrorCantMoveIntoVault, but was %@.", [self tagName]];
  }
  return _cantMoveIntoVault;
}

#pragma mark - Tag state methods

- (BOOL)isFromLookup {
  return _tag == DBFILESRelocationBatchErrorFromLookup;
}

- (BOOL)isFromWrite {
  return _tag == DBFILESRelocationBatchErrorFromWrite;
}

- (BOOL)isTo {
  return _tag == DBFILESRelocationBatchErrorTo;
}

- (BOOL)isCantCopySharedFolder {
  return _tag == DBFILESRelocationBatchErrorCantCopySharedFolder;
}

- (BOOL)isCantNestSharedFolder {
  return _tag == DBFILESRelocationBatchErrorCantNestSharedFolder;
}

- (BOOL)isCantMoveFolderIntoItself {
  return _tag == DBFILESRelocationBatchErrorCantMoveFolderIntoItself;
}

- (BOOL)isTooManyFiles {
  return _tag == DBFILESRelocationBatchErrorTooManyFiles;
}

- (BOOL)isDuplicatedOrNestedPaths {
  return _tag == DBFILESRelocationBatchErrorDuplicatedOrNestedPaths;
}

- (BOOL)isCantTransferOwnership {
  return _tag == DBFILESRelocationBatchErrorCantTransferOwnership;
}

- (BOOL)isInsufficientQuota {
  return _tag == DBFILESRelocationBatchErrorInsufficientQuota;
}

- (BOOL)isInternalError {
  return _tag == DBFILESRelocationBatchErrorInternalError;
}

- (BOOL)isCantMoveSharedFolder {
  return _tag == DBFILESRelocationBatchErrorCantMoveSharedFolder;
}

- (BOOL)isCantMoveIntoVault {
  return _tag == DBFILESRelocationBatchErrorCantMoveIntoVault;
}

- (BOOL)isOther {
  return _tag == DBFILESRelocationBatchErrorOther;
}

- (BOOL)isTooManyWriteOperations {
  return _tag == DBFILESRelocationBatchErrorTooManyWriteOperations;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESRelocationBatchErrorFromLookup:
    return @"DBFILESRelocationBatchErrorFromLookup";
  case DBFILESRelocationBatchErrorFromWrite:
    return @"DBFILESRelocationBatchErrorFromWrite";
  case DBFILESRelocationBatchErrorTo:
    return @"DBFILESRelocationBatchErrorTo";
  case DBFILESRelocationBatchErrorCantCopySharedFolder:
    return @"DBFILESRelocationBatchErrorCantCopySharedFolder";
  case DBFILESRelocationBatchErrorCantNestSharedFolder:
    return @"DBFILESRelocationBatchErrorCantNestSharedFolder";
  case DBFILESRelocationBatchErrorCantMoveFolderIntoItself:
    return @"DBFILESRelocationBatchErrorCantMoveFolderIntoItself";
  case DBFILESRelocationBatchErrorTooManyFiles:
    return @"DBFILESRelocationBatchErrorTooManyFiles";
  case DBFILESRelocationBatchErrorDuplicatedOrNestedPaths:
    return @"DBFILESRelocationBatchErrorDuplicatedOrNestedPaths";
  case DBFILESRelocationBatchErrorCantTransferOwnership:
    return @"DBFILESRelocationBatchErrorCantTransferOwnership";
  case DBFILESRelocationBatchErrorInsufficientQuota:
    return @"DBFILESRelocationBatchErrorInsufficientQuota";
  case DBFILESRelocationBatchErrorInternalError:
    return @"DBFILESRelocationBatchErrorInternalError";
  case DBFILESRelocationBatchErrorCantMoveSharedFolder:
    return @"DBFILESRelocationBatchErrorCantMoveSharedFolder";
  case DBFILESRelocationBatchErrorCantMoveIntoVault:
    return @"DBFILESRelocationBatchErrorCantMoveIntoVault";
  case DBFILESRelocationBatchErrorOther:
    return @"DBFILESRelocationBatchErrorOther";
  case DBFILESRelocationBatchErrorTooManyWriteOperations:
    return @"DBFILESRelocationBatchErrorTooManyWriteOperations";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESRelocationBatchErrorFromLookup:
    result = prime * result + [self.fromLookup hash];
    break;
  case DBFILESRelocationBatchErrorFromWrite:
    result = prime * result + [self.fromWrite hash];
    break;
  case DBFILESRelocationBatchErrorTo:
    result = prime * result + [self.to hash];
    break;
  case DBFILESRelocationBatchErrorCantCopySharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorCantNestSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorCantMoveFolderIntoItself:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorDuplicatedOrNestedPaths:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorCantTransferOwnership:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorInsufficientQuota:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorInternalError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorCantMoveSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorCantMoveIntoVault:
    result = prime * result + [self.cantMoveIntoVault hash];
    break;
  case DBFILESRelocationBatchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorTooManyWriteOperations:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchError:other];
}

- (BOOL)isEqualToRelocationBatchError:(DBFILESRelocationBatchError *)aRelocationBatchError {
  if (self == aRelocationBatchError) {
    return YES;
  }
  if (self.tag != aRelocationBatchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESRelocationBatchErrorFromLookup:
    return [self.fromLookup isEqual:aRelocationBatchError.fromLookup];
  case DBFILESRelocationBatchErrorFromWrite:
    return [self.fromWrite isEqual:aRelocationBatchError.fromWrite];
  case DBFILESRelocationBatchErrorTo:
    return [self.to isEqual:aRelocationBatchError.to];
  case DBFILESRelocationBatchErrorCantCopySharedFolder:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorCantNestSharedFolder:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorCantMoveFolderIntoItself:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorTooManyFiles:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorDuplicatedOrNestedPaths:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorCantTransferOwnership:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorInsufficientQuota:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorInternalError:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorCantMoveSharedFolder:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorCantMoveIntoVault:
    return [self.cantMoveIntoVault isEqual:aRelocationBatchError.cantMoveIntoVault];
  case DBFILESRelocationBatchErrorOther:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  case DBFILESRelocationBatchErrorTooManyWriteOperations:
    return [[self tagName] isEqual:[aRelocationBatchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFromLookup]) {
    jsonDict[@"from_lookup"] = [[DBFILESLookupErrorSerializer serialize:valueObj.fromLookup] mutableCopy];
    jsonDict[@".tag"] = @"from_lookup";
  } else if ([valueObj isFromWrite]) {
    jsonDict[@"from_write"] = [[DBFILESWriteErrorSerializer serialize:valueObj.fromWrite] mutableCopy];
    jsonDict[@".tag"] = @"from_write";
  } else if ([valueObj isTo]) {
    jsonDict[@"to"] = [[DBFILESWriteErrorSerializer serialize:valueObj.to] mutableCopy];
    jsonDict[@".tag"] = @"to";
  } else if ([valueObj isCantCopySharedFolder]) {
    jsonDict[@".tag"] = @"cant_copy_shared_folder";
  } else if ([valueObj isCantNestSharedFolder]) {
    jsonDict[@".tag"] = @"cant_nest_shared_folder";
  } else if ([valueObj isCantMoveFolderIntoItself]) {
    jsonDict[@".tag"] = @"cant_move_folder_into_itself";
  } else if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isDuplicatedOrNestedPaths]) {
    jsonDict[@".tag"] = @"duplicated_or_nested_paths";
  } else if ([valueObj isCantTransferOwnership]) {
    jsonDict[@".tag"] = @"cant_transfer_ownership";
  } else if ([valueObj isInsufficientQuota]) {
    jsonDict[@".tag"] = @"insufficient_quota";
  } else if ([valueObj isInternalError]) {
    jsonDict[@".tag"] = @"internal_error";
  } else if ([valueObj isCantMoveSharedFolder]) {
    jsonDict[@".tag"] = @"cant_move_shared_folder";
  } else if ([valueObj isCantMoveIntoVault]) {
    jsonDict[@"cant_move_into_vault"] =
        [[DBFILESMoveIntoVaultErrorSerializer serialize:valueObj.cantMoveIntoVault] mutableCopy];
    jsonDict[@".tag"] = @"cant_move_into_vault";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isTooManyWriteOperations]) {
    jsonDict[@".tag"] = @"too_many_write_operations";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"from_lookup"]) {
    DBFILESLookupError *fromLookup = [DBFILESLookupErrorSerializer deserialize:valueDict[@"from_lookup"]];
    return [[DBFILESRelocationBatchError alloc] initWithFromLookup:fromLookup];
  } else if ([tag isEqualToString:@"from_write"]) {
    DBFILESWriteError *fromWrite = [DBFILESWriteErrorSerializer deserialize:valueDict[@"from_write"]];
    return [[DBFILESRelocationBatchError alloc] initWithFromWrite:fromWrite];
  } else if ([tag isEqualToString:@"to"]) {
    DBFILESWriteError *to = [DBFILESWriteErrorSerializer deserialize:valueDict[@"to"]];
    return [[DBFILESRelocationBatchError alloc] initWithTo:to];
  } else if ([tag isEqualToString:@"cant_copy_shared_folder"]) {
    return [[DBFILESRelocationBatchError alloc] initWithCantCopySharedFolder];
  } else if ([tag isEqualToString:@"cant_nest_shared_folder"]) {
    return [[DBFILESRelocationBatchError alloc] initWithCantNestSharedFolder];
  } else if ([tag isEqualToString:@"cant_move_folder_into_itself"]) {
    return [[DBFILESRelocationBatchError alloc] initWithCantMoveFolderIntoItself];
  } else if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBFILESRelocationBatchError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"duplicated_or_nested_paths"]) {
    return [[DBFILESRelocationBatchError alloc] initWithDuplicatedOrNestedPaths];
  } else if ([tag isEqualToString:@"cant_transfer_ownership"]) {
    return [[DBFILESRelocationBatchError alloc] initWithCantTransferOwnership];
  } else if ([tag isEqualToString:@"insufficient_quota"]) {
    return [[DBFILESRelocationBatchError alloc] initWithInsufficientQuota];
  } else if ([tag isEqualToString:@"internal_error"]) {
    return [[DBFILESRelocationBatchError alloc] initWithInternalError];
  } else if ([tag isEqualToString:@"cant_move_shared_folder"]) {
    return [[DBFILESRelocationBatchError alloc] initWithCantMoveSharedFolder];
  } else if ([tag isEqualToString:@"cant_move_into_vault"]) {
    DBFILESMoveIntoVaultError *cantMoveIntoVault =
        [DBFILESMoveIntoVaultErrorSerializer deserialize:valueDict[@"cant_move_into_vault"]];
    return [[DBFILESRelocationBatchError alloc] initWithCantMoveIntoVault:cantMoveIntoVault];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESRelocationBatchError alloc] initWithOther];
  } else if ([tag isEqualToString:@"too_many_write_operations"]) {
    return [[DBFILESRelocationBatchError alloc] initWithTooManyWriteOperations];
  } else {
    return [[DBFILESRelocationBatchError alloc] initWithOther];
  }
}

@end

#import "DBFILESRelocationBatchErrorEntry.h"
#import "DBFILESRelocationError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchErrorEntry

@synthesize relocationError = _relocationError;

#pragma mark - Constructors

- (instancetype)initWithRelocationError:(DBFILESRelocationError *)relocationError {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorEntryRelocationError;
    _relocationError = relocationError;
  }
  return self;
}

- (instancetype)initWithInternalError {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorEntryInternalError;
  }
  return self;
}

- (instancetype)initWithTooManyWriteOperations {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorEntryTooManyWriteOperations;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchErrorEntryOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESRelocationError *)relocationError {
  if (![self isRelocationError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESRelocationBatchErrorEntryRelocationError, but was %@.", [self tagName]];
  }
  return _relocationError;
}

#pragma mark - Tag state methods

- (BOOL)isRelocationError {
  return _tag == DBFILESRelocationBatchErrorEntryRelocationError;
}

- (BOOL)isInternalError {
  return _tag == DBFILESRelocationBatchErrorEntryInternalError;
}

- (BOOL)isTooManyWriteOperations {
  return _tag == DBFILESRelocationBatchErrorEntryTooManyWriteOperations;
}

- (BOOL)isOther {
  return _tag == DBFILESRelocationBatchErrorEntryOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESRelocationBatchErrorEntryRelocationError:
    return @"DBFILESRelocationBatchErrorEntryRelocationError";
  case DBFILESRelocationBatchErrorEntryInternalError:
    return @"DBFILESRelocationBatchErrorEntryInternalError";
  case DBFILESRelocationBatchErrorEntryTooManyWriteOperations:
    return @"DBFILESRelocationBatchErrorEntryTooManyWriteOperations";
  case DBFILESRelocationBatchErrorEntryOther:
    return @"DBFILESRelocationBatchErrorEntryOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchErrorEntrySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchErrorEntrySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchErrorEntrySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESRelocationBatchErrorEntryRelocationError:
    result = prime * result + [self.relocationError hash];
    break;
  case DBFILESRelocationBatchErrorEntryInternalError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorEntryTooManyWriteOperations:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchErrorEntryOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchErrorEntry:other];
}

- (BOOL)isEqualToRelocationBatchErrorEntry:(DBFILESRelocationBatchErrorEntry *)aRelocationBatchErrorEntry {
  if (self == aRelocationBatchErrorEntry) {
    return YES;
  }
  if (self.tag != aRelocationBatchErrorEntry.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESRelocationBatchErrorEntryRelocationError:
    return [self.relocationError isEqual:aRelocationBatchErrorEntry.relocationError];
  case DBFILESRelocationBatchErrorEntryInternalError:
    return [[self tagName] isEqual:[aRelocationBatchErrorEntry tagName]];
  case DBFILESRelocationBatchErrorEntryTooManyWriteOperations:
    return [[self tagName] isEqual:[aRelocationBatchErrorEntry tagName]];
  case DBFILESRelocationBatchErrorEntryOther:
    return [[self tagName] isEqual:[aRelocationBatchErrorEntry tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchErrorEntrySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchErrorEntry *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isRelocationError]) {
    jsonDict[@"relocation_error"] = [[DBFILESRelocationErrorSerializer serialize:valueObj.relocationError] mutableCopy];
    jsonDict[@".tag"] = @"relocation_error";
  } else if ([valueObj isInternalError]) {
    jsonDict[@".tag"] = @"internal_error";
  } else if ([valueObj isTooManyWriteOperations]) {
    jsonDict[@".tag"] = @"too_many_write_operations";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchErrorEntry *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"relocation_error"]) {
    DBFILESRelocationError *relocationError =
        [DBFILESRelocationErrorSerializer deserialize:valueDict[@"relocation_error"]];
    return [[DBFILESRelocationBatchErrorEntry alloc] initWithRelocationError:relocationError];
  } else if ([tag isEqualToString:@"internal_error"]) {
    return [[DBFILESRelocationBatchErrorEntry alloc] initWithInternalError];
  } else if ([tag isEqualToString:@"too_many_write_operations"]) {
    return [[DBFILESRelocationBatchErrorEntry alloc] initWithTooManyWriteOperations];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESRelocationBatchErrorEntry alloc] initWithOther];
  } else {
    return [[DBFILESRelocationBatchErrorEntry alloc] initWithOther];
  }
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBFILESRelocationBatchError.h"
#import "DBFILESRelocationBatchJobStatus.h"
#import "DBFILESRelocationBatchResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchJobStatus

@synthesize complete = _complete;
@synthesize failed = _failed;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESRelocationBatchResult *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchJobStatusComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithFailed:(DBFILESRelocationBatchError *)failed {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchJobStatusFailed;
    _failed = failed;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESRelocationBatchResult *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchJobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

- (DBFILESRelocationBatchError *)failed {
  if (![self isFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchJobStatusFailed, but was %@.", [self tagName]];
  }
  return _failed;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBFILESRelocationBatchJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBFILESRelocationBatchJobStatusComplete;
}

- (BOOL)isFailed {
  return _tag == DBFILESRelocationBatchJobStatusFailed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESRelocationBatchJobStatusInProgress:
    return @"DBFILESRelocationBatchJobStatusInProgress";
  case DBFILESRelocationBatchJobStatusComplete:
    return @"DBFILESRelocationBatchJobStatusComplete";
  case DBFILESRelocationBatchJobStatusFailed:
    return @"DBFILESRelocationBatchJobStatusFailed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESRelocationBatchJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchJobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBFILESRelocationBatchJobStatusFailed:
    result = prime * result + [self.failed hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchJobStatus:other];
}

- (BOOL)isEqualToRelocationBatchJobStatus:(DBFILESRelocationBatchJobStatus *)aRelocationBatchJobStatus {
  if (self == aRelocationBatchJobStatus) {
    return YES;
  }
  if (self.tag != aRelocationBatchJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESRelocationBatchJobStatusInProgress:
    return [[self tagName] isEqual:[aRelocationBatchJobStatus tagName]];
  case DBFILESRelocationBatchJobStatusComplete:
    return [self.complete isEqual:aRelocationBatchJobStatus.complete];
  case DBFILESRelocationBatchJobStatusFailed:
    return [self.failed isEqual:aRelocationBatchJobStatus.failed];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESRelocationBatchResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isFailed]) {
    jsonDict[@"failed"] = [[DBFILESRelocationBatchErrorSerializer serialize:valueObj.failed] mutableCopy];
    jsonDict[@".tag"] = @"failed";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBFILESRelocationBatchJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESRelocationBatchResult *complete = [DBFILESRelocationBatchResultSerializer deserialize:valueDict];
    return [[DBFILESRelocationBatchJobStatus alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"failed"]) {
    DBFILESRelocationBatchError *failed = [DBFILESRelocationBatchErrorSerializer deserialize:valueDict[@"failed"]];
    return [[DBFILESRelocationBatchJobStatus alloc] initWithFailed:failed];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBASYNCLaunchResultBase.h"
#import "DBFILESRelocationBatchLaunch.h"
#import "DBFILESRelocationBatchResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchLaunch

@synthesize asyncJobId = _asyncJobId;
@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchLaunchAsyncJobId;
    _asyncJobId = asyncJobId;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESRelocationBatchResult *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchLaunchComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchLaunchOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)asyncJobId {
  if (![self isAsyncJobId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchLaunchAsyncJobId, but was %@.", [self tagName]];
  }
  return _asyncJobId;
}

- (DBFILESRelocationBatchResult *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchLaunchComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isAsyncJobId {
  return _tag == DBFILESRelocationBatchLaunchAsyncJobId;
}

- (BOOL)isComplete {
  return _tag == DBFILESRelocationBatchLaunchComplete;
}

- (BOOL)isOther {
  return _tag == DBFILESRelocationBatchLaunchOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESRelocationBatchLaunchAsyncJobId:
    return @"DBFILESRelocationBatchLaunchAsyncJobId";
  case DBFILESRelocationBatchLaunchComplete:
    return @"DBFILESRelocationBatchLaunchComplete";
  case DBFILESRelocationBatchLaunchOther:
    return @"DBFILESRelocationBatchLaunchOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchLaunchSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchLaunchSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchLaunchSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESRelocationBatchLaunchAsyncJobId:
    result = prime * result + [self.asyncJobId hash];
    break;
  case DBFILESRelocationBatchLaunchComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBFILESRelocationBatchLaunchOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchLaunch:other];
}

- (BOOL)isEqualToRelocationBatchLaunch:(DBFILESRelocationBatchLaunch *)aRelocationBatchLaunch {
  if (self == aRelocationBatchLaunch) {
    return YES;
  }
  if (self.tag != aRelocationBatchLaunch.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESRelocationBatchLaunchAsyncJobId:
    return [self.asyncJobId isEqual:aRelocationBatchLaunch.asyncJobId];
  case DBFILESRelocationBatchLaunchComplete:
    return [self.complete isEqual:aRelocationBatchLaunch.complete];
  case DBFILESRelocationBatchLaunchOther:
    return [[self tagName] isEqual:[aRelocationBatchLaunch tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchLaunchSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchLaunch *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAsyncJobId]) {
    jsonDict[@"async_job_id"] = valueObj.asyncJobId;
    jsonDict[@".tag"] = @"async_job_id";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESRelocationBatchResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchLaunch *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"async_job_id"]) {
    NSString *asyncJobId = valueDict[@"async_job_id"];
    return [[DBFILESRelocationBatchLaunch alloc] initWithAsyncJobId:asyncJobId];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESRelocationBatchResult *complete = [DBFILESRelocationBatchResultSerializer deserialize:valueDict];
    return [[DBFILESRelocationBatchLaunch alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESRelocationBatchLaunch alloc] initWithOther];
  } else {
    return [[DBFILESRelocationBatchLaunch alloc] initWithOther];
  }
}

@end

#import "DBFILESFileOpsResult.h"
#import "DBFILESRelocationBatchResult.h"
#import "DBFILESRelocationBatchResultData.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESRelocationBatchResultData *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super initDefault];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchResult:other];
}

- (BOOL)isEqualToRelocationBatchResult:(DBFILESRelocationBatchResult *)aRelocationBatchResult {
  if (self == aRelocationBatchResult) {
    return YES;
  }
  if (![self.entries isEqual:aRelocationBatchResult.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESRelocationBatchResultDataSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESRelocationBatchResultData *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESRelocationBatchResultDataSerializer deserialize:elem0];
                           }];

  return [[DBFILESRelocationBatchResult alloc] initWithEntries:entries];
}

@end

#import "DBFILESMetadata.h"
#import "DBFILESRelocationBatchResultData.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchResultData

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata {
  [DBStoneValidators nonnullValidator:nil](metadata);

  self = [super init];
  if (self) {
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchResultDataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchResultDataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchResultDataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchResultData:other];
}

- (BOOL)isEqualToRelocationBatchResultData:(DBFILESRelocationBatchResultData *)aRelocationBatchResultData {
  if (self == aRelocationBatchResultData) {
    return YES;
  }
  if (![self.metadata isEqual:aRelocationBatchResultData.metadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchResultDataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchResultData *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESMetadataSerializer serialize:valueObj.metadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchResultData *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESMetadata *metadata = [DBFILESMetadataSerializer deserialize:valueDict[@"metadata"]];

  return [[DBFILESRelocationBatchResultData alloc] initWithMetadata:metadata];
}

@end

#import "DBFILESMetadata.h"
#import "DBFILESRelocationBatchErrorEntry.h"
#import "DBFILESRelocationBatchResultEntry.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchResultEntry

@synthesize success = _success;
@synthesize failure = _failure;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBFILESMetadata *)success {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchResultEntrySuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithFailure:(DBFILESRelocationBatchErrorEntry *)failure {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchResultEntryFailure;
    _failure = failure;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchResultEntryOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESMetadata *)success {
  if (![self isSuccess]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchResultEntrySuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBFILESRelocationBatchErrorEntry *)failure {
  if (![self isFailure]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchResultEntryFailure, but was %@.", [self tagName]];
  }
  return _failure;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBFILESRelocationBatchResultEntrySuccess;
}

- (BOOL)isFailure {
  return _tag == DBFILESRelocationBatchResultEntryFailure;
}

- (BOOL)isOther {
  return _tag == DBFILESRelocationBatchResultEntryOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESRelocationBatchResultEntrySuccess:
    return @"DBFILESRelocationBatchResultEntrySuccess";
  case DBFILESRelocationBatchResultEntryFailure:
    return @"DBFILESRelocationBatchResultEntryFailure";
  case DBFILESRelocationBatchResultEntryOther:
    return @"DBFILESRelocationBatchResultEntryOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchResultEntrySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchResultEntrySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchResultEntrySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESRelocationBatchResultEntrySuccess:
    result = prime * result + [self.success hash];
    break;
  case DBFILESRelocationBatchResultEntryFailure:
    result = prime * result + [self.failure hash];
    break;
  case DBFILESRelocationBatchResultEntryOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchResultEntry:other];
}

- (BOOL)isEqualToRelocationBatchResultEntry:(DBFILESRelocationBatchResultEntry *)aRelocationBatchResultEntry {
  if (self == aRelocationBatchResultEntry) {
    return YES;
  }
  if (self.tag != aRelocationBatchResultEntry.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESRelocationBatchResultEntrySuccess:
    return [self.success isEqual:aRelocationBatchResultEntry.success];
  case DBFILESRelocationBatchResultEntryFailure:
    return [self.failure isEqual:aRelocationBatchResultEntry.failure];
  case DBFILESRelocationBatchResultEntryOther:
    return [[self tagName] isEqual:[aRelocationBatchResultEntry tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchResultEntrySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchResultEntry *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict[@"success"] = [[DBFILESMetadataSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isFailure]) {
    jsonDict[@"failure"] = [[DBFILESRelocationBatchErrorEntrySerializer serialize:valueObj.failure] mutableCopy];
    jsonDict[@".tag"] = @"failure";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchResultEntry *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBFILESMetadata *success = [DBFILESMetadataSerializer deserialize:valueDict[@"success"]];
    return [[DBFILESRelocationBatchResultEntry alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"failure"]) {
    DBFILESRelocationBatchErrorEntry *failure =
        [DBFILESRelocationBatchErrorEntrySerializer deserialize:valueDict[@"failure"]];
    return [[DBFILESRelocationBatchResultEntry alloc] initWithFailure:failure];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESRelocationBatchResultEntry alloc] initWithOther];
  } else {
    return [[DBFILESRelocationBatchResultEntry alloc] initWithOther];
  }
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBFILESRelocationBatchV2JobStatus.h"
#import "DBFILESRelocationBatchV2Result.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchV2JobStatus

@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchV2JobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESRelocationBatchV2Result *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchV2JobStatusComplete;
    _complete = complete;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESRelocationBatchV2Result *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchV2JobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBFILESRelocationBatchV2JobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBFILESRelocationBatchV2JobStatusComplete;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESRelocationBatchV2JobStatusInProgress:
    return @"DBFILESRelocationBatchV2JobStatusInProgress";
  case DBFILESRelocationBatchV2JobStatusComplete:
    return @"DBFILESRelocationBatchV2JobStatusComplete";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchV2JobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchV2JobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchV2JobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESRelocationBatchV2JobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRelocationBatchV2JobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchV2JobStatus:other];
}

- (BOOL)isEqualToRelocationBatchV2JobStatus:(DBFILESRelocationBatchV2JobStatus *)aRelocationBatchV2JobStatus {
  if (self == aRelocationBatchV2JobStatus) {
    return YES;
  }
  if (self.tag != aRelocationBatchV2JobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESRelocationBatchV2JobStatusInProgress:
    return [[self tagName] isEqual:[aRelocationBatchV2JobStatus tagName]];
  case DBFILESRelocationBatchV2JobStatusComplete:
    return [self.complete isEqual:aRelocationBatchV2JobStatus.complete];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchV2JobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchV2JobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESRelocationBatchV2ResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchV2JobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBFILESRelocationBatchV2JobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESRelocationBatchV2Result *complete = [DBFILESRelocationBatchV2ResultSerializer deserialize:valueDict];
    return [[DBFILESRelocationBatchV2JobStatus alloc] initWithComplete:complete];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBASYNCLaunchResultBase.h"
#import "DBFILESRelocationBatchV2Launch.h"
#import "DBFILESRelocationBatchV2Result.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchV2Launch

@synthesize asyncJobId = _asyncJobId;
@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchV2LaunchAsyncJobId;
    _asyncJobId = asyncJobId;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESRelocationBatchV2Result *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESRelocationBatchV2LaunchComplete;
    _complete = complete;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)asyncJobId {
  if (![self isAsyncJobId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchV2LaunchAsyncJobId, but was %@.", [self tagName]];
  }
  return _asyncJobId;
}

- (DBFILESRelocationBatchV2Result *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRelocationBatchV2LaunchComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isAsyncJobId {
  return _tag == DBFILESRelocationBatchV2LaunchAsyncJobId;
}

- (BOOL)isComplete {
  return _tag == DBFILESRelocationBatchV2LaunchComplete;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESRelocationBatchV2LaunchAsyncJobId:
    return @"DBFILESRelocationBatchV2LaunchAsyncJobId";
  case DBFILESRelocationBatchV2LaunchComplete:
    return @"DBFILESRelocationBatchV2LaunchComplete";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchV2LaunchSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchV2LaunchSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchV2LaunchSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESRelocationBatchV2LaunchAsyncJobId:
    result = prime * result + [self.asyncJobId hash];
    break;
  case DBFILESRelocationBatchV2LaunchComplete:
    result = prime * result + [self.complete hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchV2Launch:other];
}

- (BOOL)isEqualToRelocationBatchV2Launch:(DBFILESRelocationBatchV2Launch *)aRelocationBatchV2Launch {
  if (self == aRelocationBatchV2Launch) {
    return YES;
  }
  if (self.tag != aRelocationBatchV2Launch.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESRelocationBatchV2LaunchAsyncJobId:
    return [self.asyncJobId isEqual:aRelocationBatchV2Launch.asyncJobId];
  case DBFILESRelocationBatchV2LaunchComplete:
    return [self.complete isEqual:aRelocationBatchV2Launch.complete];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchV2LaunchSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchV2Launch *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAsyncJobId]) {
    jsonDict[@"async_job_id"] = valueObj.asyncJobId;
    jsonDict[@".tag"] = @"async_job_id";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESRelocationBatchV2ResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchV2Launch *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"async_job_id"]) {
    NSString *asyncJobId = valueDict[@"async_job_id"];
    return [[DBFILESRelocationBatchV2Launch alloc] initWithAsyncJobId:asyncJobId];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESRelocationBatchV2Result *complete = [DBFILESRelocationBatchV2ResultSerializer deserialize:valueDict];
    return [[DBFILESRelocationBatchV2Launch alloc] initWithComplete:complete];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESFileOpsResult.h"
#import "DBFILESRelocationBatchResultEntry.h"
#import "DBFILESRelocationBatchV2Result.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationBatchV2Result

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESRelocationBatchResultEntry *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super initDefault];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationBatchV2ResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationBatchV2ResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationBatchV2ResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationBatchV2Result:other];
}

- (BOOL)isEqualToRelocationBatchV2Result:(DBFILESRelocationBatchV2Result *)aRelocationBatchV2Result {
  if (self == aRelocationBatchV2Result) {
    return YES;
  }
  if (![self.entries isEqual:aRelocationBatchV2Result.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationBatchV2ResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchV2Result *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESRelocationBatchResultEntrySerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationBatchV2Result *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESRelocationBatchResultEntry *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESRelocationBatchResultEntrySerializer deserialize:elem0];
                           }];

  return [[DBFILESRelocationBatchV2Result alloc] initWithEntries:entries];
}

@end

#import "DBFILESFileOpsResult.h"
#import "DBFILESMetadata.h"
#import "DBFILESRelocationResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRelocationResult

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata {
  [DBStoneValidators nonnullValidator:nil](metadata);

  self = [super initDefault];
  if (self) {
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRelocationResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRelocationResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRelocationResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelocationResult:other];
}

- (BOOL)isEqualToRelocationResult:(DBFILESRelocationResult *)aRelocationResult {
  if (self == aRelocationResult) {
    return YES;
  }
  if (![self.metadata isEqual:aRelocationResult.metadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRelocationResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESMetadataSerializer serialize:valueObj.metadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRelocationResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESMetadata *metadata = [DBFILESMetadataSerializer deserialize:valueDict[@"metadata"]];

  return [[DBFILESRelocationResult alloc] initWithMetadata:metadata];
}

@end

#import "DBFILESRestoreArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRestoreArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path rev:(NSString *)rev {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil
                                                               maxLength:nil
                                                                 pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)"]](path);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(9) maxLength:nil pattern:@"[0-9a-f]+"]](rev);

  self = [super init];
  if (self) {
    _path = path;
    _rev = rev;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRestoreArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRestoreArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRestoreArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.rev hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRestoreArg:other];
}

- (BOOL)isEqualToRestoreArg:(DBFILESRestoreArg *)aRestoreArg {
  if (self == aRestoreArg) {
    return YES;
  }
  if (![self.path isEqual:aRestoreArg.path]) {
    return NO;
  }
  if (![self.rev isEqual:aRestoreArg.rev]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRestoreArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRestoreArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"rev"] = valueObj.rev;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRestoreArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSString *rev = valueDict[@"rev"];

  return [[DBFILESRestoreArg alloc] initWithPath:path rev:rev];
}

@end

#import "DBFILESLookupError.h"
#import "DBFILESRestoreError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESRestoreError

@synthesize pathLookup = _pathLookup;
@synthesize pathWrite = _pathWrite;

#pragma mark - Constructors

- (instancetype)initWithPathLookup:(DBFILESLookupError *)pathLookup {
  self = [super init];
  if (self) {
    _tag = DBFILESRestoreErrorPathLookup;
    _pathLookup = pathLookup;
  }
  return self;
}

- (instancetype)initWithPathWrite:(DBFILESWriteError *)pathWrite {
  self = [super init];
  if (self) {
    _tag = DBFILESRestoreErrorPathWrite;
    _pathWrite = pathWrite;
  }
  return self;
}

- (instancetype)initWithInvalidRevision {
  self = [super init];
  if (self) {
    _tag = DBFILESRestoreErrorInvalidRevision;
  }
  return self;
}

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBFILESRestoreErrorInProgress;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESRestoreErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)pathLookup {
  if (![self isPathLookup]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRestoreErrorPathLookup, but was %@.", [self tagName]];
  }
  return _pathLookup;
}

- (DBFILESWriteError *)pathWrite {
  if (![self isPathWrite]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESRestoreErrorPathWrite, but was %@.", [self tagName]];
  }
  return _pathWrite;
}

#pragma mark - Tag state methods

- (BOOL)isPathLookup {
  return _tag == DBFILESRestoreErrorPathLookup;
}

- (BOOL)isPathWrite {
  return _tag == DBFILESRestoreErrorPathWrite;
}

- (BOOL)isInvalidRevision {
  return _tag == DBFILESRestoreErrorInvalidRevision;
}

- (BOOL)isInProgress {
  return _tag == DBFILESRestoreErrorInProgress;
}

- (BOOL)isOther {
  return _tag == DBFILESRestoreErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESRestoreErrorPathLookup:
    return @"DBFILESRestoreErrorPathLookup";
  case DBFILESRestoreErrorPathWrite:
    return @"DBFILESRestoreErrorPathWrite";
  case DBFILESRestoreErrorInvalidRevision:
    return @"DBFILESRestoreErrorInvalidRevision";
  case DBFILESRestoreErrorInProgress:
    return @"DBFILESRestoreErrorInProgress";
  case DBFILESRestoreErrorOther:
    return @"DBFILESRestoreErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESRestoreErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESRestoreErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESRestoreErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESRestoreErrorPathLookup:
    result = prime * result + [self.pathLookup hash];
    break;
  case DBFILESRestoreErrorPathWrite:
    result = prime * result + [self.pathWrite hash];
    break;
  case DBFILESRestoreErrorInvalidRevision:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRestoreErrorInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESRestoreErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRestoreError:other];
}

- (BOOL)isEqualToRestoreError:(DBFILESRestoreError *)aRestoreError {
  if (self == aRestoreError) {
    return YES;
  }
  if (self.tag != aRestoreError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESRestoreErrorPathLookup:
    return [self.pathLookup isEqual:aRestoreError.pathLookup];
  case DBFILESRestoreErrorPathWrite:
    return [self.pathWrite isEqual:aRestoreError.pathWrite];
  case DBFILESRestoreErrorInvalidRevision:
    return [[self tagName] isEqual:[aRestoreError tagName]];
  case DBFILESRestoreErrorInProgress:
    return [[self tagName] isEqual:[aRestoreError tagName]];
  case DBFILESRestoreErrorOther:
    return [[self tagName] isEqual:[aRestoreError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESRestoreErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESRestoreError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPathLookup]) {
    jsonDict[@"path_lookup"] = [[DBFILESLookupErrorSerializer serialize:valueObj.pathLookup] mutableCopy];
    jsonDict[@".tag"] = @"path_lookup";
  } else if ([valueObj isPathWrite]) {
    jsonDict[@"path_write"] = [[DBFILESWriteErrorSerializer serialize:valueObj.pathWrite] mutableCopy];
    jsonDict[@".tag"] = @"path_write";
  } else if ([valueObj isInvalidRevision]) {
    jsonDict[@".tag"] = @"invalid_revision";
  } else if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESRestoreError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path_lookup"]) {
    DBFILESLookupError *pathLookup = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path_lookup"]];
    return [[DBFILESRestoreError alloc] initWithPathLookup:pathLookup];
  } else if ([tag isEqualToString:@"path_write"]) {
    DBFILESWriteError *pathWrite = [DBFILESWriteErrorSerializer deserialize:valueDict[@"path_write"]];
    return [[DBFILESRestoreError alloc] initWithPathWrite:pathWrite];
  } else if ([tag isEqualToString:@"invalid_revision"]) {
    return [[DBFILESRestoreError alloc] initWithInvalidRevision];
  } else if ([tag isEqualToString:@"in_progress"]) {
    return [[DBFILESRestoreError alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESRestoreError alloc] initWithOther];
  } else {
    return [[DBFILESRestoreError alloc] initWithOther];
  }
}

@end

#import "DBFILESSaveCopyReferenceArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSaveCopyReferenceArg

#pragma mark - Constructors

- (instancetype)initWithDCopyReference:(NSString *)dCopyReference path:(NSString *)path {
  [DBStoneValidators nonnullValidator:nil](dCopyReference);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"/(.|[\\r\\n])*"]](path);

  self = [super init];
  if (self) {
    _dCopyReference = dCopyReference;
    _path = path;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSaveCopyReferenceArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSaveCopyReferenceArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSaveCopyReferenceArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dCopyReference hash];
  result = prime * result + [self.path hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSaveCopyReferenceArg:other];
}

- (BOOL)isEqualToSaveCopyReferenceArg:(DBFILESSaveCopyReferenceArg *)aSaveCopyReferenceArg {
  if (self == aSaveCopyReferenceArg) {
    return YES;
  }
  if (![self.dCopyReference isEqual:aSaveCopyReferenceArg.dCopyReference]) {
    return NO;
  }
  if (![self.path isEqual:aSaveCopyReferenceArg.path]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSaveCopyReferenceArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSaveCopyReferenceArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"copy_reference"] = valueObj.dCopyReference;
  jsonDict[@"path"] = valueObj.path;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSaveCopyReferenceArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *dCopyReference = valueDict[@"copy_reference"];
  NSString *path = valueDict[@"path"];

  return [[DBFILESSaveCopyReferenceArg alloc] initWithDCopyReference:dCopyReference path:path];
}

@end

#import "DBFILESSaveCopyReferenceError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSaveCopyReferenceError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESWriteError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveCopyReferenceErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithInvalidCopyReference {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveCopyReferenceErrorInvalidCopyReference;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveCopyReferenceErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveCopyReferenceErrorNotFound;
  }
  return self;
}

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveCopyReferenceErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveCopyReferenceErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESWriteError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESSaveCopyReferenceErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESSaveCopyReferenceErrorPath;
}

- (BOOL)isInvalidCopyReference {
  return _tag == DBFILESSaveCopyReferenceErrorInvalidCopyReference;
}

- (BOOL)isNoPermission {
  return _tag == DBFILESSaveCopyReferenceErrorNoPermission;
}

- (BOOL)isNotFound {
  return _tag == DBFILESSaveCopyReferenceErrorNotFound;
}

- (BOOL)isTooManyFiles {
  return _tag == DBFILESSaveCopyReferenceErrorTooManyFiles;
}

- (BOOL)isOther {
  return _tag == DBFILESSaveCopyReferenceErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSaveCopyReferenceErrorPath:
    return @"DBFILESSaveCopyReferenceErrorPath";
  case DBFILESSaveCopyReferenceErrorInvalidCopyReference:
    return @"DBFILESSaveCopyReferenceErrorInvalidCopyReference";
  case DBFILESSaveCopyReferenceErrorNoPermission:
    return @"DBFILESSaveCopyReferenceErrorNoPermission";
  case DBFILESSaveCopyReferenceErrorNotFound:
    return @"DBFILESSaveCopyReferenceErrorNotFound";
  case DBFILESSaveCopyReferenceErrorTooManyFiles:
    return @"DBFILESSaveCopyReferenceErrorTooManyFiles";
  case DBFILESSaveCopyReferenceErrorOther:
    return @"DBFILESSaveCopyReferenceErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSaveCopyReferenceErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSaveCopyReferenceErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSaveCopyReferenceErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSaveCopyReferenceErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESSaveCopyReferenceErrorInvalidCopyReference:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSaveCopyReferenceErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSaveCopyReferenceErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSaveCopyReferenceErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSaveCopyReferenceErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSaveCopyReferenceError:other];
}

- (BOOL)isEqualToSaveCopyReferenceError:(DBFILESSaveCopyReferenceError *)aSaveCopyReferenceError {
  if (self == aSaveCopyReferenceError) {
    return YES;
  }
  if (self.tag != aSaveCopyReferenceError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSaveCopyReferenceErrorPath:
    return [self.path isEqual:aSaveCopyReferenceError.path];
  case DBFILESSaveCopyReferenceErrorInvalidCopyReference:
    return [[self tagName] isEqual:[aSaveCopyReferenceError tagName]];
  case DBFILESSaveCopyReferenceErrorNoPermission:
    return [[self tagName] isEqual:[aSaveCopyReferenceError tagName]];
  case DBFILESSaveCopyReferenceErrorNotFound:
    return [[self tagName] isEqual:[aSaveCopyReferenceError tagName]];
  case DBFILESSaveCopyReferenceErrorTooManyFiles:
    return [[self tagName] isEqual:[aSaveCopyReferenceError tagName]];
  case DBFILESSaveCopyReferenceErrorOther:
    return [[self tagName] isEqual:[aSaveCopyReferenceError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSaveCopyReferenceErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSaveCopyReferenceError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESWriteErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isInvalidCopyReference]) {
    jsonDict[@".tag"] = @"invalid_copy_reference";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSaveCopyReferenceError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESWriteError *path = [DBFILESWriteErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESSaveCopyReferenceError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"invalid_copy_reference"]) {
    return [[DBFILESSaveCopyReferenceError alloc] initWithInvalidCopyReference];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBFILESSaveCopyReferenceError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILESSaveCopyReferenceError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBFILESSaveCopyReferenceError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESSaveCopyReferenceError alloc] initWithOther];
  } else {
    return [[DBFILESSaveCopyReferenceError alloc] initWithOther];
  }
}

@end

#import "DBFILESMetadata.h"
#import "DBFILESSaveCopyReferenceResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSaveCopyReferenceResult

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata {
  [DBStoneValidators nonnullValidator:nil](metadata);

  self = [super init];
  if (self) {
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSaveCopyReferenceResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSaveCopyReferenceResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSaveCopyReferenceResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSaveCopyReferenceResult:other];
}

- (BOOL)isEqualToSaveCopyReferenceResult:(DBFILESSaveCopyReferenceResult *)aSaveCopyReferenceResult {
  if (self == aSaveCopyReferenceResult) {
    return YES;
  }
  if (![self.metadata isEqual:aSaveCopyReferenceResult.metadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSaveCopyReferenceResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSaveCopyReferenceResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESMetadataSerializer serialize:valueObj.metadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSaveCopyReferenceResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESMetadata *metadata = [DBFILESMetadataSerializer deserialize:valueDict[@"metadata"]];

  return [[DBFILESSaveCopyReferenceResult alloc] initWithMetadata:metadata];
}

@end

#import "DBFILESSaveUrlArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSaveUrlArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path url:(NSString *)url {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"/(.|[\\r\\n])*"]](path);
  [DBStoneValidators nonnullValidator:nil](url);

  self = [super init];
  if (self) {
    _path = path;
    _url = url;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSaveUrlArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSaveUrlArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSaveUrlArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.url hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSaveUrlArg:other];
}

- (BOOL)isEqualToSaveUrlArg:(DBFILESSaveUrlArg *)aSaveUrlArg {
  if (self == aSaveUrlArg) {
    return YES;
  }
  if (![self.path isEqual:aSaveUrlArg.path]) {
    return NO;
  }
  if (![self.url isEqual:aSaveUrlArg.url]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSaveUrlArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSaveUrlArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"url"] = valueObj.url;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSaveUrlArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSString *url = valueDict[@"url"];

  return [[DBFILESSaveUrlArg alloc] initWithPath:path url:url];
}

@end

#import "DBFILESSaveUrlError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSaveUrlError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESWriteError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithDownloadFailed {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlErrorDownloadFailed;
  }
  return self;
}

- (instancetype)initWithInvalidUrl {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlErrorInvalidUrl;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlErrorNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESWriteError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESSaveUrlErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESSaveUrlErrorPath;
}

- (BOOL)isDownloadFailed {
  return _tag == DBFILESSaveUrlErrorDownloadFailed;
}

- (BOOL)isInvalidUrl {
  return _tag == DBFILESSaveUrlErrorInvalidUrl;
}

- (BOOL)isNotFound {
  return _tag == DBFILESSaveUrlErrorNotFound;
}

- (BOOL)isOther {
  return _tag == DBFILESSaveUrlErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSaveUrlErrorPath:
    return @"DBFILESSaveUrlErrorPath";
  case DBFILESSaveUrlErrorDownloadFailed:
    return @"DBFILESSaveUrlErrorDownloadFailed";
  case DBFILESSaveUrlErrorInvalidUrl:
    return @"DBFILESSaveUrlErrorInvalidUrl";
  case DBFILESSaveUrlErrorNotFound:
    return @"DBFILESSaveUrlErrorNotFound";
  case DBFILESSaveUrlErrorOther:
    return @"DBFILESSaveUrlErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSaveUrlErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSaveUrlErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSaveUrlErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSaveUrlErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESSaveUrlErrorDownloadFailed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSaveUrlErrorInvalidUrl:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSaveUrlErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSaveUrlErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSaveUrlError:other];
}

- (BOOL)isEqualToSaveUrlError:(DBFILESSaveUrlError *)aSaveUrlError {
  if (self == aSaveUrlError) {
    return YES;
  }
  if (self.tag != aSaveUrlError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSaveUrlErrorPath:
    return [self.path isEqual:aSaveUrlError.path];
  case DBFILESSaveUrlErrorDownloadFailed:
    return [[self tagName] isEqual:[aSaveUrlError tagName]];
  case DBFILESSaveUrlErrorInvalidUrl:
    return [[self tagName] isEqual:[aSaveUrlError tagName]];
  case DBFILESSaveUrlErrorNotFound:
    return [[self tagName] isEqual:[aSaveUrlError tagName]];
  case DBFILESSaveUrlErrorOther:
    return [[self tagName] isEqual:[aSaveUrlError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSaveUrlErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSaveUrlError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESWriteErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isDownloadFailed]) {
    jsonDict[@".tag"] = @"download_failed";
  } else if ([valueObj isInvalidUrl]) {
    jsonDict[@".tag"] = @"invalid_url";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSaveUrlError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESWriteError *path = [DBFILESWriteErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESSaveUrlError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"download_failed"]) {
    return [[DBFILESSaveUrlError alloc] initWithDownloadFailed];
  } else if ([tag isEqualToString:@"invalid_url"]) {
    return [[DBFILESSaveUrlError alloc] initWithInvalidUrl];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILESSaveUrlError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESSaveUrlError alloc] initWithOther];
  } else {
    return [[DBFILESSaveUrlError alloc] initWithOther];
  }
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBFILESFileMetadata.h"
#import "DBFILESSaveUrlError.h"
#import "DBFILESSaveUrlJobStatus.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSaveUrlJobStatus

@synthesize complete = _complete;
@synthesize failed = _failed;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESFileMetadata *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlJobStatusComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithFailed:(DBFILESSaveUrlError *)failed {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlJobStatusFailed;
    _failed = failed;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESFileMetadata *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESSaveUrlJobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

- (DBFILESSaveUrlError *)failed {
  if (![self isFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESSaveUrlJobStatusFailed, but was %@.", [self tagName]];
  }
  return _failed;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBFILESSaveUrlJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBFILESSaveUrlJobStatusComplete;
}

- (BOOL)isFailed {
  return _tag == DBFILESSaveUrlJobStatusFailed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSaveUrlJobStatusInProgress:
    return @"DBFILESSaveUrlJobStatusInProgress";
  case DBFILESSaveUrlJobStatusComplete:
    return @"DBFILESSaveUrlJobStatusComplete";
  case DBFILESSaveUrlJobStatusFailed:
    return @"DBFILESSaveUrlJobStatusFailed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSaveUrlJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSaveUrlJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSaveUrlJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSaveUrlJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSaveUrlJobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBFILESSaveUrlJobStatusFailed:
    result = prime * result + [self.failed hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSaveUrlJobStatus:other];
}

- (BOOL)isEqualToSaveUrlJobStatus:(DBFILESSaveUrlJobStatus *)aSaveUrlJobStatus {
  if (self == aSaveUrlJobStatus) {
    return YES;
  }
  if (self.tag != aSaveUrlJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSaveUrlJobStatusInProgress:
    return [[self tagName] isEqual:[aSaveUrlJobStatus tagName]];
  case DBFILESSaveUrlJobStatusComplete:
    return [self.complete isEqual:aSaveUrlJobStatus.complete];
  case DBFILESSaveUrlJobStatusFailed:
    return [self.failed isEqual:aSaveUrlJobStatus.failed];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSaveUrlJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSaveUrlJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESFileMetadataSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isFailed]) {
    jsonDict[@"failed"] = [[DBFILESSaveUrlErrorSerializer serialize:valueObj.failed] mutableCopy];
    jsonDict[@".tag"] = @"failed";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSaveUrlJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBFILESSaveUrlJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESFileMetadata *complete = [DBFILESFileMetadataSerializer deserialize:valueDict];
    return [[DBFILESSaveUrlJobStatus alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"failed"]) {
    DBFILESSaveUrlError *failed = [DBFILESSaveUrlErrorSerializer deserialize:valueDict[@"failed"]];
    return [[DBFILESSaveUrlJobStatus alloc] initWithFailed:failed];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBASYNCLaunchResultBase.h"
#import "DBFILESFileMetadata.h"
#import "DBFILESSaveUrlResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSaveUrlResult

@synthesize asyncJobId = _asyncJobId;
@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlResultAsyncJobId;
    _asyncJobId = asyncJobId;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESFileMetadata *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESSaveUrlResultComplete;
    _complete = complete;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)asyncJobId {
  if (![self isAsyncJobId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESSaveUrlResultAsyncJobId, but was %@.", [self tagName]];
  }
  return _asyncJobId;
}

- (DBFILESFileMetadata *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESSaveUrlResultComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isAsyncJobId {
  return _tag == DBFILESSaveUrlResultAsyncJobId;
}

- (BOOL)isComplete {
  return _tag == DBFILESSaveUrlResultComplete;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSaveUrlResultAsyncJobId:
    return @"DBFILESSaveUrlResultAsyncJobId";
  case DBFILESSaveUrlResultComplete:
    return @"DBFILESSaveUrlResultComplete";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSaveUrlResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSaveUrlResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSaveUrlResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSaveUrlResultAsyncJobId:
    result = prime * result + [self.asyncJobId hash];
    break;
  case DBFILESSaveUrlResultComplete:
    result = prime * result + [self.complete hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSaveUrlResult:other];
}

- (BOOL)isEqualToSaveUrlResult:(DBFILESSaveUrlResult *)aSaveUrlResult {
  if (self == aSaveUrlResult) {
    return YES;
  }
  if (self.tag != aSaveUrlResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSaveUrlResultAsyncJobId:
    return [self.asyncJobId isEqual:aSaveUrlResult.asyncJobId];
  case DBFILESSaveUrlResultComplete:
    return [self.complete isEqual:aSaveUrlResult.complete];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSaveUrlResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSaveUrlResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAsyncJobId]) {
    jsonDict[@"async_job_id"] = valueObj.asyncJobId;
    jsonDict[@".tag"] = @"async_job_id";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESFileMetadataSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSaveUrlResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"async_job_id"]) {
    NSString *asyncJobId = valueDict[@"async_job_id"];
    return [[DBFILESSaveUrlResult alloc] initWithAsyncJobId:asyncJobId];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESFileMetadata *complete = [DBFILESFileMetadataSerializer deserialize:valueDict];
    return [[DBFILESSaveUrlResult alloc] initWithComplete:complete];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESSearchArg.h"
#import "DBFILESSearchMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                       query:(NSString *)query
                       start:(NSNumber *)start
                  maxResults:(NSNumber *)maxResults
                        mode:(DBFILESSearchMode *)mode {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)?|id:.*|(ns:[0-9]+(/.*)?)"]](path);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:@(1000) pattern:nil]](query);

  self = [super init];
  if (self) {
    _path = path;
    _query = query;
    _start = start ?: @(0);
    _maxResults = maxResults ?: @(100);
    _mode = mode ?: [[DBFILESSearchMode alloc] initWithFilename];
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path query:(NSString *)query {
  return [self initWithPath:path query:query start:nil maxResults:nil mode:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.query hash];
  result = prime * result + [self.start hash];
  result = prime * result + [self.maxResults hash];
  result = prime * result + [self.mode hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchArg:other];
}

- (BOOL)isEqualToSearchArg:(DBFILESSearchArg *)aSearchArg {
  if (self == aSearchArg) {
    return YES;
  }
  if (![self.path isEqual:aSearchArg.path]) {
    return NO;
  }
  if (![self.query isEqual:aSearchArg.query]) {
    return NO;
  }
  if (![self.start isEqual:aSearchArg.start]) {
    return NO;
  }
  if (![self.maxResults isEqual:aSearchArg.maxResults]) {
    return NO;
  }
  if (![self.mode isEqual:aSearchArg.mode]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"query"] = valueObj.query;
  jsonDict[@"start"] = valueObj.start;
  jsonDict[@"max_results"] = valueObj.maxResults;
  jsonDict[@"mode"] = [DBFILESSearchModeSerializer serialize:valueObj.mode];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSString *query = valueDict[@"query"];
  NSNumber *start = valueDict[@"start"] ?: @(0);
  NSNumber *maxResults = valueDict[@"max_results"] ?: @(100);
  DBFILESSearchMode *mode = valueDict[@"mode"] ? [DBFILESSearchModeSerializer deserialize:valueDict[@"mode"]]
                                               : [[DBFILESSearchMode alloc] initWithFilename];

  return [[DBFILESSearchArg alloc] initWithPath:path query:query start:start maxResults:maxResults mode:mode];
}

@end

#import "DBFILESLookupError.h"
#import "DBFILESSearchError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchError

@synthesize path = _path;
@synthesize invalidArgument = _invalidArgument;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithInvalidArgument:(NSString *)invalidArgument {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchErrorInvalidArgument;
    _invalidArgument = invalidArgument;
  }
  return self;
}

- (instancetype)initWithInternalError {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchErrorInternalError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESSearchErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

- (NSString *)invalidArgument {
  if (![self isInvalidArgument]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESSearchErrorInvalidArgument, but was %@.", [self tagName]];
  }
  return _invalidArgument;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESSearchErrorPath;
}

- (BOOL)isInvalidArgument {
  return _tag == DBFILESSearchErrorInvalidArgument;
}

- (BOOL)isInternalError {
  return _tag == DBFILESSearchErrorInternalError;
}

- (BOOL)isOther {
  return _tag == DBFILESSearchErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSearchErrorPath:
    return @"DBFILESSearchErrorPath";
  case DBFILESSearchErrorInvalidArgument:
    return @"DBFILESSearchErrorInvalidArgument";
  case DBFILESSearchErrorInternalError:
    return @"DBFILESSearchErrorInternalError";
  case DBFILESSearchErrorOther:
    return @"DBFILESSearchErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSearchErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESSearchErrorInvalidArgument:
    if (self.invalidArgument != nil) {
      result = prime * result + [self.invalidArgument hash];
    }
    break;
  case DBFILESSearchErrorInternalError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchError:other];
}

- (BOOL)isEqualToSearchError:(DBFILESSearchError *)aSearchError {
  if (self == aSearchError) {
    return YES;
  }
  if (self.tag != aSearchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSearchErrorPath:
    return [self.path isEqual:aSearchError.path];
  case DBFILESSearchErrorInvalidArgument:
    if (self.invalidArgument) {
      return [self.invalidArgument isEqual:aSearchError.invalidArgument];
    }
  case DBFILESSearchErrorInternalError:
    return [[self tagName] isEqual:[aSearchError tagName]];
  case DBFILESSearchErrorOther:
    return [[self tagName] isEqual:[aSearchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isInvalidArgument]) {
    if (valueObj.invalidArgument) {
      jsonDict[@"invalid_argument"] = valueObj.invalidArgument;
    }
    jsonDict[@".tag"] = @"invalid_argument";
  } else if ([valueObj isInternalError]) {
    jsonDict[@".tag"] = @"internal_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESSearchError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"invalid_argument"]) {
    NSString *invalidArgument = valueDict[@"invalid_argument"] ? valueDict[@"invalid_argument"] : nil;
    return [[DBFILESSearchError alloc] initWithInvalidArgument:invalidArgument];
  } else if ([tag isEqualToString:@"internal_error"]) {
    return [[DBFILESSearchError alloc] initWithInternalError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESSearchError alloc] initWithOther];
  } else {
    return [[DBFILESSearchError alloc] initWithOther];
  }
}

@end

#import "DBFILESMetadata.h"
#import "DBFILESSearchMatch.h"
#import "DBFILESSearchMatchType.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchMatch

#pragma mark - Constructors

- (instancetype)initWithMatchType:(DBFILESSearchMatchType *)matchType metadata:(DBFILESMetadata *)metadata {
  [DBStoneValidators nonnullValidator:nil](matchType);
  [DBStoneValidators nonnullValidator:nil](metadata);

  self = [super init];
  if (self) {
    _matchType = matchType;
    _metadata = metadata;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchMatchSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchMatchSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchMatchSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.matchType hash];
  result = prime * result + [self.metadata hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchMatch:other];
}

- (BOOL)isEqualToSearchMatch:(DBFILESSearchMatch *)aSearchMatch {
  if (self == aSearchMatch) {
    return YES;
  }
  if (![self.matchType isEqual:aSearchMatch.matchType]) {
    return NO;
  }
  if (![self.metadata isEqual:aSearchMatch.metadata]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchMatchSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchMatch *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"match_type"] = [DBFILESSearchMatchTypeSerializer serialize:valueObj.matchType];
  jsonDict[@"metadata"] = [DBFILESMetadataSerializer serialize:valueObj.metadata];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchMatch *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESSearchMatchType *matchType = [DBFILESSearchMatchTypeSerializer deserialize:valueDict[@"match_type"]];
  DBFILESMetadata *metadata = [DBFILESMetadataSerializer deserialize:valueDict[@"metadata"]];

  return [[DBFILESSearchMatch alloc] initWithMatchType:matchType metadata:metadata];
}

@end

#import "DBFILESSearchMatchFieldOptions.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchMatchFieldOptions

#pragma mark - Constructors

- (instancetype)initWithIncludeHighlights:(NSNumber *)includeHighlights {

  self = [super init];
  if (self) {
    _includeHighlights = includeHighlights ?: @NO;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithIncludeHighlights:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchMatchFieldOptionsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchMatchFieldOptionsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchMatchFieldOptionsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.includeHighlights hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchMatchFieldOptions:other];
}

- (BOOL)isEqualToSearchMatchFieldOptions:(DBFILESSearchMatchFieldOptions *)aSearchMatchFieldOptions {
  if (self == aSearchMatchFieldOptions) {
    return YES;
  }
  if (![self.includeHighlights isEqual:aSearchMatchFieldOptions.includeHighlights]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchMatchFieldOptionsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchMatchFieldOptions *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"include_highlights"] = valueObj.includeHighlights;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchMatchFieldOptions *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *includeHighlights = valueDict[@"include_highlights"] ?: @NO;

  return [[DBFILESSearchMatchFieldOptions alloc] initWithIncludeHighlights:includeHighlights];
}

@end

#import "DBFILESSearchMatchType.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchMatchType

#pragma mark - Constructors

- (instancetype)initWithFilename {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchMatchTypeFilename;
  }
  return self;
}

- (instancetype)initWithContent {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchMatchTypeContent;
  }
  return self;
}

- (instancetype)initWithBoth {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchMatchTypeBoth;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isFilename {
  return _tag == DBFILESSearchMatchTypeFilename;
}

- (BOOL)isContent {
  return _tag == DBFILESSearchMatchTypeContent;
}

- (BOOL)isBoth {
  return _tag == DBFILESSearchMatchTypeBoth;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSearchMatchTypeFilename:
    return @"DBFILESSearchMatchTypeFilename";
  case DBFILESSearchMatchTypeContent:
    return @"DBFILESSearchMatchTypeContent";
  case DBFILESSearchMatchTypeBoth:
    return @"DBFILESSearchMatchTypeBoth";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchMatchTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchMatchTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchMatchTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSearchMatchTypeFilename:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchMatchTypeContent:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchMatchTypeBoth:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchMatchType:other];
}

- (BOOL)isEqualToSearchMatchType:(DBFILESSearchMatchType *)aSearchMatchType {
  if (self == aSearchMatchType) {
    return YES;
  }
  if (self.tag != aSearchMatchType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSearchMatchTypeFilename:
    return [[self tagName] isEqual:[aSearchMatchType tagName]];
  case DBFILESSearchMatchTypeContent:
    return [[self tagName] isEqual:[aSearchMatchType tagName]];
  case DBFILESSearchMatchTypeBoth:
    return [[self tagName] isEqual:[aSearchMatchType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchMatchTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchMatchType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFilename]) {
    jsonDict[@".tag"] = @"filename";
  } else if ([valueObj isContent]) {
    jsonDict[@".tag"] = @"content";
  } else if ([valueObj isBoth]) {
    jsonDict[@".tag"] = @"both";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchMatchType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"filename"]) {
    return [[DBFILESSearchMatchType alloc] initWithFilename];
  } else if ([tag isEqualToString:@"content"]) {
    return [[DBFILESSearchMatchType alloc] initWithContent];
  } else if ([tag isEqualToString:@"both"]) {
    return [[DBFILESSearchMatchType alloc] initWithBoth];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESSearchMatchTypeV2.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchMatchTypeV2

#pragma mark - Constructors

- (instancetype)initWithFilename {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchMatchTypeV2Filename;
  }
  return self;
}

- (instancetype)initWithFileContent {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchMatchTypeV2FileContent;
  }
  return self;
}

- (instancetype)initWithFilenameAndContent {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchMatchTypeV2FilenameAndContent;
  }
  return self;
}

- (instancetype)initWithImageContent {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchMatchTypeV2ImageContent;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchMatchTypeV2Other;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isFilename {
  return _tag == DBFILESSearchMatchTypeV2Filename;
}

- (BOOL)isFileContent {
  return _tag == DBFILESSearchMatchTypeV2FileContent;
}

- (BOOL)isFilenameAndContent {
  return _tag == DBFILESSearchMatchTypeV2FilenameAndContent;
}

- (BOOL)isImageContent {
  return _tag == DBFILESSearchMatchTypeV2ImageContent;
}

- (BOOL)isOther {
  return _tag == DBFILESSearchMatchTypeV2Other;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSearchMatchTypeV2Filename:
    return @"DBFILESSearchMatchTypeV2Filename";
  case DBFILESSearchMatchTypeV2FileContent:
    return @"DBFILESSearchMatchTypeV2FileContent";
  case DBFILESSearchMatchTypeV2FilenameAndContent:
    return @"DBFILESSearchMatchTypeV2FilenameAndContent";
  case DBFILESSearchMatchTypeV2ImageContent:
    return @"DBFILESSearchMatchTypeV2ImageContent";
  case DBFILESSearchMatchTypeV2Other:
    return @"DBFILESSearchMatchTypeV2Other";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchMatchTypeV2Serializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchMatchTypeV2Serializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchMatchTypeV2Serializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSearchMatchTypeV2Filename:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchMatchTypeV2FileContent:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchMatchTypeV2FilenameAndContent:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchMatchTypeV2ImageContent:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchMatchTypeV2Other:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchMatchTypeV2:other];
}

- (BOOL)isEqualToSearchMatchTypeV2:(DBFILESSearchMatchTypeV2 *)aSearchMatchTypeV2 {
  if (self == aSearchMatchTypeV2) {
    return YES;
  }
  if (self.tag != aSearchMatchTypeV2.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSearchMatchTypeV2Filename:
    return [[self tagName] isEqual:[aSearchMatchTypeV2 tagName]];
  case DBFILESSearchMatchTypeV2FileContent:
    return [[self tagName] isEqual:[aSearchMatchTypeV2 tagName]];
  case DBFILESSearchMatchTypeV2FilenameAndContent:
    return [[self tagName] isEqual:[aSearchMatchTypeV2 tagName]];
  case DBFILESSearchMatchTypeV2ImageContent:
    return [[self tagName] isEqual:[aSearchMatchTypeV2 tagName]];
  case DBFILESSearchMatchTypeV2Other:
    return [[self tagName] isEqual:[aSearchMatchTypeV2 tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchMatchTypeV2Serializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchMatchTypeV2 *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFilename]) {
    jsonDict[@".tag"] = @"filename";
  } else if ([valueObj isFileContent]) {
    jsonDict[@".tag"] = @"file_content";
  } else if ([valueObj isFilenameAndContent]) {
    jsonDict[@".tag"] = @"filename_and_content";
  } else if ([valueObj isImageContent]) {
    jsonDict[@".tag"] = @"image_content";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchMatchTypeV2 *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"filename"]) {
    return [[DBFILESSearchMatchTypeV2 alloc] initWithFilename];
  } else if ([tag isEqualToString:@"file_content"]) {
    return [[DBFILESSearchMatchTypeV2 alloc] initWithFileContent];
  } else if ([tag isEqualToString:@"filename_and_content"]) {
    return [[DBFILESSearchMatchTypeV2 alloc] initWithFilenameAndContent];
  } else if ([tag isEqualToString:@"image_content"]) {
    return [[DBFILESSearchMatchTypeV2 alloc] initWithImageContent];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESSearchMatchTypeV2 alloc] initWithOther];
  } else {
    return [[DBFILESSearchMatchTypeV2 alloc] initWithOther];
  }
}

@end

#import "DBFILESHighlightSpan.h"
#import "DBFILESMetadataV2.h"
#import "DBFILESSearchMatchTypeV2.h"
#import "DBFILESSearchMatchV2.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchMatchV2

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBFILESMetadataV2 *)metadata
                       matchType:(DBFILESSearchMatchTypeV2 *)matchType
                  highlightSpans:(NSArray<DBFILESHighlightSpan *> *)highlightSpans {
  [DBStoneValidators nonnullValidator:nil](metadata);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](highlightSpans);

  self = [super init];
  if (self) {
    _metadata = metadata;
    _matchType = matchType;
    _highlightSpans = highlightSpans;
  }
  return self;
}

- (instancetype)initWithMetadata:(DBFILESMetadataV2 *)metadata {
  return [self initWithMetadata:metadata matchType:nil highlightSpans:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchMatchV2Serializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchMatchV2Serializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchMatchV2Serializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.metadata hash];
  if (self.matchType != nil) {
    result = prime * result + [self.matchType hash];
  }
  if (self.highlightSpans != nil) {
    result = prime * result + [self.highlightSpans hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchMatchV2:other];
}

- (BOOL)isEqualToSearchMatchV2:(DBFILESSearchMatchV2 *)aSearchMatchV2 {
  if (self == aSearchMatchV2) {
    return YES;
  }
  if (![self.metadata isEqual:aSearchMatchV2.metadata]) {
    return NO;
  }
  if (self.matchType) {
    if (![self.matchType isEqual:aSearchMatchV2.matchType]) {
      return NO;
    }
  }
  if (self.highlightSpans) {
    if (![self.highlightSpans isEqual:aSearchMatchV2.highlightSpans]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchMatchV2Serializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchMatchV2 *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"metadata"] = [DBFILESMetadataV2Serializer serialize:valueObj.metadata];
  if (valueObj.matchType) {
    jsonDict[@"match_type"] = [DBFILESSearchMatchTypeV2Serializer serialize:valueObj.matchType];
  }
  if (valueObj.highlightSpans) {
    jsonDict[@"highlight_spans"] = [DBArraySerializer serialize:valueObj.highlightSpans
                                                      withBlock:^id(id elem0) {
                                                        return [DBFILESHighlightSpanSerializer serialize:elem0];
                                                      }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchMatchV2 *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESMetadataV2 *metadata = [DBFILESMetadataV2Serializer deserialize:valueDict[@"metadata"]];
  DBFILESSearchMatchTypeV2 *matchType =
      valueDict[@"match_type"] ? [DBFILESSearchMatchTypeV2Serializer deserialize:valueDict[@"match_type"]] : nil;
  NSArray<DBFILESHighlightSpan *> *highlightSpans =
      valueDict[@"highlight_spans"] ? [DBArraySerializer deserialize:valueDict[@"highlight_spans"]
                                                           withBlock:^id(id elem0) {
                                                             return [DBFILESHighlightSpanSerializer deserialize:elem0];
                                                           }]
                                    : nil;

  return [[DBFILESSearchMatchV2 alloc] initWithMetadata:metadata matchType:matchType highlightSpans:highlightSpans];
}

@end

#import "DBFILESSearchMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchMode

#pragma mark - Constructors

- (instancetype)initWithFilename {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchModeFilename;
  }
  return self;
}

- (instancetype)initWithFilenameAndContent {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchModeFilenameAndContent;
  }
  return self;
}

- (instancetype)initWithDeletedFilename {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchModeDeletedFilename;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isFilename {
  return _tag == DBFILESSearchModeFilename;
}

- (BOOL)isFilenameAndContent {
  return _tag == DBFILESSearchModeFilenameAndContent;
}

- (BOOL)isDeletedFilename {
  return _tag == DBFILESSearchModeDeletedFilename;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSearchModeFilename:
    return @"DBFILESSearchModeFilename";
  case DBFILESSearchModeFilenameAndContent:
    return @"DBFILESSearchModeFilenameAndContent";
  case DBFILESSearchModeDeletedFilename:
    return @"DBFILESSearchModeDeletedFilename";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchModeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchModeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchModeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSearchModeFilename:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchModeFilenameAndContent:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchModeDeletedFilename:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchMode:other];
}

- (BOOL)isEqualToSearchMode:(DBFILESSearchMode *)aSearchMode {
  if (self == aSearchMode) {
    return YES;
  }
  if (self.tag != aSearchMode.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSearchModeFilename:
    return [[self tagName] isEqual:[aSearchMode tagName]];
  case DBFILESSearchModeFilenameAndContent:
    return [[self tagName] isEqual:[aSearchMode tagName]];
  case DBFILESSearchModeDeletedFilename:
    return [[self tagName] isEqual:[aSearchMode tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchModeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchMode *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFilename]) {
    jsonDict[@".tag"] = @"filename";
  } else if ([valueObj isFilenameAndContent]) {
    jsonDict[@".tag"] = @"filename_and_content";
  } else if ([valueObj isDeletedFilename]) {
    jsonDict[@".tag"] = @"deleted_filename";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchMode *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"filename"]) {
    return [[DBFILESSearchMode alloc] initWithFilename];
  } else if ([tag isEqualToString:@"filename_and_content"]) {
    return [[DBFILESSearchMode alloc] initWithFilenameAndContent];
  } else if ([tag isEqualToString:@"deleted_filename"]) {
    return [[DBFILESSearchMode alloc] initWithDeletedFilename];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESFileCategory.h"
#import "DBFILESFileStatus.h"
#import "DBFILESSearchOptions.h"
#import "DBFILESSearchOrderBy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchOptions

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                  maxResults:(NSNumber *)maxResults
                     orderBy:(DBFILESSearchOrderBy *)orderBy
                  fileStatus:(DBFILESFileStatus *)fileStatus
                filenameOnly:(NSNumber *)filenameOnly
              fileExtensions:(NSArray<NSString *> *)fileExtensions
              fileCategories:(NSArray<DBFILESFileCategory *> *)fileCategories {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil
                                              maxLength:nil
                                                pattern:@"(/(.|[\\r\\n])*)?|id:.*|(ns:[0-9]+(/.*)?)"]](path);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](fileExtensions);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](fileCategories);

  self = [super init];
  if (self) {
    _path = path;
    _maxResults = maxResults ?: @(100);
    _orderBy = orderBy;
    _fileStatus = fileStatus ?: [[DBFILESFileStatus alloc] initWithActive];
    _filenameOnly = filenameOnly ?: @NO;
    _fileExtensions = fileExtensions;
    _fileCategories = fileCategories;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithPath:nil
                 maxResults:nil
                    orderBy:nil
                 fileStatus:nil
               filenameOnly:nil
             fileExtensions:nil
             fileCategories:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchOptionsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchOptionsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchOptionsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.path != nil) {
    result = prime * result + [self.path hash];
  }
  result = prime * result + [self.maxResults hash];
  if (self.orderBy != nil) {
    result = prime * result + [self.orderBy hash];
  }
  result = prime * result + [self.fileStatus hash];
  result = prime * result + [self.filenameOnly hash];
  if (self.fileExtensions != nil) {
    result = prime * result + [self.fileExtensions hash];
  }
  if (self.fileCategories != nil) {
    result = prime * result + [self.fileCategories hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchOptions:other];
}

- (BOOL)isEqualToSearchOptions:(DBFILESSearchOptions *)aSearchOptions {
  if (self == aSearchOptions) {
    return YES;
  }
  if (self.path) {
    if (![self.path isEqual:aSearchOptions.path]) {
      return NO;
    }
  }
  if (![self.maxResults isEqual:aSearchOptions.maxResults]) {
    return NO;
  }
  if (self.orderBy) {
    if (![self.orderBy isEqual:aSearchOptions.orderBy]) {
      return NO;
    }
  }
  if (![self.fileStatus isEqual:aSearchOptions.fileStatus]) {
    return NO;
  }
  if (![self.filenameOnly isEqual:aSearchOptions.filenameOnly]) {
    return NO;
  }
  if (self.fileExtensions) {
    if (![self.fileExtensions isEqual:aSearchOptions.fileExtensions]) {
      return NO;
    }
  }
  if (self.fileCategories) {
    if (![self.fileCategories isEqual:aSearchOptions.fileCategories]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchOptionsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchOptions *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.path) {
    jsonDict[@"path"] = valueObj.path;
  }
  jsonDict[@"max_results"] = valueObj.maxResults;
  if (valueObj.orderBy) {
    jsonDict[@"order_by"] = [DBFILESSearchOrderBySerializer serialize:valueObj.orderBy];
  }
  jsonDict[@"file_status"] = [DBFILESFileStatusSerializer serialize:valueObj.fileStatus];
  jsonDict[@"filename_only"] = valueObj.filenameOnly;
  if (valueObj.fileExtensions) {
    jsonDict[@"file_extensions"] = [DBArraySerializer serialize:valueObj.fileExtensions
                                                      withBlock:^id(id elem0) {
                                                        return elem0;
                                                      }];
  }
  if (valueObj.fileCategories) {
    jsonDict[@"file_categories"] = [DBArraySerializer serialize:valueObj.fileCategories
                                                      withBlock:^id(id elem0) {
                                                        return [DBFILESFileCategorySerializer serialize:elem0];
                                                      }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchOptions *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"] ?: nil;
  NSNumber *maxResults = valueDict[@"max_results"] ?: @(100);
  DBFILESSearchOrderBy *orderBy =
      valueDict[@"order_by"] ? [DBFILESSearchOrderBySerializer deserialize:valueDict[@"order_by"]] : nil;
  DBFILESFileStatus *fileStatus = valueDict[@"file_status"]
                                      ? [DBFILESFileStatusSerializer deserialize:valueDict[@"file_status"]]
                                      : [[DBFILESFileStatus alloc] initWithActive];
  NSNumber *filenameOnly = valueDict[@"filename_only"] ?: @NO;
  NSArray<NSString *> *fileExtensions = valueDict[@"file_extensions"]
                                            ? [DBArraySerializer deserialize:valueDict[@"file_extensions"]
                                                                   withBlock:^id(id elem0) {
                                                                     return elem0;
                                                                   }]
                                            : nil;
  NSArray<DBFILESFileCategory *> *fileCategories =
      valueDict[@"file_categories"] ? [DBArraySerializer deserialize:valueDict[@"file_categories"]
                                                           withBlock:^id(id elem0) {
                                                             return [DBFILESFileCategorySerializer deserialize:elem0];
                                                           }]
                                    : nil;

  return [[DBFILESSearchOptions alloc] initWithPath:path
                                         maxResults:maxResults
                                            orderBy:orderBy
                                         fileStatus:fileStatus
                                       filenameOnly:filenameOnly
                                     fileExtensions:fileExtensions
                                     fileCategories:fileCategories];
}

@end

#import "DBFILESSearchOrderBy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchOrderBy

#pragma mark - Constructors

- (instancetype)initWithRelevance {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchOrderByRelevance;
  }
  return self;
}

- (instancetype)initWithLastModifiedTime {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchOrderByLastModifiedTime;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESSearchOrderByOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isRelevance {
  return _tag == DBFILESSearchOrderByRelevance;
}

- (BOOL)isLastModifiedTime {
  return _tag == DBFILESSearchOrderByLastModifiedTime;
}

- (BOOL)isOther {
  return _tag == DBFILESSearchOrderByOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSearchOrderByRelevance:
    return @"DBFILESSearchOrderByRelevance";
  case DBFILESSearchOrderByLastModifiedTime:
    return @"DBFILESSearchOrderByLastModifiedTime";
  case DBFILESSearchOrderByOther:
    return @"DBFILESSearchOrderByOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchOrderBySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchOrderBySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchOrderBySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSearchOrderByRelevance:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchOrderByLastModifiedTime:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSearchOrderByOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchOrderBy:other];
}

- (BOOL)isEqualToSearchOrderBy:(DBFILESSearchOrderBy *)aSearchOrderBy {
  if (self == aSearchOrderBy) {
    return YES;
  }
  if (self.tag != aSearchOrderBy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSearchOrderByRelevance:
    return [[self tagName] isEqual:[aSearchOrderBy tagName]];
  case DBFILESSearchOrderByLastModifiedTime:
    return [[self tagName] isEqual:[aSearchOrderBy tagName]];
  case DBFILESSearchOrderByOther:
    return [[self tagName] isEqual:[aSearchOrderBy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchOrderBySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchOrderBy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isRelevance]) {
    jsonDict[@".tag"] = @"relevance";
  } else if ([valueObj isLastModifiedTime]) {
    jsonDict[@".tag"] = @"last_modified_time";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchOrderBy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"relevance"]) {
    return [[DBFILESSearchOrderBy alloc] initWithRelevance];
  } else if ([tag isEqualToString:@"last_modified_time"]) {
    return [[DBFILESSearchOrderBy alloc] initWithLastModifiedTime];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESSearchOrderBy alloc] initWithOther];
  } else {
    return [[DBFILESSearchOrderBy alloc] initWithOther];
  }
}

@end

#import "DBFILESSearchMatch.h"
#import "DBFILESSearchResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchResult

#pragma mark - Constructors

- (instancetype)initWithMatches:(NSArray<DBFILESSearchMatch *> *)matches more:(NSNumber *)more start:(NSNumber *)start {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](matches);
  [DBStoneValidators nonnullValidator:nil](more);
  [DBStoneValidators nonnullValidator:nil](start);

  self = [super init];
  if (self) {
    _matches = matches;
    _more = more;
    _start = start;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.matches hash];
  result = prime * result + [self.more hash];
  result = prime * result + [self.start hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchResult:other];
}

- (BOOL)isEqualToSearchResult:(DBFILESSearchResult *)aSearchResult {
  if (self == aSearchResult) {
    return YES;
  }
  if (![self.matches isEqual:aSearchResult.matches]) {
    return NO;
  }
  if (![self.more isEqual:aSearchResult.more]) {
    return NO;
  }
  if (![self.start isEqual:aSearchResult.start]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"matches"] = [DBArraySerializer serialize:valueObj.matches
                                            withBlock:^id(id elem0) {
                                              return [DBFILESSearchMatchSerializer serialize:elem0];
                                            }];
  jsonDict[@"more"] = valueObj.more;
  jsonDict[@"start"] = valueObj.start;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESSearchMatch *> *matches =
      [DBArraySerializer deserialize:valueDict[@"matches"]
                           withBlock:^id(id elem0) {
                             return [DBFILESSearchMatchSerializer deserialize:elem0];
                           }];
  NSNumber *more = valueDict[@"more"];
  NSNumber *start = valueDict[@"start"];

  return [[DBFILESSearchResult alloc] initWithMatches:matches more:more start:start];
}

@end

#import "DBFILESSearchMatchFieldOptions.h"
#import "DBFILESSearchOptions.h"
#import "DBFILESSearchV2Arg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchV2Arg

#pragma mark - Constructors

- (instancetype)initWithQuery:(NSString *)query
                      options:(DBFILESSearchOptions *)options
            matchFieldOptions:(DBFILESSearchMatchFieldOptions *)matchFieldOptions
            includeHighlights:(NSNumber *)includeHighlights {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:@(1000) pattern:nil]](query);

  self = [super init];
  if (self) {
    _query = query;
    _options = options;
    _matchFieldOptions = matchFieldOptions;
    _includeHighlights = includeHighlights;
  }
  return self;
}

- (instancetype)initWithQuery:(NSString *)query {
  return [self initWithQuery:query options:nil matchFieldOptions:nil includeHighlights:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchV2ArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchV2ArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchV2ArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.query hash];
  if (self.options != nil) {
    result = prime * result + [self.options hash];
  }
  if (self.matchFieldOptions != nil) {
    result = prime * result + [self.matchFieldOptions hash];
  }
  if (self.includeHighlights != nil) {
    result = prime * result + [self.includeHighlights hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchV2Arg:other];
}

- (BOOL)isEqualToSearchV2Arg:(DBFILESSearchV2Arg *)aSearchV2Arg {
  if (self == aSearchV2Arg) {
    return YES;
  }
  if (![self.query isEqual:aSearchV2Arg.query]) {
    return NO;
  }
  if (self.options) {
    if (![self.options isEqual:aSearchV2Arg.options]) {
      return NO;
    }
  }
  if (self.matchFieldOptions) {
    if (![self.matchFieldOptions isEqual:aSearchV2Arg.matchFieldOptions]) {
      return NO;
    }
  }
  if (self.includeHighlights) {
    if (![self.includeHighlights isEqual:aSearchV2Arg.includeHighlights]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchV2ArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchV2Arg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"query"] = valueObj.query;
  if (valueObj.options) {
    jsonDict[@"options"] = [DBFILESSearchOptionsSerializer serialize:valueObj.options];
  }
  if (valueObj.matchFieldOptions) {
    jsonDict[@"match_field_options"] = [DBFILESSearchMatchFieldOptionsSerializer serialize:valueObj.matchFieldOptions];
  }
  if (valueObj.includeHighlights) {
    jsonDict[@"include_highlights"] = valueObj.includeHighlights;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchV2Arg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *query = valueDict[@"query"];
  DBFILESSearchOptions *options =
      valueDict[@"options"] ? [DBFILESSearchOptionsSerializer deserialize:valueDict[@"options"]] : nil;
  DBFILESSearchMatchFieldOptions *matchFieldOptions =
      valueDict[@"match_field_options"]
          ? [DBFILESSearchMatchFieldOptionsSerializer deserialize:valueDict[@"match_field_options"]]
          : nil;
  NSNumber *includeHighlights = valueDict[@"include_highlights"] ?: nil;

  return [[DBFILESSearchV2Arg alloc] initWithQuery:query
                                           options:options
                                 matchFieldOptions:matchFieldOptions
                                 includeHighlights:includeHighlights];
}

@end

#import "DBFILESSearchV2ContinueArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchV2ContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchV2ContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchV2ContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchV2ContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchV2ContinueArg:other];
}

- (BOOL)isEqualToSearchV2ContinueArg:(DBFILESSearchV2ContinueArg *)aSearchV2ContinueArg {
  if (self == aSearchV2ContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aSearchV2ContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchV2ContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchV2ContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchV2ContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBFILESSearchV2ContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBFILESSearchMatchV2.h"
#import "DBFILESSearchV2Result.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSearchV2Result

#pragma mark - Constructors

- (instancetype)initWithMatches:(NSArray<DBFILESSearchMatchV2 *> *)matches
                        hasMore:(NSNumber *)hasMore
                         cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](matches);
  [DBStoneValidators nonnullValidator:nil](hasMore);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](cursor);

  self = [super init];
  if (self) {
    _matches = matches;
    _hasMore = hasMore;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithMatches:(NSArray<DBFILESSearchMatchV2 *> *)matches hasMore:(NSNumber *)hasMore {
  return [self initWithMatches:matches hasMore:hasMore cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSearchV2ResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSearchV2ResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSearchV2ResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.matches hash];
  result = prime * result + [self.hasMore hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSearchV2Result:other];
}

- (BOOL)isEqualToSearchV2Result:(DBFILESSearchV2Result *)aSearchV2Result {
  if (self == aSearchV2Result) {
    return YES;
  }
  if (![self.matches isEqual:aSearchV2Result.matches]) {
    return NO;
  }
  if (![self.hasMore isEqual:aSearchV2Result.hasMore]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aSearchV2Result.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSearchV2ResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSearchV2Result *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"matches"] = [DBArraySerializer serialize:valueObj.matches
                                            withBlock:^id(id elem0) {
                                              return [DBFILESSearchMatchV2Serializer serialize:elem0];
                                            }];
  jsonDict[@"has_more"] = valueObj.hasMore;
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSearchV2Result *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESSearchMatchV2 *> *matches =
      [DBArraySerializer deserialize:valueDict[@"matches"]
                           withBlock:^id(id elem0) {
                             return [DBFILESSearchMatchV2Serializer deserialize:elem0];
                           }];
  NSNumber *hasMore = valueDict[@"has_more"];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBFILESSearchV2Result alloc] initWithMatches:matches hasMore:hasMore cursor:cursor];
}

@end

#import "DBFILESSharedLink.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSharedLink

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url password:(NSString *)password {
  [DBStoneValidators nonnullValidator:nil](url);

  self = [super init];
  if (self) {
    _url = url;
    _password = password;
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url {
  return [self initWithUrl:url password:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSharedLinkSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSharedLinkSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSharedLinkSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  if (self.password != nil) {
    result = prime * result + [self.password hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLink:other];
}

- (BOOL)isEqualToSharedLink:(DBFILESSharedLink *)aSharedLink {
  if (self == aSharedLink) {
    return YES;
  }
  if (![self.url isEqual:aSharedLink.url]) {
    return NO;
  }
  if (self.password) {
    if (![self.password isEqual:aSharedLink.password]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSharedLinkSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSharedLink *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  if (valueObj.password) {
    jsonDict[@"password"] = valueObj.password;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSharedLink *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  NSString *password = valueDict[@"password"] ?: nil;

  return [[DBFILESSharedLink alloc] initWithUrl:url password:password];
}

@end

#import "DBFILESSharedLinkFileInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSharedLinkFileInfo

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url path:(NSString *)path password:(NSString *)password {
  [DBStoneValidators nonnullValidator:nil](url);

  self = [super init];
  if (self) {
    _url = url;
    _path = path;
    _password = password;
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url {
  return [self initWithUrl:url path:nil password:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSharedLinkFileInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSharedLinkFileInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSharedLinkFileInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  if (self.path != nil) {
    result = prime * result + [self.path hash];
  }
  if (self.password != nil) {
    result = prime * result + [self.password hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLinkFileInfo:other];
}

- (BOOL)isEqualToSharedLinkFileInfo:(DBFILESSharedLinkFileInfo *)aSharedLinkFileInfo {
  if (self == aSharedLinkFileInfo) {
    return YES;
  }
  if (![self.url isEqual:aSharedLinkFileInfo.url]) {
    return NO;
  }
  if (self.path) {
    if (![self.path isEqual:aSharedLinkFileInfo.path]) {
      return NO;
    }
  }
  if (self.password) {
    if (![self.password isEqual:aSharedLinkFileInfo.password]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSharedLinkFileInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSharedLinkFileInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  if (valueObj.path) {
    jsonDict[@"path"] = valueObj.path;
  }
  if (valueObj.password) {
    jsonDict[@"password"] = valueObj.password;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSharedLinkFileInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  NSString *path = valueDict[@"path"] ?: nil;
  NSString *password = valueDict[@"password"] ?: nil;

  return [[DBFILESSharedLinkFileInfo alloc] initWithUrl:url path:path password:password];
}

@end

#import "DBFILESSingleUserLock.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSingleUserLock

#pragma mark - Constructors

- (instancetype)initWithCreated:(NSDate *)created
            lockHolderAccountId:(NSString *)lockHolderAccountId
               lockHolderTeamId:(NSString *)lockHolderTeamId {
  [DBStoneValidators nonnullValidator:nil](created);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(40) maxLength:@(40) pattern:nil]](lockHolderAccountId);

  self = [super init];
  if (self) {
    _created = created;
    _lockHolderAccountId = lockHolderAccountId;
    _lockHolderTeamId = lockHolderTeamId;
  }
  return self;
}

- (instancetype)initWithCreated:(NSDate *)created lockHolderAccountId:(NSString *)lockHolderAccountId {
  return [self initWithCreated:created lockHolderAccountId:lockHolderAccountId lockHolderTeamId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSingleUserLockSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSingleUserLockSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSingleUserLockSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.created hash];
  result = prime * result + [self.lockHolderAccountId hash];
  if (self.lockHolderTeamId != nil) {
    result = prime * result + [self.lockHolderTeamId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSingleUserLock:other];
}

- (BOOL)isEqualToSingleUserLock:(DBFILESSingleUserLock *)aSingleUserLock {
  if (self == aSingleUserLock) {
    return YES;
  }
  if (![self.created isEqual:aSingleUserLock.created]) {
    return NO;
  }
  if (![self.lockHolderAccountId isEqual:aSingleUserLock.lockHolderAccountId]) {
    return NO;
  }
  if (self.lockHolderTeamId) {
    if (![self.lockHolderTeamId isEqual:aSingleUserLock.lockHolderTeamId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSingleUserLockSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSingleUserLock *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"created"] = [DBNSDateSerializer serialize:valueObj.created dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  jsonDict[@"lock_holder_account_id"] = valueObj.lockHolderAccountId;
  if (valueObj.lockHolderTeamId) {
    jsonDict[@"lock_holder_team_id"] = valueObj.lockHolderTeamId;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSingleUserLock *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSDate *created = [DBNSDateSerializer deserialize:valueDict[@"created"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  NSString *lockHolderAccountId = valueDict[@"lock_holder_account_id"];
  NSString *lockHolderTeamId = valueDict[@"lock_holder_team_id"] ?: nil;

  return [[DBFILESSingleUserLock alloc] initWithCreated:created
                                    lockHolderAccountId:lockHolderAccountId
                                       lockHolderTeamId:lockHolderTeamId];
}

@end

#import "DBFILESSymlinkInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSymlinkInfo

#pragma mark - Constructors

- (instancetype)initWithTarget:(NSString *)target {
  [DBStoneValidators nonnullValidator:nil](target);

  self = [super init];
  if (self) {
    _target = target;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSymlinkInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSymlinkInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSymlinkInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.target hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSymlinkInfo:other];
}

- (BOOL)isEqualToSymlinkInfo:(DBFILESSymlinkInfo *)aSymlinkInfo {
  if (self == aSymlinkInfo) {
    return YES;
  }
  if (![self.target isEqual:aSymlinkInfo.target]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSymlinkInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSymlinkInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"target"] = valueObj.target;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSymlinkInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *target = valueDict[@"target"];

  return [[DBFILESSymlinkInfo alloc] initWithTarget:target];
}

@end

#import "DBFILESSyncSetting.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSyncSetting

#pragma mark - Constructors

- (instancetype)initWithDefault_ {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingDefault_;
  }
  return self;
}

- (instancetype)initWithNotSynced {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingNotSynced;
  }
  return self;
}

- (instancetype)initWithNotSyncedInactive {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingNotSyncedInactive;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDefault_ {
  return _tag == DBFILESSyncSettingDefault_;
}

- (BOOL)isNotSynced {
  return _tag == DBFILESSyncSettingNotSynced;
}

- (BOOL)isNotSyncedInactive {
  return _tag == DBFILESSyncSettingNotSyncedInactive;
}

- (BOOL)isOther {
  return _tag == DBFILESSyncSettingOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSyncSettingDefault_:
    return @"DBFILESSyncSettingDefault_";
  case DBFILESSyncSettingNotSynced:
    return @"DBFILESSyncSettingNotSynced";
  case DBFILESSyncSettingNotSyncedInactive:
    return @"DBFILESSyncSettingNotSyncedInactive";
  case DBFILESSyncSettingOther:
    return @"DBFILESSyncSettingOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSyncSettingSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSyncSettingSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSyncSettingSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSyncSettingDefault_:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSyncSettingNotSynced:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSyncSettingNotSyncedInactive:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSyncSettingOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSyncSetting:other];
}

- (BOOL)isEqualToSyncSetting:(DBFILESSyncSetting *)aSyncSetting {
  if (self == aSyncSetting) {
    return YES;
  }
  if (self.tag != aSyncSetting.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSyncSettingDefault_:
    return [[self tagName] isEqual:[aSyncSetting tagName]];
  case DBFILESSyncSettingNotSynced:
    return [[self tagName] isEqual:[aSyncSetting tagName]];
  case DBFILESSyncSettingNotSyncedInactive:
    return [[self tagName] isEqual:[aSyncSetting tagName]];
  case DBFILESSyncSettingOther:
    return [[self tagName] isEqual:[aSyncSetting tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSyncSettingSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSyncSetting *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDefault_]) {
    jsonDict[@".tag"] = @"default";
  } else if ([valueObj isNotSynced]) {
    jsonDict[@".tag"] = @"not_synced";
  } else if ([valueObj isNotSyncedInactive]) {
    jsonDict[@".tag"] = @"not_synced_inactive";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSyncSetting *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"default"]) {
    return [[DBFILESSyncSetting alloc] initWithDefault_];
  } else if ([tag isEqualToString:@"not_synced"]) {
    return [[DBFILESSyncSetting alloc] initWithNotSynced];
  } else if ([tag isEqualToString:@"not_synced_inactive"]) {
    return [[DBFILESSyncSetting alloc] initWithNotSyncedInactive];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESSyncSetting alloc] initWithOther];
  } else {
    return [[DBFILESSyncSetting alloc] initWithOther];
  }
}

@end

#import "DBFILESSyncSettingArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSyncSettingArg

#pragma mark - Constructors

- (instancetype)initWithDefault_ {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingArgDefault_;
  }
  return self;
}

- (instancetype)initWithNotSynced {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingArgNotSynced;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingArgOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDefault_ {
  return _tag == DBFILESSyncSettingArgDefault_;
}

- (BOOL)isNotSynced {
  return _tag == DBFILESSyncSettingArgNotSynced;
}

- (BOOL)isOther {
  return _tag == DBFILESSyncSettingArgOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSyncSettingArgDefault_:
    return @"DBFILESSyncSettingArgDefault_";
  case DBFILESSyncSettingArgNotSynced:
    return @"DBFILESSyncSettingArgNotSynced";
  case DBFILESSyncSettingArgOther:
    return @"DBFILESSyncSettingArgOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSyncSettingArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSyncSettingArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSyncSettingArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSyncSettingArgDefault_:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSyncSettingArgNotSynced:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSyncSettingArgOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSyncSettingArg:other];
}

- (BOOL)isEqualToSyncSettingArg:(DBFILESSyncSettingArg *)aSyncSettingArg {
  if (self == aSyncSettingArg) {
    return YES;
  }
  if (self.tag != aSyncSettingArg.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSyncSettingArgDefault_:
    return [[self tagName] isEqual:[aSyncSettingArg tagName]];
  case DBFILESSyncSettingArgNotSynced:
    return [[self tagName] isEqual:[aSyncSettingArg tagName]];
  case DBFILESSyncSettingArgOther:
    return [[self tagName] isEqual:[aSyncSettingArg tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSyncSettingArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSyncSettingArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDefault_]) {
    jsonDict[@".tag"] = @"default";
  } else if ([valueObj isNotSynced]) {
    jsonDict[@".tag"] = @"not_synced";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSyncSettingArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"default"]) {
    return [[DBFILESSyncSettingArg alloc] initWithDefault_];
  } else if ([tag isEqualToString:@"not_synced"]) {
    return [[DBFILESSyncSettingArg alloc] initWithNotSynced];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESSyncSettingArg alloc] initWithOther];
  } else {
    return [[DBFILESSyncSettingArg alloc] initWithOther];
  }
}

@end

#import "DBFILESLookupError.h"
#import "DBFILESSyncSettingsError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESSyncSettingsError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingsErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithUnsupportedCombination {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingsErrorUnsupportedCombination;
  }
  return self;
}

- (instancetype)initWithUnsupportedConfiguration {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingsErrorUnsupportedConfiguration;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESSyncSettingsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESSyncSettingsErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESSyncSettingsErrorPath;
}

- (BOOL)isUnsupportedCombination {
  return _tag == DBFILESSyncSettingsErrorUnsupportedCombination;
}

- (BOOL)isUnsupportedConfiguration {
  return _tag == DBFILESSyncSettingsErrorUnsupportedConfiguration;
}

- (BOOL)isOther {
  return _tag == DBFILESSyncSettingsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESSyncSettingsErrorPath:
    return @"DBFILESSyncSettingsErrorPath";
  case DBFILESSyncSettingsErrorUnsupportedCombination:
    return @"DBFILESSyncSettingsErrorUnsupportedCombination";
  case DBFILESSyncSettingsErrorUnsupportedConfiguration:
    return @"DBFILESSyncSettingsErrorUnsupportedConfiguration";
  case DBFILESSyncSettingsErrorOther:
    return @"DBFILESSyncSettingsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESSyncSettingsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESSyncSettingsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESSyncSettingsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESSyncSettingsErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESSyncSettingsErrorUnsupportedCombination:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSyncSettingsErrorUnsupportedConfiguration:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESSyncSettingsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSyncSettingsError:other];
}

- (BOOL)isEqualToSyncSettingsError:(DBFILESSyncSettingsError *)aSyncSettingsError {
  if (self == aSyncSettingsError) {
    return YES;
  }
  if (self.tag != aSyncSettingsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESSyncSettingsErrorPath:
    return [self.path isEqual:aSyncSettingsError.path];
  case DBFILESSyncSettingsErrorUnsupportedCombination:
    return [[self tagName] isEqual:[aSyncSettingsError tagName]];
  case DBFILESSyncSettingsErrorUnsupportedConfiguration:
    return [[self tagName] isEqual:[aSyncSettingsError tagName]];
  case DBFILESSyncSettingsErrorOther:
    return [[self tagName] isEqual:[aSyncSettingsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESSyncSettingsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESSyncSettingsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isUnsupportedCombination]) {
    jsonDict[@".tag"] = @"unsupported_combination";
  } else if ([valueObj isUnsupportedConfiguration]) {
    jsonDict[@".tag"] = @"unsupported_configuration";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESSyncSettingsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESSyncSettingsError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"unsupported_combination"]) {
    return [[DBFILESSyncSettingsError alloc] initWithUnsupportedCombination];
  } else if ([tag isEqualToString:@"unsupported_configuration"]) {
    return [[DBFILESSyncSettingsError alloc] initWithUnsupportedConfiguration];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESSyncSettingsError alloc] initWithOther];
  } else {
    return [[DBFILESSyncSettingsError alloc] initWithOther];
  }
}

@end

#import "DBFILESThumbnailArg.h"
#import "DBFILESThumbnailFormat.h"
#import "DBFILESThumbnailMode.h"
#import "DBFILESThumbnailSize.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESThumbnailArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                      format:(DBFILESThumbnailFormat *)format
                        size:(DBFILESThumbnailSize *)size
                        mode:(DBFILESThumbnailMode *)mode {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
    _format = format ?: [[DBFILESThumbnailFormat alloc] initWithJpeg];
    _size = size ?: [[DBFILESThumbnailSize alloc] initWithW64h64];
    _mode = mode ?: [[DBFILESThumbnailMode alloc] initWithStrict];
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path format:nil size:nil mode:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESThumbnailArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESThumbnailArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESThumbnailArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.format hash];
  result = prime * result + [self.size hash];
  result = prime * result + [self.mode hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToThumbnailArg:other];
}

- (BOOL)isEqualToThumbnailArg:(DBFILESThumbnailArg *)aThumbnailArg {
  if (self == aThumbnailArg) {
    return YES;
  }
  if (![self.path isEqual:aThumbnailArg.path]) {
    return NO;
  }
  if (![self.format isEqual:aThumbnailArg.format]) {
    return NO;
  }
  if (![self.size isEqual:aThumbnailArg.size]) {
    return NO;
  }
  if (![self.mode isEqual:aThumbnailArg.mode]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESThumbnailArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"format"] = [DBFILESThumbnailFormatSerializer serialize:valueObj.format];
  jsonDict[@"size"] = [DBFILESThumbnailSizeSerializer serialize:valueObj.size];
  jsonDict[@"mode"] = [DBFILESThumbnailModeSerializer serialize:valueObj.mode];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESThumbnailArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  DBFILESThumbnailFormat *format = valueDict[@"format"]
                                       ? [DBFILESThumbnailFormatSerializer deserialize:valueDict[@"format"]]
                                       : [[DBFILESThumbnailFormat alloc] initWithJpeg];
  DBFILESThumbnailSize *size = valueDict[@"size"] ? [DBFILESThumbnailSizeSerializer deserialize:valueDict[@"size"]]
                                                  : [[DBFILESThumbnailSize alloc] initWithW64h64];
  DBFILESThumbnailMode *mode = valueDict[@"mode"] ? [DBFILESThumbnailModeSerializer deserialize:valueDict[@"mode"]]
                                                  : [[DBFILESThumbnailMode alloc] initWithStrict];

  return [[DBFILESThumbnailArg alloc] initWithPath:path format:format size:size mode:mode];
}

@end

#import "DBFILESLookupError.h"
#import "DBFILESThumbnailError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESThumbnailError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithUnsupportedExtension {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailErrorUnsupportedExtension;
  }
  return self;
}

- (instancetype)initWithUnsupportedImage {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailErrorUnsupportedImage;
  }
  return self;
}

- (instancetype)initWithConversionError {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailErrorConversionError;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESThumbnailErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESThumbnailErrorPath;
}

- (BOOL)isUnsupportedExtension {
  return _tag == DBFILESThumbnailErrorUnsupportedExtension;
}

- (BOOL)isUnsupportedImage {
  return _tag == DBFILESThumbnailErrorUnsupportedImage;
}

- (BOOL)isConversionError {
  return _tag == DBFILESThumbnailErrorConversionError;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESThumbnailErrorPath:
    return @"DBFILESThumbnailErrorPath";
  case DBFILESThumbnailErrorUnsupportedExtension:
    return @"DBFILESThumbnailErrorUnsupportedExtension";
  case DBFILESThumbnailErrorUnsupportedImage:
    return @"DBFILESThumbnailErrorUnsupportedImage";
  case DBFILESThumbnailErrorConversionError:
    return @"DBFILESThumbnailErrorConversionError";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESThumbnailErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESThumbnailErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESThumbnailErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESThumbnailErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESThumbnailErrorUnsupportedExtension:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailErrorUnsupportedImage:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailErrorConversionError:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToThumbnailError:other];
}

- (BOOL)isEqualToThumbnailError:(DBFILESThumbnailError *)aThumbnailError {
  if (self == aThumbnailError) {
    return YES;
  }
  if (self.tag != aThumbnailError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESThumbnailErrorPath:
    return [self.path isEqual:aThumbnailError.path];
  case DBFILESThumbnailErrorUnsupportedExtension:
    return [[self tagName] isEqual:[aThumbnailError tagName]];
  case DBFILESThumbnailErrorUnsupportedImage:
    return [[self tagName] isEqual:[aThumbnailError tagName]];
  case DBFILESThumbnailErrorConversionError:
    return [[self tagName] isEqual:[aThumbnailError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESThumbnailErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isUnsupportedExtension]) {
    jsonDict[@".tag"] = @"unsupported_extension";
  } else if ([valueObj isUnsupportedImage]) {
    jsonDict[@".tag"] = @"unsupported_image";
  } else if ([valueObj isConversionError]) {
    jsonDict[@".tag"] = @"conversion_error";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESThumbnailError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESThumbnailError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"unsupported_extension"]) {
    return [[DBFILESThumbnailError alloc] initWithUnsupportedExtension];
  } else if ([tag isEqualToString:@"unsupported_image"]) {
    return [[DBFILESThumbnailError alloc] initWithUnsupportedImage];
  } else if ([tag isEqualToString:@"conversion_error"]) {
    return [[DBFILESThumbnailError alloc] initWithConversionError];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESThumbnailFormat.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESThumbnailFormat

#pragma mark - Constructors

- (instancetype)initWithJpeg {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailFormatJpeg;
  }
  return self;
}

- (instancetype)initWithPng {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailFormatPng;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isJpeg {
  return _tag == DBFILESThumbnailFormatJpeg;
}

- (BOOL)isPng {
  return _tag == DBFILESThumbnailFormatPng;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESThumbnailFormatJpeg:
    return @"DBFILESThumbnailFormatJpeg";
  case DBFILESThumbnailFormatPng:
    return @"DBFILESThumbnailFormatPng";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESThumbnailFormatSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESThumbnailFormatSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESThumbnailFormatSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESThumbnailFormatJpeg:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailFormatPng:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToThumbnailFormat:other];
}

- (BOOL)isEqualToThumbnailFormat:(DBFILESThumbnailFormat *)aThumbnailFormat {
  if (self == aThumbnailFormat) {
    return YES;
  }
  if (self.tag != aThumbnailFormat.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESThumbnailFormatJpeg:
    return [[self tagName] isEqual:[aThumbnailFormat tagName]];
  case DBFILESThumbnailFormatPng:
    return [[self tagName] isEqual:[aThumbnailFormat tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESThumbnailFormatSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailFormat *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isJpeg]) {
    jsonDict[@".tag"] = @"jpeg";
  } else if ([valueObj isPng]) {
    jsonDict[@".tag"] = @"png";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESThumbnailFormat *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"jpeg"]) {
    return [[DBFILESThumbnailFormat alloc] initWithJpeg];
  } else if ([tag isEqualToString:@"png"]) {
    return [[DBFILESThumbnailFormat alloc] initWithPng];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESThumbnailMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESThumbnailMode

#pragma mark - Constructors

- (instancetype)initWithStrict {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailModeStrict;
  }
  return self;
}

- (instancetype)initWithBestfit {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailModeBestfit;
  }
  return self;
}

- (instancetype)initWithFitoneBestfit {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailModeFitoneBestfit;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isStrict {
  return _tag == DBFILESThumbnailModeStrict;
}

- (BOOL)isBestfit {
  return _tag == DBFILESThumbnailModeBestfit;
}

- (BOOL)isFitoneBestfit {
  return _tag == DBFILESThumbnailModeFitoneBestfit;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESThumbnailModeStrict:
    return @"DBFILESThumbnailModeStrict";
  case DBFILESThumbnailModeBestfit:
    return @"DBFILESThumbnailModeBestfit";
  case DBFILESThumbnailModeFitoneBestfit:
    return @"DBFILESThumbnailModeFitoneBestfit";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESThumbnailModeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESThumbnailModeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESThumbnailModeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESThumbnailModeStrict:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailModeBestfit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailModeFitoneBestfit:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToThumbnailMode:other];
}

- (BOOL)isEqualToThumbnailMode:(DBFILESThumbnailMode *)aThumbnailMode {
  if (self == aThumbnailMode) {
    return YES;
  }
  if (self.tag != aThumbnailMode.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESThumbnailModeStrict:
    return [[self tagName] isEqual:[aThumbnailMode tagName]];
  case DBFILESThumbnailModeBestfit:
    return [[self tagName] isEqual:[aThumbnailMode tagName]];
  case DBFILESThumbnailModeFitoneBestfit:
    return [[self tagName] isEqual:[aThumbnailMode tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESThumbnailModeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailMode *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isStrict]) {
    jsonDict[@".tag"] = @"strict";
  } else if ([valueObj isBestfit]) {
    jsonDict[@".tag"] = @"bestfit";
  } else if ([valueObj isFitoneBestfit]) {
    jsonDict[@".tag"] = @"fitone_bestfit";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESThumbnailMode *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"strict"]) {
    return [[DBFILESThumbnailMode alloc] initWithStrict];
  } else if ([tag isEqualToString:@"bestfit"]) {
    return [[DBFILESThumbnailMode alloc] initWithBestfit];
  } else if ([tag isEqualToString:@"fitone_bestfit"]) {
    return [[DBFILESThumbnailMode alloc] initWithFitoneBestfit];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESThumbnailSize.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESThumbnailSize

#pragma mark - Constructors

- (instancetype)initWithW32h32 {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailSizeW32h32;
  }
  return self;
}

- (instancetype)initWithW64h64 {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailSizeW64h64;
  }
  return self;
}

- (instancetype)initWithW128h128 {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailSizeW128h128;
  }
  return self;
}

- (instancetype)initWithW256h256 {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailSizeW256h256;
  }
  return self;
}

- (instancetype)initWithW480h320 {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailSizeW480h320;
  }
  return self;
}

- (instancetype)initWithW640h480 {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailSizeW640h480;
  }
  return self;
}

- (instancetype)initWithW960h640 {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailSizeW960h640;
  }
  return self;
}

- (instancetype)initWithW1024h768 {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailSizeW1024h768;
  }
  return self;
}

- (instancetype)initWithW2048h1536 {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailSizeW2048h1536;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isW32h32 {
  return _tag == DBFILESThumbnailSizeW32h32;
}

- (BOOL)isW64h64 {
  return _tag == DBFILESThumbnailSizeW64h64;
}

- (BOOL)isW128h128 {
  return _tag == DBFILESThumbnailSizeW128h128;
}

- (BOOL)isW256h256 {
  return _tag == DBFILESThumbnailSizeW256h256;
}

- (BOOL)isW480h320 {
  return _tag == DBFILESThumbnailSizeW480h320;
}

- (BOOL)isW640h480 {
  return _tag == DBFILESThumbnailSizeW640h480;
}

- (BOOL)isW960h640 {
  return _tag == DBFILESThumbnailSizeW960h640;
}

- (BOOL)isW1024h768 {
  return _tag == DBFILESThumbnailSizeW1024h768;
}

- (BOOL)isW2048h1536 {
  return _tag == DBFILESThumbnailSizeW2048h1536;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESThumbnailSizeW32h32:
    return @"DBFILESThumbnailSizeW32h32";
  case DBFILESThumbnailSizeW64h64:
    return @"DBFILESThumbnailSizeW64h64";
  case DBFILESThumbnailSizeW128h128:
    return @"DBFILESThumbnailSizeW128h128";
  case DBFILESThumbnailSizeW256h256:
    return @"DBFILESThumbnailSizeW256h256";
  case DBFILESThumbnailSizeW480h320:
    return @"DBFILESThumbnailSizeW480h320";
  case DBFILESThumbnailSizeW640h480:
    return @"DBFILESThumbnailSizeW640h480";
  case DBFILESThumbnailSizeW960h640:
    return @"DBFILESThumbnailSizeW960h640";
  case DBFILESThumbnailSizeW1024h768:
    return @"DBFILESThumbnailSizeW1024h768";
  case DBFILESThumbnailSizeW2048h1536:
    return @"DBFILESThumbnailSizeW2048h1536";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESThumbnailSizeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESThumbnailSizeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESThumbnailSizeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESThumbnailSizeW32h32:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailSizeW64h64:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailSizeW128h128:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailSizeW256h256:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailSizeW480h320:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailSizeW640h480:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailSizeW960h640:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailSizeW1024h768:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailSizeW2048h1536:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToThumbnailSize:other];
}

- (BOOL)isEqualToThumbnailSize:(DBFILESThumbnailSize *)aThumbnailSize {
  if (self == aThumbnailSize) {
    return YES;
  }
  if (self.tag != aThumbnailSize.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESThumbnailSizeW32h32:
    return [[self tagName] isEqual:[aThumbnailSize tagName]];
  case DBFILESThumbnailSizeW64h64:
    return [[self tagName] isEqual:[aThumbnailSize tagName]];
  case DBFILESThumbnailSizeW128h128:
    return [[self tagName] isEqual:[aThumbnailSize tagName]];
  case DBFILESThumbnailSizeW256h256:
    return [[self tagName] isEqual:[aThumbnailSize tagName]];
  case DBFILESThumbnailSizeW480h320:
    return [[self tagName] isEqual:[aThumbnailSize tagName]];
  case DBFILESThumbnailSizeW640h480:
    return [[self tagName] isEqual:[aThumbnailSize tagName]];
  case DBFILESThumbnailSizeW960h640:
    return [[self tagName] isEqual:[aThumbnailSize tagName]];
  case DBFILESThumbnailSizeW1024h768:
    return [[self tagName] isEqual:[aThumbnailSize tagName]];
  case DBFILESThumbnailSizeW2048h1536:
    return [[self tagName] isEqual:[aThumbnailSize tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESThumbnailSizeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailSize *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isW32h32]) {
    jsonDict[@".tag"] = @"w32h32";
  } else if ([valueObj isW64h64]) {
    jsonDict[@".tag"] = @"w64h64";
  } else if ([valueObj isW128h128]) {
    jsonDict[@".tag"] = @"w128h128";
  } else if ([valueObj isW256h256]) {
    jsonDict[@".tag"] = @"w256h256";
  } else if ([valueObj isW480h320]) {
    jsonDict[@".tag"] = @"w480h320";
  } else if ([valueObj isW640h480]) {
    jsonDict[@".tag"] = @"w640h480";
  } else if ([valueObj isW960h640]) {
    jsonDict[@".tag"] = @"w960h640";
  } else if ([valueObj isW1024h768]) {
    jsonDict[@".tag"] = @"w1024h768";
  } else if ([valueObj isW2048h1536]) {
    jsonDict[@".tag"] = @"w2048h1536";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESThumbnailSize *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"w32h32"]) {
    return [[DBFILESThumbnailSize alloc] initWithW32h32];
  } else if ([tag isEqualToString:@"w64h64"]) {
    return [[DBFILESThumbnailSize alloc] initWithW64h64];
  } else if ([tag isEqualToString:@"w128h128"]) {
    return [[DBFILESThumbnailSize alloc] initWithW128h128];
  } else if ([tag isEqualToString:@"w256h256"]) {
    return [[DBFILESThumbnailSize alloc] initWithW256h256];
  } else if ([tag isEqualToString:@"w480h320"]) {
    return [[DBFILESThumbnailSize alloc] initWithW480h320];
  } else if ([tag isEqualToString:@"w640h480"]) {
    return [[DBFILESThumbnailSize alloc] initWithW640h480];
  } else if ([tag isEqualToString:@"w960h640"]) {
    return [[DBFILESThumbnailSize alloc] initWithW960h640];
  } else if ([tag isEqualToString:@"w1024h768"]) {
    return [[DBFILESThumbnailSize alloc] initWithW1024h768];
  } else if ([tag isEqualToString:@"w2048h1536"]) {
    return [[DBFILESThumbnailSize alloc] initWithW2048h1536];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESPathOrLink.h"
#import "DBFILESThumbnailFormat.h"
#import "DBFILESThumbnailMode.h"
#import "DBFILESThumbnailSize.h"
#import "DBFILESThumbnailV2Arg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESThumbnailV2Arg

#pragma mark - Constructors

- (instancetype)initWithResource:(DBFILESPathOrLink *)resource
                          format:(DBFILESThumbnailFormat *)format
                            size:(DBFILESThumbnailSize *)size
                            mode:(DBFILESThumbnailMode *)mode {
  [DBStoneValidators nonnullValidator:nil](resource);

  self = [super init];
  if (self) {
    _resource = resource;
    _format = format ?: [[DBFILESThumbnailFormat alloc] initWithJpeg];
    _size = size ?: [[DBFILESThumbnailSize alloc] initWithW64h64];
    _mode = mode ?: [[DBFILESThumbnailMode alloc] initWithStrict];
  }
  return self;
}

- (instancetype)initWithResource:(DBFILESPathOrLink *)resource {
  return [self initWithResource:resource format:nil size:nil mode:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESThumbnailV2ArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESThumbnailV2ArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESThumbnailV2ArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.resource hash];
  result = prime * result + [self.format hash];
  result = prime * result + [self.size hash];
  result = prime * result + [self.mode hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToThumbnailV2Arg:other];
}

- (BOOL)isEqualToThumbnailV2Arg:(DBFILESThumbnailV2Arg *)aThumbnailV2Arg {
  if (self == aThumbnailV2Arg) {
    return YES;
  }
  if (![self.resource isEqual:aThumbnailV2Arg.resource]) {
    return NO;
  }
  if (![self.format isEqual:aThumbnailV2Arg.format]) {
    return NO;
  }
  if (![self.size isEqual:aThumbnailV2Arg.size]) {
    return NO;
  }
  if (![self.mode isEqual:aThumbnailV2Arg.mode]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESThumbnailV2ArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailV2Arg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"resource"] = [DBFILESPathOrLinkSerializer serialize:valueObj.resource];
  jsonDict[@"format"] = [DBFILESThumbnailFormatSerializer serialize:valueObj.format];
  jsonDict[@"size"] = [DBFILESThumbnailSizeSerializer serialize:valueObj.size];
  jsonDict[@"mode"] = [DBFILESThumbnailModeSerializer serialize:valueObj.mode];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESThumbnailV2Arg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESPathOrLink *resource = [DBFILESPathOrLinkSerializer deserialize:valueDict[@"resource"]];
  DBFILESThumbnailFormat *format = valueDict[@"format"]
                                       ? [DBFILESThumbnailFormatSerializer deserialize:valueDict[@"format"]]
                                       : [[DBFILESThumbnailFormat alloc] initWithJpeg];
  DBFILESThumbnailSize *size = valueDict[@"size"] ? [DBFILESThumbnailSizeSerializer deserialize:valueDict[@"size"]]
                                                  : [[DBFILESThumbnailSize alloc] initWithW64h64];
  DBFILESThumbnailMode *mode = valueDict[@"mode"] ? [DBFILESThumbnailModeSerializer deserialize:valueDict[@"mode"]]
                                                  : [[DBFILESThumbnailMode alloc] initWithStrict];

  return [[DBFILESThumbnailV2Arg alloc] initWithResource:resource format:format size:size mode:mode];
}

@end

#import "DBFILESLookupError.h"
#import "DBFILESThumbnailV2Error.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESThumbnailV2Error

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailV2ErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithUnsupportedExtension {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailV2ErrorUnsupportedExtension;
  }
  return self;
}

- (instancetype)initWithUnsupportedImage {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailV2ErrorUnsupportedImage;
  }
  return self;
}

- (instancetype)initWithConversionError {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailV2ErrorConversionError;
  }
  return self;
}

- (instancetype)initWithAccessDenied {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailV2ErrorAccessDenied;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailV2ErrorNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESThumbnailV2ErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESThumbnailV2ErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESThumbnailV2ErrorPath;
}

- (BOOL)isUnsupportedExtension {
  return _tag == DBFILESThumbnailV2ErrorUnsupportedExtension;
}

- (BOOL)isUnsupportedImage {
  return _tag == DBFILESThumbnailV2ErrorUnsupportedImage;
}

- (BOOL)isConversionError {
  return _tag == DBFILESThumbnailV2ErrorConversionError;
}

- (BOOL)isAccessDenied {
  return _tag == DBFILESThumbnailV2ErrorAccessDenied;
}

- (BOOL)isNotFound {
  return _tag == DBFILESThumbnailV2ErrorNotFound;
}

- (BOOL)isOther {
  return _tag == DBFILESThumbnailV2ErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESThumbnailV2ErrorPath:
    return @"DBFILESThumbnailV2ErrorPath";
  case DBFILESThumbnailV2ErrorUnsupportedExtension:
    return @"DBFILESThumbnailV2ErrorUnsupportedExtension";
  case DBFILESThumbnailV2ErrorUnsupportedImage:
    return @"DBFILESThumbnailV2ErrorUnsupportedImage";
  case DBFILESThumbnailV2ErrorConversionError:
    return @"DBFILESThumbnailV2ErrorConversionError";
  case DBFILESThumbnailV2ErrorAccessDenied:
    return @"DBFILESThumbnailV2ErrorAccessDenied";
  case DBFILESThumbnailV2ErrorNotFound:
    return @"DBFILESThumbnailV2ErrorNotFound";
  case DBFILESThumbnailV2ErrorOther:
    return @"DBFILESThumbnailV2ErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESThumbnailV2ErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESThumbnailV2ErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESThumbnailV2ErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESThumbnailV2ErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESThumbnailV2ErrorUnsupportedExtension:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailV2ErrorUnsupportedImage:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailV2ErrorConversionError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailV2ErrorAccessDenied:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailV2ErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESThumbnailV2ErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToThumbnailV2Error:other];
}

- (BOOL)isEqualToThumbnailV2Error:(DBFILESThumbnailV2Error *)aThumbnailV2Error {
  if (self == aThumbnailV2Error) {
    return YES;
  }
  if (self.tag != aThumbnailV2Error.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESThumbnailV2ErrorPath:
    return [self.path isEqual:aThumbnailV2Error.path];
  case DBFILESThumbnailV2ErrorUnsupportedExtension:
    return [[self tagName] isEqual:[aThumbnailV2Error tagName]];
  case DBFILESThumbnailV2ErrorUnsupportedImage:
    return [[self tagName] isEqual:[aThumbnailV2Error tagName]];
  case DBFILESThumbnailV2ErrorConversionError:
    return [[self tagName] isEqual:[aThumbnailV2Error tagName]];
  case DBFILESThumbnailV2ErrorAccessDenied:
    return [[self tagName] isEqual:[aThumbnailV2Error tagName]];
  case DBFILESThumbnailV2ErrorNotFound:
    return [[self tagName] isEqual:[aThumbnailV2Error tagName]];
  case DBFILESThumbnailV2ErrorOther:
    return [[self tagName] isEqual:[aThumbnailV2Error tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESThumbnailV2ErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailV2Error *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isUnsupportedExtension]) {
    jsonDict[@".tag"] = @"unsupported_extension";
  } else if ([valueObj isUnsupportedImage]) {
    jsonDict[@".tag"] = @"unsupported_image";
  } else if ([valueObj isConversionError]) {
    jsonDict[@".tag"] = @"conversion_error";
  } else if ([valueObj isAccessDenied]) {
    jsonDict[@".tag"] = @"access_denied";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESThumbnailV2Error *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESThumbnailV2Error alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"unsupported_extension"]) {
    return [[DBFILESThumbnailV2Error alloc] initWithUnsupportedExtension];
  } else if ([tag isEqualToString:@"unsupported_image"]) {
    return [[DBFILESThumbnailV2Error alloc] initWithUnsupportedImage];
  } else if ([tag isEqualToString:@"conversion_error"]) {
    return [[DBFILESThumbnailV2Error alloc] initWithConversionError];
  } else if ([tag isEqualToString:@"access_denied"]) {
    return [[DBFILESThumbnailV2Error alloc] initWithAccessDenied];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILESThumbnailV2Error alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESThumbnailV2Error alloc] initWithOther];
  } else {
    return [[DBFILESThumbnailV2Error alloc] initWithOther];
  }
}

@end

#import "DBFILESUnlockFileArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUnlockFileArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil
                                             maxLength:nil
                                               pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)"]](path);

  self = [super init];
  if (self) {
    _path = path;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUnlockFileArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUnlockFileArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUnlockFileArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUnlockFileArg:other];
}

- (BOOL)isEqualToUnlockFileArg:(DBFILESUnlockFileArg *)anUnlockFileArg {
  if (self == anUnlockFileArg) {
    return YES;
  }
  if (![self.path isEqual:anUnlockFileArg.path]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUnlockFileArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUnlockFileArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUnlockFileArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];

  return [[DBFILESUnlockFileArg alloc] initWithPath:path];
}

@end

#import "DBFILESUnlockFileArg.h"
#import "DBFILESUnlockFileBatchArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUnlockFileBatchArg

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESUnlockFileArg *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUnlockFileBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUnlockFileBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUnlockFileBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUnlockFileBatchArg:other];
}

- (BOOL)isEqualToUnlockFileBatchArg:(DBFILESUnlockFileBatchArg *)anUnlockFileBatchArg {
  if (self == anUnlockFileBatchArg) {
    return YES;
  }
  if (![self.entries isEqual:anUnlockFileBatchArg.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUnlockFileBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUnlockFileBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESUnlockFileArgSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUnlockFileBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESUnlockFileArg *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESUnlockFileArgSerializer deserialize:elem0];
                           }];

  return [[DBFILESUnlockFileBatchArg alloc] initWithEntries:entries];
}

@end

#import "DBFILEPROPERTIESInvalidPropertyGroupError.h"
#import "DBFILESUploadError.h"
#import "DBFILESUploadWriteFailed.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadError

@synthesize path = _path;
@synthesize propertiesError = _propertiesError;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESUploadWriteFailed *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithPropertiesError:(DBFILEPROPERTIESInvalidPropertyGroupError *)propertiesError {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadErrorPropertiesError;
    _propertiesError = propertiesError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESUploadWriteFailed *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESUploadErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

- (DBFILEPROPERTIESInvalidPropertyGroupError *)propertiesError {
  if (![self isPropertiesError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESUploadErrorPropertiesError, but was %@.", [self tagName]];
  }
  return _propertiesError;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESUploadErrorPath;
}

- (BOOL)isPropertiesError {
  return _tag == DBFILESUploadErrorPropertiesError;
}

- (BOOL)isOther {
  return _tag == DBFILESUploadErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESUploadErrorPath:
    return @"DBFILESUploadErrorPath";
  case DBFILESUploadErrorPropertiesError:
    return @"DBFILESUploadErrorPropertiesError";
  case DBFILESUploadErrorOther:
    return @"DBFILESUploadErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESUploadErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESUploadErrorPropertiesError:
    result = prime * result + [self.propertiesError hash];
    break;
  case DBFILESUploadErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadError:other];
}

- (BOOL)isEqualToUploadError:(DBFILESUploadError *)anUploadError {
  if (self == anUploadError) {
    return YES;
  }
  if (self.tag != anUploadError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESUploadErrorPath:
    return [self.path isEqual:anUploadError.path];
  case DBFILESUploadErrorPropertiesError:
    return [self.propertiesError isEqual:anUploadError.propertiesError];
  case DBFILESUploadErrorOther:
    return [[self tagName] isEqual:[anUploadError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict = [[DBFILESUploadWriteFailedSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isPropertiesError]) {
    jsonDict[@"properties_error"] =
        [[DBFILEPROPERTIESInvalidPropertyGroupErrorSerializer serialize:valueObj.propertiesError] mutableCopy];
    jsonDict[@".tag"] = @"properties_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESUploadWriteFailed *path = [DBFILESUploadWriteFailedSerializer deserialize:valueDict];
    return [[DBFILESUploadError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"properties_error"]) {
    DBFILEPROPERTIESInvalidPropertyGroupError *propertiesError =
        [DBFILEPROPERTIESInvalidPropertyGroupErrorSerializer deserialize:valueDict[@"properties_error"]];
    return [[DBFILESUploadError alloc] initWithPropertiesError:propertiesError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESUploadError alloc] initWithOther];
  } else {
    return [[DBFILESUploadError alloc] initWithOther];
  }
}

@end

#import "DBFILEPROPERTIESInvalidPropertyGroupError.h"
#import "DBFILESUploadError.h"
#import "DBFILESUploadErrorWithProperties.h"
#import "DBFILESUploadWriteFailed.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadErrorWithProperties

@synthesize path = _path;
@synthesize propertiesError = _propertiesError;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESUploadWriteFailed *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadErrorWithPropertiesPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithPropertiesError:(DBFILEPROPERTIESInvalidPropertyGroupError *)propertiesError {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadErrorWithPropertiesPropertiesError;
    _propertiesError = propertiesError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadErrorWithPropertiesOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESUploadWriteFailed *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESUploadErrorWithPropertiesPath, but was %@.", [self tagName]];
  }
  return _path;
}

- (DBFILEPROPERTIESInvalidPropertyGroupError *)propertiesError {
  if (![self isPropertiesError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESUploadErrorWithPropertiesPropertiesError, but was %@.", [self tagName]];
  }
  return _propertiesError;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBFILESUploadErrorWithPropertiesPath;
}

- (BOOL)isPropertiesError {
  return _tag == DBFILESUploadErrorWithPropertiesPropertiesError;
}

- (BOOL)isOther {
  return _tag == DBFILESUploadErrorWithPropertiesOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESUploadErrorWithPropertiesPath:
    return @"DBFILESUploadErrorWithPropertiesPath";
  case DBFILESUploadErrorWithPropertiesPropertiesError:
    return @"DBFILESUploadErrorWithPropertiesPropertiesError";
  case DBFILESUploadErrorWithPropertiesOther:
    return @"DBFILESUploadErrorWithPropertiesOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadErrorWithPropertiesSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadErrorWithPropertiesSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadErrorWithPropertiesSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESUploadErrorWithPropertiesPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESUploadErrorWithPropertiesPropertiesError:
    result = prime * result + [self.propertiesError hash];
    break;
  case DBFILESUploadErrorWithPropertiesOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadErrorWithProperties:other];
}

- (BOOL)isEqualToUploadErrorWithProperties:(DBFILESUploadErrorWithProperties *)anUploadErrorWithProperties {
  if (self == anUploadErrorWithProperties) {
    return YES;
  }
  if (self.tag != anUploadErrorWithProperties.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESUploadErrorWithPropertiesPath:
    return [self.path isEqual:anUploadErrorWithProperties.path];
  case DBFILESUploadErrorWithPropertiesPropertiesError:
    return [self.propertiesError isEqual:anUploadErrorWithProperties.propertiesError];
  case DBFILESUploadErrorWithPropertiesOther:
    return [[self tagName] isEqual:[anUploadErrorWithProperties tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadErrorWithPropertiesSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadErrorWithProperties *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict = [[DBFILESUploadWriteFailedSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isPropertiesError]) {
    jsonDict[@"properties_error"] =
        [[DBFILEPROPERTIESInvalidPropertyGroupErrorSerializer serialize:valueObj.propertiesError] mutableCopy];
    jsonDict[@".tag"] = @"properties_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadErrorWithProperties *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESUploadWriteFailed *path = [DBFILESUploadWriteFailedSerializer deserialize:valueDict];
    return [[DBFILESUploadErrorWithProperties alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"properties_error"]) {
    DBFILEPROPERTIESInvalidPropertyGroupError *propertiesError =
        [DBFILEPROPERTIESInvalidPropertyGroupErrorSerializer deserialize:valueDict[@"properties_error"]];
    return [[DBFILESUploadErrorWithProperties alloc] initWithPropertiesError:propertiesError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESUploadErrorWithProperties alloc] initWithOther];
  } else {
    return [[DBFILESUploadErrorWithProperties alloc] initWithOther];
  }
}

@end

#import "DBFILESUploadSessionAppendArg.h"
#import "DBFILESUploadSessionCursor.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionAppendArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(DBFILESUploadSessionCursor *)cursor close:(NSNumber *)close {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
    _close = close ?: @NO;
  }
  return self;
}

- (instancetype)initWithCursor:(DBFILESUploadSessionCursor *)cursor {
  return [self initWithCursor:cursor close:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionAppendArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionAppendArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionAppendArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];
  result = prime * result + [self.close hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionAppendArg:other];
}

- (BOOL)isEqualToUploadSessionAppendArg:(DBFILESUploadSessionAppendArg *)anUploadSessionAppendArg {
  if (self == anUploadSessionAppendArg) {
    return YES;
  }
  if (![self.cursor isEqual:anUploadSessionAppendArg.cursor]) {
    return NO;
  }
  if (![self.close isEqual:anUploadSessionAppendArg.close]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionAppendArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionAppendArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = [DBFILESUploadSessionCursorSerializer serialize:valueObj.cursor];
  jsonDict[@"close"] = valueObj.close;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionAppendArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESUploadSessionCursor *cursor = [DBFILESUploadSessionCursorSerializer deserialize:valueDict[@"cursor"]];
  NSNumber *close = valueDict[@"close"] ?: @NO;

  return [[DBFILESUploadSessionAppendArg alloc] initWithCursor:cursor close:close];
}

@end

#import "DBFILESUploadSessionCursor.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionCursor

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId offset:(NSNumber *)offset {
  [DBStoneValidators nonnullValidator:nil](sessionId);
  [DBStoneValidators nonnullValidator:nil](offset);

  self = [super init];
  if (self) {
    _sessionId = sessionId;
    _offset = offset;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionCursorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionCursorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionCursorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sessionId hash];
  result = prime * result + [self.offset hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionCursor:other];
}

- (BOOL)isEqualToUploadSessionCursor:(DBFILESUploadSessionCursor *)anUploadSessionCursor {
  if (self == anUploadSessionCursor) {
    return YES;
  }
  if (![self.sessionId isEqual:anUploadSessionCursor.sessionId]) {
    return NO;
  }
  if (![self.offset isEqual:anUploadSessionCursor.offset]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionCursorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionCursor *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"session_id"] = valueObj.sessionId;
  jsonDict[@"offset"] = valueObj.offset;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionCursor *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sessionId = valueDict[@"session_id"];
  NSNumber *offset = valueDict[@"offset"];

  return [[DBFILESUploadSessionCursor alloc] initWithSessionId:sessionId offset:offset];
}

@end

#import "DBFILESCommitInfo.h"
#import "DBFILESUploadSessionCursor.h"
#import "DBFILESUploadSessionFinishArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionFinishArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(DBFILESUploadSessionCursor *)cursor commit:(DBFILESCommitInfo *)commit {
  [DBStoneValidators nonnullValidator:nil](cursor);
  [DBStoneValidators nonnullValidator:nil](commit);

  self = [super init];
  if (self) {
    _cursor = cursor;
    _commit = commit;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionFinishArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionFinishArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionFinishArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];
  result = prime * result + [self.commit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionFinishArg:other];
}

- (BOOL)isEqualToUploadSessionFinishArg:(DBFILESUploadSessionFinishArg *)anUploadSessionFinishArg {
  if (self == anUploadSessionFinishArg) {
    return YES;
  }
  if (![self.cursor isEqual:anUploadSessionFinishArg.cursor]) {
    return NO;
  }
  if (![self.commit isEqual:anUploadSessionFinishArg.commit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionFinishArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionFinishArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = [DBFILESUploadSessionCursorSerializer serialize:valueObj.cursor];
  jsonDict[@"commit"] = [DBFILESCommitInfoSerializer serialize:valueObj.commit];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionFinishArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESUploadSessionCursor *cursor = [DBFILESUploadSessionCursorSerializer deserialize:valueDict[@"cursor"]];
  DBFILESCommitInfo *commit = [DBFILESCommitInfoSerializer deserialize:valueDict[@"commit"]];

  return [[DBFILESUploadSessionFinishArg alloc] initWithCursor:cursor commit:commit];
}

@end

#import "DBFILESUploadSessionFinishArg.h"
#import "DBFILESUploadSessionFinishBatchArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionFinishBatchArg

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESUploadSessionFinishArg *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:@(1000)
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionFinishBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionFinishBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionFinishBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionFinishBatchArg:other];
}

- (BOOL)isEqualToUploadSessionFinishBatchArg:(DBFILESUploadSessionFinishBatchArg *)anUploadSessionFinishBatchArg {
  if (self == anUploadSessionFinishBatchArg) {
    return YES;
  }
  if (![self.entries isEqual:anUploadSessionFinishBatchArg.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionFinishBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionFinishBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBFILESUploadSessionFinishArgSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionFinishBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESUploadSessionFinishArg *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESUploadSessionFinishArgSerializer deserialize:elem0];
                           }];

  return [[DBFILESUploadSessionFinishBatchArg alloc] initWithEntries:entries];
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBFILESUploadSessionFinishBatchJobStatus.h"
#import "DBFILESUploadSessionFinishBatchResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionFinishBatchJobStatus

@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishBatchJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESUploadSessionFinishBatchResult *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishBatchJobStatusComplete;
    _complete = complete;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESUploadSessionFinishBatchResult *)complete {
  if (![self isComplete]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESUploadSessionFinishBatchJobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBFILESUploadSessionFinishBatchJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBFILESUploadSessionFinishBatchJobStatusComplete;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESUploadSessionFinishBatchJobStatusInProgress:
    return @"DBFILESUploadSessionFinishBatchJobStatusInProgress";
  case DBFILESUploadSessionFinishBatchJobStatusComplete:
    return @"DBFILESUploadSessionFinishBatchJobStatusComplete";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionFinishBatchJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionFinishBatchJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionFinishBatchJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESUploadSessionFinishBatchJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionFinishBatchJobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionFinishBatchJobStatus:other];
}

- (BOOL)isEqualToUploadSessionFinishBatchJobStatus:
    (DBFILESUploadSessionFinishBatchJobStatus *)anUploadSessionFinishBatchJobStatus {
  if (self == anUploadSessionFinishBatchJobStatus) {
    return YES;
  }
  if (self.tag != anUploadSessionFinishBatchJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESUploadSessionFinishBatchJobStatusInProgress:
    return [[self tagName] isEqual:[anUploadSessionFinishBatchJobStatus tagName]];
  case DBFILESUploadSessionFinishBatchJobStatusComplete:
    return [self.complete isEqual:anUploadSessionFinishBatchJobStatus.complete];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionFinishBatchJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionFinishBatchJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESUploadSessionFinishBatchResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionFinishBatchJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBFILESUploadSessionFinishBatchJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESUploadSessionFinishBatchResult *complete =
        [DBFILESUploadSessionFinishBatchResultSerializer deserialize:valueDict];
    return [[DBFILESUploadSessionFinishBatchJobStatus alloc] initWithComplete:complete];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBASYNCLaunchResultBase.h"
#import "DBFILESUploadSessionFinishBatchLaunch.h"
#import "DBFILESUploadSessionFinishBatchResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionFinishBatchLaunch

@synthesize asyncJobId = _asyncJobId;
@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishBatchLaunchAsyncJobId;
    _asyncJobId = asyncJobId;
  }
  return self;
}

- (instancetype)initWithComplete:(DBFILESUploadSessionFinishBatchResult *)complete {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishBatchLaunchComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishBatchLaunchOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)asyncJobId {
  if (![self isAsyncJobId]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESUploadSessionFinishBatchLaunchAsyncJobId, but was %@.", [self tagName]];
  }
  return _asyncJobId;
}

- (DBFILESUploadSessionFinishBatchResult *)complete {
  if (![self isComplete]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESUploadSessionFinishBatchLaunchComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isAsyncJobId {
  return _tag == DBFILESUploadSessionFinishBatchLaunchAsyncJobId;
}

- (BOOL)isComplete {
  return _tag == DBFILESUploadSessionFinishBatchLaunchComplete;
}

- (BOOL)isOther {
  return _tag == DBFILESUploadSessionFinishBatchLaunchOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESUploadSessionFinishBatchLaunchAsyncJobId:
    return @"DBFILESUploadSessionFinishBatchLaunchAsyncJobId";
  case DBFILESUploadSessionFinishBatchLaunchComplete:
    return @"DBFILESUploadSessionFinishBatchLaunchComplete";
  case DBFILESUploadSessionFinishBatchLaunchOther:
    return @"DBFILESUploadSessionFinishBatchLaunchOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionFinishBatchLaunchSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionFinishBatchLaunchSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionFinishBatchLaunchSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESUploadSessionFinishBatchLaunchAsyncJobId:
    result = prime * result + [self.asyncJobId hash];
    break;
  case DBFILESUploadSessionFinishBatchLaunchComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBFILESUploadSessionFinishBatchLaunchOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionFinishBatchLaunch:other];
}

- (BOOL)isEqualToUploadSessionFinishBatchLaunch:
    (DBFILESUploadSessionFinishBatchLaunch *)anUploadSessionFinishBatchLaunch {
  if (self == anUploadSessionFinishBatchLaunch) {
    return YES;
  }
  if (self.tag != anUploadSessionFinishBatchLaunch.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESUploadSessionFinishBatchLaunchAsyncJobId:
    return [self.asyncJobId isEqual:anUploadSessionFinishBatchLaunch.asyncJobId];
  case DBFILESUploadSessionFinishBatchLaunchComplete:
    return [self.complete isEqual:anUploadSessionFinishBatchLaunch.complete];
  case DBFILESUploadSessionFinishBatchLaunchOther:
    return [[self tagName] isEqual:[anUploadSessionFinishBatchLaunch tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionFinishBatchLaunchSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionFinishBatchLaunch *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAsyncJobId]) {
    jsonDict[@"async_job_id"] = valueObj.asyncJobId;
    jsonDict[@".tag"] = @"async_job_id";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBFILESUploadSessionFinishBatchResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionFinishBatchLaunch *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"async_job_id"]) {
    NSString *asyncJobId = valueDict[@"async_job_id"];
    return [[DBFILESUploadSessionFinishBatchLaunch alloc] initWithAsyncJobId:asyncJobId];
  } else if ([tag isEqualToString:@"complete"]) {
    DBFILESUploadSessionFinishBatchResult *complete =
        [DBFILESUploadSessionFinishBatchResultSerializer deserialize:valueDict];
    return [[DBFILESUploadSessionFinishBatchLaunch alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESUploadSessionFinishBatchLaunch alloc] initWithOther];
  } else {
    return [[DBFILESUploadSessionFinishBatchLaunch alloc] initWithOther];
  }
}

@end

#import "DBFILESUploadSessionFinishBatchResult.h"
#import "DBFILESUploadSessionFinishBatchResultEntry.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionFinishBatchResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBFILESUploadSessionFinishBatchResultEntry *> *)entries {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionFinishBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionFinishBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionFinishBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionFinishBatchResult:other];
}

- (BOOL)isEqualToUploadSessionFinishBatchResult:
    (DBFILESUploadSessionFinishBatchResult *)anUploadSessionFinishBatchResult {
  if (self == anUploadSessionFinishBatchResult) {
    return YES;
  }
  if (![self.entries isEqual:anUploadSessionFinishBatchResult.entries]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionFinishBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionFinishBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] =
      [DBArraySerializer serialize:valueObj.entries
                         withBlock:^id(id elem0) {
                           return [DBFILESUploadSessionFinishBatchResultEntrySerializer serialize:elem0];
                         }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionFinishBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILESUploadSessionFinishBatchResultEntry *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBFILESUploadSessionFinishBatchResultEntrySerializer deserialize:elem0];
                           }];

  return [[DBFILESUploadSessionFinishBatchResult alloc] initWithEntries:entries];
}

@end

#import "DBFILESFileMetadata.h"
#import "DBFILESUploadSessionFinishBatchResultEntry.h"
#import "DBFILESUploadSessionFinishError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionFinishBatchResultEntry

@synthesize success = _success;
@synthesize failure = _failure;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBFILESFileMetadata *)success {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishBatchResultEntrySuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithFailure:(DBFILESUploadSessionFinishError *)failure {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishBatchResultEntryFailure;
    _failure = failure;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESFileMetadata *)success {
  if (![self isSuccess]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESUploadSessionFinishBatchResultEntrySuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBFILESUploadSessionFinishError *)failure {
  if (![self isFailure]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESUploadSessionFinishBatchResultEntryFailure, but was %@.", [self tagName]];
  }
  return _failure;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBFILESUploadSessionFinishBatchResultEntrySuccess;
}

- (BOOL)isFailure {
  return _tag == DBFILESUploadSessionFinishBatchResultEntryFailure;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESUploadSessionFinishBatchResultEntrySuccess:
    return @"DBFILESUploadSessionFinishBatchResultEntrySuccess";
  case DBFILESUploadSessionFinishBatchResultEntryFailure:
    return @"DBFILESUploadSessionFinishBatchResultEntryFailure";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionFinishBatchResultEntrySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionFinishBatchResultEntrySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionFinishBatchResultEntrySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESUploadSessionFinishBatchResultEntrySuccess:
    result = prime * result + [self.success hash];
    break;
  case DBFILESUploadSessionFinishBatchResultEntryFailure:
    result = prime * result + [self.failure hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionFinishBatchResultEntry:other];
}

- (BOOL)isEqualToUploadSessionFinishBatchResultEntry:
    (DBFILESUploadSessionFinishBatchResultEntry *)anUploadSessionFinishBatchResultEntry {
  if (self == anUploadSessionFinishBatchResultEntry) {
    return YES;
  }
  if (self.tag != anUploadSessionFinishBatchResultEntry.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESUploadSessionFinishBatchResultEntrySuccess:
    return [self.success isEqual:anUploadSessionFinishBatchResultEntry.success];
  case DBFILESUploadSessionFinishBatchResultEntryFailure:
    return [self.failure isEqual:anUploadSessionFinishBatchResultEntry.failure];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionFinishBatchResultEntrySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionFinishBatchResultEntry *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict = [[DBFILESFileMetadataSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isFailure]) {
    jsonDict[@"failure"] = [[DBFILESUploadSessionFinishErrorSerializer serialize:valueObj.failure] mutableCopy];
    jsonDict[@".tag"] = @"failure";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionFinishBatchResultEntry *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBFILESFileMetadata *success = [DBFILESFileMetadataSerializer deserialize:valueDict];
    return [[DBFILESUploadSessionFinishBatchResultEntry alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"failure"]) {
    DBFILESUploadSessionFinishError *failure =
        [DBFILESUploadSessionFinishErrorSerializer deserialize:valueDict[@"failure"]];
    return [[DBFILESUploadSessionFinishBatchResultEntry alloc] initWithFailure:failure];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILEPROPERTIESInvalidPropertyGroupError.h"
#import "DBFILESUploadSessionFinishError.h"
#import "DBFILESUploadSessionLookupError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionFinishError

@synthesize lookupFailed = _lookupFailed;
@synthesize path = _path;
@synthesize propertiesError = _propertiesError;

#pragma mark - Constructors

- (instancetype)initWithLookupFailed:(DBFILESUploadSessionLookupError *)lookupFailed {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishErrorLookupFailed;
    _lookupFailed = lookupFailed;
  }
  return self;
}

- (instancetype)initWithPath:(DBFILESWriteError *)path {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithPropertiesError:(DBFILEPROPERTIESInvalidPropertyGroupError *)propertiesError {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishErrorPropertiesError;
    _propertiesError = propertiesError;
  }
  return self;
}

- (instancetype)initWithTooManySharedFolderTargets {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishErrorTooManySharedFolderTargets;
  }
  return self;
}

- (instancetype)initWithTooManyWriteOperations {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishErrorTooManyWriteOperations;
  }
  return self;
}

- (instancetype)initWithConcurrentSessionDataNotAllowed {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishErrorConcurrentSessionDataNotAllowed;
  }
  return self;
}

- (instancetype)initWithConcurrentSessionNotClosed {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishErrorConcurrentSessionNotClosed;
  }
  return self;
}

- (instancetype)initWithConcurrentSessionMissingData {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishErrorConcurrentSessionMissingData;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionFinishErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESUploadSessionLookupError *)lookupFailed {
  if (![self isLookupFailed]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESUploadSessionFinishErrorLookupFailed, but was %@.", [self tagName]];
  }
  return _lookupFailed;
}

- (DBFILESWriteError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESUploadSessionFinishErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

- (DBFILEPROPERTIESInvalidPropertyGroupError *)propertiesError {
  if (![self isPropertiesError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESUploadSessionFinishErrorPropertiesError, but was %@.", [self tagName]];
  }
  return _propertiesError;
}

#pragma mark - Tag state methods

- (BOOL)isLookupFailed {
  return _tag == DBFILESUploadSessionFinishErrorLookupFailed;
}

- (BOOL)isPath {
  return _tag == DBFILESUploadSessionFinishErrorPath;
}

- (BOOL)isPropertiesError {
  return _tag == DBFILESUploadSessionFinishErrorPropertiesError;
}

- (BOOL)isTooManySharedFolderTargets {
  return _tag == DBFILESUploadSessionFinishErrorTooManySharedFolderTargets;
}

- (BOOL)isTooManyWriteOperations {
  return _tag == DBFILESUploadSessionFinishErrorTooManyWriteOperations;
}

- (BOOL)isConcurrentSessionDataNotAllowed {
  return _tag == DBFILESUploadSessionFinishErrorConcurrentSessionDataNotAllowed;
}

- (BOOL)isConcurrentSessionNotClosed {
  return _tag == DBFILESUploadSessionFinishErrorConcurrentSessionNotClosed;
}

- (BOOL)isConcurrentSessionMissingData {
  return _tag == DBFILESUploadSessionFinishErrorConcurrentSessionMissingData;
}

- (BOOL)isOther {
  return _tag == DBFILESUploadSessionFinishErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESUploadSessionFinishErrorLookupFailed:
    return @"DBFILESUploadSessionFinishErrorLookupFailed";
  case DBFILESUploadSessionFinishErrorPath:
    return @"DBFILESUploadSessionFinishErrorPath";
  case DBFILESUploadSessionFinishErrorPropertiesError:
    return @"DBFILESUploadSessionFinishErrorPropertiesError";
  case DBFILESUploadSessionFinishErrorTooManySharedFolderTargets:
    return @"DBFILESUploadSessionFinishErrorTooManySharedFolderTargets";
  case DBFILESUploadSessionFinishErrorTooManyWriteOperations:
    return @"DBFILESUploadSessionFinishErrorTooManyWriteOperations";
  case DBFILESUploadSessionFinishErrorConcurrentSessionDataNotAllowed:
    return @"DBFILESUploadSessionFinishErrorConcurrentSessionDataNotAllowed";
  case DBFILESUploadSessionFinishErrorConcurrentSessionNotClosed:
    return @"DBFILESUploadSessionFinishErrorConcurrentSessionNotClosed";
  case DBFILESUploadSessionFinishErrorConcurrentSessionMissingData:
    return @"DBFILESUploadSessionFinishErrorConcurrentSessionMissingData";
  case DBFILESUploadSessionFinishErrorOther:
    return @"DBFILESUploadSessionFinishErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionFinishErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionFinishErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionFinishErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESUploadSessionFinishErrorLookupFailed:
    result = prime * result + [self.lookupFailed hash];
    break;
  case DBFILESUploadSessionFinishErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBFILESUploadSessionFinishErrorPropertiesError:
    result = prime * result + [self.propertiesError hash];
    break;
  case DBFILESUploadSessionFinishErrorTooManySharedFolderTargets:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionFinishErrorTooManyWriteOperations:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionFinishErrorConcurrentSessionDataNotAllowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionFinishErrorConcurrentSessionNotClosed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionFinishErrorConcurrentSessionMissingData:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionFinishErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionFinishError:other];
}

- (BOOL)isEqualToUploadSessionFinishError:(DBFILESUploadSessionFinishError *)anUploadSessionFinishError {
  if (self == anUploadSessionFinishError) {
    return YES;
  }
  if (self.tag != anUploadSessionFinishError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESUploadSessionFinishErrorLookupFailed:
    return [self.lookupFailed isEqual:anUploadSessionFinishError.lookupFailed];
  case DBFILESUploadSessionFinishErrorPath:
    return [self.path isEqual:anUploadSessionFinishError.path];
  case DBFILESUploadSessionFinishErrorPropertiesError:
    return [self.propertiesError isEqual:anUploadSessionFinishError.propertiesError];
  case DBFILESUploadSessionFinishErrorTooManySharedFolderTargets:
    return [[self tagName] isEqual:[anUploadSessionFinishError tagName]];
  case DBFILESUploadSessionFinishErrorTooManyWriteOperations:
    return [[self tagName] isEqual:[anUploadSessionFinishError tagName]];
  case DBFILESUploadSessionFinishErrorConcurrentSessionDataNotAllowed:
    return [[self tagName] isEqual:[anUploadSessionFinishError tagName]];
  case DBFILESUploadSessionFinishErrorConcurrentSessionNotClosed:
    return [[self tagName] isEqual:[anUploadSessionFinishError tagName]];
  case DBFILESUploadSessionFinishErrorConcurrentSessionMissingData:
    return [[self tagName] isEqual:[anUploadSessionFinishError tagName]];
  case DBFILESUploadSessionFinishErrorOther:
    return [[self tagName] isEqual:[anUploadSessionFinishError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionFinishErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionFinishError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isLookupFailed]) {
    jsonDict[@"lookup_failed"] =
        [[DBFILESUploadSessionLookupErrorSerializer serialize:valueObj.lookupFailed] mutableCopy];
    jsonDict[@".tag"] = @"lookup_failed";
  } else if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESWriteErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isPropertiesError]) {
    jsonDict[@"properties_error"] =
        [[DBFILEPROPERTIESInvalidPropertyGroupErrorSerializer serialize:valueObj.propertiesError] mutableCopy];
    jsonDict[@".tag"] = @"properties_error";
  } else if ([valueObj isTooManySharedFolderTargets]) {
    jsonDict[@".tag"] = @"too_many_shared_folder_targets";
  } else if ([valueObj isTooManyWriteOperations]) {
    jsonDict[@".tag"] = @"too_many_write_operations";
  } else if ([valueObj isConcurrentSessionDataNotAllowed]) {
    jsonDict[@".tag"] = @"concurrent_session_data_not_allowed";
  } else if ([valueObj isConcurrentSessionNotClosed]) {
    jsonDict[@".tag"] = @"concurrent_session_not_closed";
  } else if ([valueObj isConcurrentSessionMissingData]) {
    jsonDict[@".tag"] = @"concurrent_session_missing_data";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionFinishError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"lookup_failed"]) {
    DBFILESUploadSessionLookupError *lookupFailed =
        [DBFILESUploadSessionLookupErrorSerializer deserialize:valueDict[@"lookup_failed"]];
    return [[DBFILESUploadSessionFinishError alloc] initWithLookupFailed:lookupFailed];
  } else if ([tag isEqualToString:@"path"]) {
    DBFILESWriteError *path = [DBFILESWriteErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBFILESUploadSessionFinishError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"properties_error"]) {
    DBFILEPROPERTIESInvalidPropertyGroupError *propertiesError =
        [DBFILEPROPERTIESInvalidPropertyGroupErrorSerializer deserialize:valueDict[@"properties_error"]];
    return [[DBFILESUploadSessionFinishError alloc] initWithPropertiesError:propertiesError];
  } else if ([tag isEqualToString:@"too_many_shared_folder_targets"]) {
    return [[DBFILESUploadSessionFinishError alloc] initWithTooManySharedFolderTargets];
  } else if ([tag isEqualToString:@"too_many_write_operations"]) {
    return [[DBFILESUploadSessionFinishError alloc] initWithTooManyWriteOperations];
  } else if ([tag isEqualToString:@"concurrent_session_data_not_allowed"]) {
    return [[DBFILESUploadSessionFinishError alloc] initWithConcurrentSessionDataNotAllowed];
  } else if ([tag isEqualToString:@"concurrent_session_not_closed"]) {
    return [[DBFILESUploadSessionFinishError alloc] initWithConcurrentSessionNotClosed];
  } else if ([tag isEqualToString:@"concurrent_session_missing_data"]) {
    return [[DBFILESUploadSessionFinishError alloc] initWithConcurrentSessionMissingData];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESUploadSessionFinishError alloc] initWithOther];
  } else {
    return [[DBFILESUploadSessionFinishError alloc] initWithOther];
  }
}

@end

#import "DBFILESUploadSessionLookupError.h"
#import "DBFILESUploadSessionOffsetError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionLookupError

@synthesize incorrectOffset = _incorrectOffset;

#pragma mark - Constructors

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionLookupErrorNotFound;
  }
  return self;
}

- (instancetype)initWithIncorrectOffset:(DBFILESUploadSessionOffsetError *)incorrectOffset {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionLookupErrorIncorrectOffset;
    _incorrectOffset = incorrectOffset;
  }
  return self;
}

- (instancetype)initWithClosed {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionLookupErrorClosed;
  }
  return self;
}

- (instancetype)initWithNotClosed {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionLookupErrorNotClosed;
  }
  return self;
}

- (instancetype)initWithTooLarge {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionLookupErrorTooLarge;
  }
  return self;
}

- (instancetype)initWithConcurrentSessionInvalidOffset {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionLookupErrorConcurrentSessionInvalidOffset;
  }
  return self;
}

- (instancetype)initWithConcurrentSessionInvalidDataSize {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionLookupErrorConcurrentSessionInvalidDataSize;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionLookupErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESUploadSessionOffsetError *)incorrectOffset {
  if (![self isIncorrectOffset]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILESUploadSessionLookupErrorIncorrectOffset, but was %@.", [self tagName]];
  }
  return _incorrectOffset;
}

#pragma mark - Tag state methods

- (BOOL)isNotFound {
  return _tag == DBFILESUploadSessionLookupErrorNotFound;
}

- (BOOL)isIncorrectOffset {
  return _tag == DBFILESUploadSessionLookupErrorIncorrectOffset;
}

- (BOOL)isClosed {
  return _tag == DBFILESUploadSessionLookupErrorClosed;
}

- (BOOL)isNotClosed {
  return _tag == DBFILESUploadSessionLookupErrorNotClosed;
}

- (BOOL)isTooLarge {
  return _tag == DBFILESUploadSessionLookupErrorTooLarge;
}

- (BOOL)isConcurrentSessionInvalidOffset {
  return _tag == DBFILESUploadSessionLookupErrorConcurrentSessionInvalidOffset;
}

- (BOOL)isConcurrentSessionInvalidDataSize {
  return _tag == DBFILESUploadSessionLookupErrorConcurrentSessionInvalidDataSize;
}

- (BOOL)isOther {
  return _tag == DBFILESUploadSessionLookupErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESUploadSessionLookupErrorNotFound:
    return @"DBFILESUploadSessionLookupErrorNotFound";
  case DBFILESUploadSessionLookupErrorIncorrectOffset:
    return @"DBFILESUploadSessionLookupErrorIncorrectOffset";
  case DBFILESUploadSessionLookupErrorClosed:
    return @"DBFILESUploadSessionLookupErrorClosed";
  case DBFILESUploadSessionLookupErrorNotClosed:
    return @"DBFILESUploadSessionLookupErrorNotClosed";
  case DBFILESUploadSessionLookupErrorTooLarge:
    return @"DBFILESUploadSessionLookupErrorTooLarge";
  case DBFILESUploadSessionLookupErrorConcurrentSessionInvalidOffset:
    return @"DBFILESUploadSessionLookupErrorConcurrentSessionInvalidOffset";
  case DBFILESUploadSessionLookupErrorConcurrentSessionInvalidDataSize:
    return @"DBFILESUploadSessionLookupErrorConcurrentSessionInvalidDataSize";
  case DBFILESUploadSessionLookupErrorOther:
    return @"DBFILESUploadSessionLookupErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionLookupErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionLookupErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionLookupErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESUploadSessionLookupErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionLookupErrorIncorrectOffset:
    result = prime * result + [self.incorrectOffset hash];
    break;
  case DBFILESUploadSessionLookupErrorClosed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionLookupErrorNotClosed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionLookupErrorTooLarge:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionLookupErrorConcurrentSessionInvalidOffset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionLookupErrorConcurrentSessionInvalidDataSize:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionLookupErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionLookupError:other];
}

- (BOOL)isEqualToUploadSessionLookupError:(DBFILESUploadSessionLookupError *)anUploadSessionLookupError {
  if (self == anUploadSessionLookupError) {
    return YES;
  }
  if (self.tag != anUploadSessionLookupError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESUploadSessionLookupErrorNotFound:
    return [[self tagName] isEqual:[anUploadSessionLookupError tagName]];
  case DBFILESUploadSessionLookupErrorIncorrectOffset:
    return [self.incorrectOffset isEqual:anUploadSessionLookupError.incorrectOffset];
  case DBFILESUploadSessionLookupErrorClosed:
    return [[self tagName] isEqual:[anUploadSessionLookupError tagName]];
  case DBFILESUploadSessionLookupErrorNotClosed:
    return [[self tagName] isEqual:[anUploadSessionLookupError tagName]];
  case DBFILESUploadSessionLookupErrorTooLarge:
    return [[self tagName] isEqual:[anUploadSessionLookupError tagName]];
  case DBFILESUploadSessionLookupErrorConcurrentSessionInvalidOffset:
    return [[self tagName] isEqual:[anUploadSessionLookupError tagName]];
  case DBFILESUploadSessionLookupErrorConcurrentSessionInvalidDataSize:
    return [[self tagName] isEqual:[anUploadSessionLookupError tagName]];
  case DBFILESUploadSessionLookupErrorOther:
    return [[self tagName] isEqual:[anUploadSessionLookupError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionLookupErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionLookupError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isIncorrectOffset]) {
    jsonDict = [[DBFILESUploadSessionOffsetErrorSerializer serialize:valueObj.incorrectOffset] mutableCopy];
    jsonDict[@".tag"] = @"incorrect_offset";
  } else if ([valueObj isClosed]) {
    jsonDict[@".tag"] = @"closed";
  } else if ([valueObj isNotClosed]) {
    jsonDict[@".tag"] = @"not_closed";
  } else if ([valueObj isTooLarge]) {
    jsonDict[@".tag"] = @"too_large";
  } else if ([valueObj isConcurrentSessionInvalidOffset]) {
    jsonDict[@".tag"] = @"concurrent_session_invalid_offset";
  } else if ([valueObj isConcurrentSessionInvalidDataSize]) {
    jsonDict[@".tag"] = @"concurrent_session_invalid_data_size";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionLookupError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILESUploadSessionLookupError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"incorrect_offset"]) {
    DBFILESUploadSessionOffsetError *incorrectOffset =
        [DBFILESUploadSessionOffsetErrorSerializer deserialize:valueDict];
    return [[DBFILESUploadSessionLookupError alloc] initWithIncorrectOffset:incorrectOffset];
  } else if ([tag isEqualToString:@"closed"]) {
    return [[DBFILESUploadSessionLookupError alloc] initWithClosed];
  } else if ([tag isEqualToString:@"not_closed"]) {
    return [[DBFILESUploadSessionLookupError alloc] initWithNotClosed];
  } else if ([tag isEqualToString:@"too_large"]) {
    return [[DBFILESUploadSessionLookupError alloc] initWithTooLarge];
  } else if ([tag isEqualToString:@"concurrent_session_invalid_offset"]) {
    return [[DBFILESUploadSessionLookupError alloc] initWithConcurrentSessionInvalidOffset];
  } else if ([tag isEqualToString:@"concurrent_session_invalid_data_size"]) {
    return [[DBFILESUploadSessionLookupError alloc] initWithConcurrentSessionInvalidDataSize];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESUploadSessionLookupError alloc] initWithOther];
  } else {
    return [[DBFILESUploadSessionLookupError alloc] initWithOther];
  }
}

@end

#import "DBFILESUploadSessionOffsetError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionOffsetError

#pragma mark - Constructors

- (instancetype)initWithCorrectOffset:(NSNumber *)correctOffset {
  [DBStoneValidators nonnullValidator:nil](correctOffset);

  self = [super init];
  if (self) {
    _correctOffset = correctOffset;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionOffsetErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionOffsetErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionOffsetErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.correctOffset hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionOffsetError:other];
}

- (BOOL)isEqualToUploadSessionOffsetError:(DBFILESUploadSessionOffsetError *)anUploadSessionOffsetError {
  if (self == anUploadSessionOffsetError) {
    return YES;
  }
  if (![self.correctOffset isEqual:anUploadSessionOffsetError.correctOffset]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionOffsetErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionOffsetError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"correct_offset"] = valueObj.correctOffset;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionOffsetError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *correctOffset = valueDict[@"correct_offset"];

  return [[DBFILESUploadSessionOffsetError alloc] initWithCorrectOffset:correctOffset];
}

@end

#import "DBFILESUploadSessionStartArg.h"
#import "DBFILESUploadSessionType.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionStartArg

#pragma mark - Constructors

- (instancetype)initWithClose:(NSNumber *)close sessionType:(DBFILESUploadSessionType *)sessionType {

  self = [super init];
  if (self) {
    _close = close ?: @NO;
    _sessionType = sessionType;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithClose:nil sessionType:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionStartArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionStartArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionStartArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.close hash];
  if (self.sessionType != nil) {
    result = prime * result + [self.sessionType hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionStartArg:other];
}

- (BOOL)isEqualToUploadSessionStartArg:(DBFILESUploadSessionStartArg *)anUploadSessionStartArg {
  if (self == anUploadSessionStartArg) {
    return YES;
  }
  if (![self.close isEqual:anUploadSessionStartArg.close]) {
    return NO;
  }
  if (self.sessionType) {
    if (![self.sessionType isEqual:anUploadSessionStartArg.sessionType]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionStartArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionStartArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"close"] = valueObj.close;
  if (valueObj.sessionType) {
    jsonDict[@"session_type"] = [DBFILESUploadSessionTypeSerializer serialize:valueObj.sessionType];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionStartArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *close = valueDict[@"close"] ?: @NO;
  DBFILESUploadSessionType *sessionType =
      valueDict[@"session_type"] ? [DBFILESUploadSessionTypeSerializer deserialize:valueDict[@"session_type"]] : nil;

  return [[DBFILESUploadSessionStartArg alloc] initWithClose:close sessionType:sessionType];
}

@end

#import "DBFILESUploadSessionStartError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionStartError

#pragma mark - Constructors

- (instancetype)initWithConcurrentSessionDataNotAllowed {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionStartErrorConcurrentSessionDataNotAllowed;
  }
  return self;
}

- (instancetype)initWithConcurrentSessionCloseNotAllowed {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionStartErrorConcurrentSessionCloseNotAllowed;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionStartErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isConcurrentSessionDataNotAllowed {
  return _tag == DBFILESUploadSessionStartErrorConcurrentSessionDataNotAllowed;
}

- (BOOL)isConcurrentSessionCloseNotAllowed {
  return _tag == DBFILESUploadSessionStartErrorConcurrentSessionCloseNotAllowed;
}

- (BOOL)isOther {
  return _tag == DBFILESUploadSessionStartErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESUploadSessionStartErrorConcurrentSessionDataNotAllowed:
    return @"DBFILESUploadSessionStartErrorConcurrentSessionDataNotAllowed";
  case DBFILESUploadSessionStartErrorConcurrentSessionCloseNotAllowed:
    return @"DBFILESUploadSessionStartErrorConcurrentSessionCloseNotAllowed";
  case DBFILESUploadSessionStartErrorOther:
    return @"DBFILESUploadSessionStartErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionStartErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionStartErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionStartErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESUploadSessionStartErrorConcurrentSessionDataNotAllowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionStartErrorConcurrentSessionCloseNotAllowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionStartErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionStartError:other];
}

- (BOOL)isEqualToUploadSessionStartError:(DBFILESUploadSessionStartError *)anUploadSessionStartError {
  if (self == anUploadSessionStartError) {
    return YES;
  }
  if (self.tag != anUploadSessionStartError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESUploadSessionStartErrorConcurrentSessionDataNotAllowed:
    return [[self tagName] isEqual:[anUploadSessionStartError tagName]];
  case DBFILESUploadSessionStartErrorConcurrentSessionCloseNotAllowed:
    return [[self tagName] isEqual:[anUploadSessionStartError tagName]];
  case DBFILESUploadSessionStartErrorOther:
    return [[self tagName] isEqual:[anUploadSessionStartError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionStartErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionStartError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isConcurrentSessionDataNotAllowed]) {
    jsonDict[@".tag"] = @"concurrent_session_data_not_allowed";
  } else if ([valueObj isConcurrentSessionCloseNotAllowed]) {
    jsonDict[@".tag"] = @"concurrent_session_close_not_allowed";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionStartError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"concurrent_session_data_not_allowed"]) {
    return [[DBFILESUploadSessionStartError alloc] initWithConcurrentSessionDataNotAllowed];
  } else if ([tag isEqualToString:@"concurrent_session_close_not_allowed"]) {
    return [[DBFILESUploadSessionStartError alloc] initWithConcurrentSessionCloseNotAllowed];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESUploadSessionStartError alloc] initWithOther];
  } else {
    return [[DBFILESUploadSessionStartError alloc] initWithOther];
  }
}

@end

#import "DBFILESUploadSessionStartResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionStartResult

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId {
  [DBStoneValidators nonnullValidator:nil](sessionId);

  self = [super init];
  if (self) {
    _sessionId = sessionId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionStartResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionStartResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionStartResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sessionId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionStartResult:other];
}

- (BOOL)isEqualToUploadSessionStartResult:(DBFILESUploadSessionStartResult *)anUploadSessionStartResult {
  if (self == anUploadSessionStartResult) {
    return YES;
  }
  if (![self.sessionId isEqual:anUploadSessionStartResult.sessionId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionStartResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionStartResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"session_id"] = valueObj.sessionId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionStartResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sessionId = valueDict[@"session_id"];

  return [[DBFILESUploadSessionStartResult alloc] initWithSessionId:sessionId];
}

@end

#import "DBFILESUploadSessionType.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadSessionType

#pragma mark - Constructors

- (instancetype)initWithSequential {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionTypeSequential;
  }
  return self;
}

- (instancetype)initWithConcurrent {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionTypeConcurrent;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESUploadSessionTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isSequential {
  return _tag == DBFILESUploadSessionTypeSequential;
}

- (BOOL)isConcurrent {
  return _tag == DBFILESUploadSessionTypeConcurrent;
}

- (BOOL)isOther {
  return _tag == DBFILESUploadSessionTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESUploadSessionTypeSequential:
    return @"DBFILESUploadSessionTypeSequential";
  case DBFILESUploadSessionTypeConcurrent:
    return @"DBFILESUploadSessionTypeConcurrent";
  case DBFILESUploadSessionTypeOther:
    return @"DBFILESUploadSessionTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadSessionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadSessionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadSessionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESUploadSessionTypeSequential:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionTypeConcurrent:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESUploadSessionTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadSessionType:other];
}

- (BOOL)isEqualToUploadSessionType:(DBFILESUploadSessionType *)anUploadSessionType {
  if (self == anUploadSessionType) {
    return YES;
  }
  if (self.tag != anUploadSessionType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESUploadSessionTypeSequential:
    return [[self tagName] isEqual:[anUploadSessionType tagName]];
  case DBFILESUploadSessionTypeConcurrent:
    return [[self tagName] isEqual:[anUploadSessionType tagName]];
  case DBFILESUploadSessionTypeOther:
    return [[self tagName] isEqual:[anUploadSessionType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadSessionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSequential]) {
    jsonDict[@".tag"] = @"sequential";
  } else if ([valueObj isConcurrent]) {
    jsonDict[@".tag"] = @"concurrent";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadSessionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"sequential"]) {
    return [[DBFILESUploadSessionType alloc] initWithSequential];
  } else if ([tag isEqualToString:@"concurrent"]) {
    return [[DBFILESUploadSessionType alloc] initWithConcurrent];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESUploadSessionType alloc] initWithOther];
  } else {
    return [[DBFILESUploadSessionType alloc] initWithOther];
  }
}

@end

#import "DBFILESUploadWriteFailed.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESUploadWriteFailed

#pragma mark - Constructors

- (instancetype)initWithReason:(DBFILESWriteError *)reason uploadSessionId:(NSString *)uploadSessionId {
  [DBStoneValidators nonnullValidator:nil](reason);
  [DBStoneValidators nonnullValidator:nil](uploadSessionId);

  self = [super init];
  if (self) {
    _reason = reason;
    _uploadSessionId = uploadSessionId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESUploadWriteFailedSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESUploadWriteFailedSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESUploadWriteFailedSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.reason hash];
  result = prime * result + [self.uploadSessionId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUploadWriteFailed:other];
}

- (BOOL)isEqualToUploadWriteFailed:(DBFILESUploadWriteFailed *)anUploadWriteFailed {
  if (self == anUploadWriteFailed) {
    return YES;
  }
  if (![self.reason isEqual:anUploadWriteFailed.reason]) {
    return NO;
  }
  if (![self.uploadSessionId isEqual:anUploadWriteFailed.uploadSessionId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESUploadWriteFailedSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESUploadWriteFailed *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"reason"] = [DBFILESWriteErrorSerializer serialize:valueObj.reason];
  jsonDict[@"upload_session_id"] = valueObj.uploadSessionId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESUploadWriteFailed *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESWriteError *reason = [DBFILESWriteErrorSerializer deserialize:valueDict[@"reason"]];
  NSString *uploadSessionId = valueDict[@"upload_session_id"];

  return [[DBFILESUploadWriteFailed alloc] initWithReason:reason uploadSessionId:uploadSessionId];
}

@end

#import "DBFILESDimensions.h"
#import "DBFILESGpsCoordinates.h"
#import "DBFILESMediaMetadata.h"
#import "DBFILESVideoMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESVideoMetadata

#pragma mark - Constructors

- (instancetype)initWithDimensions:(DBFILESDimensions *)dimensions
                          location:(DBFILESGpsCoordinates *)location
                         timeTaken:(NSDate *)timeTaken
                          duration:(NSNumber *)duration {

  self = [super initWithDimensions:dimensions location:location timeTaken:timeTaken];
  if (self) {
    _duration = duration;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithDimensions:nil location:nil timeTaken:nil duration:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESVideoMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESVideoMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESVideoMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.dimensions != nil) {
    result = prime * result + [self.dimensions hash];
  }
  if (self.location != nil) {
    result = prime * result + [self.location hash];
  }
  if (self.timeTaken != nil) {
    result = prime * result + [self.timeTaken hash];
  }
  if (self.duration != nil) {
    result = prime * result + [self.duration hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToVideoMetadata:other];
}

- (BOOL)isEqualToVideoMetadata:(DBFILESVideoMetadata *)aVideoMetadata {
  if (self == aVideoMetadata) {
    return YES;
  }
  if (self.dimensions) {
    if (![self.dimensions isEqual:aVideoMetadata.dimensions]) {
      return NO;
    }
  }
  if (self.location) {
    if (![self.location isEqual:aVideoMetadata.location]) {
      return NO;
    }
  }
  if (self.timeTaken) {
    if (![self.timeTaken isEqual:aVideoMetadata.timeTaken]) {
      return NO;
    }
  }
  if (self.duration) {
    if (![self.duration isEqual:aVideoMetadata.duration]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESVideoMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESVideoMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.dimensions) {
    jsonDict[@"dimensions"] = [DBFILESDimensionsSerializer serialize:valueObj.dimensions];
  }
  if (valueObj.location) {
    jsonDict[@"location"] = [DBFILESGpsCoordinatesSerializer serialize:valueObj.location];
  }
  if (valueObj.timeTaken) {
    jsonDict[@"time_taken"] = [DBNSDateSerializer serialize:valueObj.timeTaken dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.duration) {
    jsonDict[@"duration"] = valueObj.duration;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESVideoMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBFILESDimensions *dimensions =
      valueDict[@"dimensions"] ? [DBFILESDimensionsSerializer deserialize:valueDict[@"dimensions"]] : nil;
  DBFILESGpsCoordinates *location =
      valueDict[@"location"] ? [DBFILESGpsCoordinatesSerializer deserialize:valueDict[@"location"]] : nil;
  NSDate *timeTaken = valueDict[@"time_taken"]
                          ? [DBNSDateSerializer deserialize:valueDict[@"time_taken"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                          : nil;
  NSNumber *duration = valueDict[@"duration"] ?: nil;

  return [[DBFILESVideoMetadata alloc] initWithDimensions:dimensions
                                                 location:location
                                                timeTaken:timeTaken
                                                 duration:duration];
}

@end

#import "DBFILESWriteConflictError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESWriteConflictError

#pragma mark - Constructors

- (instancetype)initWithFile {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteConflictErrorFile;
  }
  return self;
}

- (instancetype)initWithFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteConflictErrorFolder;
  }
  return self;
}

- (instancetype)initWithFileAncestor {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteConflictErrorFileAncestor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteConflictErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isFile {
  return _tag == DBFILESWriteConflictErrorFile;
}

- (BOOL)isFolder {
  return _tag == DBFILESWriteConflictErrorFolder;
}

- (BOOL)isFileAncestor {
  return _tag == DBFILESWriteConflictErrorFileAncestor;
}

- (BOOL)isOther {
  return _tag == DBFILESWriteConflictErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESWriteConflictErrorFile:
    return @"DBFILESWriteConflictErrorFile";
  case DBFILESWriteConflictErrorFolder:
    return @"DBFILESWriteConflictErrorFolder";
  case DBFILESWriteConflictErrorFileAncestor:
    return @"DBFILESWriteConflictErrorFileAncestor";
  case DBFILESWriteConflictErrorOther:
    return @"DBFILESWriteConflictErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESWriteConflictErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESWriteConflictErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESWriteConflictErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESWriteConflictErrorFile:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteConflictErrorFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteConflictErrorFileAncestor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteConflictErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToWriteConflictError:other];
}

- (BOOL)isEqualToWriteConflictError:(DBFILESWriteConflictError *)aWriteConflictError {
  if (self == aWriteConflictError) {
    return YES;
  }
  if (self.tag != aWriteConflictError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESWriteConflictErrorFile:
    return [[self tagName] isEqual:[aWriteConflictError tagName]];
  case DBFILESWriteConflictErrorFolder:
    return [[self tagName] isEqual:[aWriteConflictError tagName]];
  case DBFILESWriteConflictErrorFileAncestor:
    return [[self tagName] isEqual:[aWriteConflictError tagName]];
  case DBFILESWriteConflictErrorOther:
    return [[self tagName] isEqual:[aWriteConflictError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESWriteConflictErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESWriteConflictError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFile]) {
    jsonDict[@".tag"] = @"file";
  } else if ([valueObj isFolder]) {
    jsonDict[@".tag"] = @"folder";
  } else if ([valueObj isFileAncestor]) {
    jsonDict[@".tag"] = @"file_ancestor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESWriteConflictError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"file"]) {
    return [[DBFILESWriteConflictError alloc] initWithFile];
  } else if ([tag isEqualToString:@"folder"]) {
    return [[DBFILESWriteConflictError alloc] initWithFolder];
  } else if ([tag isEqualToString:@"file_ancestor"]) {
    return [[DBFILESWriteConflictError alloc] initWithFileAncestor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESWriteConflictError alloc] initWithOther];
  } else {
    return [[DBFILESWriteConflictError alloc] initWithOther];
  }
}

@end

#import "DBFILESWriteConflictError.h"
#import "DBFILESWriteError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESWriteError

@synthesize malformedPath = _malformedPath;
@synthesize conflict = _conflict;

#pragma mark - Constructors

- (instancetype)initWithMalformedPath:(NSString *)malformedPath {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteErrorMalformedPath;
    _malformedPath = malformedPath;
  }
  return self;
}

- (instancetype)initWithConflict:(DBFILESWriteConflictError *)conflict {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteErrorConflict;
    _conflict = conflict;
  }
  return self;
}

- (instancetype)initWithNoWritePermission {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteErrorNoWritePermission;
  }
  return self;
}

- (instancetype)initWithInsufficientSpace {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteErrorInsufficientSpace;
  }
  return self;
}

- (instancetype)initWithDisallowedName {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteErrorDisallowedName;
  }
  return self;
}

- (instancetype)initWithTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteErrorTeamFolder;
  }
  return self;
}

- (instancetype)initWithOperationSuppressed {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteErrorOperationSuppressed;
  }
  return self;
}

- (instancetype)initWithTooManyWriteOperations {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteErrorTooManyWriteOperations;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)malformedPath {
  if (![self isMalformedPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESWriteErrorMalformedPath, but was %@.", [self tagName]];
  }
  return _malformedPath;
}

- (DBFILESWriteConflictError *)conflict {
  if (![self isConflict]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESWriteErrorConflict, but was %@.", [self tagName]];
  }
  return _conflict;
}

#pragma mark - Tag state methods

- (BOOL)isMalformedPath {
  return _tag == DBFILESWriteErrorMalformedPath;
}

- (BOOL)isConflict {
  return _tag == DBFILESWriteErrorConflict;
}

- (BOOL)isNoWritePermission {
  return _tag == DBFILESWriteErrorNoWritePermission;
}

- (BOOL)isInsufficientSpace {
  return _tag == DBFILESWriteErrorInsufficientSpace;
}

- (BOOL)isDisallowedName {
  return _tag == DBFILESWriteErrorDisallowedName;
}

- (BOOL)isTeamFolder {
  return _tag == DBFILESWriteErrorTeamFolder;
}

- (BOOL)isOperationSuppressed {
  return _tag == DBFILESWriteErrorOperationSuppressed;
}

- (BOOL)isTooManyWriteOperations {
  return _tag == DBFILESWriteErrorTooManyWriteOperations;
}

- (BOOL)isOther {
  return _tag == DBFILESWriteErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESWriteErrorMalformedPath:
    return @"DBFILESWriteErrorMalformedPath";
  case DBFILESWriteErrorConflict:
    return @"DBFILESWriteErrorConflict";
  case DBFILESWriteErrorNoWritePermission:
    return @"DBFILESWriteErrorNoWritePermission";
  case DBFILESWriteErrorInsufficientSpace:
    return @"DBFILESWriteErrorInsufficientSpace";
  case DBFILESWriteErrorDisallowedName:
    return @"DBFILESWriteErrorDisallowedName";
  case DBFILESWriteErrorTeamFolder:
    return @"DBFILESWriteErrorTeamFolder";
  case DBFILESWriteErrorOperationSuppressed:
    return @"DBFILESWriteErrorOperationSuppressed";
  case DBFILESWriteErrorTooManyWriteOperations:
    return @"DBFILESWriteErrorTooManyWriteOperations";
  case DBFILESWriteErrorOther:
    return @"DBFILESWriteErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESWriteErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESWriteErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESWriteErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESWriteErrorMalformedPath:
    if (self.malformedPath != nil) {
      result = prime * result + [self.malformedPath hash];
    }
    break;
  case DBFILESWriteErrorConflict:
    result = prime * result + [self.conflict hash];
    break;
  case DBFILESWriteErrorNoWritePermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteErrorInsufficientSpace:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteErrorDisallowedName:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteErrorTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteErrorOperationSuppressed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteErrorTooManyWriteOperations:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToWriteError:other];
}

- (BOOL)isEqualToWriteError:(DBFILESWriteError *)aWriteError {
  if (self == aWriteError) {
    return YES;
  }
  if (self.tag != aWriteError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESWriteErrorMalformedPath:
    if (self.malformedPath) {
      return [self.malformedPath isEqual:aWriteError.malformedPath];
    }
  case DBFILESWriteErrorConflict:
    return [self.conflict isEqual:aWriteError.conflict];
  case DBFILESWriteErrorNoWritePermission:
    return [[self tagName] isEqual:[aWriteError tagName]];
  case DBFILESWriteErrorInsufficientSpace:
    return [[self tagName] isEqual:[aWriteError tagName]];
  case DBFILESWriteErrorDisallowedName:
    return [[self tagName] isEqual:[aWriteError tagName]];
  case DBFILESWriteErrorTeamFolder:
    return [[self tagName] isEqual:[aWriteError tagName]];
  case DBFILESWriteErrorOperationSuppressed:
    return [[self tagName] isEqual:[aWriteError tagName]];
  case DBFILESWriteErrorTooManyWriteOperations:
    return [[self tagName] isEqual:[aWriteError tagName]];
  case DBFILESWriteErrorOther:
    return [[self tagName] isEqual:[aWriteError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESWriteErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESWriteError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isMalformedPath]) {
    if (valueObj.malformedPath) {
      jsonDict[@"malformed_path"] = valueObj.malformedPath;
    }
    jsonDict[@".tag"] = @"malformed_path";
  } else if ([valueObj isConflict]) {
    jsonDict[@"conflict"] = [[DBFILESWriteConflictErrorSerializer serialize:valueObj.conflict] mutableCopy];
    jsonDict[@".tag"] = @"conflict";
  } else if ([valueObj isNoWritePermission]) {
    jsonDict[@".tag"] = @"no_write_permission";
  } else if ([valueObj isInsufficientSpace]) {
    jsonDict[@".tag"] = @"insufficient_space";
  } else if ([valueObj isDisallowedName]) {
    jsonDict[@".tag"] = @"disallowed_name";
  } else if ([valueObj isTeamFolder]) {
    jsonDict[@".tag"] = @"team_folder";
  } else if ([valueObj isOperationSuppressed]) {
    jsonDict[@".tag"] = @"operation_suppressed";
  } else if ([valueObj isTooManyWriteOperations]) {
    jsonDict[@".tag"] = @"too_many_write_operations";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESWriteError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"malformed_path"]) {
    NSString *malformedPath = valueDict[@"malformed_path"] ? valueDict[@"malformed_path"] : nil;
    return [[DBFILESWriteError alloc] initWithMalformedPath:malformedPath];
  } else if ([tag isEqualToString:@"conflict"]) {
    DBFILESWriteConflictError *conflict = [DBFILESWriteConflictErrorSerializer deserialize:valueDict[@"conflict"]];
    return [[DBFILESWriteError alloc] initWithConflict:conflict];
  } else if ([tag isEqualToString:@"no_write_permission"]) {
    return [[DBFILESWriteError alloc] initWithNoWritePermission];
  } else if ([tag isEqualToString:@"insufficient_space"]) {
    return [[DBFILESWriteError alloc] initWithInsufficientSpace];
  } else if ([tag isEqualToString:@"disallowed_name"]) {
    return [[DBFILESWriteError alloc] initWithDisallowedName];
  } else if ([tag isEqualToString:@"team_folder"]) {
    return [[DBFILESWriteError alloc] initWithTeamFolder];
  } else if ([tag isEqualToString:@"operation_suppressed"]) {
    return [[DBFILESWriteError alloc] initWithOperationSuppressed];
  } else if ([tag isEqualToString:@"too_many_write_operations"]) {
    return [[DBFILESWriteError alloc] initWithTooManyWriteOperations];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILESWriteError alloc] initWithOther];
  } else {
    return [[DBFILESWriteError alloc] initWithOther];
  }
}

@end

#import "DBFILESWriteMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILESWriteMode

@synthesize update = _update;

#pragma mark - Constructors

- (instancetype)initWithAdd {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteModeAdd;
  }
  return self;
}

- (instancetype)initWithOverwrite {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteModeOverwrite;
  }
  return self;
}

- (instancetype)initWithUpdate:(NSString *)update {
  self = [super init];
  if (self) {
    _tag = DBFILESWriteModeUpdate;
    _update = update;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)update {
  if (![self isUpdate]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBFILESWriteModeUpdate, but was %@.", [self tagName]];
  }
  return _update;
}

#pragma mark - Tag state methods

- (BOOL)isAdd {
  return _tag == DBFILESWriteModeAdd;
}

- (BOOL)isOverwrite {
  return _tag == DBFILESWriteModeOverwrite;
}

- (BOOL)isUpdate {
  return _tag == DBFILESWriteModeUpdate;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILESWriteModeAdd:
    return @"DBFILESWriteModeAdd";
  case DBFILESWriteModeOverwrite:
    return @"DBFILESWriteModeOverwrite";
  case DBFILESWriteModeUpdate:
    return @"DBFILESWriteModeUpdate";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILESWriteModeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILESWriteModeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILESWriteModeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILESWriteModeAdd:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteModeOverwrite:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILESWriteModeUpdate:
    result = prime * result + [self.update hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToWriteMode:other];
}

- (BOOL)isEqualToWriteMode:(DBFILESWriteMode *)aWriteMode {
  if (self == aWriteMode) {
    return YES;
  }
  if (self.tag != aWriteMode.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILESWriteModeAdd:
    return [[self tagName] isEqual:[aWriteMode tagName]];
  case DBFILESWriteModeOverwrite:
    return [[self tagName] isEqual:[aWriteMode tagName]];
  case DBFILESWriteModeUpdate:
    return [self.update isEqual:aWriteMode.update];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILESWriteModeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILESWriteMode *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAdd]) {
    jsonDict[@".tag"] = @"add";
  } else if ([valueObj isOverwrite]) {
    jsonDict[@".tag"] = @"overwrite";
  } else if ([valueObj isUpdate]) {
    jsonDict[@"update"] = valueObj.update;
    jsonDict[@".tag"] = @"update";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILESWriteMode *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"add"]) {
    return [[DBFILESWriteMode alloc] initWithAdd];
  } else if ([tag isEqualToString:@"overwrite"]) {
    return [[DBFILESWriteMode alloc] initWithOverwrite];
  } else if ([tag isEqualToString:@"update"]) {
    NSString *update = valueDict[@"update"];
    return [[DBFILESWriteMode alloc] initWithUpdate:update];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end
