///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESAddPropertiesError;
@class DBFILEPROPERTIESLookupError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AddPropertiesError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEPROPERTIESAddPropertiesError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILEPROPERTIESAddPropertiesErrorTag` enum type represents the
/// possible tag states with which the `DBFILEPROPERTIESAddPropertiesError`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILEPROPERTIESAddPropertiesErrorTag){
    /// Template does not exist for the given identifier.
    DBFILEPROPERTIESAddPropertiesErrorTemplateNotFound,

    /// You do not have permission to modify this template.
    DBFILEPROPERTIESAddPropertiesErrorRestrictedContent,

    /// (no description).
    DBFILEPROPERTIESAddPropertiesErrorOther,

    /// (no description).
    DBFILEPROPERTIESAddPropertiesErrorPath,

    /// This folder cannot be tagged. Tagging folders is not supported for
    /// team-owned templates.
    DBFILEPROPERTIESAddPropertiesErrorUnsupportedFolder,

    /// One or more of the supplied property field values is too large.
    DBFILEPROPERTIESAddPropertiesErrorPropertyFieldTooLarge,

    /// One or more of the supplied property fields does not conform to the
    /// template specifications.
    DBFILEPROPERTIESAddPropertiesErrorDoesNotFitTemplate,

    /// There are 2 or more property groups referring to the same templates in
    /// the input.
    DBFILEPROPERTIESAddPropertiesErrorDuplicatePropertyGroups,

    /// A property group associated with this template and file already exists.
    DBFILEPROPERTIESAddPropertiesErrorPropertyGroupAlreadyExists,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILEPROPERTIESAddPropertiesErrorTag tag;

/// Template does not exist for the given identifier. @note Ensure the
/// `isTemplateNotFound` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *templateNotFound;

/// (no description). @note Ensure the `isPath` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILEPROPERTIESLookupError *path;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "template_not_found".
///
/// Description of the "template_not_found" tag state: Template does not exist
/// for the given identifier.
///
/// @param templateNotFound Template does not exist for the given identifier.
///
/// @return An initialized instance.
///
- (instancetype)initWithTemplateNotFound:(NSString *)templateNotFound;

///
/// Initializes union class with tag state of "restricted_content".
///
/// Description of the "restricted_content" tag state: You do not have
/// permission to modify this template.
///
/// @return An initialized instance.
///
- (instancetype)initWithRestrictedContent;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of "path".
///
/// @param path (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(DBFILEPROPERTIESLookupError *)path;

///
/// Initializes union class with tag state of "unsupported_folder".
///
/// Description of the "unsupported_folder" tag state: This folder cannot be
/// tagged. Tagging folders is not supported for team-owned templates.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnsupportedFolder;

///
/// Initializes union class with tag state of "property_field_too_large".
///
/// Description of the "property_field_too_large" tag state: One or more of the
/// supplied property field values is too large.
///
/// @return An initialized instance.
///
- (instancetype)initWithPropertyFieldTooLarge;

///
/// Initializes union class with tag state of "does_not_fit_template".
///
/// Description of the "does_not_fit_template" tag state: One or more of the
/// supplied property fields does not conform to the template specifications.
///
/// @return An initialized instance.
///
- (instancetype)initWithDoesNotFitTemplate;

///
/// Initializes union class with tag state of "duplicate_property_groups".
///
/// Description of the "duplicate_property_groups" tag state: There are 2 or
/// more property groups referring to the same templates in the input.
///
/// @return An initialized instance.
///
- (instancetype)initWithDuplicatePropertyGroups;

///
/// Initializes union class with tag state of "property_group_already_exists".
///
/// Description of the "property_group_already_exists" tag state: A property
/// group associated with this template and file already exists.
///
/// @return An initialized instance.
///
- (instancetype)initWithPropertyGroupAlreadyExists;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "template_not_found".
///
/// @note Call this method and ensure it returns true before accessing the
/// `templateNotFound` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "template_not_found".
///
- (BOOL)isTemplateNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "restricted_content".
///
/// @return Whether the union's current tag state has value
/// "restricted_content".
///
- (BOOL)isRestrictedContent;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value "path".
///
/// @note Call this method and ensure it returns true before accessing the
/// `path` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path".
///
- (BOOL)isPath;

///
/// Retrieves whether the union's current tag state has value
/// "unsupported_folder".
///
/// @return Whether the union's current tag state has value
/// "unsupported_folder".
///
- (BOOL)isUnsupportedFolder;

///
/// Retrieves whether the union's current tag state has value
/// "property_field_too_large".
///
/// @return Whether the union's current tag state has value
/// "property_field_too_large".
///
- (BOOL)isPropertyFieldTooLarge;

///
/// Retrieves whether the union's current tag state has value
/// "does_not_fit_template".
///
/// @return Whether the union's current tag state has value
/// "does_not_fit_template".
///
- (BOOL)isDoesNotFitTemplate;

///
/// Retrieves whether the union's current tag state has value
/// "duplicate_property_groups".
///
/// @return Whether the union's current tag state has value
/// "duplicate_property_groups".
///
- (BOOL)isDuplicatePropertyGroups;

///
/// Retrieves whether the union's current tag state has value
/// "property_group_already_exists".
///
/// @return Whether the union's current tag state has value
/// "property_group_already_exists".
///
- (BOOL)isPropertyGroupAlreadyExists;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILEPROPERTIESAddPropertiesError` union.
///
@interface DBFILEPROPERTIESAddPropertiesErrorSerializer : NSObject

///
/// Serializes `DBFILEPROPERTIESAddPropertiesError` instances.
///
/// @param instance An instance of the `DBFILEPROPERTIESAddPropertiesError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESAddPropertiesError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEPROPERTIESAddPropertiesError *)instance;

///
/// Deserializes `DBFILEPROPERTIESAddPropertiesError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESAddPropertiesError` API object.
///
/// @return An instantiation of the `DBFILEPROPERTIESAddPropertiesError` object.
///
+ (DBFILEPROPERTIESAddPropertiesError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
