///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBASYNCPollArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PollArg` struct.
///
/// Arguments for methods that poll the status of an asynchronous job.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBASYNCPollArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Id of the asynchronous job. This is the value of a response returned from
/// the method that launched the job.
@property (nonatomic, readonly, copy) NSString *asyncJobId;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param asyncJobId Id of the asynchronous job. This is the value of a
/// response returned from the method that launched the job.
///
/// @return An initialized instance.
///
- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PollArg` struct.
///
@interface DBASYNCPollArgSerializer : NSObject

///
/// Serializes `DBASYNCPollArg` instances.
///
/// @param instance An instance of the `DBASYNCPollArg` API object.
///
/// @return A json-compatible dictionary representation of the `DBASYNCPollArg`
/// API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBASYNCPollArg *)instance;

///
/// Deserializes `DBASYNCPollArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBASYNCPollArg` API object.
///
/// @return An instantiation of the `DBASYNCPollArg` object.
///
+ (DBASYNCPollArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
