//
//  WCXFWrapper.h
//
//

#import "WCCardModel.h"
#import "WCImageDefine.h"
#import "WCXFRootInfoModel.h"
#import "WCXFDataControllerDefine.h"

@class WCXFWrapper;
@protocol WCXFWrapperDelegate <NSObject>

- (BOOL)wrapper:(WCXFWrapper *)wrapper shouldReadCardWithIndex:(NSInteger)index totalCount:(NSInteger)totalCount;
- (void)wrapper:(WCXFWrapper *)wrapper didReadCardInfo:(WCCardModel *)cardModel;
- (void)wrapper:(WCXFWrapper *)wrapper didReadImageData:(NSData *)imageData imageType:(WC_ImageType)imageType cardID:(NSString *)cardID;
- (WC_GroupID)wrapper:(WCXFWrapper *)wrapper groupIDWithGroupName:(NSString *)groupName error:(NSError **)error;
- (void)wrapper:(WCXFWrapper *)wrapper didReadCardWithIndex:(NSInteger)index totalCount:(NSInteger)totalCount;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCXFWrapper : NSObject

@property (nonatomic, assign) WCXFDataController_ProductLine productLine;

- (instancetype)initWithDelegate:(id<WCXFWrapperDelegate>)delegate;

- (BOOL)openFileForWritingWithPath:(NSString *)filePath;
- (BOOL)writeRootInfoWithFilePath:(NSString *)filePath cardCount:(NSInteger)cardCount;
- (BOOL)writeCardInfoWithCardModel:(WCCardModel *)cardModel defaultGroupNames:(NSArray *)defaultGroupNames definedGroupNames:(NSArray *)definedGroupNames imageDataDict:(NSDictionary *)imageDataDict;

- (BOOL)openFileForReadingWithPath:(NSString *)filePath;
- (WCXFRootInfoModel *)copyRootInfo;
- (BOOL)readCardInfoWithTotalCount:(NSInteger)totalCount error:(NSError **)error;

- (void)closeFile;

@end
