//
//  WCTRestClient+PublicContact.h
//  
//
//  Created by Howard on 2016/3/25.
//
//

#import "WCTRestClient.h"

// Model
#import "WCTRCPublicContactsDownloadByContactGuidReponseResult.h"
#import "WCTRCSharedAccountsResponseResult.h"
#import "WCTRCContactNubmerByAccountGuidsResponseResult.h"
#import "WCTRCAllContactNumberResponseResult.h"
#import "WCTRCContactNumberBySelfResponseResult.h"
#import "WCTRCSharedContactStatusResponseResult.h"
#import "WCTRCSharedContactsByCategoryResponseResult.h"
#import "WCTRCShareCategoryListResponseResult.h"
#import "WCTRCShareStatusForOneContactResponseResult.h"
#import "WCTRCContactShareAccountRequest.h"
#import "WCTRCContactShareAccountResponseResult.h"
#import "WCTRCContactGetByAccountRequest.h"
#import "WCTRCSetOwnerOfContactResponseResult.h"
#import "WCTRCListRequest.h"
#import "WCTRCContactGetByGuidListRequest.h"
#import "WCTRCContactListPageResponseResult.h"

// V 1.3
#import "WCTRCSharedContactNumberIsntAccountCategoryResponseResult.h"
#import "WCTRCMLCategorySharedContactNumberWithCategoryGuidsResponseResult.h"
#import "WCTRCContactGetByCategoryAndOwnerVoRequest.h"

@interface WCTRestClient (PublicContact)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  下載公有名片
 *
 *  @param loginToken   登入token
 *  @param contactGuids 連絡人guids
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出

 */
- (RKObjectRequestOperation *)downloadPublicContactsWithLoginToken:(NSString *)loginToken
                                                      contactGuids:(NSArray *)contactGuids
                                                           success:(void (^)(WCTRCPublicContactsDownloadByContactGuidReponseResult *publicContactsDownloadByContactGuidReponseResult))success
                                                           failure:(void (^)(NSError *error))failure;


/**
 *  取得分享帳號
 *
 *  @param loginToken   登入token
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)shareAccountsWithLoginToken:(NSString *)loginToken
                                                  success:(void (^)(WCTRCSharedAccountsResponseResult *sharedAccountsResponseResult))success
                                                  failure:(void (^)(NSError *error))failure;


/**
 *  透過帳號取得連絡人數量
 *
 *  @param loginToken   登入token
 *  @param accountGuids 帳號 guids
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)contactNumberWithLoginToken:(NSString *)loginToken
                                             accountGuids:(NSArray *)accountGuids
                                                  success:(void (^)(WCTRCContactNubmerByAccountGuidsResponseResult *sharedAccountNubmerResponseResult))success
                                                  failure:(void (^)(NSError *error))failure;


/**
 *  取得所有連絡人數量
 *
 *  @param loginToken 登入token
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)allContactNumberWithLoginToken:(NSString *)loginToken
                                                     success:(void (^)(WCTRCAllContactNumberResponseResult *allContactNumberResponseResult))success
                                                     failure:(void (^)(NSError *error))failure;

/**
 *  取得帳號下所有連絡人數量
 *
 *  @param loginToken 登入token
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)contactNumberBySelfWithLoginToken:(NSString *)loginToken
                                                        success:(void (^)(WCTRCContactNumberBySelfResponseResult *contactNumberBySelfResponseResult))success
                                                        failure:(void (^)(NSError *error))failure;

/**
 *  取得連絡人狀態
 *
 *  @param loginToken 登入token
 *  @param contactGuids 連絡人 guids
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)shareContactStatusWithLoginToken:(NSString *)loginToken
                                                  contactGuids:(NSArray *)contactGuids
                                                       success:(void (^)(WCTRCSharedContactStatusResponseResult *sharedContactStatusResponseResult))success
                                                       failure:(void (^)(NSError *error))failure;

/**
 *  取得帳號下連絡列表基本資訊
 *
 *  @param loginToken  loginToken
 *  @param contactGetByAccountRequest 取得帳號下連絡人需求
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)shareContactListWithLoginToken:(NSString *)loginToken
                                  contactGetByAccountRequest:(WCTRCContactGetByAccountRequest *)contactGetByAccountRequest
                                                     success:(void (^)(WCTRCContactListPageResponseResult *sharedContactsByAccountResponseResult))success
                                                     failure:(void (^)(NSError *error))failure;


/**
 *  取得連絡人分享狀態
 *
 *  @param loginToken   登入token
 *  @param contactGuid  連絡人 guid
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)shareStatusForOneContactWithLoginToken:(NSString *)loginToken
                                                         contactGuid:(NSString *)contactGuid
                                                             success:(void (^)(WCTRCShareStatusForOneContactResponseResult *shareStatusForOneContactResponseResult))success
                                                             failure:(void (^)(NSError *error))failure;

/**
 *  分享連絡人至帳號
 *
 *  @param loginToken                 登入token
 *  @param contactShareAccountRequest 需求物件
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)contactShareOperationWithLoginToken:(NSString *)loginToken
                                       contactShareAccountRequest:(WCTRCContactShareAccountRequest *)contactShareAccountRequest
                                                          success:(void (^)(WCTRCContactShareAccountResponseResult *contactShareAccountResponseResult))success
                                                          failure:(void (^)(NSError *error))failure;


/**
 *  設定名片擁有者
 *
 *  @param loginToken          登入token
 *  @param contactGuids        名片guids
 *  @param newOwnerAccountGuid 擁有者
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)setContactOwnerWithLoginToken:(NSString *)loginToken
                                               contactGuids:(NSArray *)contactGuids
                                        newOwnerAccountGuid:(NSString *)newOwnerAccountGuid
                                                    success:(void (^)(WCTRCSetOwnerOfContactResponseResult *setOwnerOfContactResponseResult))success
                                                    failure:(void (^)(NSError *error))failure;



/**
 *  取得指定guid的contact資訊
 *
 *  @param loginToken   登入token
 *  @param request      傳入搜尋的條件
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)contactsWithLoginToken:(NSString *)loginToken
                                             request:(WCTRCContactGetByGuidListRequest *)request
                                             success:(void (^)(WCTRCContactListPageResponseResult *contactListPageResponseResult))success
                                             failure:(void (^)(NSError *error))failure;






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Public Contact Method (V1.3)


/**
 取得公有區裡,某帳號所擁有並且有分享給我,但卻不在他的私有區裡的名片數量.

 @param loginToken 登入 token
 @param accountGuid 帳號 id
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)sharedContactNumberIsntAccountCategoryWithLoginToken:(NSString *)loginToken
                                                                       accountGuid:(NSString *)accountGuid
                                                                           success:(void (^)(WCTRCSharedContactNumberIsntAccountCategoryResponseResult *multiLayerCategorySharedContactNumberIsntAccountCategoryResponseResult))success
                                                                           failure:(void (^)(NSError *failureError))failure;



/**
 傳入公有區裡的類別guid列表,取回這些類別裡的名片數量.

 @param loginToken 登入token
 @param categoryGuids 類別 IDs The NSString of Array
 @param categoryOwnerGuid 擁有者 id
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)sharedContactNumberWithLoginToken:(NSString *)loginToken
                                                  categoryGuids:(NSArray *)categoryGuids
                                              categoryOwnerGuid:(NSString *)categoryOwnerGuid
                                                        success:(void (^)(WCTRCMLCategorySharedContactNumberWithCategoryGuidsResponseResult *multiLayerSharedContactNumberWithCategoryGuidsResponseResult))success
                                                        failure:(void (^)(NSError *failureError))failure;




/**
 取得公有區裡,某帳號所擁有並且有分享給我,但卻不在他的私有區裡的名片列表

 @param loginToken 登入 token
 @param contactGetByAccountRequest 取得物件
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)sharedContactListIsntAccountCategoryWithLoginToken:(NSString *)loginToken
                                                      contactGetByAccountRequest:(WCTRCContactGetByAccountRequest *)contactGetByAccountRequest
                                                                         success:(void (^)(WCTRCContactListPageResponseResult *listPageResponseResult))success
                                                                         failure:(void (^)(NSError *failureError))failure;


/**
 取得公有區裡,某一個類別裡的名片列表

 @param loginToken 登入 token
 @param contactGetByCategoryAndOwnerVoRequest 類別 id
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)sharedContactListWithLoginToken:(NSString *)loginToken
                        contactGetByCategoryAndOwnerVoRequest:(WCTRCContactGetByCategoryAndOwnerVoRequest *)contactGetByCategoryAndOwnerVoRequest
                                                      success:(void (^)(WCTRCContactListPageResponseResult *contactListPageResponseResult))success
                                                      failure:(void (^)(NSError *failureError))failure;

@end
