//
//  WCTRestClient+PrivateContact.h
//
//
//  Created by Howard on 2016/3/16.
//
//

#import "WCTRestClient.h"

// Model
#import "WCTRCContactPageRequest.h"
#import "WCTRCContactUpdateInfoRequest.h"
#import "WCTRCContactCreationWithImageRequest.h"
#import "WCTRCContactSetCategoriesRequest.h"
#import "WCTRCPrivateContactUploadImageResponseResult.h"
#import "WCTRCPrivateContactUpdateResponseResult.h"
#import "WCTRCPrivateContactManualUploadResponseResult.h"
#import "WCTRCPrivateContactScanUploadResponseResult.h"
#import "WCTRCPrivateContactOperateCategoryResponseResult.h"
#import "WCTRCContactGetByCategoryRequest.h"
#import "WCTRCPrivateContactListResponseResult.h"
#import "WCTRCContactsSetFavoriteRequest.h"
#import "WCTRCPrivateContactToggleFavoriteResponseResult.h"
#import "WCTRCPrivateContactDeleteResponseResult.h"
#import "WCTRCContactGetByAccountRequest.h"
#import "WCTRCPrivateContactNumberResponseResult.h"
#import "WCTRCPrivateContactListSetCorrectedResponseResult.h"
#import "WCTRCContactsRemoveFromCategoryRequest.h"
#import "WCTRCContactsRemoveFromCategoryResponseResult.h"
#import "WCTRCPrivateContactResponseResult.h"
#import "WCTRCPrivateContactImageBase64ResponseResult.h"

@interface WCTRestClient (PrivateContact)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  更新連絡人類別操作
 *
 *  @param loginToken                  登入 Token
 *  @param contactSetCategoriesRequest 更新連絡人類別物件
 *  @param success                     成功 回傳
 *  @param failure                     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)privateContactOperateCategoryWithLoginToken:(NSString *)loginToken
                                              contactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                  success:(void (^)(WCTRCPrivateContactOperateCategoryResponseResult *privateContactOperateCategoryResponseResult))success
                                                                  failure:(void (^)(NSError *error))failure;

/**
 *  更新連絡人
 *
 *  @param loginToken        登入 Token
 *  @param contactUpdateInfoRequest 更新連絡人需求物件
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)updatePrivateContactWithLoginToken:(NSString *)loginToken
                                        contactUpdateInfoRequest:(WCTRCContactUpdateInfoRequest *)contactUpdateInfoRequest
                                                         success:(void (^)(WCTRCPrivateContactUpdateResponseResult *privateContactUpdateResponseResult))success
                                                         failure:(void (^)(NSError *error))failure;

/**
 *  上傳連絡人縮圖
 *
 *  @param loginToken 登入 Token
 *  @param image  圖像資料
 *  @param fileName   圖像名稱
 *  @param mineType   圖像類型 WCTRC_MineType_JPG or WCTRC_MineType_PNG
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)uploadPrivateContactImageWithLoginToken:(NSString *)loginToken
                                                                image:(CPImage *)image
                                                             fileName:(NSString *)fileName
                                                             mineType:(NSString *)mineType
                                                              success:(void (^)(WCTRCPrivateContactUploadImageResponseResult *privateContactUploadImageResponseResult))success
                                                              failure:(void (^)(NSError *error))failure;


/**
 *  手動新增名片
 *
 *  @param loginToken 登入 Token
 *  @param contactCreationWithImageRequest 建立模型需求
 *  @param success                         成功 回傳
 *  @param failure                         失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)manualUploadPrivateContactWithLoginToken:(NSString *)loginToken
                                       contactCreationWithImageRequest:(WCTRCContactCreationWithImageRequest *)contactCreationWithImageRequest
                                                               success:(void (^)(WCTRCPrivateContactManualUploadResponseResult *privateContactManualUploadResponseResult))success
                                                               failure:(void (^)(NSError *error))failure;



/**
 新增名片(協助掃描者專用API).
 
 @param loginToken 登入 Token
 @param contactCreationWithImageRequest 需求模型
 @param contactReceiverAccountGuid 要傳入指定要掃給哪一個帳號的GUID
 @param success 成功 回傳
 @param failure 失敗 回傳
 @return nil 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)scanUploadPrivateContactWithLoginToken:(NSString *)loginToken
                                     contactCreationWithImageRequest:(WCTRCContactCreationWithImageRequest *)contactCreationWithImageRequest
                                          contactReceiverAccountGuid:(NSString *)contactReceiverAccountGuid
                                                             success:(void (^)(WCTRCPrivateContactScanUploadResponseResult *privateContactManualUploadResponseResult))success
                                                             failure:(void (^)(NSError *error))failure;

/**
 *  刪除連絡人
 *
 *  @param loginToken  登入 Token
 *  @param contactGuids 連絡人 guids
 *  @param success     成功 回傳
 *  @param failure     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)deletePrivateContactWithLoginToken:(NSString *)loginToken
                                                    contactGuids:(NSArray *)contactGuids
                                                         success:(void (^)(WCTRCPrivateContactDeleteResponseResult *privateContactDeleteResponseResult))success
                                                         failure:(void (^)(NSError *error))failure;


/**
 *  取得類別下連絡人列表
 *
 *  @param loginToken                  登入 Token
 *  @param contactGetByCategoryRequest 需求物件
 *  @param success                     成功 回傳
 *  @param failure                     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)privateContactListUnderCategoryWithLoginToken:(NSString *)loginToken
                                                contactGetByCategoryRequest:(WCTRCContactGetByCategoryRequest *)contactGetByCategoryRequest
                                                                    success:(void (^)(WCTRCPrivateContactListResponseResult *privateContactListResponseResult))success
                                                                    failure:(void (^)(NSError *error))failure;


/**
 *  取得帳號下連絡人列表
 *
 *  @param loginToken                  登入 Token
 *  @param contactGetByAccountRequest  需求物件
 *  @param success                     成功 回傳
 *  @param failure                     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)privateContactListUnderAccountWithLoginToken:(NSString *)loginToken
                                                contactGetByAccountRequest:(WCTRCContactGetByAccountRequest *)contactGetByAccountRequest
                                                                   success:(void (^)(WCTRCPrivateContactListResponseResult *privateContactListResponseResult))success
                                                                   failure:(void (^)(NSError *error))failure;


/**
 *  取得帳號下連絡人數量
 *
 *  @param loginToken  登入 Token
 *  @param accountGuid 帳號 Guid
 *  @param success                     成功 回傳
 *  @param failure                     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)privateContactNumberUnderAccountWithLoginToken:(NSString *)loginToken
                                                                 accountGuid:(NSString *)accountGuid
                                                                     success:(void (^)(WCTRCPrivateContactNumberResponseResult *privateContactNumberResponseResult))success
                                                                     failure:(void (^)(NSError *error))failure;


/**
 *  連絡人加入or取消我的最愛
 *
 *  @param loginToken                 登入 Token
 *  @param contactsSetFavoriteRequest 需求物件
 *  @param success                     成功 回傳
 *  @param failure                     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)toggleFavoriteContactWithLoginToken:(NSString *)loginToken
                                       contactsSetFavoriteRequest:(WCTRCContactsSetFavoriteRequest *)contactsSetFavoriteRequest
                                                          success:(void (^)(WCTRCPrivateContactToggleFavoriteResponseResult *privateContactToggleFavoriteResponseResult))success
                                                          failure:(void (^)(NSError *error))failure;

/**
 *  連絡人設定為已校正
 *
 *  @param loginToken 登入 Token
 *  @param contactGuids 連絡人 guid
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)privateContactListSetCorrectedWithLoginToken:(NSString *)loginToken
                                                              contactGuids:(NSArray *)contactGuids
                                                                   success:(void (^)(WCTRCPrivateContactListSetCorrectedResponseResult *privateContactListSetCorrectedResponseResult))success
                                                                   failure:(void (^)(NSError *error))failure;


/**
 *  連絡人從類別移除
 *
 *  @param loginToken                        登入 Token
 *  @param contactsRemoveFromCategoryRequest 需求物件
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)privateContactsRemoveCategoryWithLoginToken:(NSString *)loginToken
                                        contactsRemoveFromCategoryRequest:(WCTRCContactsRemoveFromCategoryRequest *)contactsRemoveFromCategoryRequest
                                                                  success:(void (^)(WCTRCContactsRemoveFromCategoryResponseResult *contactsRemoveFromCategoryResponseResult))success
                                                                  failure:(void (^)(NSError *error))failure;


/**
 *  取得連絡人詳細資訊
 *
 *  @param loginToken  登入 Token
 *  @param contactGuid 連絡人 Guid
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)privateContactWithLoginToken:(NSString *)loginToken
                                               contactGuid:(NSString *)contactGuid
                                                   success:(void (^)(WCTRCPrivateContactResponseResult *privateContactResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  取得連絡人 ImageBase64 資訊
 *
 *  @param loginToken 登入 Token
 *  @param contactGuid 連絡人 Guid
 *  @param imageType 圖片類型 WCTRC_ImageType_Front, WCTRC_ImageType_Rear, WCTRC_ImageType_Logo
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)privateContactImageBase64WithLoginToken:(NSString *)loginToken
                                                          contactGuid:(NSString *)contactGuid
                                                            imageType:(NSString *)imageType
                                                              success:(void (^)(WCTRCPrivateContactImageBase64ResponseResult *privateContactImageBase64ResponseResult))success
                                                              failure:(void (^)(NSError *error))failure;



/**
 取得連絡人圖檔

 @param loginToken 登入 Token
 @param contactGuid 連絡人 Guid
 @param imageType 圖片類型 WCTRC_ImageType_Front, WCTRC_ImageType_Rear, WCTRC_ImageType_Logo
 @param success    成功 回傳
 @param failure    失敗 回傳
 
 @return 代表需求沒透過網路傳送出
 */
- (AFRKImageRequestOperation *)privateContactImageWithLoginToken:(NSString *)loginToken
                                                     contactGuid:(NSString *)contactGuid
                                                       imageType:(NSString *)imageType
                                                         success:(void (^)(CPImage *image))success
                                                         failure:(void (^)(NSError *error))failure;


/**
 取得連絡人圖檔(NSData)
 
 @param loginToken 登入 Token
 @param contactGuid 連絡人 Guid
 @param imageType 圖片類型 WCTRC_ImageType_Front, WCTRC_ImageType_Rear, WCTRC_ImageType_Logo
 @param success    成功 回傳
 @param failure    失敗 回傳
 
 @return 代表需求沒透過網路傳送出
 */
- (AFRKHTTPRequestOperation *)privateContactImageDataWithLoginToken:(NSString *)loginToken
                                                        contactGuid:(NSString *)contactGuid
                                                          imageType:(NSString *)imageType
                                                            success:(void (^)(NSData *data))success
                                                            failure:(void (^)(NSError *error))failure;



/**
 *  更新連絡人多層類別操作
 *
 *  @param loginToken                  登入 Token
 *  @param contactSetCategoriesRequest 更新連絡人類別物件
 *  @param success                     成功 回傳
 *  @param failure                     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)privateContactOperateMultiCategoryWithLoginToken:(NSString *)loginToken
                                                   contactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                       success:(void (^)(WCTRCPrivateContactOperateCategoryResponseResult *privateContactOperateCategoryResponseResult))success
                                                                       failure:(void (^)(NSError *failureError))failure;






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - TSMC methods
/**
 * 取得匯到saleseforce Contact，但沒有帳戶而失敗的名片
 *  @param loginToken                  登入 Token
 *  @param contactPageRequest 抓取得條件
 *  @param success                     成功 回傳
 *  @param failure                     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
*/
- (RKObjectRequestOperation *)privateNoAccountSFContactWithLoginToken:(NSString *)loginToken
                                                   contactPageRequest:(WCTRCContactPageRequest *)contactPageRequest
                                                              success:(void (^)(WCTRCPrivateContactListResponseResult *contactListResponseResult))success
                                                              failure:(void (^)(NSError *failureError))failure;
@end
