//
//  WCTRestClient+MultiLayerCategory.h
//  
//
//  Created by Howard on 2018/2/13.
//

#import "WCTRestClient.h"

// Model
#import "WCTRCMLCategoryCreationRequest.h"
#import "WCTRCMLCategoryCreationResponseResult.h"
#import "WCTRCMLCategoryPathCreationRequest.h"
#import "WCTRCMLCategoryPathCreationResponseResult.h"
#import "WCTRCMLCategoryDeleteResponseResult.h"
#import "WCTRCMLCategoryInfoListResponseResult.h"
#import "WCTRCMLCategorySetOrderForToggledCategoriesResponseResult.h"
#import "WCTRCCategoryToggleUsualVo.h"
#import "WCTRCMLCategoryToggledCategoriesResponseResult.h"
#import "WCTRCMLCategoryUpdateResponseResult.h"
#import "WCTRCMLCategoryMoveResponseResult.h"
#import "WCTRCMLSetOrderListRequest.h"

@interface WCTRestClient (MultiLayerCategory)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  建立類別
 *
 *  @param loginToken   登入 Token
 *  @param multiLayerCategoryCreationRequest 建立類別物件
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)createMultiLayerCategoryWithLoginToken:(NSString *)loginToken
                                   multiLayerCategoryCreationRequest:(WCTRCMLCategoryCreationRequest *)multiLayerCategoryCreationRequest
                                                             success:(void (^)(WCTRCMLCategoryCreationResponseResult *categoryCreateResponseResult))success
                                                             failure:(void (^)(NSError *failureError))failure;



/**
 建立多層類別

 @param loginToken  登入 Token
 @param categoryPathCreationRequest 建立多層類別物件
 @param success    成功 回傳
 @param failure    失敗 回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)createMultiLayerCategoryPathWithLoginToken:(NSString *)loginToken
                                             categoryPathCreationRequest:(WCTRCMLCategoryPathCreationRequest *)categoryPathCreationRequest
                                                                 success:(void (^)(WCTRCMLCategoryPathCreationResponseResult *categoryPathCreationResponseResult))success
                                                                 failure:(void (^)(NSError *failureError))failure;


/**
 *  刪除類別
 *
 *  @param loginToken 登入 Token
 *  @param categoryGuid 刪除類別Guid
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)deleteMultiLayerCategoryWithLoginToken:(NSString *)loginToken
                                                               categoryGuid:(NSString *)categoryGuid
                                                                     success:(void (^)(WCTRCMLCategoryDeleteResponseResult *multiLayerCategoryDeleteResponseResult))success
                                                                     failure:(void (^)(NSError *failureError))failure;



/**
 取得類別列表

 @param loginToken 登入 token
 @param accountGuid 帳號 ID
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)multiLayerCategoryListWithLoginToken:(NSString *)loginToken
                                                       accountGuid:(NSString *)accountGuid
                                                           success:(void (^)(WCTRCMLCategoryInfoListResponseResult *multiLayerCategoryInfoListResponseResult))success
                                                           failure:(void (^)(NSError *failureError))failure;



/**
 取回指定帳號底下,可做為類別移動目的地的類別列表

 @param loginToken 登入 token
 @param accountGuid 要取哪一個帳號底下的列表
 @param movedCategoryGuid 被移動的類別GUID
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)movableMultiLayerCategoryListWithLoginToken:(NSString *)loginToken
                                                              accountGuid:(NSString *)accountGuid
                                                        movedCategoryGuid:(NSString *)movedCategoryGuid
                                                                  success:(void (^)(WCTRCMLCategoryInfoListResponseResult *multiLayerCategoryInfoListResponseResult))success
                                                                  failure:(void (^)(NSError *failureError))failure;



/**
 取得指定帳號,指定類別底下一層的類別列表,如果不指定類別,會取得該帳號的第一層類別

 @param loginToken 登入 token
 @param accountGuid 帳號 guid
 @param parentCategoryGuid 父類別 guid
 @param needMarkHasChild 是否需要標示類別底下有沒有子類別
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)multiLayerCategoryOneLayerListWithLoginToken:(NSString *)loginToken
                                                               accountGuid:(NSString *)accountGuid
                                                        parentCategoryGuid:(NSString *)parentCategoryGuid
                                                          needMarkHasChild:(BOOL)needMarkHasChild
                                                                   success:(void (^)(WCTRCMLCategoryInfoListResponseResult *multiLayerCategoryInfoListResponseResult))success
                                                                   failure:(void (^)(NSError *failureError))failure;



/**
 按使用者設定的顯示順序,取回登入帳號底下,被標為釘選的類別列表

 @param loginToken 登入 token
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)toggledMultiLayerCategoryListWithLoginToken:(NSString *)loginToken
                                                                  success:(void (^)(WCTRCMLCategoryInfoListResponseResult *multiLayerCategoryInfoListResponseResult))success
                                                                  failure:(void (^)(NSError *failureError))failure;


/**
 設定釘選類別順序

 @param request 釘選類別順序物件
 @param loginToken 登入 token
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)setOrderToggledMultiLayerCategoryListWithRequest:(WCTRCMLSetOrderListRequest *)request
                                                                    loginToken:(NSString *)loginToken
                                                                       success:(void (^)(WCTRCMLCategorySetOrderForToggledCategoriesResponseResult *toggledCategoriesResponseResult))success
                                                                       failure:(void (^)(NSError *failureError))failure;


/**
 將多個類別指定或取消為登入帳號的釘選類別
 

 @param categoryToggleUsualVo 多個類別指定或取消為登入帳號的釘選類別物件
 @param loginToken 登入token
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)setToggledMultiLayerWithCategoryToggleUsualVo:(WCTRCCategoryToggleUsualVo *)categoryToggleUsualVo
                                                                 loginToken:(NSString *)loginToken
                                                                    success:(void (^)(WCTRCMLCategoryToggledCategoriesResponseResult *toggledCategoriesResponseResult))success
                                                                    failure:(void (^)(NSError *failureError))failure;


/**
 修改指定類別的名稱

 @param guid 類別 guid
 @param categoryName 類別名稱
 @param loginToken 登入 token
 @param success 成功回傳
 @param failure 失敗回傳
 @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)updateMultiLayerCategoryWithGuid:(NSString *)guid
                                                  categoryName:(NSString *)categoryName
                                                    loginToken:(NSString *)loginToken
                                                       success:(void (^)(WCTRCMLCategoryUpdateResponseResult *categoryUpdateResponseResult))success
                                                       failure:(void (^)(NSError *failureError))failure;




/**
 將類別移動到某一個指定的父類別底下

 @param guid 類別 guid
 @param parentCategoryGuid 父類別 guid
 @param categoryOwnerGuid 類別擁有者id
 @param loginToken 登入 token
 @param success 成功回傳
 @param failure 失敗回傳
 @return 類別移動到某一個指定的父類別底下結果
 */
- (RKObjectRequestOperation *)moveMultiLayerCategoryWithGuid:(NSString *)guid
                                        toParentCategoryGuid:(NSString *)parentCategoryGuid
                                           categoryOwnerGuid:(NSString *)categoryOwnerGuid
                                                  loginToken:(NSString *)loginToken
                                                     success:(void (^)(WCTRCMLCategoryMoveResponseResult *categoryMoveResponseResult))success
                                                     failure:(void (^)(NSError *failureError))failure;

@end
