//
//  WCTLoginController.h
//  
//
//  Created by Howard on 2017/7/3.
//
//

#import <Foundation/Foundation.h>
#import "WCTLoginController+ParameterDefine.h"


@class WCTRCLoginInfo;

@interface WCTLoginController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 檢查密碼合法性
 
 @param password 密碼
 @param error 回傳錯誤
 @return YES, 密碼合法
 */
+ (BOOL)validPassword:(NSString *)password withError:(NSError **)error;



/**
 字串移除前後空白
 
 @param text 字串
 @return 移除前後空白
 */
+ (NSString *)removeBeforeAndAfterSpaceFromText:(NSString *)text;



/**
 伺服器字串自動補齊

 @param addressString 伺服器地址字串
 @return 補齊的伺服器字串
 */
+ (NSString *)autoFillServerAddressString:(NSString *)addressString;



/**
 完整的伺服器 host 字串

 @param urlHostString 伺服器地址字串
 @return 伺服器 host 字串
 */
+ (NSString *)completeServerUrlHostString:(NSString *)urlHostString;



/**
 連線字串轉 NSURLComponents

 @param urlPath 連線字串
 @return NSURLComponents
 */
+ (NSURLComponents *)urlComponentsFromUrlPath:(NSString *)urlPath;



/**
 NSURLComponents 轉連線字串

 @param components 連線 URLComponents
 @return 連線字串
 */
+ (NSString *)urlPathFromUrlComponents:(NSURLComponents *)components;



/**
 登入成功紀錄時間
 離線模式只有沒有紀錄時才要記，special case for 1.2 upgrade to 1.3
 online每次都要記
 
 @param offlineMode 目前登入模式

 */
+ (void)saveLoginSuccessTimeWithOfflineMode:(BOOL)offlineMode;


/**
 檢查帳號是否為暫停使用，並回傳錯誤
 
 @param loginInfo 登入資訊
 @param error 回傳錯誤原因
 @return 是否為暫停使用
 */
+ (BOOL)isLimitedAccountWithLoginInfo:(WCTRCLoginInfo *)loginInfo returnError:(NSError **)error;


/**
 調整成公有雲的 components
 
 @param components 來源 components
 @param https If Yes https,
 */
+ (void)adjustURLComponents:(NSURLComponents *)components
                  withHttps:(BOOL)https;


/**
 是否為公有伺服器

 @param components 來源 components
 @return YES, 公有伺服器
 */
+ (BOOL)publicServerURLComponents:(NSURLComponents *)components;


+ (NSUInteger)portFromURLHost:(NSString *)host
                    withHttps:(BOOL)https;

+ (BOOL)publicServerURLHost:(NSString *)host;


/**
 取得公有雲網址
 
 @return 公有雲網址
 */
+ (NSString *)cloudServerURLString;

/**
 取得註冊網址
 
 @param longTrialDay  使用長的試用天數
 @return 註冊網址
 */
+ (NSURL *)cloudRegisterURLWithLongTrialDay:(BOOL)longTrialDay;


/**
 是否為公有雲網址 (app.worldcardcloud.com, wct.worldcardteam.com都是)
 
 @param urlString 要驗証的網址
 @return 是否為公有雲網址
 */
+ (BOOL)isCloudServerURLString:(NSString *)urlString;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Login Method

/**
 登入伺服器

 @param urlComponents 伺服器 urlComponents
 @param accountName 帳號名稱
 @param password 密碼
 @param completion 登入回傳
 */
- (void)loginServerByUrlComponents:(NSURLComponents *)urlComponents
                       accountName:(NSString *)accountName
                          password:(NSString *)password
                        completion:(void(^)(WCTRCLoginInfo *loginInfo, WCTLC_ChangePasswordReason changePasswordReason, NSDictionary <NSString *, NSError *> *errorDictionary))completion;

/**
 登入伺服器

 @param urlComponents 伺服器 urlComponents
 @param accountName 帳號名稱
 @param password 密碼
 @param switchUserHandler 切換使用者時的通知
 @param completion 登入回傳
 */
- (void)loginServerByUrlComponents:(NSURLComponents *)urlComponents
                       accountName:(NSString *)accountName
                          password:(NSString *)password
                 switchUserHandler:(void(^)(NSString *preAccountGuid, NSString *curAccountGuid))switchUserHandler
                        completion:(void(^)(WCTRCLoginInfo *loginInfo, WCTLC_ChangePasswordReason changePasswordReason, NSDictionary <NSString *, NSError *> *errorDictionary))completion;




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Forget Password Method


/**
 取得忘記密碼網址

 @param urlString 輸入的伺服器網址
 @param error 錯誤原因
 @return 忘記密碼網址
 */
- (NSURL *)forgetPasswordURLWithUrlString:(NSString *)urlString error:(NSError **)error;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Server Address List Method


/**
 取得紀錄的伺服器字串陣列

 @return 紀錄的伺服器字串陣列
 */
- (NSArray <NSString *> *)recordServerList;



/**
 更新紀錄的伺服器字串陣列

 @param serverUrl 紀錄的伺服器陣列
 */
- (void)recordServerListAddServerURL:(NSString *)serverUrl;


/**
 補齊伺服器清單
 */
- (void)completedServerListRecord;




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Subscription Method


/**
 取得訂閱網址

 @param completion 結束回傳
 */
- (void)subscriptionURLWithCompletion:(void(^)(NSURL *subscriptionURL, NSError *error))completion;


/**
 試用升級
 block都會從main thread call回來
 
 @param checkHandler 檢查邏輯實作
 @param completeHandler 回傳升級結果
 */
+ (void)upgradeFromRetailIfNeededWithCheckHandler:(BOOL(^)(void))checkHandler completeHandler:(void(^)(BOOL needUpgrade, BOOL upgradeSuccess, NSError *error))completeHandler;






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class GetReviewStatus


/**
 * 取得是否在review的狀態, 升級時會自動清除review flag
 * @return completeHandler 回傳結果, 會在background thread call回來
 */

+ (void)getReviewStatusWithCompleteHandler:(void(^)(BOOL isReviewing))completeHandler;

/**
 * 設定可以離線登入的時間
 * @param days 登入成功後，幾天內可以離線登入
 */
+ (void)setOfflineLoginTimeoutDays:(NSInteger)days;






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Log methods
+ (NSString *)logDirPath;
+ (void)logEnable:(BOOL)enable;

@end
