//
//  WCTCardSyncActionModel.h
//  Pods
//
//  Created by Eddie Hu on 2016/4/20.
//
//

#import "WCTSyncActionModel.h"


typedef NS_ENUM(NSInteger, WCTSyncState)
{
    WCTSyncState_UnSync = 0,       // 未同步
    WCTSyncState_Synced,           // 已同步
    WCTSyncState_Synced_Modify,    // 已同步，但又修改
};


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTCardSyncActionModel : WCTSyncActionModel

@property (nonatomic, assign) WCTSyncState syncState;   // 是否有同步過
@property (nonatomic, retain) NSString *groupSHA1;
@property (nonatomic, retain) NSString *contentSHA1;
@property (nonatomic, retain) NSString *sharedAccountSHA1;
@property (nonatomic, retain) NSString *frontSideSHA1;
@property (nonatomic, retain) NSString *backSideSHA1;
@property (nonatomic, retain) NSString *IDPhotoSHA1;

@end
