//
//  WCTAccountSelectViewController.h
//  Pods
//
//  Created by AndrewLai on 2016/4/19.
//
//

#import "PPViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSUInteger, WCTAccountSelectViewControllerStyle)
{
    WCTAccountSelectViewControllerStyle_ShareToColleague = 1,  //分享給同事(不顯示主管)
    WCTAccountSelectViewControllerStyle_ChangeVisibleAccounts, //變更名片可檢視帳號(不顯示主管)
    WCTAccountSelectViewControllerStyle_ViewAccountSwitch,     //切換檢視帳號
    WCTAccountSelectViewControllerStyle_ChangeOwner            //變更名片擁有者(Admin)
};

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountSelectViewControllerDelegate

@class WCTAccountSelectViewController;
@protocol WCTAccountSelectViewControllerDelegate <NSObject>

@required
/**
 *  告知點選完成後，目前勾選的帳號Guid清單
 *
 *  @param accountSelectViewController WCTAccountSelectViewController Object
 *  @param selectAccountArray      勾選的帳號WCTAccountRelationModel清單
 */
- (void)accountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController didSelectAccountArray:(NSArray *)selectAccountArray;

@optional
/**
 *  取得有分享名片給使用者的帳號清單，裡面該包含使用者的帳號資訊，並且擺放於第一個
 *
 *  @param accountSelectViewController WCTAccountSelectViewController Object
 *
 *  @return WCTAccountRelationModel所組成的帳號清單陣列
 */
- (NSArray *)viewAccountListForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController;


/**
 *  取得所有帳號的清單，裡面包含使用者的帳號資訊，每個都包含與使用者的關聯
 *  可透過WCTAccountDataController的updateAccountListFromServerWithCompleteHandler進行網路判斷與資料庫帳號關係清單的更新
 *
 *  @param accountSelectViewController WCTAccountSelectViewController Object
 *
 *  @return WCTAccountRelationModel所組成的帳號清單陣列
 */
- (NSArray *)allAccountListForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController;


/**
 *  若為名片變更可檢視用戶與切換檢視帳號，必需取得已可檢視的帳號清單
 *
 *  @param accountSelectViewController WCTAccountSelectViewController Object
 *
 *  @return 已選擇的可檢視帳號Guid清單
 */
- (NSArray *)selectedAccountGuidListForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController;


/**
 *  若為名片變更可檢視用戶，必須取得該名片的擁有/創建者為哪一個帳號
 *
 *  @param accountSelectViewController WCTAccountSelectViewController Object
 *
 *  @return 名片擁有者的帳號Guid
 */
- (NSString *)ownerAccountGuidForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountSelectViewController Interface

@interface WCTAccountSelectViewController : PPViewController

@property (nonatomic, assign) id<WCTAccountSelectViewControllerDelegate> delegate;
@property (nonatomic, assign) WCTAccountSelectViewControllerStyle style;
@property (nonatomic, retain) id userInfo;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Class Method

/**
 提供外部透過網路擷取已分享名片給使用者的帳號清單，裡面包含使用者帳號

 @param error 回傳錯誤
 @param allCompanyContact 所有公司聯絡人
 @return WCTAccountRelationModel所組成的帳號清單陣列
 */
+ (NSArray *)fetchViewAccountListWithError:(NSError **)error allCompanyContact:(BOOL)allCompanyContact;

@end
