//
//  PPSignatureViewController.h
//
//  Created by Howard.Lin on 14/1/14.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPSignatureViewControllerAction)
{
    PPSignatureViewControllerAction_Back,
    PPSignatureViewControllerAction_Recognition,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPSignatureViewController;

@protocol PPSignatureViewControllerDelegate <NSObject>

@required
 - (void)ppSignatureViewController:(PPSignatureViewController *)signatureController action:(PPSignatureViewControllerAction)action;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSignatureViewController : PPViewController

#pragma mark - Property

@property (nonatomic,assign) id<PPSignatureViewControllerDelegate> delegate;
@property (nonatomic,retain) UIColor                               *textViewTextColor;
@property (nonatomic,retain) UIColor                               *topBarButtonHighlightedBackgroundColor;
@property (nonatomic,retain) UIColor                               *bottomBarBackgroundColor;
@property (nonatomic,retain) UIColor                               *bottomBarFontColor;
@property (nonatomic,assign) CGFloat                               contentFontSize;
@property (nonatomic,assign) CGFloat                               bottomBarFontSize;
@property (nonatomic,copy)   NSString                              *controllerTitle;
@property (nonatomic,assign) UIEdgeInsets                          buttonImageEdgeInset;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (NSString *)recognitionString;
- (void)setRecognitionString:(NSString *)recognitionString;

@end
