//
//  WCMultiLayerGroupPickerViewController.h
//  ADAL
//
//  Created by sanhue on 2018/3/8.
//

#import "WCGroupTreeViewController.h"


@class WCMultiLayerGroupPickerViewController;

typedef void(^WCMLGroupPickerFinishHandler)(WCMultiLayerGroupPickerViewController *viewController);
typedef void(^WCMLGroupPickerSelectionHandler)(NSArray *selectedGroups);
typedef NSArray *(^WCMLGroupPickerRequestSourceHandler)(NSError **error);
typedef NSString *(^WCMLGroupPickerRequestErrorMessageHandler)(NSError *error);

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCMultiLayerGroupPickerViewController : WCGroupTreeViewController

+ (void)showMultiLayerGroupPickerViewConrollerFromViewController:(UIViewController *)viewController
                                                     titleString:(NSString *)titleString
                                                  multiSelection:(BOOL)multiSelection
                                              exclusiveWithOther:(BOOL)exclusiveWithOther
                                                    forcePresent:(BOOL)forcePresent
                                       requestSourceGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSourceGroupHandler
                                     requestSelectedGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSelectedGroupHandler
                                                selectionHandler:(WCMLGroupPickerSelectionHandler)selectionHandler;

+ (void)showMultiLayerGroupPickerViewConrollerFromViewController:(UIViewController *)viewController
                                                     titleString:(NSString *)titleString
                                                  multiSelection:(BOOL)multiSelection
                                           checkWhileNoSelection:(BOOL)checkWhileNoSelection
                                              exclusiveWithOther:(BOOL)exclusiveWithOther
                                                    forcePresent:(BOOL)forcePresent
                                       requestSourceGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSourceGroupHandler
                                     requestSelectedGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSelectedGroupHandler
                                                selectionHandler:(WCMLGroupPickerSelectionHandler)selectionHandler;


/**
 * 顯示多選清單
 * @param viewController view controller to show from
 * @param titleString title string
 * @param multiSelection YES, if multi select item, NO, Single select
 * @param showPinButton YES, show pin button 
 * @param enablePin when showPinButton is YES, enablePin YES if need pin, else NO
 * @param checkWhileNoSelection when multiSelection==YES, checkWhileNoSelection==YES,  check other while requestSelectedGroupHandler return nil;
 * @param exclusiveWithOther 類別"其他聯絡人"是否與其他類別互斥
 * @param forcePresent YES, force create a new navigation controller; NO, use original navigation controller
 * @param requestSourceGroupHandler block for request All group
 * @param requestSelectedGroupHandler block for request selected group
 * @param selectionHandler block for notice user selection
 * @param finishHandler block for notice end of selection. You need end the view controller yourself.
 */
+ (void)showMultiLayerGroupPickerViewConrollerFromViewController:(UIViewController *)viewController
                                                     titleString:(NSString *)titleString
                                                  multiSelection:(BOOL)multiSelection
                                                   showPinButton:(BOOL)showPinButton
                                                       enablePin:(BOOL)enablePin
                                           checkWhileNoSelection:(BOOL)checkWhileNoSelection
                                              exclusiveWithOther:(BOOL)exclusiveWithOther
                                                    forcePresent:(BOOL)forcePresent
                                       requestSourceGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSourceGroupHandler
                                     requestSelectedGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSelectedGroupHandler
                                      requestErrorMessageHandler:(WCMLGroupPickerRequestErrorMessageHandler)requestErrorMessageHandler
                                                selectionHandler:(WCMLGroupPickerSelectionHandler)selectionHandler
                                                   finishHandler:(WCMLGroupPickerFinishHandler)finishHandler;
@end

