//
//  WCGroupTreeViewController.h
//  Example
//
//  Created by sanhue on 2018/2/27.
//  Copyright © 2018年 penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPViewController.h"
#import "WCGroupView.h"
#import "WCGroupModel.h"

typedef NS_ENUM(NSInteger, WCGroupTreeViewControllerErroCode)
{
    WCGroupTreeViewControllerErroCode_None = 0,
    WCGroupTreeViewControllerErroCode_GetCategoryListFailed,
    WCGroupTreeViewControllerErroCode_FailedToCreateCategory,
    WCGroupTreeViewControllerErroCode_FailedToRenameCategory,
    WCGroupTreeViewControllerErroCode_FailedToMoveCategory,
    WCGroupTreeViewControllerErroCode_FailedToDeleteCategory
};

@class WCGroupTreeViewController;

@protocol WCGroupTreeViewControllerDelegate <NSObject>

/**
 *  取得group tree
 *
 *  @param groupTreeViewController WCGroupTreeViewController
 *  @param error 回傳錯誤
 *  @return array of WCGroupModel
 */
- (NSArray *)groupsWithWCGroupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController error:(NSError **)error;


@optional

#pragma mark - error message handler
/**
 * 客制化錯誤
 * @param groupTreeViewController WCGroupTreeViewController
 * @param error 目前錯誤
 * @return 要顯示的錯誤字串，沒有要客制化則回傳nil，會顯示預設錯誤訊息
 */
- (NSString *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController requestErrorMessageForError:(NSError *)error;

#pragma mark - for group add


/**
 *  取得已選取的group列表
 *
 *  @param groupTreeViewController WCGroupTreeViewController
 *  @param error 回傳錯誤
 *  @return array of WCGroupModel that selected
 */
- (NSArray *)selectedGroupsWithWCGroupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController error:(NSError **)error;


#pragma mark - for group add

/**
 *  詢問group名稱是否已存在，不存在才可以新增
 *
 *  @param groupTreeViewController WCGroupTreeViewController
 *  @param groupNamed                  要詢問的群組名稱
 */
- (BOOL)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController isExistGroupNamed:(NSString*)groupNamed;

/**
 *  新增按下確定後，通知要新增群組，並回傳新增後的群組資訊
 *
 *  @param groupTreeViewController WCGroupTreeViewController
 *  @param groupName           新增的群組名稱
 *  @param superGroupGuid      父類別ID
 */
- (WCGroupModel *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController groupModelByNewGroupName:(NSString *)groupName superGroupGuid:(NSString *)superGroupGuid error:(NSError **)error;

#pragma mark - for group edit style

/**
 *  編輯按下確定後，通知要更新群組
 *
 *  @param groupTreeViewController WCGroupTreeViewController
 *  @param groupModel                  要更新的群組
 *  @return 更新失敗原因
 */
- (NSError *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController updateGroupModel:(WCGroupModel *)groupModel;


/**
 *  按下刪除後，通知要刪除群組
 *
 *  @param groupTreeViewController WCGroupTreeViewController
 *  @param groupModel                  要刪除的群組
 */
- (NSError *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController deleteGroupModel:(WCGroupModel *)groupModel;

#pragma mark - for group move
/**
 *  取得可移動的群組列表
 *
 *  @param groupModel 要搬移的群組
 *  @param groupTreeViewController WCGroupTreeViewController
 *  @param error 回傳錯誤訊息
 *  @return 可移動的群組列表
 */
- (NSArray *)validParentsForMoveGroupModel:(WCGroupModel *)groupModel withGroupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController error:(NSError **)error;

/**
 *  按下移動，通知要移動群組
 *
 *  @param groupTreeViewController WCGroupTreeViewController
 *  @param groupModel 要搬移的群組
 *  @param parentGuid 要搬到哪個群組下
 */
- (NSError *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController moveGroupModel:(WCGroupModel *)groupModel toParentGuid:(NSString *)parentGuid;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCGroupTreeViewController : PPViewController

@property (nonatomic, assign) id<WCGroupTreeViewControllerDelegate> delegate;
@property (nonatomic, retain) WCGroupView *groupView;
@property (nonatomic, assign) WCGroupViewStyle style;

@property (nonatomic, retain, readonly) NSArray *datas;

///  titleString, default nil
@property (nonatomic, retain) NSString *titleString;

/// 排版時，下方保留 reserveBottomHeight，預設0
@property (nonatomic, assign) NSInteger reserveBottomHeight;
@property (nonatomic, assign) NSInteger maxGroupLength;     /// < 群組名稱最大長度，default 0表示不限制
@property (nonatomic, assign) BOOL activeCellByDefault;     /// < 預設是否要active一個cell, default NO
@property (nonatomic, assign) BOOL checkWhileNoSelection;     /// < WCGroupViewStyle_NameWithCheckBox沒有選取時是否要勾選Other, default NO
/// other group 是否與一般類別互斥，default YES
@property (nonatomic, assign) BOOL exclusiveWithOther;
/// 展開時是否要focus cell, default NO, 單選時才可用
@property (nonatomic, assign) BOOL activeWhenExpandCell;

/// 是否允許在介面上操作釘選，default YES;
@property (nonatomic, assign) BOOL enablePin;

/// 顯示類別名稱編輯
- (void)showGroupEditorWithName:(NSString *)name;

/// 搬移目前類別
- (void)moveGroupModel:(WCGroupModel *)groupModel;

/// 刪除目前選取類別
- (void)deleteGroupModel:(WCGroupModel *)groupModel;

/// 取得目前選取項目
- (NSArray*)selectedItems;


/// 清除目前資料，並重新讀取
- (void)clearAndLoadDataWithCompletion:(void(^)(void))completion;

@end
