//
//  WCCoverFlowViewController.h
//  Pods//
//  Created by duke on 2016/5/30.
//
//
// WCCoverFlowViewController的viewWillAppear, viewDidAppear, viewWillDisAppear, viewDidDisAppear不準確，所以不要在裡面做事，
// viewWillAppear, viewDidAppear要做的事放到addCoverFlowViewController, viewWillDisAppear, viewDidDisAppear放到removeCoverFlowViewController

#import <UIKit/UIKit.h>
#import "iCarousel.h"
#import "PPSectionIndexDefine.h"
#import "PPSectionIndexView.h"
#import "PPURLController.h"
#import "PPViewController.h"
#import "WCCardModel.h"
#import "WCCoverFlowActionBar.h"


/// coverFlow顯示的內容
typedef NS_ENUM(NSInteger, WCCoverFlowViewControllerMode)
{
    WCCoverFlowViewControllerMode_CardHolder = 0,       /// 顯示card holder
    WCCoverFlowViewControllerMode_Favorite,             /// 顯示我的最愛
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@class WCCoverFlowViewController;

@protocol WCCoverFlowViewControllerDelegate <NSObject>
@optional

/**
 * 執行某個動作
 * @param coverFlowViewController instance of view controller
 * @param actionType 要執行的動作
 * @param actionContent 用來查詢的字串
 * @param displayString 用來顯示的內容
 * @param cardID 點選到的名片的cardID

 */
- (void)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController
                     actionType:(PPURLControllerType)actionType
              withActionContent:(NSString *)actionContent
                  displayString:(NSString *)displayString
                         cardID:(NSString *)cardID;

/**
 * 點選某張名片
 * @param coverFlowViewController instance of view controller
 * @param cardID 點選到的名片的cardID
 */
- (void)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController didSelectCardWithCardID:(NSString *)cardID;

@end

@protocol WCCoverFlowViewControllerDataSource <NSObject>

/**
 * 取得所有名片資料
 * @param coverFlowViewController instance of view controller
 * @return NSArray array of PPSectionModel, and cardArray of PPSectionModel contains PPRowModel, and object of PPRowModel contains WCCardModel
 */
- (NSArray *)cardSectionArrayWithCoverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController;

/**
 * 取得名片的完整資料
 * @param coverFlowViewController instance of view controller
 * @return WCCardModel
 */
- (WCCardModel *)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController requestFullCardModelWithCardID:(NSString *)cardID;

/**
 * 取得名片圖
 * @param coverFlowViewController instance of view controller
 * @param cardID 要取得的
 * @return UIImage 名片圖
 */
- (UIImage *)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController cardImageWithCardID:(NSString *)cardID;

/**
 * 取得名片縮圖
 * @param coverFlowViewController instance of view controller
 * @param cardID 要取得的
 * @return UIImage 名片圖
 */
- (UIImage *)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController thumbnailCardImageWithCardID:(NSString *)cardID;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCCoverFlowViewController : PPViewController



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - property

/// delegate
@property (nonatomic, assign) id<WCCoverFlowViewControllerDelegate> delegate;

/// datasource delegate
@property (nonatomic, assign) id<WCCoverFlowViewControllerDataSource> dataSource;

/// instance of cover flow view
@property (nonatomic ,retain, readonly) iCarousel *coverFlowView;

/// instance of section index view
@property (nonatomic ,retain, readonly) PPSectionIndexView *sectionIndexView;

/// 設定要顯示到哪一個index
@property (nonatomic, assign) NSInteger currentItemIndex;

/// 類別名稱
@property (nonatomic, retain) NSString *categoryName;

/// 沒有名片圖時要顯示的字串, default nil表示不顯示
@property (nonatomic, retain) NSString *noCardString;

/// 沒有姓名時要顯示的名稱, default nil表示不顯示
@property (nonatomic, retain) NSString *noNameString;

/// 目前的顯示模式
@property (nonatomic, assign) WCCoverFlowViewControllerMode mode;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Style

/// 設定section index view 的樣式
- (void)setSectionIndexStyle:(PPSIC_Mode)sectionIndexStyle;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

/**
 * 初始化
 * @param mode 顯示模式
 * @return instancetype instance of WCCoverFlowViewController
 */
-(instancetype)initWithMode:(WCCoverFlowViewControllerMode)mode;




- (void)addOnViewController:(UIViewController *)viewController
                   withMode:(WCCoverFlowViewControllerMode)mode;

- (void)removeFromParent;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - utility

/// 取得目前的item index 對應的indexPath
- (NSIndexPath *)indexPathForCurrentItemIndex;

/// 由index path計算對應到的itemIndex是哪一個
- (NSInteger)itemIndexFromIndexPath:(NSIndexPath *)indexPath;

/// 強制重新讀取內容
- (void)reloadData;

/// 回傳所有CardID
- (NSArray *)allCardIDArray;

@end
